/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.EventQueue;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.plugin.jdb.server.EventsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventsCollector
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(EventsCollector.class);
    private final EventsHandler handler;
    private final EventQueue queue;
    private final Thread thread;
    private volatile boolean running;

    EventsCollector(EventQueue queue, EventsHandler handler) {
        this.queue = queue;
        this.handler = handler;
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.handler.handleEvents(this.queue.remove());
            }
            catch (DebuggerException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (VMDisconnectedException e) {
                break;
            }
            catch (InterruptedException e) {
                LOG.debug("EventsCollector terminated");
            }
        }
        LOG.debug("EventsCollector stopped");
    }

    void stop() {
        this.running = false;
        this.thread.interrupt();
    }
}

