/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.plugin.jdb.server.model.JdbVariable;

public class JdbMethod
implements org.eclipse.che.api.debug.shared.model.Method {
    private final Method jdiMethod;
    private final AtomicReference<List<Variable>> arguments;

    public JdbMethod(StackFrame jdiStackFrame) {
        this.jdiMethod = jdiStackFrame.location().method();
        this.arguments = new AtomicReference();
    }

    public String getName() {
        return this.jdiMethod.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Variable> getArguments() {
        if (this.arguments.get() == null) {
            AtomicReference<List<Variable>> atomicReference = this.arguments;
            synchronized (atomicReference) {
                if (this.arguments.get() == null) {
                    try {
                        this.arguments.set(this.jdiMethod.arguments().stream().map(v -> new JdbVariable((SimpleValue)null, (LocalVariable)v)).collect(Collectors.toList()));
                    }
                    catch (AbsentInformationException e) {
                        this.arguments.set(Collections.emptyList());
                    }
                }
            }
        }
        return this.arguments.get();
    }
}

