/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import org.eclipse.che.api.debug.shared.model.Method;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServerExtensionService;
import org.eclipse.che.plugin.jdb.server.model.JdbMethod;

public class JdbLocation
implements org.eclipse.che.api.debug.shared.model.Location {
    private final Method method;
    private final org.eclipse.che.api.debug.shared.model.Location internal;
    private final StackFrame jdiStackFrame;
    private final JavaLanguageServerExtensionService languageServer;

    public JdbLocation(JavaLanguageServerExtensionService languageServer, StackFrame stackFrame) {
        this(languageServer, stackFrame, new JdbMethod(stackFrame));
    }

    public JdbLocation(JavaLanguageServerExtensionService languageServer, Location jdiLocation) {
        this.languageServer = languageServer;
        this.internal = this.getLocation(jdiLocation);
        this.method = null;
        this.jdiStackFrame = null;
    }

    public JdbLocation(JavaLanguageServerExtensionService languageServer, StackFrame jdiStackFrame, Method method) {
        this.jdiStackFrame = jdiStackFrame;
        this.languageServer = languageServer;
        this.method = method;
        this.internal = this.getLocation(jdiStackFrame.location());
    }

    public String getTarget() {
        return this.internal.getTarget();
    }

    public int getLineNumber() {
        return this.internal.getLineNumber();
    }

    public boolean isExternalResource() {
        return this.internal.isExternalResource();
    }

    public String getExternalResourceId() {
        return this.internal.getExternalResourceId();
    }

    public String getResourceProjectPath() {
        return this.internal.getResourceProjectPath();
    }

    public Method getMethod() {
        return this.method;
    }

    public long getThreadId() {
        return this.jdiStackFrame == null ? -1L : this.jdiStackFrame.thread().uniqueID();
    }

    private org.eclipse.che.api.debug.shared.model.Location getLocation(Location jdiLocation) {
        try {
            return this.languageServer.findResourcesByFqn(jdiLocation.declaringType().name(), jdiLocation.lineNumber());
        }
        catch (Exception e) {
            return new LocationImpl(jdiLocation.declaringType().name(), jdiLocation.lineNumber());
        }
    }
}

