package org.eclipse.che.ide.ext.java.dto;
import org.eclipse.che.ide.dto.ClientDtoFactoryVisitor;
import org.eclipse.che.ide.dto.DtoFactoryVisitor;
import org.eclipse.che.ide.dto.DtoFactory;
import org.eclipse.che.ide.dto.DtoProvider;
import org.eclipse.che.api.languageserver.util.JsonSerializable;
import com.google.inject.Singleton;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONNull;
import java.util.Map.Entry;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.che.api.languageserver.util.EitherUtil;
import org.eclipse.che.api.languageserver.util.JsonUtil;
import org.eclipse.che.api.languageserver.shared.util.JsonDecision;
import static org.eclipse.che.api.languageserver.shared.dto.DtoClientImpls.*;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions;
import org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPosition;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams;
import org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences;
import org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport;
import org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams;
import org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit;
import org.eclipse.che.jdt.ls.extension.api.dto.JarEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.StatusReport;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus;
import org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse;
import org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation;
import org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.SearchResult;
import org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange;
import org.eclipse.che.jdt.ls.extension.api.dto.Jar;
import org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse;
import org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult;
import org.eclipse.che.jdt.ls.extension.api.dto.Resource;
import org.eclipse.che.jdt.ls.extension.api.dto.JobResult;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment;

@Singleton
@ClientDtoFactoryVisitor
@SuppressWarnings("deprecation")
public class DtoClientImpls implements DtoFactoryVisitor {
    public static class UpdateMavenModulesInfoDto extends UpdateMavenModulesInfo implements JsonSerializable {

        public UpdateMavenModulesInfoDto() {
        }

        public UpdateMavenModulesInfoDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getAdded() == null) {
                setAdded((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> addedVal= new ArrayList<java.lang.String>();
                    for (java.lang.String addedValX : o.getAdded()) {
                        java.lang.String addedValY = (java.lang.String)makeDto(addedValX);;
                        addedVal.add(addedValY);
                    }
                setAdded((java.util.List<java.lang.String>)addedVal);
            }
            if (o.getRemoved() == null) {
                setRemoved((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> removedVal= new ArrayList<java.lang.String>();
                    for (java.lang.String removedValX : o.getRemoved()) {
                        java.lang.String removedValY = (java.lang.String)makeDto(removedValX);;
                        removedVal.add(removedValY);
                    }
                setRemoved((java.util.List<java.lang.String>)removedVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            if (getAdded() == null) {
                setAdded((java.util.List<java.lang.String>)null);
            } else {
                JSONArray addedVal = new JSONArray();
                for (java.lang.String addedValX : getAdded()) {
                    JSONValue addedValY = addedValX == null ? JSONNull.getInstance() : new JSONString(addedValX);;
                    addedVal.set(addedVal.size(), addedValY);
                }
                result.put("added", addedVal);
            }
            if (getRemoved() == null) {
                setRemoved((java.util.List<java.lang.String>)null);
            } else {
                JSONArray removedVal = new JSONArray();
                for (java.lang.String removedValX : getRemoved()) {
                    JSONValue removedValY = removedValX == null ? JSONNull.getInstance() : new JSONString(removedValX);;
                    removedVal.set(removedVal.size(), removedValY);
                }
                result.put("removed", removedVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateMavenModulesInfoDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static UpdateMavenModulesInfoDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            UpdateMavenModulesInfoDto result= new UpdateMavenModulesInfoDto();
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JSONValue jsonaddedJson = json.get("added");
            if (jsonaddedJson != null && !(jsonaddedJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonaddedVal= new ArrayList<java.lang.String>();
                JSONArray jsonaddedVala = jsonaddedJson.isArray();
                for(int jsonaddedValai= 0; jsonaddedValai < jsonaddedVala.size(); jsonaddedValai++) {
                    java.lang.String jsonaddedValaX = jsonaddedVala.get(jsonaddedValai).isString().stringValue();;
                    jsonaddedVal.add(jsonaddedValaX);
                }
                result.setAdded((java.util.List<java.lang.String>)jsonaddedVal);
            }
            JSONValue jsonremovedJson = json.get("removed");
            if (jsonremovedJson != null && !(jsonremovedJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonremovedVal= new ArrayList<java.lang.String>();
                JSONArray jsonremovedVala = jsonremovedJson.isArray();
                for(int jsonremovedValai= 0; jsonremovedValai < jsonremovedVala.size(); jsonremovedValai++) {
                    java.lang.String jsonremovedValaX = jsonremovedVala.get(jsonremovedValai).isString().stringValue();;
                    jsonremovedVal.add(jsonremovedValaX);
                }
                result.setRemoved((java.util.List<java.lang.String>)jsonremovedVal);
            }
            return result;
        }
    }

    public static class UpdateMavenModulesInfoDtoProvider implements DtoProvider<UpdateMavenModulesInfoDto> {
    	public Class<? extends UpdateMavenModulesInfoDto> getImplClass() {
    	  	return UpdateMavenModulesInfoDto.class;
    	}
    
    	public UpdateMavenModulesInfoDto newInstance() {
        	return new UpdateMavenModulesInfoDto();
    	}
    
    	public UpdateMavenModulesInfoDto fromJson(String json) {
    		return UpdateMavenModulesInfoDto.fromJson(json);
    	}
        public UpdateMavenModulesInfoDto fromJson(JSONValue json) {
    		return UpdateMavenModulesInfoDto.fromJson(json);
    	}
        public UpdateMavenModulesInfoDto clone(UpdateMavenModulesInfoDto dto) {
            return UpdateMavenModulesInfoDto.fromJson(dto.toJson());
    	}
    }

    public static class JavaProjectStructureDto extends JavaProjectStructure implements JsonSerializable {

        public JavaProjectStructureDto() {
        }

        public JavaProjectStructureDto(org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure o) {
            if (o.getPackageRoots() == null) {
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot> packageRootsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValX : o.getPackageRoots()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValY = new PackageFragmentRootDto(packageRootsValX);
                        packageRootsVal.add(packageRootsValY);
                    }
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)packageRootsVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getPackageRoots() == null) {
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)null);
            } else {
                JSONArray packageRootsVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValX : getPackageRoots()) {
                    JSONValue packageRootsValY = packageRootsValX == null ? JSONNull.getInstance() : ((PackageFragmentRootDto)packageRootsValX).toJsonElement();;
                    packageRootsVal.set(packageRootsVal.size(), packageRootsValY);
                }
                result.put("packageRoots", packageRootsVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JSONValue nameVal = getName() == null ? JSONNull.getInstance() : new JSONString(getName());;
                result.put("name", nameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JavaProjectStructureDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JavaProjectStructureDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JavaProjectStructureDto result= new JavaProjectStructureDto();
            JSONValue jsonpackageRootsJson = json.get("packageRoots");
            if (jsonpackageRootsJson != null && !(jsonpackageRootsJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot> jsonpackageRootsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>();
                JSONArray jsonpackageRootsVala = jsonpackageRootsJson.isArray();
                for(int jsonpackageRootsValai= 0; jsonpackageRootsValai < jsonpackageRootsVala.size(); jsonpackageRootsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot jsonpackageRootsValaX = PackageFragmentRootDto.fromJson((JSONObject)jsonpackageRootsVala.get(jsonpackageRootsValai));;
                    jsonpackageRootsVal.add(jsonpackageRootsValaX);
                }
                result.setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)jsonpackageRootsVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JSONValue jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isNull() != null)) {
                java.lang.String jsonnameVal = jsonnameJson.isString().stringValue();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JavaProjectStructureDtoProvider implements DtoProvider<JavaProjectStructureDto> {
    	public Class<? extends JavaProjectStructureDto> getImplClass() {
    	  	return JavaProjectStructureDto.class;
    	}
    
    	public JavaProjectStructureDto newInstance() {
        	return new JavaProjectStructureDto();
    	}
    
    	public JavaProjectStructureDto fromJson(String json) {
    		return JavaProjectStructureDto.fromJson(json);
    	}
        public JavaProjectStructureDto fromJson(JSONValue json) {
    		return JavaProjectStructureDto.fromJson(json);
    	}
        public JavaProjectStructureDto clone(JavaProjectStructureDto dto) {
            return JavaProjectStructureDto.fromJson(dto.toJson());
    	}
    }

    public static class TestPositionParametersDto extends TestPositionParameters implements JsonSerializable {

        public TestPositionParametersDto() {
        }

        public TestPositionParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters o) {
                int cursorOffsetVal = (int)makeDto(o.getCursorOffset());;
                setCursorOffset((int)cursorOffsetVal);
            if (o.getTestAnnotation() == null) {
                setTestAnnotation((java.lang.String)null);
            } else {
                java.lang.String testAnnotationVal = (java.lang.String)makeDto(o.getTestAnnotation());;
                setTestAnnotation((java.lang.String)testAnnotationVal);
            }
            if (o.getFileUri() == null) {
                setFileUri((java.lang.String)null);
            } else {
                java.lang.String fileUriVal = (java.lang.String)makeDto(o.getFileUri());;
                setFileUri((java.lang.String)fileUriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue cursorOffsetVal = new JSONNumber(getCursorOffset());;
                result.put("cursorOffset", cursorOffsetVal);
            if (getTestAnnotation() == null) {
                setTestAnnotation((java.lang.String)null);
            } else {
                JSONValue testAnnotationVal = getTestAnnotation() == null ? JSONNull.getInstance() : new JSONString(getTestAnnotation());;
                result.put("testAnnotation", testAnnotationVal);
            }
            if (getFileUri() == null) {
                setFileUri((java.lang.String)null);
            } else {
                JSONValue fileUriVal = getFileUri() == null ? JSONNull.getInstance() : new JSONString(getFileUri());;
                result.put("fileUri", fileUriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestPositionParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static TestPositionParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            TestPositionParametersDto result= new TestPositionParametersDto();
            JSONValue jsoncursorOffsetJson = json.get("cursorOffset");
            if (jsoncursorOffsetJson != null && !(jsoncursorOffsetJson.isNull() != null)) {
                int jsoncursorOffsetVal = (int)jsoncursorOffsetJson.isNumber().doubleValue();;
                result.setCursorOffset((int)jsoncursorOffsetVal);
            }
            JSONValue jsontestAnnotationJson = json.get("testAnnotation");
            if (jsontestAnnotationJson != null && !(jsontestAnnotationJson.isNull() != null)) {
                java.lang.String jsontestAnnotationVal = jsontestAnnotationJson.isString().stringValue();;
                result.setTestAnnotation((java.lang.String)jsontestAnnotationVal);
            }
            JSONValue jsonfileUriJson = json.get("fileUri");
            if (jsonfileUriJson != null && !(jsonfileUriJson.isNull() != null)) {
                java.lang.String jsonfileUriVal = jsonfileUriJson.isString().stringValue();;
                result.setFileUri((java.lang.String)jsonfileUriVal);
            }
            return result;
        }
    }

    public static class TestPositionParametersDtoProvider implements DtoProvider<TestPositionParametersDto> {
    	public Class<? extends TestPositionParametersDto> getImplClass() {
    	  	return TestPositionParametersDto.class;
    	}
    
    	public TestPositionParametersDto newInstance() {
        	return new TestPositionParametersDto();
    	}
    
    	public TestPositionParametersDto fromJson(String json) {
    		return TestPositionParametersDto.fromJson(json);
    	}
        public TestPositionParametersDto fromJson(JSONValue json) {
    		return TestPositionParametersDto.fromJson(json);
    	}
        public TestPositionParametersDto clone(TestPositionParametersDto dto) {
            return TestPositionParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class OrganizeImportParamsDto extends OrganizeImportParams implements JsonSerializable {

        public OrganizeImportParamsDto() {
        }

        public OrganizeImportParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams o) {
            if (o.getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                java.lang.String resourceUriVal = (java.lang.String)makeDto(o.getResourceUri());;
                setResourceUri((java.lang.String)resourceUriVal);
            }
            if (o.getChoices() == null) {
                setChoices((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> choicesVal= new ArrayList<java.lang.String>();
                    for (java.lang.String choicesValX : o.getChoices()) {
                        java.lang.String choicesValY = (java.lang.String)makeDto(choicesValX);;
                        choicesVal.add(choicesValY);
                    }
                setChoices((java.util.List<java.lang.String>)choicesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                JSONValue resourceUriVal = getResourceUri() == null ? JSONNull.getInstance() : new JSONString(getResourceUri());;
                result.put("resourceUri", resourceUriVal);
            }
            if (getChoices() == null) {
                setChoices((java.util.List<java.lang.String>)null);
            } else {
                JSONArray choicesVal = new JSONArray();
                for (java.lang.String choicesValX : getChoices()) {
                    JSONValue choicesValY = choicesValX == null ? JSONNull.getInstance() : new JSONString(choicesValX);;
                    choicesVal.set(choicesVal.size(), choicesValY);
                }
                result.put("choices", choicesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static OrganizeImportParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static OrganizeImportParamsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            OrganizeImportParamsDto result= new OrganizeImportParamsDto();
            JSONValue jsonresourceUriJson = json.get("resourceUri");
            if (jsonresourceUriJson != null && !(jsonresourceUriJson.isNull() != null)) {
                java.lang.String jsonresourceUriVal = jsonresourceUriJson.isString().stringValue();;
                result.setResourceUri((java.lang.String)jsonresourceUriVal);
            }
            JSONValue jsonchoicesJson = json.get("choices");
            if (jsonchoicesJson != null && !(jsonchoicesJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonchoicesVal= new ArrayList<java.lang.String>();
                JSONArray jsonchoicesVala = jsonchoicesJson.isArray();
                for(int jsonchoicesValai= 0; jsonchoicesValai < jsonchoicesVala.size(); jsonchoicesValai++) {
                    java.lang.String jsonchoicesValaX = jsonchoicesVala.get(jsonchoicesValai).isString().stringValue();;
                    jsonchoicesVal.add(jsonchoicesValaX);
                }
                result.setChoices((java.util.List<java.lang.String>)jsonchoicesVal);
            }
            return result;
        }
    }

    public static class OrganizeImportParamsDtoProvider implements DtoProvider<OrganizeImportParamsDto> {
    	public Class<? extends OrganizeImportParamsDto> getImplClass() {
    	  	return OrganizeImportParamsDto.class;
    	}
    
    	public OrganizeImportParamsDto newInstance() {
        	return new OrganizeImportParamsDto();
    	}
    
    	public OrganizeImportParamsDto fromJson(String json) {
    		return OrganizeImportParamsDto.fromJson(json);
    	}
        public OrganizeImportParamsDto fromJson(JSONValue json) {
    		return OrganizeImportParamsDto.fromJson(json);
    	}
        public OrganizeImportParamsDto clone(OrganizeImportParamsDto dto) {
            return OrganizeImportParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class RenameSettingsDto extends RenameSettings implements JsonSerializable {

        public RenameSettingsDto() {
        }

        public RenameSettingsDto(org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings o) {
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
                boolean updateReferencesVal = (boolean)makeDto(o.isUpdateReferences());;
                setUpdateReferences((boolean)updateReferencesVal);
                boolean updateQualifiedNamesVal = (boolean)makeDto(o.isUpdateQualifiedNames());;
                setUpdateQualifiedNames((boolean)updateQualifiedNamesVal);
            if (o.getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                java.lang.String filePatternsVal = (java.lang.String)makeDto(o.getFilePatterns());;
                setFilePatterns((java.lang.String)filePatternsVal);
            }
            if (o.getRenameParams() == null) {
                setRenameParams((org.eclipse.lsp4j.RenameParams)null);
            } else {
                org.eclipse.lsp4j.RenameParams renameParamsVal = (org.eclipse.lsp4j.RenameParams)makeDto(o.getRenameParams());;
                setRenameParams((org.eclipse.lsp4j.RenameParams)renameParamsVal);
            }
                boolean delegateUpdatingVal = (boolean)makeDto(o.isDelegateUpdating());;
                setDelegateUpdating((boolean)delegateUpdatingVal);
                boolean deprecateDelegatesVal = (boolean)makeDto(o.isDeprecateDelegates());;
                setDeprecateDelegates((boolean)deprecateDelegatesVal);
                boolean updateSubpackagesVal = (boolean)makeDto(o.isUpdateSubpackages());;
                setUpdateSubpackages((boolean)updateSubpackagesVal);
                boolean updateSimilarDeclarationsVal = (boolean)makeDto(o.isUpdateSimilarDeclarations());;
                setUpdateSimilarDeclarations((boolean)updateSimilarDeclarationsVal);
            if (o.getMatchStrategy() == null) {
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.MatchStrategy matchStrategyVal = (org.eclipse.che.jdt.ls.extension.api.MatchStrategy)makeDto(o.getMatchStrategy());;
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)matchStrategyVal);
            }
                boolean updateTextualMatchesVal = (boolean)makeDto(o.isUpdateTextualMatches());;
                setUpdateTextualMatches((boolean)updateTextualMatchesVal);
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JSONValue renameKindVal = getRenameKind() == null ? JSONNull.getInstance() : new JSONString(getRenameKind().name());;
                result.put("renameKind", renameKindVal);
            }
            JSONValue updateReferencesVal = JSONBoolean.getInstance(isUpdateReferences());;
                result.put("updateReferences", updateReferencesVal);
            JSONValue updateQualifiedNamesVal = JSONBoolean.getInstance(isUpdateQualifiedNames());;
                result.put("updateQualifiedNames", updateQualifiedNamesVal);
            if (getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                JSONValue filePatternsVal = getFilePatterns() == null ? JSONNull.getInstance() : new JSONString(getFilePatterns());;
                result.put("filePatterns", filePatternsVal);
            }
            if (getRenameParams() == null) {
                setRenameParams((org.eclipse.lsp4j.RenameParams)null);
            } else {
                JSONValue renameParamsVal = getRenameParams() == null ? JSONNull.getInstance() : ((RenameParamsDto)getRenameParams()).toJsonElement();;
                result.put("renameParams", renameParamsVal);
            }
            JSONValue delegateUpdatingVal = JSONBoolean.getInstance(isDelegateUpdating());;
                result.put("delegateUpdating", delegateUpdatingVal);
            JSONValue deprecateDelegatesVal = JSONBoolean.getInstance(isDeprecateDelegates());;
                result.put("deprecateDelegates", deprecateDelegatesVal);
            JSONValue updateSubpackagesVal = JSONBoolean.getInstance(isUpdateSubpackages());;
                result.put("updateSubpackages", updateSubpackagesVal);
            JSONValue updateSimilarDeclarationsVal = JSONBoolean.getInstance(isUpdateSimilarDeclarations());;
                result.put("updateSimilarDeclarations", updateSimilarDeclarationsVal);
            if (getMatchStrategy() == null) {
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)null);
            } else {
                JSONValue matchStrategyVal = getMatchStrategy() == null ? JSONNull.getInstance() : new JSONString(getMatchStrategy().name());;
                result.put("matchStrategy", matchStrategyVal);
            }
            JSONValue updateTextualMatchesVal = JSONBoolean.getInstance(isUpdateTextualMatches());;
                result.put("updateTextualMatches", updateTextualMatchesVal);
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenameSettingsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RenameSettingsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RenameSettingsDto result= new RenameSettingsDto();
            JSONValue jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.isString().stringValue());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JSONValue jsonupdateReferencesJson = json.get("updateReferences");
            if (jsonupdateReferencesJson != null && !(jsonupdateReferencesJson.isNull() != null)) {
                boolean jsonupdateReferencesVal = jsonupdateReferencesJson.isBoolean().booleanValue();
                result.setUpdateReferences((boolean)jsonupdateReferencesVal);
            }
            JSONValue jsonupdateQualifiedNamesJson = json.get("updateQualifiedNames");
            if (jsonupdateQualifiedNamesJson != null && !(jsonupdateQualifiedNamesJson.isNull() != null)) {
                boolean jsonupdateQualifiedNamesVal = jsonupdateQualifiedNamesJson.isBoolean().booleanValue();
                result.setUpdateQualifiedNames((boolean)jsonupdateQualifiedNamesVal);
            }
            JSONValue jsonfilePatternsJson = json.get("filePatterns");
            if (jsonfilePatternsJson != null && !(jsonfilePatternsJson.isNull() != null)) {
                java.lang.String jsonfilePatternsVal = jsonfilePatternsJson.isString().stringValue();;
                result.setFilePatterns((java.lang.String)jsonfilePatternsVal);
            }
            JSONValue jsonrenameParamsJson = json.get("renameParams");
            if (jsonrenameParamsJson != null && !(jsonrenameParamsJson.isNull() != null)) {
                org.eclipse.lsp4j.RenameParams jsonrenameParamsVal = RenameParamsDto.fromJson((JSONObject)jsonrenameParamsJson);;
                result.setRenameParams((org.eclipse.lsp4j.RenameParams)jsonrenameParamsVal);
            }
            JSONValue jsondelegateUpdatingJson = json.get("delegateUpdating");
            if (jsondelegateUpdatingJson != null && !(jsondelegateUpdatingJson.isNull() != null)) {
                boolean jsondelegateUpdatingVal = jsondelegateUpdatingJson.isBoolean().booleanValue();
                result.setDelegateUpdating((boolean)jsondelegateUpdatingVal);
            }
            JSONValue jsondeprecateDelegatesJson = json.get("deprecateDelegates");
            if (jsondeprecateDelegatesJson != null && !(jsondeprecateDelegatesJson.isNull() != null)) {
                boolean jsondeprecateDelegatesVal = jsondeprecateDelegatesJson.isBoolean().booleanValue();
                result.setDeprecateDelegates((boolean)jsondeprecateDelegatesVal);
            }
            JSONValue jsonupdateSubpackagesJson = json.get("updateSubpackages");
            if (jsonupdateSubpackagesJson != null && !(jsonupdateSubpackagesJson.isNull() != null)) {
                boolean jsonupdateSubpackagesVal = jsonupdateSubpackagesJson.isBoolean().booleanValue();
                result.setUpdateSubpackages((boolean)jsonupdateSubpackagesVal);
            }
            JSONValue jsonupdateSimilarDeclarationsJson = json.get("updateSimilarDeclarations");
            if (jsonupdateSimilarDeclarationsJson != null && !(jsonupdateSimilarDeclarationsJson.isNull() != null)) {
                boolean jsonupdateSimilarDeclarationsVal = jsonupdateSimilarDeclarationsJson.isBoolean().booleanValue();
                result.setUpdateSimilarDeclarations((boolean)jsonupdateSimilarDeclarationsVal);
            }
            JSONValue jsonmatchStrategyJson = json.get("matchStrategy");
            if (jsonmatchStrategyJson != null && !(jsonmatchStrategyJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.MatchStrategy jsonmatchStrategyVal = org.eclipse.che.jdt.ls.extension.api.MatchStrategy.valueOf(jsonmatchStrategyJson.isString().stringValue());;
                result.setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)jsonmatchStrategyVal);
            }
            JSONValue jsonupdateTextualMatchesJson = json.get("updateTextualMatches");
            if (jsonupdateTextualMatchesJson != null && !(jsonupdateTextualMatchesJson.isNull() != null)) {
                boolean jsonupdateTextualMatchesVal = jsonupdateTextualMatchesJson.isBoolean().booleanValue();
                result.setUpdateTextualMatches((boolean)jsonupdateTextualMatchesVal);
            }
            return result;
        }
    }

    public static class RenameSettingsDtoProvider implements DtoProvider<RenameSettingsDto> {
    	public Class<? extends RenameSettingsDto> getImplClass() {
    	  	return RenameSettingsDto.class;
    	}
    
    	public RenameSettingsDto newInstance() {
        	return new RenameSettingsDto();
    	}
    
    	public RenameSettingsDto fromJson(String json) {
    		return RenameSettingsDto.fromJson(json);
    	}
        public RenameSettingsDto fromJson(JSONValue json) {
    		return RenameSettingsDto.fromJson(json);
    	}
        public RenameSettingsDto clone(RenameSettingsDto dto) {
            return RenameSettingsDto.fromJson(dto.toJson());
    	}
    }

    public static class OrganizeImportsResultDto extends OrganizeImportsResult implements JsonSerializable {

        public OrganizeImportsResultDto() {
        }

        public OrganizeImportsResultDto(org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult o) {
            if (o.getAmbiguousTypes() == null) {
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)null);
            } else {
                    ArrayList<java.util.List<java.lang.String>> ambiguousTypesVal= new ArrayList<java.util.List<java.lang.String>>();
                    for (java.util.List<java.lang.String> ambiguousTypesValX : o.getAmbiguousTypes()) {
                            ArrayList<java.lang.String> ambiguousTypesValY= new ArrayList<java.lang.String>();
                            for (java.lang.String ambiguousTypesValYX : ambiguousTypesValX) {
                                java.lang.String ambiguousTypesValYY = (java.lang.String)makeDto(ambiguousTypesValYX);;
                                ambiguousTypesValY.add(ambiguousTypesValYY);
                            }
                        ambiguousTypesVal.add(ambiguousTypesValY);
                    }
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)ambiguousTypesVal);
            }
            if (o.getWorkspaceEdit() == null) {
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)null);
            } else {
                org.eclipse.lsp4j.WorkspaceEdit workspaceEditVal = (org.eclipse.lsp4j.WorkspaceEdit)makeDto(o.getWorkspaceEdit());;
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)workspaceEditVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getAmbiguousTypes() == null) {
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)null);
            } else {
                JSONArray ambiguousTypesVal = new JSONArray();
                for (java.util.List<java.lang.String> ambiguousTypesValX : getAmbiguousTypes()) {
                    JSONArray ambiguousTypesValY = new JSONArray();
                    for (java.lang.String ambiguousTypesValYX : ambiguousTypesValX) {
                        JSONValue ambiguousTypesValYY = ambiguousTypesValYX == null ? JSONNull.getInstance() : new JSONString(ambiguousTypesValYX);;
                        ambiguousTypesValY.set(ambiguousTypesValY.size(), ambiguousTypesValYY);
                    }
                    ambiguousTypesVal.set(ambiguousTypesVal.size(), ambiguousTypesValY);
                }
                result.put("ambiguousTypes", ambiguousTypesVal);
            }
            if (getWorkspaceEdit() == null) {
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)null);
            } else {
                JSONValue workspaceEditVal = getWorkspaceEdit() == null ? JSONNull.getInstance() : ((WorkspaceEditDto)getWorkspaceEdit()).toJsonElement();;
                result.put("workspaceEdit", workspaceEditVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static OrganizeImportsResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static OrganizeImportsResultDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            OrganizeImportsResultDto result= new OrganizeImportsResultDto();
            JSONValue jsonambiguousTypesJson = json.get("ambiguousTypes");
            if (jsonambiguousTypesJson != null && !(jsonambiguousTypesJson.isNull() != null)) {
                ArrayList<java.util.List<java.lang.String>> jsonambiguousTypesVal= new ArrayList<java.util.List<java.lang.String>>();
                JSONArray jsonambiguousTypesVala = jsonambiguousTypesJson.isArray();
                for(int jsonambiguousTypesValai= 0; jsonambiguousTypesValai < jsonambiguousTypesVala.size(); jsonambiguousTypesValai++) {
                    ArrayList<java.lang.String> jsonambiguousTypesValaX= new ArrayList<java.lang.String>();
                    JSONArray jsonambiguousTypesValaXa = jsonambiguousTypesVala.get(jsonambiguousTypesValai).isArray();
                    for(int jsonambiguousTypesValaXai= 0; jsonambiguousTypesValaXai < jsonambiguousTypesValaXa.size(); jsonambiguousTypesValaXai++) {
                        java.lang.String jsonambiguousTypesValaXaX = jsonambiguousTypesValaXa.get(jsonambiguousTypesValaXai).isString().stringValue();;
                        jsonambiguousTypesValaX.add(jsonambiguousTypesValaXaX);
                    }
                    jsonambiguousTypesVal.add(jsonambiguousTypesValaX);
                }
                result.setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)jsonambiguousTypesVal);
            }
            JSONValue jsonworkspaceEditJson = json.get("workspaceEdit");
            if (jsonworkspaceEditJson != null && !(jsonworkspaceEditJson.isNull() != null)) {
                org.eclipse.lsp4j.WorkspaceEdit jsonworkspaceEditVal = WorkspaceEditDto.fromJson((JSONObject)jsonworkspaceEditJson);;
                result.setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)jsonworkspaceEditVal);
            }
            return result;
        }
    }

    public static class OrganizeImportsResultDtoProvider implements DtoProvider<OrganizeImportsResultDto> {
    	public Class<? extends OrganizeImportsResultDto> getImplClass() {
    	  	return OrganizeImportsResultDto.class;
    	}
    
    	public OrganizeImportsResultDto newInstance() {
        	return new OrganizeImportsResultDto();
    	}
    
    	public OrganizeImportsResultDto fromJson(String json) {
    		return OrganizeImportsResultDto.fromJson(json);
    	}
        public OrganizeImportsResultDto fromJson(JSONValue json) {
    		return OrganizeImportsResultDto.fromJson(json);
    	}
        public OrganizeImportsResultDto clone(OrganizeImportsResultDto dto) {
            return OrganizeImportsResultDto.fromJson(dto.toJson());
    	}
    }

    public static class JavaCoreOptionsDto extends JavaCoreOptions implements JsonSerializable {

        public JavaCoreOptionsDto() {
        }

        public JavaCoreOptionsDto(org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions o) {
            if (o.getOptions() == null) {
                setOptions((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                    java.util.Map<java.lang.String, java.lang.String> optionsVal= new HashMap<String, java.lang.String>();
                    for (Entry<String, java.lang.String> optionsValX : o.getOptions().entrySet()) {
                        java.lang.String optionsValY = (java.lang.String)makeDto(optionsValX.getValue());;
                        optionsVal.put(optionsValX.getKey(), optionsValY);
                    }
                setOptions((java.util.Map<java.lang.String, java.lang.String>)optionsVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getOptions() == null) {
                setOptions((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                JSONObject optionsVal = new JSONObject();
                for (Entry<String, java.lang.String> optionsValX : getOptions().entrySet()) {
                    JSONValue optionsValY = optionsValX.getValue() == null ? JSONNull.getInstance() : new JSONString(optionsValX.getValue());;
                    optionsVal.put(optionsValX.getKey().toString(), optionsValY);
                }
                result.put("options", optionsVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JavaCoreOptionsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JavaCoreOptionsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JavaCoreOptionsDto result= new JavaCoreOptionsDto();
            JSONValue jsonoptionsJson = json.get("options");
            if (jsonoptionsJson != null && !(jsonoptionsJson.isNull() != null)) {
                java.util.Map<java.lang.String, java.lang.String> jsonoptionsVal= new HashMap<String, java.lang.String>();
                JSONObject jsonoptionsValo = jsonoptionsJson.isObject();
                for(String jsonoptionsValok : jsonoptionsValo.keySet()) {
                    java.lang.String jsonoptionsValoX = jsonoptionsValo.get(jsonoptionsValok).isString().stringValue();;
                    jsonoptionsVal.put(jsonoptionsValok, jsonoptionsValoX);
                }
                result.setOptions((java.util.Map<java.lang.String, java.lang.String>)jsonoptionsVal);
            }
            return result;
        }
    }

    public static class JavaCoreOptionsDtoProvider implements DtoProvider<JavaCoreOptionsDto> {
    	public Class<? extends JavaCoreOptionsDto> getImplClass() {
    	  	return JavaCoreOptionsDto.class;
    	}
    
    	public JavaCoreOptionsDto newInstance() {
        	return new JavaCoreOptionsDto();
    	}
    
    	public JavaCoreOptionsDto fromJson(String json) {
    		return JavaCoreOptionsDto.fromJson(json);
    	}
        public JavaCoreOptionsDto fromJson(JSONValue json) {
    		return JavaCoreOptionsDto.fromJson(json);
    	}
        public JavaCoreOptionsDto clone(JavaCoreOptionsDto dto) {
            return JavaCoreOptionsDto.fromJson(dto.toJson());
    	}
    }

    public static class MoveSettingsDto extends MoveSettings implements JsonSerializable {

        public MoveSettingsDto() {
        }

        public MoveSettingsDto(org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings o) {
            if (o.getDestination() == null) {
                setDestination((java.lang.String)null);
            } else {
                java.lang.String destinationVal = (java.lang.String)makeDto(o.getDestination());;
                setDestination((java.lang.String)destinationVal);
            }
            if (o.getElements() == null) {
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> elementsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValX : o.getElements()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValY = new ResourceDto(elementsValX);
                        elementsVal.add(elementsValY);
                    }
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)elementsVal);
            }
                boolean updateReferencesVal = (boolean)makeDto(o.isUpdateReferences());;
                setUpdateReferences((boolean)updateReferencesVal);
                boolean updateQualifiedNamesVal = (boolean)makeDto(o.isUpdateQualifiedNames());;
                setUpdateQualifiedNames((boolean)updateQualifiedNamesVal);
            if (o.getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                java.lang.String filePatternsVal = (java.lang.String)makeDto(o.getFilePatterns());;
                setFilePatterns((java.lang.String)filePatternsVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getDestination() == null) {
                setDestination((java.lang.String)null);
            } else {
                JSONValue destinationVal = getDestination() == null ? JSONNull.getInstance() : new JSONString(getDestination());;
                result.put("destination", destinationVal);
            }
            if (getElements() == null) {
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                JSONArray elementsVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValX : getElements()) {
                    JSONValue elementsValY = elementsValX == null ? JSONNull.getInstance() : ((ResourceDto)elementsValX).toJsonElement();;
                    elementsVal.set(elementsVal.size(), elementsValY);
                }
                result.put("elements", elementsVal);
            }
            JSONValue updateReferencesVal = JSONBoolean.getInstance(isUpdateReferences());;
                result.put("updateReferences", updateReferencesVal);
            JSONValue updateQualifiedNamesVal = JSONBoolean.getInstance(isUpdateQualifiedNames());;
                result.put("updateQualifiedNames", updateQualifiedNamesVal);
            if (getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                JSONValue filePatternsVal = getFilePatterns() == null ? JSONNull.getInstance() : new JSONString(getFilePatterns());;
                result.put("filePatterns", filePatternsVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static MoveSettingsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static MoveSettingsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            MoveSettingsDto result= new MoveSettingsDto();
            JSONValue jsondestinationJson = json.get("destination");
            if (jsondestinationJson != null && !(jsondestinationJson.isNull() != null)) {
                java.lang.String jsondestinationVal = jsondestinationJson.isString().stringValue();;
                result.setDestination((java.lang.String)jsondestinationVal);
            }
            JSONValue jsonelementsJson = json.get("elements");
            if (jsonelementsJson != null && !(jsonelementsJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> jsonelementsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                JSONArray jsonelementsVala = jsonelementsJson.isArray();
                for(int jsonelementsValai= 0; jsonelementsValai < jsonelementsVala.size(); jsonelementsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.Resource jsonelementsValaX = ResourceDto.fromJson((JSONObject)jsonelementsVala.get(jsonelementsValai));;
                    jsonelementsVal.add(jsonelementsValaX);
                }
                result.setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)jsonelementsVal);
            }
            JSONValue jsonupdateReferencesJson = json.get("updateReferences");
            if (jsonupdateReferencesJson != null && !(jsonupdateReferencesJson.isNull() != null)) {
                boolean jsonupdateReferencesVal = jsonupdateReferencesJson.isBoolean().booleanValue();
                result.setUpdateReferences((boolean)jsonupdateReferencesVal);
            }
            JSONValue jsonupdateQualifiedNamesJson = json.get("updateQualifiedNames");
            if (jsonupdateQualifiedNamesJson != null && !(jsonupdateQualifiedNamesJson.isNull() != null)) {
                boolean jsonupdateQualifiedNamesVal = jsonupdateQualifiedNamesJson.isBoolean().booleanValue();
                result.setUpdateQualifiedNames((boolean)jsonupdateQualifiedNamesVal);
            }
            JSONValue jsonfilePatternsJson = json.get("filePatterns");
            if (jsonfilePatternsJson != null && !(jsonfilePatternsJson.isNull() != null)) {
                java.lang.String jsonfilePatternsVal = jsonfilePatternsJson.isString().stringValue();;
                result.setFilePatterns((java.lang.String)jsonfilePatternsVal);
            }
            return result;
        }
    }

    public static class MoveSettingsDtoProvider implements DtoProvider<MoveSettingsDto> {
    	public Class<? extends MoveSettingsDto> getImplClass() {
    	  	return MoveSettingsDto.class;
    	}
    
    	public MoveSettingsDto newInstance() {
        	return new MoveSettingsDto();
    	}
    
    	public MoveSettingsDto fromJson(String json) {
    		return MoveSettingsDto.fromJson(json);
    	}
        public MoveSettingsDto fromJson(JSONValue json) {
    		return MoveSettingsDto.fromJson(json);
    	}
        public MoveSettingsDto clone(MoveSettingsDto dto) {
            return MoveSettingsDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringStatusEntryDto extends RefactoringStatusEntry implements JsonSerializable {

        public RefactoringStatusEntryDto() {
        }

        public RefactoringStatusEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry o) {
            if (o.getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity refactoringSeverityVal = (org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)makeDto(o.getRefactoringSeverity());;
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)refactoringSeverityVal);
            }
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                JSONValue refactoringSeverityVal = getRefactoringSeverity() == null ? JSONNull.getInstance() : new JSONString(getRefactoringSeverity().name());;
                result.put("refactoringSeverity", refactoringSeverityVal);
            }
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JSONValue messageVal = getMessage() == null ? JSONNull.getInstance() : new JSONString(getMessage());;
                result.put("message", messageVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringStatusEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RefactoringStatusEntryDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RefactoringStatusEntryDto result= new RefactoringStatusEntryDto();
            JSONValue jsonrefactoringSeverityJson = json.get("refactoringSeverity");
            if (jsonrefactoringSeverityJson != null && !(jsonrefactoringSeverityJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity jsonrefactoringSeverityVal = org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity.valueOf(jsonrefactoringSeverityJson.isString().stringValue());;
                result.setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)jsonrefactoringSeverityVal);
            }
            JSONValue jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isNull() != null)) {
                java.lang.String jsonmessageVal = jsonmessageJson.isString().stringValue();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            return result;
        }
    }

    public static class RefactoringStatusEntryDtoProvider implements DtoProvider<RefactoringStatusEntryDto> {
    	public Class<? extends RefactoringStatusEntryDto> getImplClass() {
    	  	return RefactoringStatusEntryDto.class;
    	}
    
    	public RefactoringStatusEntryDto newInstance() {
        	return new RefactoringStatusEntryDto();
    	}
    
    	public RefactoringStatusEntryDto fromJson(String json) {
    		return RefactoringStatusEntryDto.fromJson(json);
    	}
        public RefactoringStatusEntryDto fromJson(JSONValue json) {
    		return RefactoringStatusEntryDto.fromJson(json);
    	}
        public RefactoringStatusEntryDto clone(RefactoringStatusEntryDto dto) {
            return RefactoringStatusEntryDto.fromJson(dto.toJson());
    	}
    }

    public static class FileStructureCommandParametersDto extends FileStructureCommandParameters implements JsonSerializable {

        public FileStructureCommandParametersDto() {
        }

        public FileStructureCommandParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters o) {
                boolean showInheritedVal = (boolean)makeDto(o.getShowInherited());;
                setShowInherited((boolean)showInheritedVal);
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue showInheritedVal = JSONBoolean.getInstance(getShowInherited());;
                result.put("showInherited", showInheritedVal);
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static FileStructureCommandParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static FileStructureCommandParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            FileStructureCommandParametersDto result= new FileStructureCommandParametersDto();
            JSONValue jsonshowInheritedJson = json.get("showInherited");
            if (jsonshowInheritedJson != null && !(jsonshowInheritedJson.isNull() != null)) {
                boolean jsonshowInheritedVal = jsonshowInheritedJson.isBoolean().booleanValue();
                result.setShowInherited((boolean)jsonshowInheritedVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class FileStructureCommandParametersDtoProvider implements DtoProvider<FileStructureCommandParametersDto> {
    	public Class<? extends FileStructureCommandParametersDto> getImplClass() {
    	  	return FileStructureCommandParametersDto.class;
    	}
    
    	public FileStructureCommandParametersDto newInstance() {
        	return new FileStructureCommandParametersDto();
    	}
    
    	public FileStructureCommandParametersDto fromJson(String json) {
    		return FileStructureCommandParametersDto.fromJson(json);
    	}
        public FileStructureCommandParametersDto fromJson(JSONValue json) {
    		return FileStructureCommandParametersDto.fromJson(json);
    	}
        public FileStructureCommandParametersDto clone(FileStructureCommandParametersDto dto) {
            return FileStructureCommandParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class TestPositionDto extends TestPosition implements JsonSerializable {

        public TestPositionDto() {
        }

        public TestPositionDto(org.eclipse.che.jdt.ls.extension.api.dto.TestPosition o) {
            if (o.getTestName() == null) {
                setTestName((java.lang.String)null);
            } else {
                java.lang.String testNameVal = (java.lang.String)makeDto(o.getTestName());;
                setTestName((java.lang.String)testNameVal);
            }
                int testNameStartOffsetVal = (int)makeDto(o.getTestNameStartOffset());;
                setTestNameStartOffset((int)testNameStartOffsetVal);
                int testBodyLengthVal = (int)makeDto(o.getTestBodyLength());;
                setTestBodyLength((int)testBodyLengthVal);
                int testNameLengthVal = (int)makeDto(o.getTestNameLength());;
                setTestNameLength((int)testNameLengthVal);
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getTestName() == null) {
                setTestName((java.lang.String)null);
            } else {
                JSONValue testNameVal = getTestName() == null ? JSONNull.getInstance() : new JSONString(getTestName());;
                result.put("testName", testNameVal);
            }
            JSONValue testNameStartOffsetVal = new JSONNumber(getTestNameStartOffset());;
                result.put("testNameStartOffset", testNameStartOffsetVal);
            JSONValue testBodyLengthVal = new JSONNumber(getTestBodyLength());;
                result.put("testBodyLength", testBodyLengthVal);
            JSONValue testNameLengthVal = new JSONNumber(getTestNameLength());;
                result.put("testNameLength", testNameLengthVal);
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestPositionDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static TestPositionDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            TestPositionDto result= new TestPositionDto();
            JSONValue jsontestNameJson = json.get("testName");
            if (jsontestNameJson != null && !(jsontestNameJson.isNull() != null)) {
                java.lang.String jsontestNameVal = jsontestNameJson.isString().stringValue();;
                result.setTestName((java.lang.String)jsontestNameVal);
            }
            JSONValue jsontestNameStartOffsetJson = json.get("testNameStartOffset");
            if (jsontestNameStartOffsetJson != null && !(jsontestNameStartOffsetJson.isNull() != null)) {
                int jsontestNameStartOffsetVal = (int)jsontestNameStartOffsetJson.isNumber().doubleValue();;
                result.setTestNameStartOffset((int)jsontestNameStartOffsetVal);
            }
            JSONValue jsontestBodyLengthJson = json.get("testBodyLength");
            if (jsontestBodyLengthJson != null && !(jsontestBodyLengthJson.isNull() != null)) {
                int jsontestBodyLengthVal = (int)jsontestBodyLengthJson.isNumber().doubleValue();;
                result.setTestBodyLength((int)jsontestBodyLengthVal);
            }
            JSONValue jsontestNameLengthJson = json.get("testNameLength");
            if (jsontestNameLengthJson != null && !(jsontestNameLengthJson.isNull() != null)) {
                int jsontestNameLengthVal = (int)jsontestNameLengthJson.isNumber().doubleValue();;
                result.setTestNameLength((int)jsontestNameLengthVal);
            }
            return result;
        }
    }

    public static class TestPositionDtoProvider implements DtoProvider<TestPositionDto> {
    	public Class<? extends TestPositionDto> getImplClass() {
    	  	return TestPositionDto.class;
    	}
    
    	public TestPositionDto newInstance() {
        	return new TestPositionDto();
    	}
    
    	public TestPositionDto fromJson(String json) {
    		return TestPositionDto.fromJson(json);
    	}
        public TestPositionDto fromJson(JSONValue json) {
    		return TestPositionDto.fromJson(json);
    	}
        public TestPositionDto clone(TestPositionDto dto) {
            return TestPositionDto.fromJson(dto.toJson());
    	}
    }

    public static class PackageFragmentRootDto extends PackageFragmentRoot implements JsonSerializable {

        public PackageFragmentRootDto() {
        }

        public PackageFragmentRootDto(org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getPackages() == null) {
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment> packagesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValX : o.getPackages()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValY = new PackageFragmentDto(packagesValX);
                        packagesVal.add(packagesValY);
                    }
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)packagesVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            if (getPackages() == null) {
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)null);
            } else {
                JSONArray packagesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValX : getPackages()) {
                    JSONValue packagesValY = packagesValX == null ? JSONNull.getInstance() : ((PackageFragmentDto)packagesValX).toJsonElement();;
                    packagesVal.set(packagesVal.size(), packagesValY);
                }
                result.put("packages", packagesVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static PackageFragmentRootDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static PackageFragmentRootDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            PackageFragmentRootDto result= new PackageFragmentRootDto();
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JSONValue jsonpackagesJson = json.get("packages");
            if (jsonpackagesJson != null && !(jsonpackagesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment> jsonpackagesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>();
                JSONArray jsonpackagesVala = jsonpackagesJson.isArray();
                for(int jsonpackagesValai= 0; jsonpackagesValai < jsonpackagesVala.size(); jsonpackagesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment jsonpackagesValaX = PackageFragmentDto.fromJson((JSONObject)jsonpackagesVala.get(jsonpackagesValai));;
                    jsonpackagesVal.add(jsonpackagesValaX);
                }
                result.setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)jsonpackagesVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class PackageFragmentRootDtoProvider implements DtoProvider<PackageFragmentRootDto> {
    	public Class<? extends PackageFragmentRootDto> getImplClass() {
    	  	return PackageFragmentRootDto.class;
    	}
    
    	public PackageFragmentRootDto newInstance() {
        	return new PackageFragmentRootDto();
    	}
    
    	public PackageFragmentRootDto fromJson(String json) {
    		return PackageFragmentRootDto.fromJson(json);
    	}
        public PackageFragmentRootDto fromJson(JSONValue json) {
    		return PackageFragmentRootDto.fromJson(json);
    	}
        public PackageFragmentRootDto clone(PackageFragmentRootDto dto) {
            return PackageFragmentRootDto.fromJson(dto.toJson());
    	}
    }

    public static class UpdateWorkspaceParametersDto extends UpdateWorkspaceParameters implements JsonSerializable {

        public UpdateWorkspaceParametersDto() {
        }

        public UpdateWorkspaceParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters o) {
            if (o.getAddedProjectsUri() == null) {
                setAddedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> addedProjectsUriVal= new ArrayList<java.lang.String>();
                    for (java.lang.String addedProjectsUriValX : o.getAddedProjectsUri()) {
                        java.lang.String addedProjectsUriValY = (java.lang.String)makeDto(addedProjectsUriValX);;
                        addedProjectsUriVal.add(addedProjectsUriValY);
                    }
                setAddedProjectsUri((java.util.List<java.lang.String>)addedProjectsUriVal);
            }
            if (o.getRemovedProjectsUri() == null) {
                setRemovedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> removedProjectsUriVal= new ArrayList<java.lang.String>();
                    for (java.lang.String removedProjectsUriValX : o.getRemovedProjectsUri()) {
                        java.lang.String removedProjectsUriValY = (java.lang.String)makeDto(removedProjectsUriValX);;
                        removedProjectsUriVal.add(removedProjectsUriValY);
                    }
                setRemovedProjectsUri((java.util.List<java.lang.String>)removedProjectsUriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getAddedProjectsUri() == null) {
                setAddedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                JSONArray addedProjectsUriVal = new JSONArray();
                for (java.lang.String addedProjectsUriValX : getAddedProjectsUri()) {
                    JSONValue addedProjectsUriValY = addedProjectsUriValX == null ? JSONNull.getInstance() : new JSONString(addedProjectsUriValX);;
                    addedProjectsUriVal.set(addedProjectsUriVal.size(), addedProjectsUriValY);
                }
                result.put("addedProjectsUri", addedProjectsUriVal);
            }
            if (getRemovedProjectsUri() == null) {
                setRemovedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                JSONArray removedProjectsUriVal = new JSONArray();
                for (java.lang.String removedProjectsUriValX : getRemovedProjectsUri()) {
                    JSONValue removedProjectsUriValY = removedProjectsUriValX == null ? JSONNull.getInstance() : new JSONString(removedProjectsUriValX);;
                    removedProjectsUriVal.set(removedProjectsUriVal.size(), removedProjectsUriValY);
                }
                result.put("removedProjectsUri", removedProjectsUriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateWorkspaceParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static UpdateWorkspaceParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            UpdateWorkspaceParametersDto result= new UpdateWorkspaceParametersDto();
            JSONValue jsonaddedProjectsUriJson = json.get("addedProjectsUri");
            if (jsonaddedProjectsUriJson != null && !(jsonaddedProjectsUriJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonaddedProjectsUriVal= new ArrayList<java.lang.String>();
                JSONArray jsonaddedProjectsUriVala = jsonaddedProjectsUriJson.isArray();
                for(int jsonaddedProjectsUriValai= 0; jsonaddedProjectsUriValai < jsonaddedProjectsUriVala.size(); jsonaddedProjectsUriValai++) {
                    java.lang.String jsonaddedProjectsUriValaX = jsonaddedProjectsUriVala.get(jsonaddedProjectsUriValai).isString().stringValue();;
                    jsonaddedProjectsUriVal.add(jsonaddedProjectsUriValaX);
                }
                result.setAddedProjectsUri((java.util.List<java.lang.String>)jsonaddedProjectsUriVal);
            }
            JSONValue jsonremovedProjectsUriJson = json.get("removedProjectsUri");
            if (jsonremovedProjectsUriJson != null && !(jsonremovedProjectsUriJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonremovedProjectsUriVal= new ArrayList<java.lang.String>();
                JSONArray jsonremovedProjectsUriVala = jsonremovedProjectsUriJson.isArray();
                for(int jsonremovedProjectsUriValai= 0; jsonremovedProjectsUriValai < jsonremovedProjectsUriVala.size(); jsonremovedProjectsUriValai++) {
                    java.lang.String jsonremovedProjectsUriValaX = jsonremovedProjectsUriVala.get(jsonremovedProjectsUriValai).isString().stringValue();;
                    jsonremovedProjectsUriVal.add(jsonremovedProjectsUriValaX);
                }
                result.setRemovedProjectsUri((java.util.List<java.lang.String>)jsonremovedProjectsUriVal);
            }
            return result;
        }
    }

    public static class UpdateWorkspaceParametersDtoProvider implements DtoProvider<UpdateWorkspaceParametersDto> {
    	public Class<? extends UpdateWorkspaceParametersDto> getImplClass() {
    	  	return UpdateWorkspaceParametersDto.class;
    	}
    
    	public UpdateWorkspaceParametersDto newInstance() {
        	return new UpdateWorkspaceParametersDto();
    	}
    
    	public UpdateWorkspaceParametersDto fromJson(String json) {
    		return UpdateWorkspaceParametersDto.fromJson(json);
    	}
        public UpdateWorkspaceParametersDto fromJson(JSONValue json) {
    		return UpdateWorkspaceParametersDto.fromJson(json);
    	}
        public UpdateWorkspaceParametersDto clone(UpdateWorkspaceParametersDto dto) {
            return UpdateWorkspaceParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class RenamingElementInfoDto extends RenamingElementInfo implements JsonSerializable {

        public RenamingElementInfoDto() {
        }

        public RenamingElementInfoDto(org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo o) {
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
            if (o.getElementName() == null) {
                setElementName((java.lang.String)null);
            } else {
                java.lang.String elementNameVal = (java.lang.String)makeDto(o.getElementName());;
                setElementName((java.lang.String)elementNameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JSONValue renameKindVal = getRenameKind() == null ? JSONNull.getInstance() : new JSONString(getRenameKind().name());;
                result.put("renameKind", renameKindVal);
            }
            if (getElementName() == null) {
                setElementName((java.lang.String)null);
            } else {
                JSONValue elementNameVal = getElementName() == null ? JSONNull.getInstance() : new JSONString(getElementName());;
                result.put("elementName", elementNameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenamingElementInfoDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RenamingElementInfoDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RenamingElementInfoDto result= new RenamingElementInfoDto();
            JSONValue jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.isString().stringValue());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JSONValue jsonelementNameJson = json.get("elementName");
            if (jsonelementNameJson != null && !(jsonelementNameJson.isNull() != null)) {
                java.lang.String jsonelementNameVal = jsonelementNameJson.isString().stringValue();;
                result.setElementName((java.lang.String)jsonelementNameVal);
            }
            return result;
        }
    }

    public static class RenamingElementInfoDtoProvider implements DtoProvider<RenamingElementInfoDto> {
    	public Class<? extends RenamingElementInfoDto> getImplClass() {
    	  	return RenamingElementInfoDto.class;
    	}
    
    	public RenamingElementInfoDto newInstance() {
        	return new RenamingElementInfoDto();
    	}
    
    	public RenamingElementInfoDto fromJson(String json) {
    		return RenamingElementInfoDto.fromJson(json);
    	}
        public RenamingElementInfoDto fromJson(JSONValue json) {
    		return RenamingElementInfoDto.fromJson(json);
    	}
        public RenamingElementInfoDto clone(RenamingElementInfoDto dto) {
            return RenamingElementInfoDto.fromJson(dto.toJson());
    	}
    }

    public static class UpdateClasspathParametersDto extends UpdateClasspathParameters implements JsonSerializable {

        public UpdateClasspathParametersDto() {
        }

        public UpdateClasspathParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getEntries() == null) {
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> entriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValX : o.getEntries()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValY = new ClasspathEntryDto(entriesValX);
                        entriesVal.add(entriesValY);
                    }
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)entriesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            if (getEntries() == null) {
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                JSONArray entriesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValX : getEntries()) {
                    JSONValue entriesValY = entriesValX == null ? JSONNull.getInstance() : ((ClasspathEntryDto)entriesValX).toJsonElement();;
                    entriesVal.set(entriesVal.size(), entriesValY);
                }
                result.put("entries", entriesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateClasspathParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static UpdateClasspathParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            UpdateClasspathParametersDto result= new UpdateClasspathParametersDto();
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JSONValue jsonentriesJson = json.get("entries");
            if (jsonentriesJson != null && !(jsonentriesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> jsonentriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                JSONArray jsonentriesVala = jsonentriesJson.isArray();
                for(int jsonentriesValai= 0; jsonentriesValai < jsonentriesVala.size(); jsonentriesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry jsonentriesValaX = ClasspathEntryDto.fromJson((JSONObject)jsonentriesVala.get(jsonentriesValai));;
                    jsonentriesVal.add(jsonentriesValaX);
                }
                result.setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)jsonentriesVal);
            }
            return result;
        }
    }

    public static class UpdateClasspathParametersDtoProvider implements DtoProvider<UpdateClasspathParametersDto> {
    	public Class<? extends UpdateClasspathParametersDto> getImplClass() {
    	  	return UpdateClasspathParametersDto.class;
    	}
    
    	public UpdateClasspathParametersDto newInstance() {
        	return new UpdateClasspathParametersDto();
    	}
    
    	public UpdateClasspathParametersDto fromJson(String json) {
    		return UpdateClasspathParametersDto.fromJson(json);
    	}
        public UpdateClasspathParametersDto fromJson(JSONValue json) {
    		return UpdateClasspathParametersDto.fromJson(json);
    	}
        public UpdateClasspathParametersDto clone(UpdateClasspathParametersDto dto) {
            return UpdateClasspathParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class RenameSelectionParamsDto extends RenameSelectionParams implements JsonSerializable {

        public RenameSelectionParamsDto() {
        }

        public RenameSelectionParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams o) {
            if (o.getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                java.lang.String resourceUriVal = (java.lang.String)makeDto(o.getResourceUri());;
                setResourceUri((java.lang.String)resourceUriVal);
            }
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
            if (o.getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                org.eclipse.lsp4j.Position positionVal = (org.eclipse.lsp4j.Position)makeDto(o.getPosition());;
                setPosition((org.eclipse.lsp4j.Position)positionVal);
            }
            if (o.getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                java.lang.String newNameVal = (java.lang.String)makeDto(o.getNewName());;
                setNewName((java.lang.String)newNameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                JSONValue resourceUriVal = getResourceUri() == null ? JSONNull.getInstance() : new JSONString(getResourceUri());;
                result.put("resourceUri", resourceUriVal);
            }
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JSONValue renameKindVal = getRenameKind() == null ? JSONNull.getInstance() : new JSONString(getRenameKind().name());;
                result.put("renameKind", renameKindVal);
            }
            if (getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                JSONValue positionVal = getPosition() == null ? JSONNull.getInstance() : ((PositionDto)getPosition()).toJsonElement();;
                result.put("position", positionVal);
            }
            if (getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                JSONValue newNameVal = getNewName() == null ? JSONNull.getInstance() : new JSONString(getNewName());;
                result.put("newName", newNameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenameSelectionParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RenameSelectionParamsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RenameSelectionParamsDto result= new RenameSelectionParamsDto();
            JSONValue jsonresourceUriJson = json.get("resourceUri");
            if (jsonresourceUriJson != null && !(jsonresourceUriJson.isNull() != null)) {
                java.lang.String jsonresourceUriVal = jsonresourceUriJson.isString().stringValue();;
                result.setResourceUri((java.lang.String)jsonresourceUriVal);
            }
            JSONValue jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.isString().stringValue());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JSONValue jsonpositionJson = json.get("position");
            if (jsonpositionJson != null && !(jsonpositionJson.isNull() != null)) {
                org.eclipse.lsp4j.Position jsonpositionVal = PositionDto.fromJson((JSONObject)jsonpositionJson);;
                result.setPosition((org.eclipse.lsp4j.Position)jsonpositionVal);
            }
            JSONValue jsonnewNameJson = json.get("newName");
            if (jsonnewNameJson != null && !(jsonnewNameJson.isNull() != null)) {
                java.lang.String jsonnewNameVal = jsonnewNameJson.isString().stringValue();;
                result.setNewName((java.lang.String)jsonnewNameVal);
            }
            return result;
        }
    }

    public static class RenameSelectionParamsDtoProvider implements DtoProvider<RenameSelectionParamsDto> {
    	public Class<? extends RenameSelectionParamsDto> getImplClass() {
    	  	return RenameSelectionParamsDto.class;
    	}
    
    	public RenameSelectionParamsDto newInstance() {
        	return new RenameSelectionParamsDto();
    	}
    
    	public RenameSelectionParamsDto fromJson(String json) {
    		return RenameSelectionParamsDto.fromJson(json);
    	}
        public RenameSelectionParamsDto fromJson(JSONValue json) {
    		return RenameSelectionParamsDto.fromJson(json);
    	}
        public RenameSelectionParamsDto clone(RenameSelectionParamsDto dto) {
            return RenameSelectionParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class JdtLsPreferencesDto extends JdtLsPreferences implements JsonSerializable {

        public JdtLsPreferencesDto() {
        }

        public JdtLsPreferencesDto(org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences o) {
            if (o.getPreferences() == null) {
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                    java.util.Map<java.lang.String, java.lang.String> preferencesVal= new HashMap<String, java.lang.String>();
                    for (Entry<String, java.lang.String> preferencesValX : o.getPreferences().entrySet()) {
                        java.lang.String preferencesValY = (java.lang.String)makeDto(preferencesValX.getValue());;
                        preferencesVal.put(preferencesValX.getKey(), preferencesValY);
                    }
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)preferencesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getPreferences() == null) {
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                JSONObject preferencesVal = new JSONObject();
                for (Entry<String, java.lang.String> preferencesValX : getPreferences().entrySet()) {
                    JSONValue preferencesValY = preferencesValX.getValue() == null ? JSONNull.getInstance() : new JSONString(preferencesValX.getValue());;
                    preferencesVal.put(preferencesValX.getKey().toString(), preferencesValY);
                }
                result.put("preferences", preferencesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JdtLsPreferencesDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JdtLsPreferencesDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JdtLsPreferencesDto result= new JdtLsPreferencesDto();
            JSONValue jsonpreferencesJson = json.get("preferences");
            if (jsonpreferencesJson != null && !(jsonpreferencesJson.isNull() != null)) {
                java.util.Map<java.lang.String, java.lang.String> jsonpreferencesVal= new HashMap<String, java.lang.String>();
                JSONObject jsonpreferencesValo = jsonpreferencesJson.isObject();
                for(String jsonpreferencesValok : jsonpreferencesValo.keySet()) {
                    java.lang.String jsonpreferencesValoX = jsonpreferencesValo.get(jsonpreferencesValok).isString().stringValue();;
                    jsonpreferencesVal.put(jsonpreferencesValok, jsonpreferencesValoX);
                }
                result.setPreferences((java.util.Map<java.lang.String, java.lang.String>)jsonpreferencesVal);
            }
            return result;
        }
    }

    public static class JdtLsPreferencesDtoProvider implements DtoProvider<JdtLsPreferencesDto> {
    	public Class<? extends JdtLsPreferencesDto> getImplClass() {
    	  	return JdtLsPreferencesDto.class;
    	}
    
    	public JdtLsPreferencesDto newInstance() {
        	return new JdtLsPreferencesDto();
    	}
    
    	public JdtLsPreferencesDto fromJson(String json) {
    		return JdtLsPreferencesDto.fromJson(json);
    	}
        public JdtLsPreferencesDto fromJson(JSONValue json) {
    		return JdtLsPreferencesDto.fromJson(json);
    	}
        public JdtLsPreferencesDto clone(JdtLsPreferencesDto dto) {
            return JdtLsPreferencesDto.fromJson(dto.toJson());
    	}
    }

    public static class TestFindParametersDto extends TestFindParameters implements JsonSerializable {

        public TestFindParametersDto() {
        }

        public TestFindParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters o) {
            if (o.getSourceUri() == null) {
                setSourceUri((java.lang.String)null);
            } else {
                java.lang.String sourceUriVal = (java.lang.String)makeDto(o.getSourceUri());;
                setSourceUri((java.lang.String)sourceUriVal);
            }
            if (o.getTestMethodAnnotation() == null) {
                setTestMethodAnnotation((java.lang.String)null);
            } else {
                java.lang.String testMethodAnnotationVal = (java.lang.String)makeDto(o.getTestMethodAnnotation());;
                setTestMethodAnnotation((java.lang.String)testMethodAnnotationVal);
            }
            if (o.getTestClassAnnotation() == null) {
                setTestClassAnnotation((java.lang.String)null);
            } else {
                java.lang.String testClassAnnotationVal = (java.lang.String)makeDto(o.getTestClassAnnotation());;
                setTestClassAnnotation((java.lang.String)testClassAnnotationVal);
            }
                int cursorOffsetVal = (int)makeDto(o.getCursorOffset());;
                setCursorOffset((int)cursorOffsetVal);
            if (o.getEntryClasses() == null) {
                setEntryClasses((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> entryClassesVal= new ArrayList<java.lang.String>();
                    for (java.lang.String entryClassesValX : o.getEntryClasses()) {
                        java.lang.String entryClassesValY = (java.lang.String)makeDto(entryClassesValX);;
                        entryClassesVal.add(entryClassesValY);
                    }
                setEntryClasses((java.util.List<java.lang.String>)entryClassesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getSourceUri() == null) {
                setSourceUri((java.lang.String)null);
            } else {
                JSONValue sourceUriVal = getSourceUri() == null ? JSONNull.getInstance() : new JSONString(getSourceUri());;
                result.put("sourceUri", sourceUriVal);
            }
            if (getTestMethodAnnotation() == null) {
                setTestMethodAnnotation((java.lang.String)null);
            } else {
                JSONValue testMethodAnnotationVal = getTestMethodAnnotation() == null ? JSONNull.getInstance() : new JSONString(getTestMethodAnnotation());;
                result.put("testMethodAnnotation", testMethodAnnotationVal);
            }
            if (getTestClassAnnotation() == null) {
                setTestClassAnnotation((java.lang.String)null);
            } else {
                JSONValue testClassAnnotationVal = getTestClassAnnotation() == null ? JSONNull.getInstance() : new JSONString(getTestClassAnnotation());;
                result.put("testClassAnnotation", testClassAnnotationVal);
            }
            JSONValue cursorOffsetVal = new JSONNumber(getCursorOffset());;
                result.put("cursorOffset", cursorOffsetVal);
            if (getEntryClasses() == null) {
                setEntryClasses((java.util.List<java.lang.String>)null);
            } else {
                JSONArray entryClassesVal = new JSONArray();
                for (java.lang.String entryClassesValX : getEntryClasses()) {
                    JSONValue entryClassesValY = entryClassesValX == null ? JSONNull.getInstance() : new JSONString(entryClassesValX);;
                    entryClassesVal.set(entryClassesVal.size(), entryClassesValY);
                }
                result.put("entryClasses", entryClassesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestFindParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static TestFindParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            TestFindParametersDto result= new TestFindParametersDto();
            JSONValue jsonsourceUriJson = json.get("sourceUri");
            if (jsonsourceUriJson != null && !(jsonsourceUriJson.isNull() != null)) {
                java.lang.String jsonsourceUriVal = jsonsourceUriJson.isString().stringValue();;
                result.setSourceUri((java.lang.String)jsonsourceUriVal);
            }
            JSONValue jsontestMethodAnnotationJson = json.get("testMethodAnnotation");
            if (jsontestMethodAnnotationJson != null && !(jsontestMethodAnnotationJson.isNull() != null)) {
                java.lang.String jsontestMethodAnnotationVal = jsontestMethodAnnotationJson.isString().stringValue();;
                result.setTestMethodAnnotation((java.lang.String)jsontestMethodAnnotationVal);
            }
            JSONValue jsontestClassAnnotationJson = json.get("testClassAnnotation");
            if (jsontestClassAnnotationJson != null && !(jsontestClassAnnotationJson.isNull() != null)) {
                java.lang.String jsontestClassAnnotationVal = jsontestClassAnnotationJson.isString().stringValue();;
                result.setTestClassAnnotation((java.lang.String)jsontestClassAnnotationVal);
            }
            JSONValue jsoncursorOffsetJson = json.get("cursorOffset");
            if (jsoncursorOffsetJson != null && !(jsoncursorOffsetJson.isNull() != null)) {
                int jsoncursorOffsetVal = (int)jsoncursorOffsetJson.isNumber().doubleValue();;
                result.setCursorOffset((int)jsoncursorOffsetVal);
            }
            JSONValue jsonentryClassesJson = json.get("entryClasses");
            if (jsonentryClassesJson != null && !(jsonentryClassesJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonentryClassesVal= new ArrayList<java.lang.String>();
                JSONArray jsonentryClassesVala = jsonentryClassesJson.isArray();
                for(int jsonentryClassesValai= 0; jsonentryClassesValai < jsonentryClassesVala.size(); jsonentryClassesValai++) {
                    java.lang.String jsonentryClassesValaX = jsonentryClassesVala.get(jsonentryClassesValai).isString().stringValue();;
                    jsonentryClassesVal.add(jsonentryClassesValaX);
                }
                result.setEntryClasses((java.util.List<java.lang.String>)jsonentryClassesVal);
            }
            return result;
        }
    }

    public static class TestFindParametersDtoProvider implements DtoProvider<TestFindParametersDto> {
    	public Class<? extends TestFindParametersDto> getImplClass() {
    	  	return TestFindParametersDto.class;
    	}
    
    	public TestFindParametersDto newInstance() {
        	return new TestFindParametersDto();
    	}
    
    	public TestFindParametersDto fromJson(String json) {
    		return TestFindParametersDto.fromJson(json);
    	}
        public TestFindParametersDto fromJson(JSONValue json) {
    		return TestFindParametersDto.fromJson(json);
    	}
        public TestFindParametersDto clone(TestFindParametersDto dto) {
            return TestFindParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class ProgressReportDto extends ProgressReport implements JsonSerializable {

        public ProgressReportDto() {
        }

        public ProgressReportDto(org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport o) {
                boolean completeVal = (boolean)makeDto(o.isComplete());;
                setComplete((boolean)completeVal);
                int totalWorkVal = (int)makeDto(o.getTotalWork());;
                setTotalWork((int)totalWorkVal);
                int workDoneVal = (int)makeDto(o.getWorkDone());;
                setWorkDone((int)workDoneVal);
            if (o.getSubTask() == null) {
                setSubTask((java.lang.String)null);
            } else {
                java.lang.String subTaskVal = (java.lang.String)makeDto(o.getSubTask());;
                setSubTask((java.lang.String)subTaskVal);
            }
            if (o.getTask() == null) {
                setTask((java.lang.String)null);
            } else {
                java.lang.String taskVal = (java.lang.String)makeDto(o.getTask());;
                setTask((java.lang.String)taskVal);
            }
            if (o.getId() == null) {
                setId((java.lang.String)null);
            } else {
                java.lang.String idVal = (java.lang.String)makeDto(o.getId());;
                setId((java.lang.String)idVal);
            }
            if (o.getStatus() == null) {
                setStatus((java.lang.String)null);
            } else {
                java.lang.String statusVal = (java.lang.String)makeDto(o.getStatus());;
                setStatus((java.lang.String)statusVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue completeVal = JSONBoolean.getInstance(isComplete());;
                result.put("complete", completeVal);
            JSONValue totalWorkVal = new JSONNumber(getTotalWork());;
                result.put("totalWork", totalWorkVal);
            JSONValue workDoneVal = new JSONNumber(getWorkDone());;
                result.put("workDone", workDoneVal);
            if (getSubTask() == null) {
                setSubTask((java.lang.String)null);
            } else {
                JSONValue subTaskVal = getSubTask() == null ? JSONNull.getInstance() : new JSONString(getSubTask());;
                result.put("subTask", subTaskVal);
            }
            if (getTask() == null) {
                setTask((java.lang.String)null);
            } else {
                JSONValue taskVal = getTask() == null ? JSONNull.getInstance() : new JSONString(getTask());;
                result.put("task", taskVal);
            }
            if (getId() == null) {
                setId((java.lang.String)null);
            } else {
                JSONValue idVal = getId() == null ? JSONNull.getInstance() : new JSONString(getId());;
                result.put("id", idVal);
            }
            if (getStatus() == null) {
                setStatus((java.lang.String)null);
            } else {
                JSONValue statusVal = getStatus() == null ? JSONNull.getInstance() : new JSONString(getStatus());;
                result.put("status", statusVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ProgressReportDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ProgressReportDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ProgressReportDto result= new ProgressReportDto();
            JSONValue jsoncompleteJson = json.get("complete");
            if (jsoncompleteJson != null && !(jsoncompleteJson.isNull() != null)) {
                boolean jsoncompleteVal = jsoncompleteJson.isBoolean().booleanValue();
                result.setComplete((boolean)jsoncompleteVal);
            }
            JSONValue jsontotalWorkJson = json.get("totalWork");
            if (jsontotalWorkJson != null && !(jsontotalWorkJson.isNull() != null)) {
                int jsontotalWorkVal = (int)jsontotalWorkJson.isNumber().doubleValue();;
                result.setTotalWork((int)jsontotalWorkVal);
            }
            JSONValue jsonworkDoneJson = json.get("workDone");
            if (jsonworkDoneJson != null && !(jsonworkDoneJson.isNull() != null)) {
                int jsonworkDoneVal = (int)jsonworkDoneJson.isNumber().doubleValue();;
                result.setWorkDone((int)jsonworkDoneVal);
            }
            JSONValue jsonsubTaskJson = json.get("subTask");
            if (jsonsubTaskJson != null && !(jsonsubTaskJson.isNull() != null)) {
                java.lang.String jsonsubTaskVal = jsonsubTaskJson.isString().stringValue();;
                result.setSubTask((java.lang.String)jsonsubTaskVal);
            }
            JSONValue jsontaskJson = json.get("task");
            if (jsontaskJson != null && !(jsontaskJson.isNull() != null)) {
                java.lang.String jsontaskVal = jsontaskJson.isString().stringValue();;
                result.setTask((java.lang.String)jsontaskVal);
            }
            JSONValue jsonidJson = json.get("id");
            if (jsonidJson != null && !(jsonidJson.isNull() != null)) {
                java.lang.String jsonidVal = jsonidJson.isString().stringValue();;
                result.setId((java.lang.String)jsonidVal);
            }
            JSONValue jsonstatusJson = json.get("status");
            if (jsonstatusJson != null && !(jsonstatusJson.isNull() != null)) {
                java.lang.String jsonstatusVal = jsonstatusJson.isString().stringValue();;
                result.setStatus((java.lang.String)jsonstatusVal);
            }
            return result;
        }
    }

    public static class ProgressReportDtoProvider implements DtoProvider<ProgressReportDto> {
    	public Class<? extends ProgressReportDto> getImplClass() {
    	  	return ProgressReportDto.class;
    	}
    
    	public ProgressReportDto newInstance() {
        	return new ProgressReportDto();
    	}
    
    	public ProgressReportDto fromJson(String json) {
    		return ProgressReportDto.fromJson(json);
    	}
        public ProgressReportDto fromJson(JSONValue json) {
    		return ProgressReportDto.fromJson(json);
    	}
        public ProgressReportDto clone(ProgressReportDto dto) {
            return ProgressReportDto.fromJson(dto.toJson());
    	}
    }

    public static class CreateMoveParamsDto extends CreateMoveParams implements JsonSerializable {

        public CreateMoveParamsDto() {
        }

        public CreateMoveParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getResources() == null) {
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> resourcesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValX : o.getResources()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValY = new ResourceDto(resourcesValX);
                        resourcesVal.add(resourcesValY);
                    }
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)resourcesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            if (getResources() == null) {
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                JSONArray resourcesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValX : getResources()) {
                    JSONValue resourcesValY = resourcesValX == null ? JSONNull.getInstance() : ((ResourceDto)resourcesValX).toJsonElement();;
                    resourcesVal.set(resourcesVal.size(), resourcesValY);
                }
                result.put("resources", resourcesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CreateMoveParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static CreateMoveParamsDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            CreateMoveParamsDto result= new CreateMoveParamsDto();
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JSONValue jsonresourcesJson = json.get("resources");
            if (jsonresourcesJson != null && !(jsonresourcesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> jsonresourcesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                JSONArray jsonresourcesVala = jsonresourcesJson.isArray();
                for(int jsonresourcesValai= 0; jsonresourcesValai < jsonresourcesVala.size(); jsonresourcesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.Resource jsonresourcesValaX = ResourceDto.fromJson((JSONObject)jsonresourcesVala.get(jsonresourcesValai));;
                    jsonresourcesVal.add(jsonresourcesValaX);
                }
                result.setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)jsonresourcesVal);
            }
            return result;
        }
    }

    public static class CreateMoveParamsDtoProvider implements DtoProvider<CreateMoveParamsDto> {
    	public Class<? extends CreateMoveParamsDto> getImplClass() {
    	  	return CreateMoveParamsDto.class;
    	}
    
    	public CreateMoveParamsDto newInstance() {
        	return new CreateMoveParamsDto();
    	}
    
    	public CreateMoveParamsDto fromJson(String json) {
    		return CreateMoveParamsDto.fromJson(json);
    	}
        public CreateMoveParamsDto fromJson(JSONValue json) {
    		return CreateMoveParamsDto.fromJson(json);
    	}
        public CreateMoveParamsDto clone(CreateMoveParamsDto dto) {
            return CreateMoveParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class CheWorkspaceEditDto extends CheWorkspaceEdit implements JsonSerializable {

        public CheWorkspaceEditDto() {
        }

        public CheWorkspaceEditDto(org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit o) {
            if (o.getCheResourceChanges() == null) {
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange> cheResourceChangesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValX : o.getCheResourceChanges()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValY = new CheResourceChangeDto(cheResourceChangesValX);
                        cheResourceChangesVal.add(cheResourceChangesValY);
                    }
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)cheResourceChangesVal);
            }
            if (o.getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                    java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                    for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : o.getChanges().entrySet()) {
                            ArrayList<org.eclipse.lsp4j.TextEdit> changesValY= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                            for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                                org.eclipse.lsp4j.TextEdit changesValYY = (org.eclipse.lsp4j.TextEdit)makeDto(changesValYX);;
                                changesValY.add(changesValYY);
                            }
                        changesVal.put(changesValX.getKey(), changesValY);
                    }
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)changesVal);
            }
            if (o.getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>> documentChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>();
                    for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation> documentChangesValX : o.getDocumentChanges()) {
                            org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation> documentChangesValY;
                            if (documentChangesValX.getLeft() != null) {
                                org.eclipse.lsp4j.TextDocumentEdit documentChangesValYe = (org.eclipse.lsp4j.TextDocumentEdit)makeDto(documentChangesValX.getLeft());;
                                documentChangesValY= Either.forLeft(documentChangesValYe);
                            } else  {
                                org.eclipse.lsp4j.ResourceOperation documentChangesValYe = (org.eclipse.lsp4j.ResourceOperation)makeDto(documentChangesValX.getRight());;
                                documentChangesValY= Either.forRight(documentChangesValYe);
                            }
                        documentChangesVal.add(documentChangesValY);
                    }
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>)documentChangesVal);
            }
            if (o.getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> resourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                    for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : o.getResourceChanges()) {
                            org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValY;
                            if (resourceChangesValX.getLeft() != null) {
                                org.eclipse.lsp4j.ResourceChange resourceChangesValYe = (org.eclipse.lsp4j.ResourceChange)makeDto(resourceChangesValX.getLeft());;
                                resourceChangesValY= Either.forLeft(resourceChangesValYe);
                            } else  {
                                org.eclipse.lsp4j.TextDocumentEdit resourceChangesValYe = (org.eclipse.lsp4j.TextDocumentEdit)makeDto(resourceChangesValX.getRight());;
                                resourceChangesValY= Either.forRight(resourceChangesValYe);
                            }
                        resourceChangesVal.add(resourceChangesValY);
                    }
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)resourceChangesVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getCheResourceChanges() == null) {
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)null);
            } else {
                JSONArray cheResourceChangesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValX : getCheResourceChanges()) {
                    JSONValue cheResourceChangesValY = cheResourceChangesValX == null ? JSONNull.getInstance() : ((CheResourceChangeDto)cheResourceChangesValX).toJsonElement();;
                    cheResourceChangesVal.set(cheResourceChangesVal.size(), cheResourceChangesValY);
                }
                result.put("cheResourceChanges", cheResourceChangesVal);
            }
            if (getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                JSONObject changesVal = new JSONObject();
                for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : getChanges().entrySet()) {
                    JSONArray changesValY = new JSONArray();
                    for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                        JSONValue changesValYY = changesValYX == null ? JSONNull.getInstance() : ((TextEditDto)changesValYX).toJsonElement();;
                        changesValY.set(changesValY.size(), changesValYY);
                    }
                    changesVal.put(changesValX.getKey().toString(), changesValY);
                }
                result.put("changes", changesVal);
            }
            if (getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>)null);
            } else {
                JSONArray documentChangesVal = new JSONArray();
                for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation> documentChangesValX : getDocumentChanges()) {
                    JSONValue documentChangesValY;
                    if (documentChangesValX.getLeft() != null) {
                        JSONValue documentChangesValYe = documentChangesValX.getLeft() == null ? JSONNull.getInstance() : ((TextDocumentEditDto)documentChangesValX.getLeft()).toJsonElement();;
                        documentChangesValY= documentChangesValYe;
                    } else  {
                        JSONValue documentChangesValYe = documentChangesValX.getRight() == null ? JSONNull.getInstance() : ((ResourceOperationDto)documentChangesValX.getRight()).toJsonElement();;
                        documentChangesValY= documentChangesValYe;
                    }
                    documentChangesVal.set(documentChangesVal.size(), documentChangesValY);
                }
                result.put("documentChanges", documentChangesVal);
            }
            if (getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                JSONArray resourceChangesVal = new JSONArray();
                for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : getResourceChanges()) {
                    JSONValue resourceChangesValY;
                    if (resourceChangesValX.getLeft() != null) {
                        JSONValue resourceChangesValYe = resourceChangesValX.getLeft() == null ? JSONNull.getInstance() : ((ResourceChangeDto)resourceChangesValX.getLeft()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    } else  {
                        JSONValue resourceChangesValYe = resourceChangesValX.getRight() == null ? JSONNull.getInstance() : ((TextDocumentEditDto)resourceChangesValX.getRight()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    }
                    resourceChangesVal.set(resourceChangesVal.size(), resourceChangesValY);
                }
                result.put("resourceChanges", resourceChangesVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CheWorkspaceEditDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static CheWorkspaceEditDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            CheWorkspaceEditDto result= new CheWorkspaceEditDto();
            JSONValue jsoncheResourceChangesJson = json.get("cheResourceChanges");
            if (jsoncheResourceChangesJson != null && !(jsoncheResourceChangesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange> jsoncheResourceChangesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>();
                JSONArray jsoncheResourceChangesVala = jsoncheResourceChangesJson.isArray();
                for(int jsoncheResourceChangesValai= 0; jsoncheResourceChangesValai < jsoncheResourceChangesVala.size(); jsoncheResourceChangesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange jsoncheResourceChangesValaX = CheResourceChangeDto.fromJson((JSONObject)jsoncheResourceChangesVala.get(jsoncheResourceChangesValai));;
                    jsoncheResourceChangesVal.add(jsoncheResourceChangesValaX);
                }
                result.setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)jsoncheResourceChangesVal);
            }
            JSONValue jsonchangesJson = json.get("changes");
            if (jsonchangesJson != null && !(jsonchangesJson.isNull() != null)) {
                java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> jsonchangesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                JSONObject jsonchangesValo = jsonchangesJson.isObject();
                for(String jsonchangesValok : jsonchangesValo.keySet()) {
                    ArrayList<org.eclipse.lsp4j.TextEdit> jsonchangesValoX= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                    JSONArray jsonchangesValoXa = jsonchangesValo.get(jsonchangesValok).isArray();
                    for(int jsonchangesValoXai= 0; jsonchangesValoXai < jsonchangesValoXa.size(); jsonchangesValoXai++) {
                        org.eclipse.lsp4j.TextEdit jsonchangesValoXaX = TextEditDto.fromJson((JSONObject)jsonchangesValoXa.get(jsonchangesValoXai));;
                        jsonchangesValoX.add(jsonchangesValoXaX);
                    }
                    jsonchangesVal.put(jsonchangesValok, jsonchangesValoX);
                }
                result.setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)jsonchangesVal);
            }
            JSONValue jsondocumentChangesJson = json.get("documentChanges");
            if (jsondocumentChangesJson != null && !(jsondocumentChangesJson.isNull() != null)) {
                ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>> jsondocumentChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>();
                JSONArray jsondocumentChangesVala = jsondocumentChangesJson.isArray();
                for(int jsondocumentChangesValai= 0; jsondocumentChangesValai < jsondocumentChangesVala.size(); jsondocumentChangesValai++) {
                    JsonDecision[] jsondocumentChangesValaXecls= new JsonDecision[] {
                        JsonDecision.OBJECT
                    };
                    org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation> jsondocumentChangesValaX;
                    if (EitherUtil.matches(jsondocumentChangesVala.get(jsondocumentChangesValai), jsondocumentChangesValaXecls)) {
                        org.eclipse.lsp4j.TextDocumentEdit jsondocumentChangesValaXe = TextDocumentEditDto.fromJson((JSONObject)jsondocumentChangesVala.get(jsondocumentChangesValai));;
                        jsondocumentChangesValaX= Either.forLeft(jsondocumentChangesValaXe);
                    } else  {
                        org.eclipse.lsp4j.ResourceOperation jsondocumentChangesValaXe = ResourceOperationDto.fromJson((JSONObject)jsondocumentChangesVala.get(jsondocumentChangesValai));;
                        jsondocumentChangesValaX= Either.forRight(jsondocumentChangesValaXe);
                    }
                    jsondocumentChangesVal.add(jsondocumentChangesValaX);
                }
                result.setDocumentChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.TextDocumentEdit, org.eclipse.lsp4j.ResourceOperation>>)jsondocumentChangesVal);
            }
            JSONValue jsonresourceChangesJson = json.get("resourceChanges");
            if (jsonresourceChangesJson != null && !(jsonresourceChangesJson.isNull() != null)) {
                ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> jsonresourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                JSONArray jsonresourceChangesVala = jsonresourceChangesJson.isArray();
                for(int jsonresourceChangesValai= 0; jsonresourceChangesValai < jsonresourceChangesVala.size(); jsonresourceChangesValai++) {
                    JsonDecision[] jsonresourceChangesValaXecls= new JsonDecision[] {
                        JsonDecision.OBJECT
                    };
                    org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> jsonresourceChangesValaX;
                    if (EitherUtil.matches(jsonresourceChangesVala.get(jsonresourceChangesValai), jsonresourceChangesValaXecls)) {
                        org.eclipse.lsp4j.ResourceChange jsonresourceChangesValaXe = ResourceChangeDto.fromJson((JSONObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forLeft(jsonresourceChangesValaXe);
                    } else  {
                        org.eclipse.lsp4j.TextDocumentEdit jsonresourceChangesValaXe = TextDocumentEditDto.fromJson((JSONObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forRight(jsonresourceChangesValaXe);
                    }
                    jsonresourceChangesVal.add(jsonresourceChangesValaX);
                }
                result.setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)jsonresourceChangesVal);
            }
            return result;
        }
    }

    public static class CheWorkspaceEditDtoProvider implements DtoProvider<CheWorkspaceEditDto> {
    	public Class<? extends CheWorkspaceEditDto> getImplClass() {
    	  	return CheWorkspaceEditDto.class;
    	}
    
    	public CheWorkspaceEditDto newInstance() {
        	return new CheWorkspaceEditDto();
    	}
    
    	public CheWorkspaceEditDto fromJson(String json) {
    		return CheWorkspaceEditDto.fromJson(json);
    	}
        public CheWorkspaceEditDto fromJson(JSONValue json) {
    		return CheWorkspaceEditDto.fromJson(json);
    	}
        public CheWorkspaceEditDto clone(CheWorkspaceEditDto dto) {
            return CheWorkspaceEditDto.fromJson(dto.toJson());
    	}
    }

    public static class JarEntryDto extends JarEntry implements JsonSerializable {

        public JarEntryDto() {
        }

        public JarEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.JarEntry o) {
            if (o.getEntryType() == null) {
                setEntryType((java.lang.String)null);
            } else {
                java.lang.String entryTypeVal = (java.lang.String)makeDto(o.getEntryType());;
                setEntryType((java.lang.String)entryTypeVal);
            }
            if (o.getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                java.lang.String pathVal = (java.lang.String)makeDto(o.getPath());;
                setPath((java.lang.String)pathVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getEntryType() == null) {
                setEntryType((java.lang.String)null);
            } else {
                JSONValue entryTypeVal = getEntryType() == null ? JSONNull.getInstance() : new JSONString(getEntryType());;
                result.put("entryType", entryTypeVal);
            }
            if (getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                JSONValue pathVal = getPath() == null ? JSONNull.getInstance() : new JSONString(getPath());;
                result.put("path", pathVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JSONValue nameVal = getName() == null ? JSONNull.getInstance() : new JSONString(getName());;
                result.put("name", nameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JarEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JarEntryDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JarEntryDto result= new JarEntryDto();
            JSONValue jsonentryTypeJson = json.get("entryType");
            if (jsonentryTypeJson != null && !(jsonentryTypeJson.isNull() != null)) {
                java.lang.String jsonentryTypeVal = jsonentryTypeJson.isString().stringValue();;
                result.setEntryType((java.lang.String)jsonentryTypeVal);
            }
            JSONValue jsonpathJson = json.get("path");
            if (jsonpathJson != null && !(jsonpathJson.isNull() != null)) {
                java.lang.String jsonpathVal = jsonpathJson.isString().stringValue();;
                result.setPath((java.lang.String)jsonpathVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JSONValue jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isNull() != null)) {
                java.lang.String jsonnameVal = jsonnameJson.isString().stringValue();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JarEntryDtoProvider implements DtoProvider<JarEntryDto> {
    	public Class<? extends JarEntryDto> getImplClass() {
    	  	return JarEntryDto.class;
    	}
    
    	public JarEntryDto newInstance() {
        	return new JarEntryDto();
    	}
    
    	public JarEntryDto fromJson(String json) {
    		return JarEntryDto.fromJson(json);
    	}
        public JarEntryDto fromJson(JSONValue json) {
    		return JarEntryDto.fromJson(json);
    	}
        public JarEntryDto clone(JarEntryDto dto) {
            return JarEntryDto.fromJson(dto.toJson());
    	}
    }

    public static class StatusReportDto extends StatusReport implements JsonSerializable {

        public StatusReportDto() {
        }

        public StatusReportDto(org.eclipse.che.jdt.ls.extension.api.dto.StatusReport o) {
            if (o.getType() == null) {
                setType((java.lang.String)null);
            } else {
                java.lang.String typeVal = (java.lang.String)makeDto(o.getType());;
                setType((java.lang.String)typeVal);
            }
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getType() == null) {
                setType((java.lang.String)null);
            } else {
                JSONValue typeVal = getType() == null ? JSONNull.getInstance() : new JSONString(getType());;
                result.put("type", typeVal);
            }
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JSONValue messageVal = getMessage() == null ? JSONNull.getInstance() : new JSONString(getMessage());;
                result.put("message", messageVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static StatusReportDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static StatusReportDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            StatusReportDto result= new StatusReportDto();
            JSONValue jsontypeJson = json.get("type");
            if (jsontypeJson != null && !(jsontypeJson.isNull() != null)) {
                java.lang.String jsontypeVal = jsontypeJson.isString().stringValue();;
                result.setType((java.lang.String)jsontypeVal);
            }
            JSONValue jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isNull() != null)) {
                java.lang.String jsonmessageVal = jsonmessageJson.isString().stringValue();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            return result;
        }
    }

    public static class StatusReportDtoProvider implements DtoProvider<StatusReportDto> {
    	public Class<? extends StatusReportDto> getImplClass() {
    	  	return StatusReportDto.class;
    	}
    
    	public StatusReportDto newInstance() {
        	return new StatusReportDto();
    	}
    
    	public StatusReportDto fromJson(String json) {
    		return StatusReportDto.fromJson(json);
    	}
        public StatusReportDto fromJson(JSONValue json) {
    		return StatusReportDto.fromJson(json);
    	}
        public StatusReportDto clone(StatusReportDto dto) {
            return StatusReportDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringStatusDto extends RefactoringStatus implements JsonSerializable {

        public RefactoringStatusDto() {
        }

        public RefactoringStatusDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus o) {
            if (o.getRefactoringStatusEntries() == null) {
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry> refactoringStatusEntriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValX : o.getRefactoringStatusEntries()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValY = new RefactoringStatusEntryDto(refactoringStatusEntriesValX);
                        refactoringStatusEntriesVal.add(refactoringStatusEntriesValY);
                    }
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)refactoringStatusEntriesVal);
            }
            if (o.getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity refactoringSeverityVal = (org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)makeDto(o.getRefactoringSeverity());;
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)refactoringSeverityVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getRefactoringStatusEntries() == null) {
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)null);
            } else {
                JSONArray refactoringStatusEntriesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValX : getRefactoringStatusEntries()) {
                    JSONValue refactoringStatusEntriesValY = refactoringStatusEntriesValX == null ? JSONNull.getInstance() : ((RefactoringStatusEntryDto)refactoringStatusEntriesValX).toJsonElement();;
                    refactoringStatusEntriesVal.set(refactoringStatusEntriesVal.size(), refactoringStatusEntriesValY);
                }
                result.put("refactoringStatusEntries", refactoringStatusEntriesVal);
            }
            if (getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                JSONValue refactoringSeverityVal = getRefactoringSeverity() == null ? JSONNull.getInstance() : new JSONString(getRefactoringSeverity().name());;
                result.put("refactoringSeverity", refactoringSeverityVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringStatusDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RefactoringStatusDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RefactoringStatusDto result= new RefactoringStatusDto();
            JSONValue jsonrefactoringStatusEntriesJson = json.get("refactoringStatusEntries");
            if (jsonrefactoringStatusEntriesJson != null && !(jsonrefactoringStatusEntriesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry> jsonrefactoringStatusEntriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>();
                JSONArray jsonrefactoringStatusEntriesVala = jsonrefactoringStatusEntriesJson.isArray();
                for(int jsonrefactoringStatusEntriesValai= 0; jsonrefactoringStatusEntriesValai < jsonrefactoringStatusEntriesVala.size(); jsonrefactoringStatusEntriesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry jsonrefactoringStatusEntriesValaX = RefactoringStatusEntryDto.fromJson((JSONObject)jsonrefactoringStatusEntriesVala.get(jsonrefactoringStatusEntriesValai));;
                    jsonrefactoringStatusEntriesVal.add(jsonrefactoringStatusEntriesValaX);
                }
                result.setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)jsonrefactoringStatusEntriesVal);
            }
            JSONValue jsonrefactoringSeverityJson = json.get("refactoringSeverity");
            if (jsonrefactoringSeverityJson != null && !(jsonrefactoringSeverityJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity jsonrefactoringSeverityVal = org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity.valueOf(jsonrefactoringSeverityJson.isString().stringValue());;
                result.setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)jsonrefactoringSeverityVal);
            }
            return result;
        }
    }

    public static class RefactoringStatusDtoProvider implements DtoProvider<RefactoringStatusDto> {
    	public Class<? extends RefactoringStatusDto> getImplClass() {
    	  	return RefactoringStatusDto.class;
    	}
    
    	public RefactoringStatusDto newInstance() {
        	return new RefactoringStatusDto();
    	}
    
    	public RefactoringStatusDto fromJson(String json) {
    		return RefactoringStatusDto.fromJson(json);
    	}
        public RefactoringStatusDto fromJson(JSONValue json) {
    		return RefactoringStatusDto.fromJson(json);
    	}
        public RefactoringStatusDto clone(RefactoringStatusDto dto) {
            return RefactoringStatusDto.fromJson(dto.toJson());
    	}
    }

    public static class UsagesResponseDto extends UsagesResponse implements JsonSerializable {

        public UsagesResponseDto() {
        }

        public UsagesResponseDto(org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse o) {
            if (o.getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                java.lang.String searchedElementVal = (java.lang.String)makeDto(o.getSearchedElement());;
                setSearchedElement((java.lang.String)searchedElementVal);
            }
            if (o.getElementKind() == null) {
                setElementKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                org.eclipse.lsp4j.SymbolKind elementKindVal = (org.eclipse.lsp4j.SymbolKind)makeDto(o.getElementKind());;
                setElementKind((org.eclipse.lsp4j.SymbolKind)elementKindVal);
            }
            if (o.getSearchResults() == null) {
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> searchResultsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValX : o.getSearchResults()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValY = new SearchResultDto(searchResultsValX);
                        searchResultsVal.add(searchResultsValY);
                    }
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)searchResultsVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                JSONValue searchedElementVal = getSearchedElement() == null ? JSONNull.getInstance() : new JSONString(getSearchedElement());;
                result.put("searchedElement", searchedElementVal);
            }
            if (getElementKind() == null) {
                setElementKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                JSONValue elementKindVal = getElementKind() == null ? JSONNull.getInstance() : new JSONString(getElementKind().name());;
                result.put("elementKind", elementKindVal);
            }
            if (getSearchResults() == null) {
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                JSONArray searchResultsVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValX : getSearchResults()) {
                    JSONValue searchResultsValY = searchResultsValX == null ? JSONNull.getInstance() : ((SearchResultDto)searchResultsValX).toJsonElement();;
                    searchResultsVal.set(searchResultsVal.size(), searchResultsValY);
                }
                result.put("searchResults", searchResultsVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UsagesResponseDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static UsagesResponseDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            UsagesResponseDto result= new UsagesResponseDto();
            JSONValue jsonsearchedElementJson = json.get("searchedElement");
            if (jsonsearchedElementJson != null && !(jsonsearchedElementJson.isNull() != null)) {
                java.lang.String jsonsearchedElementVal = jsonsearchedElementJson.isString().stringValue();;
                result.setSearchedElement((java.lang.String)jsonsearchedElementVal);
            }
            JSONValue jsonelementKindJson = json.get("elementKind");
            if (jsonelementKindJson != null && !(jsonelementKindJson.isNull() != null)) {
                org.eclipse.lsp4j.SymbolKind jsonelementKindVal = org.eclipse.lsp4j.SymbolKind.valueOf(jsonelementKindJson.isString().stringValue());;
                result.setElementKind((org.eclipse.lsp4j.SymbolKind)jsonelementKindVal);
            }
            JSONValue jsonsearchResultsJson = json.get("searchResults");
            if (jsonsearchResultsJson != null && !(jsonsearchResultsJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> jsonsearchResultsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                JSONArray jsonsearchResultsVala = jsonsearchResultsJson.isArray();
                for(int jsonsearchResultsValai= 0; jsonsearchResultsValai < jsonsearchResultsVala.size(); jsonsearchResultsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.SearchResult jsonsearchResultsValaX = SearchResultDto.fromJson((JSONObject)jsonsearchResultsVala.get(jsonsearchResultsValai));;
                    jsonsearchResultsVal.add(jsonsearchResultsValaX);
                }
                result.setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)jsonsearchResultsVal);
            }
            return result;
        }
    }

    public static class UsagesResponseDtoProvider implements DtoProvider<UsagesResponseDto> {
    	public Class<? extends UsagesResponseDto> getImplClass() {
    	  	return UsagesResponseDto.class;
    	}
    
    	public UsagesResponseDto newInstance() {
        	return new UsagesResponseDto();
    	}
    
    	public UsagesResponseDto fromJson(String json) {
    		return UsagesResponseDto.fromJson(json);
    	}
        public UsagesResponseDto fromJson(JSONValue json) {
    		return UsagesResponseDto.fromJson(json);
    	}
        public UsagesResponseDto clone(UsagesResponseDto dto) {
            return UsagesResponseDto.fromJson(dto.toJson());
    	}
    }

    public static class ExternalLibrariesParametersDto extends ExternalLibrariesParameters implements JsonSerializable {

        public ExternalLibrariesParametersDto() {
        }

        public ExternalLibrariesParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters o) {
            if (o.getNodeId() == null) {
                setNodeId((java.lang.String)null);
            } else {
                java.lang.String nodeIdVal = (java.lang.String)makeDto(o.getNodeId());;
                setNodeId((java.lang.String)nodeIdVal);
            }
            if (o.getNodePath() == null) {
                setNodePath((java.lang.String)null);
            } else {
                java.lang.String nodePathVal = (java.lang.String)makeDto(o.getNodePath());;
                setNodePath((java.lang.String)nodePathVal);
            }
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getNodeId() == null) {
                setNodeId((java.lang.String)null);
            } else {
                JSONValue nodeIdVal = getNodeId() == null ? JSONNull.getInstance() : new JSONString(getNodeId());;
                result.put("nodeId", nodeIdVal);
            }
            if (getNodePath() == null) {
                setNodePath((java.lang.String)null);
            } else {
                JSONValue nodePathVal = getNodePath() == null ? JSONNull.getInstance() : new JSONString(getNodePath());;
                result.put("nodePath", nodePathVal);
            }
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ExternalLibrariesParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ExternalLibrariesParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ExternalLibrariesParametersDto result= new ExternalLibrariesParametersDto();
            JSONValue jsonnodeIdJson = json.get("nodeId");
            if (jsonnodeIdJson != null && !(jsonnodeIdJson.isNull() != null)) {
                java.lang.String jsonnodeIdVal = jsonnodeIdJson.isString().stringValue();;
                result.setNodeId((java.lang.String)jsonnodeIdVal);
            }
            JSONValue jsonnodePathJson = json.get("nodePath");
            if (jsonnodePathJson != null && !(jsonnodePathJson.isNull() != null)) {
                java.lang.String jsonnodePathVal = jsonnodePathJson.isString().stringValue();;
                result.setNodePath((java.lang.String)jsonnodePathVal);
            }
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            return result;
        }
    }

    public static class ExternalLibrariesParametersDtoProvider implements DtoProvider<ExternalLibrariesParametersDto> {
    	public Class<? extends ExternalLibrariesParametersDto> getImplClass() {
    	  	return ExternalLibrariesParametersDto.class;
    	}
    
    	public ExternalLibrariesParametersDto newInstance() {
        	return new ExternalLibrariesParametersDto();
    	}
    
    	public ExternalLibrariesParametersDto fromJson(String json) {
    		return ExternalLibrariesParametersDto.fromJson(json);
    	}
        public ExternalLibrariesParametersDto fromJson(JSONValue json) {
    		return ExternalLibrariesParametersDto.fromJson(json);
    	}
        public ExternalLibrariesParametersDto clone(ExternalLibrariesParametersDto dto) {
            return ExternalLibrariesParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class ReImportMavenProjectsCommandParametersDto extends ReImportMavenProjectsCommandParameters implements JsonSerializable {

        public ReImportMavenProjectsCommandParametersDto() {
        }

        public ReImportMavenProjectsCommandParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters o) {
            if (o.getProjectsToUpdate() == null) {
                setProjectsToUpdate((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> projectsToUpdateVal= new ArrayList<java.lang.String>();
                    for (java.lang.String projectsToUpdateValX : o.getProjectsToUpdate()) {
                        java.lang.String projectsToUpdateValY = (java.lang.String)makeDto(projectsToUpdateValX);;
                        projectsToUpdateVal.add(projectsToUpdateValY);
                    }
                setProjectsToUpdate((java.util.List<java.lang.String>)projectsToUpdateVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getProjectsToUpdate() == null) {
                setProjectsToUpdate((java.util.List<java.lang.String>)null);
            } else {
                JSONArray projectsToUpdateVal = new JSONArray();
                for (java.lang.String projectsToUpdateValX : getProjectsToUpdate()) {
                    JSONValue projectsToUpdateValY = projectsToUpdateValX == null ? JSONNull.getInstance() : new JSONString(projectsToUpdateValX);;
                    projectsToUpdateVal.set(projectsToUpdateVal.size(), projectsToUpdateValY);
                }
                result.put("projectsToUpdate", projectsToUpdateVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ReImportMavenProjectsCommandParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ReImportMavenProjectsCommandParametersDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ReImportMavenProjectsCommandParametersDto result= new ReImportMavenProjectsCommandParametersDto();
            JSONValue jsonprojectsToUpdateJson = json.get("projectsToUpdate");
            if (jsonprojectsToUpdateJson != null && !(jsonprojectsToUpdateJson.isNull() != null)) {
                ArrayList<java.lang.String> jsonprojectsToUpdateVal= new ArrayList<java.lang.String>();
                JSONArray jsonprojectsToUpdateVala = jsonprojectsToUpdateJson.isArray();
                for(int jsonprojectsToUpdateValai= 0; jsonprojectsToUpdateValai < jsonprojectsToUpdateVala.size(); jsonprojectsToUpdateValai++) {
                    java.lang.String jsonprojectsToUpdateValaX = jsonprojectsToUpdateVala.get(jsonprojectsToUpdateValai).isString().stringValue();;
                    jsonprojectsToUpdateVal.add(jsonprojectsToUpdateValaX);
                }
                result.setProjectsToUpdate((java.util.List<java.lang.String>)jsonprojectsToUpdateVal);
            }
            return result;
        }
    }

    public static class ReImportMavenProjectsCommandParametersDtoProvider implements DtoProvider<ReImportMavenProjectsCommandParametersDto> {
    	public Class<? extends ReImportMavenProjectsCommandParametersDto> getImplClass() {
    	  	return ReImportMavenProjectsCommandParametersDto.class;
    	}
    
    	public ReImportMavenProjectsCommandParametersDto newInstance() {
        	return new ReImportMavenProjectsCommandParametersDto();
    	}
    
    	public ReImportMavenProjectsCommandParametersDto fromJson(String json) {
    		return ReImportMavenProjectsCommandParametersDto.fromJson(json);
    	}
        public ReImportMavenProjectsCommandParametersDto fromJson(JSONValue json) {
    		return ReImportMavenProjectsCommandParametersDto.fromJson(json);
    	}
        public ReImportMavenProjectsCommandParametersDto clone(ReImportMavenProjectsCommandParametersDto dto) {
            return ReImportMavenProjectsCommandParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class ResourceLocationDto extends ResourceLocation implements JsonSerializable {

        public ResourceLocationDto() {
        }

        public ResourceLocationDto(org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation o) {
            if (o.getLibId() == null) {
                setLibId((java.lang.String)null);
            } else {
                java.lang.String libIdVal = (java.lang.String)makeDto(o.getLibId());;
                setLibId((java.lang.String)libIdVal);
            }
            if (o.getFqn() == null) {
                setFqn((java.lang.String)null);
            } else {
                java.lang.String fqnVal = (java.lang.String)makeDto(o.getFqn());;
                setFqn((java.lang.String)fqnVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getLibId() == null) {
                setLibId((java.lang.String)null);
            } else {
                JSONValue libIdVal = getLibId() == null ? JSONNull.getInstance() : new JSONString(getLibId());;
                result.put("libId", libIdVal);
            }
            if (getFqn() == null) {
                setFqn((java.lang.String)null);
            } else {
                JSONValue fqnVal = getFqn() == null ? JSONNull.getInstance() : new JSONString(getFqn());;
                result.put("fqn", fqnVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ResourceLocationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ResourceLocationDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ResourceLocationDto result= new ResourceLocationDto();
            JSONValue jsonlibIdJson = json.get("libId");
            if (jsonlibIdJson != null && !(jsonlibIdJson.isNull() != null)) {
                java.lang.String jsonlibIdVal = jsonlibIdJson.isString().stringValue();;
                result.setLibId((java.lang.String)jsonlibIdVal);
            }
            JSONValue jsonfqnJson = json.get("fqn");
            if (jsonfqnJson != null && !(jsonfqnJson.isNull() != null)) {
                java.lang.String jsonfqnVal = jsonfqnJson.isString().stringValue();;
                result.setFqn((java.lang.String)jsonfqnVal);
            }
            return result;
        }
    }

    public static class ResourceLocationDtoProvider implements DtoProvider<ResourceLocationDto> {
    	public Class<? extends ResourceLocationDto> getImplClass() {
    	  	return ResourceLocationDto.class;
    	}
    
    	public ResourceLocationDto newInstance() {
        	return new ResourceLocationDto();
    	}
    
    	public ResourceLocationDto fromJson(String json) {
    		return ResourceLocationDto.fromJson(json);
    	}
        public ResourceLocationDto fromJson(JSONValue json) {
    		return ResourceLocationDto.fromJson(json);
    	}
        public ResourceLocationDto clone(ResourceLocationDto dto) {
            return ResourceLocationDto.fromJson(dto.toJson());
    	}
    }

    public static class ClasspathEntryDto extends ClasspathEntry implements JsonSerializable {

        public ClasspathEntryDto() {
        }

        public ClasspathEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry o) {
                int entryKindVal = (int)makeDto(o.getEntryKind());;
                setEntryKind((int)entryKindVal);
            if (o.getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                java.lang.String pathVal = (java.lang.String)makeDto(o.getPath());;
                setPath((java.lang.String)pathVal);
            }
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValY = new ClasspathEntryDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)childrenVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue entryKindVal = new JSONNumber(getEntryKind());;
                result.put("entryKind", entryKindVal);
            if (getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                JSONValue pathVal = getPath() == null ? JSONNull.getInstance() : new JSONString(getPath());;
                result.put("path", pathVal);
            }
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                JSONArray childrenVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValX : getChildren()) {
                    JSONValue childrenValY = childrenValX == null ? JSONNull.getInstance() : ((ClasspathEntryDto)childrenValX).toJsonElement();;
                    childrenVal.set(childrenVal.size(), childrenValY);
                }
                result.put("children", childrenVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ClasspathEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ClasspathEntryDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ClasspathEntryDto result= new ClasspathEntryDto();
            JSONValue jsonentryKindJson = json.get("entryKind");
            if (jsonentryKindJson != null && !(jsonentryKindJson.isNull() != null)) {
                int jsonentryKindVal = (int)jsonentryKindJson.isNumber().doubleValue();;
                result.setEntryKind((int)jsonentryKindVal);
            }
            JSONValue jsonpathJson = json.get("path");
            if (jsonpathJson != null && !(jsonpathJson.isNull() != null)) {
                java.lang.String jsonpathVal = jsonpathJson.isString().stringValue();;
                result.setPath((java.lang.String)jsonpathVal);
            }
            JSONValue jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                JSONArray jsonchildrenVala = jsonchildrenJson.isArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry jsonchildrenValaX = ClasspathEntryDto.fromJson((JSONObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)jsonchildrenVal);
            }
            return result;
        }
    }

    public static class ClasspathEntryDtoProvider implements DtoProvider<ClasspathEntryDto> {
    	public Class<? extends ClasspathEntryDto> getImplClass() {
    	  	return ClasspathEntryDto.class;
    	}
    
    	public ClasspathEntryDto newInstance() {
        	return new ClasspathEntryDto();
    	}
    
    	public ClasspathEntryDto fromJson(String json) {
    		return ClasspathEntryDto.fromJson(json);
    	}
        public ClasspathEntryDto fromJson(JSONValue json) {
    		return ClasspathEntryDto.fromJson(json);
    	}
        public ClasspathEntryDto clone(ClasspathEntryDto dto) {
            return ClasspathEntryDto.fromJson(dto.toJson());
    	}
    }

    public static class SearchResultDto extends SearchResult implements JsonSerializable {

        public SearchResultDto() {
        }

        public SearchResultDto(org.eclipse.che.jdt.ls.extension.api.dto.SearchResult o) {
            if (o.getMatches() == null) {
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange> matchesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValX : o.getMatches()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValY = (org.eclipse.che.jdt.ls.extension.api.dto.LinearRange)makeDto(matchesValX);;
                        matchesVal.add(matchesValY);
                    }
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)matchesVal);
            }
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValY = new SearchResultDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)childrenVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                org.eclipse.lsp4j.SymbolKind kindVal = (org.eclipse.lsp4j.SymbolKind)makeDto(o.getKind());;
                setKind((org.eclipse.lsp4j.SymbolKind)kindVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getMatches() == null) {
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)null);
            } else {
                JSONArray matchesVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValX : getMatches()) {
                    JSONValue matchesValY = matchesValX == null ? JSONNull.getInstance() : ((LinearRangeDto)matchesValX).toJsonElement();;
                    matchesVal.set(matchesVal.size(), matchesValY);
                }
                result.put("matches", matchesVal);
            }
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                JSONArray childrenVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValX : getChildren()) {
                    JSONValue childrenValY = childrenValX == null ? JSONNull.getInstance() : ((SearchResultDto)childrenValX).toJsonElement();;
                    childrenVal.set(childrenVal.size(), childrenValY);
                }
                result.put("children", childrenVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            if (getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                JSONValue kindVal = getKind() == null ? JSONNull.getInstance() : new JSONString(getKind().name());;
                result.put("kind", kindVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JSONValue nameVal = getName() == null ? JSONNull.getInstance() : new JSONString(getName());;
                result.put("name", nameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static SearchResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static SearchResultDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            SearchResultDto result= new SearchResultDto();
            JSONValue jsonmatchesJson = json.get("matches");
            if (jsonmatchesJson != null && !(jsonmatchesJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange> jsonmatchesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>();
                JSONArray jsonmatchesVala = jsonmatchesJson.isArray();
                for(int jsonmatchesValai= 0; jsonmatchesValai < jsonmatchesVala.size(); jsonmatchesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.LinearRange jsonmatchesValaX = LinearRangeDto.fromJson((JSONObject)jsonmatchesVala.get(jsonmatchesValai));;
                    jsonmatchesVal.add(jsonmatchesValaX);
                }
                result.setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)jsonmatchesVal);
            }
            JSONValue jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                JSONArray jsonchildrenVala = jsonchildrenJson.isArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.SearchResult jsonchildrenValaX = SearchResultDto.fromJson((JSONObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)jsonchildrenVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JSONValue jsonkindJson = json.get("kind");
            if (jsonkindJson != null && !(jsonkindJson.isNull() != null)) {
                org.eclipse.lsp4j.SymbolKind jsonkindVal = org.eclipse.lsp4j.SymbolKind.valueOf(jsonkindJson.isString().stringValue());;
                result.setKind((org.eclipse.lsp4j.SymbolKind)jsonkindVal);
            }
            JSONValue jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isNull() != null)) {
                java.lang.String jsonnameVal = jsonnameJson.isString().stringValue();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class SearchResultDtoProvider implements DtoProvider<SearchResultDto> {
    	public Class<? extends SearchResultDto> getImplClass() {
    	  	return SearchResultDto.class;
    	}
    
    	public SearchResultDto newInstance() {
        	return new SearchResultDto();
    	}
    
    	public SearchResultDto fromJson(String json) {
    		return SearchResultDto.fromJson(json);
    	}
        public SearchResultDto fromJson(JSONValue json) {
    		return SearchResultDto.fromJson(json);
    	}
        public SearchResultDto clone(SearchResultDto dto) {
            return SearchResultDto.fromJson(dto.toJson());
    	}
    }

    public static class CheResourceChangeDto extends CheResourceChange implements JsonSerializable {

        public CheResourceChangeDto() {
        }

        public CheResourceChangeDto(org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange o) {
            if (o.getResourceKind() == null) {
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.ResourceKind resourceKindVal = (org.eclipse.che.jdt.ls.extension.api.ResourceKind)makeDto(o.getResourceKind());;
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)resourceKindVal);
            }
            if (o.getDescription() == null) {
                setDescription((java.lang.String)null);
            } else {
                java.lang.String descriptionVal = (java.lang.String)makeDto(o.getDescription());;
                setDescription((java.lang.String)descriptionVal);
            }
            if (o.getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                java.lang.String currentVal = (java.lang.String)makeDto(o.getCurrent());;
                setCurrent((java.lang.String)currentVal);
            }
            if (o.getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                java.lang.String newUriVal = (java.lang.String)makeDto(o.getNewUri());;
                setNewUri((java.lang.String)newUriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getResourceKind() == null) {
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)null);
            } else {
                JSONValue resourceKindVal = getResourceKind() == null ? JSONNull.getInstance() : new JSONString(getResourceKind().name());;
                result.put("resourceKind", resourceKindVal);
            }
            if (getDescription() == null) {
                setDescription((java.lang.String)null);
            } else {
                JSONValue descriptionVal = getDescription() == null ? JSONNull.getInstance() : new JSONString(getDescription());;
                result.put("description", descriptionVal);
            }
            if (getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                JSONValue currentVal = getCurrent() == null ? JSONNull.getInstance() : new JSONString(getCurrent());;
                result.put("current", currentVal);
            }
            if (getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                JSONValue newUriVal = getNewUri() == null ? JSONNull.getInstance() : new JSONString(getNewUri());;
                result.put("newUri", newUriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CheResourceChangeDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static CheResourceChangeDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            CheResourceChangeDto result= new CheResourceChangeDto();
            JSONValue jsonresourceKindJson = json.get("resourceKind");
            if (jsonresourceKindJson != null && !(jsonresourceKindJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.ResourceKind jsonresourceKindVal = org.eclipse.che.jdt.ls.extension.api.ResourceKind.valueOf(jsonresourceKindJson.isString().stringValue());;
                result.setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)jsonresourceKindVal);
            }
            JSONValue jsondescriptionJson = json.get("description");
            if (jsondescriptionJson != null && !(jsondescriptionJson.isNull() != null)) {
                java.lang.String jsondescriptionVal = jsondescriptionJson.isString().stringValue();;
                result.setDescription((java.lang.String)jsondescriptionVal);
            }
            JSONValue jsoncurrentJson = json.get("current");
            if (jsoncurrentJson != null && !(jsoncurrentJson.isNull() != null)) {
                java.lang.String jsoncurrentVal = jsoncurrentJson.isString().stringValue();;
                result.setCurrent((java.lang.String)jsoncurrentVal);
            }
            JSONValue jsonnewUriJson = json.get("newUri");
            if (jsonnewUriJson != null && !(jsonnewUriJson.isNull() != null)) {
                java.lang.String jsonnewUriVal = jsonnewUriJson.isString().stringValue();;
                result.setNewUri((java.lang.String)jsonnewUriVal);
            }
            return result;
        }
    }

    public static class CheResourceChangeDtoProvider implements DtoProvider<CheResourceChangeDto> {
    	public Class<? extends CheResourceChangeDto> getImplClass() {
    	  	return CheResourceChangeDto.class;
    	}
    
    	public CheResourceChangeDto newInstance() {
        	return new CheResourceChangeDto();
    	}
    
    	public CheResourceChangeDto fromJson(String json) {
    		return CheResourceChangeDto.fromJson(json);
    	}
        public CheResourceChangeDto fromJson(JSONValue json) {
    		return CheResourceChangeDto.fromJson(json);
    	}
        public CheResourceChangeDto clone(CheResourceChangeDto dto) {
            return CheResourceChangeDto.fromJson(dto.toJson());
    	}
    }

    public static class JarDto extends Jar implements JsonSerializable {

        public JarDto() {
        }

        public JarDto(org.eclipse.che.jdt.ls.extension.api.dto.Jar o) {
            if (o.getId() == null) {
                setId((java.lang.String)null);
            } else {
                java.lang.String idVal = (java.lang.String)makeDto(o.getId());;
                setId((java.lang.String)idVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getId() == null) {
                setId((java.lang.String)null);
            } else {
                JSONValue idVal = getId() == null ? JSONNull.getInstance() : new JSONString(getId());;
                result.put("id", idVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JSONValue nameVal = getName() == null ? JSONNull.getInstance() : new JSONString(getName());;
                result.put("name", nameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JarDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JarDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JarDto result= new JarDto();
            JSONValue jsonidJson = json.get("id");
            if (jsonidJson != null && !(jsonidJson.isNull() != null)) {
                java.lang.String jsonidVal = jsonidJson.isString().stringValue();;
                result.setId((java.lang.String)jsonidVal);
            }
            JSONValue jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isNull() != null)) {
                java.lang.String jsonnameVal = jsonnameJson.isString().stringValue();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JarDtoProvider implements DtoProvider<JarDto> {
    	public Class<? extends JarDto> getImplClass() {
    	  	return JarDto.class;
    	}
    
    	public JarDto newInstance() {
        	return new JarDto();
    	}
    
    	public JarDto fromJson(String json) {
    		return JarDto.fromJson(json);
    	}
        public JarDto fromJson(JSONValue json) {
    		return JarDto.fromJson(json);
    	}
        public JarDto clone(JarDto dto) {
            return JarDto.fromJson(dto.toJson());
    	}
    }

    public static class ImplementersResponseDto extends ImplementersResponse implements JsonSerializable {

        public ImplementersResponseDto() {
        }

        public ImplementersResponseDto(org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse o) {
            if (o.getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                java.lang.String searchedElementVal = (java.lang.String)makeDto(o.getSearchedElement());;
                setSearchedElement((java.lang.String)searchedElementVal);
            }
            if (o.getImplementers() == null) {
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.SymbolInformation> implementersVal= new ArrayList<org.eclipse.lsp4j.SymbolInformation>();
                    for (org.eclipse.lsp4j.SymbolInformation implementersValX : o.getImplementers()) {
                        org.eclipse.lsp4j.SymbolInformation implementersValY = (org.eclipse.lsp4j.SymbolInformation)makeDto(implementersValX);;
                        implementersVal.add(implementersValY);
                    }
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)implementersVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                JSONValue searchedElementVal = getSearchedElement() == null ? JSONNull.getInstance() : new JSONString(getSearchedElement());;
                result.put("searchedElement", searchedElementVal);
            }
            if (getImplementers() == null) {
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)null);
            } else {
                JSONArray implementersVal = new JSONArray();
                for (org.eclipse.lsp4j.SymbolInformation implementersValX : getImplementers()) {
                    JSONValue implementersValY = implementersValX == null ? JSONNull.getInstance() : ((SymbolInformationDto)implementersValX).toJsonElement();;
                    implementersVal.set(implementersVal.size(), implementersValY);
                }
                result.put("implementers", implementersVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ImplementersResponseDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ImplementersResponseDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ImplementersResponseDto result= new ImplementersResponseDto();
            JSONValue jsonsearchedElementJson = json.get("searchedElement");
            if (jsonsearchedElementJson != null && !(jsonsearchedElementJson.isNull() != null)) {
                java.lang.String jsonsearchedElementVal = jsonsearchedElementJson.isString().stringValue();;
                result.setSearchedElement((java.lang.String)jsonsearchedElementVal);
            }
            JSONValue jsonimplementersJson = json.get("implementers");
            if (jsonimplementersJson != null && !(jsonimplementersJson.isNull() != null)) {
                ArrayList<org.eclipse.lsp4j.SymbolInformation> jsonimplementersVal= new ArrayList<org.eclipse.lsp4j.SymbolInformation>();
                JSONArray jsonimplementersVala = jsonimplementersJson.isArray();
                for(int jsonimplementersValai= 0; jsonimplementersValai < jsonimplementersVala.size(); jsonimplementersValai++) {
                    org.eclipse.lsp4j.SymbolInformation jsonimplementersValaX = SymbolInformationDto.fromJson((JSONObject)jsonimplementersVala.get(jsonimplementersValai));;
                    jsonimplementersVal.add(jsonimplementersValaX);
                }
                result.setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)jsonimplementersVal);
            }
            return result;
        }
    }

    public static class ImplementersResponseDtoProvider implements DtoProvider<ImplementersResponseDto> {
    	public Class<? extends ImplementersResponseDto> getImplClass() {
    	  	return ImplementersResponseDto.class;
    	}
    
    	public ImplementersResponseDto newInstance() {
        	return new ImplementersResponseDto();
    	}
    
    	public ImplementersResponseDto fromJson(String json) {
    		return ImplementersResponseDto.fromJson(json);
    	}
        public ImplementersResponseDto fromJson(JSONValue json) {
    		return ImplementersResponseDto.fromJson(json);
    	}
        public ImplementersResponseDto clone(ImplementersResponseDto dto) {
            return ImplementersResponseDto.fromJson(dto.toJson());
    	}
    }

    public static class ExtendedSymbolInformationDto extends ExtendedSymbolInformation implements JsonSerializable {

        public ExtendedSymbolInformationDto() {
        }

        public ExtendedSymbolInformationDto(org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation o) {
            if (o.getVisiblity() == null) {
                setVisiblity((org.eclipse.che.jdt.ls.extension.api.Visibility)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.Visibility visiblityVal = (org.eclipse.che.jdt.ls.extension.api.Visibility)makeDto(o.getVisiblity());;
                setVisiblity((org.eclipse.che.jdt.ls.extension.api.Visibility)visiblityVal);
            }
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValY = new ExtendedSymbolInformationDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)childrenVal);
            }
            if (o.getInfo() == null) {
                setInfo((org.eclipse.lsp4j.SymbolInformation)null);
            } else {
                org.eclipse.lsp4j.SymbolInformation infoVal = (org.eclipse.lsp4j.SymbolInformation)makeDto(o.getInfo());;
                setInfo((org.eclipse.lsp4j.SymbolInformation)infoVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getVisiblity() == null) {
                setVisiblity((org.eclipse.che.jdt.ls.extension.api.Visibility)null);
            } else {
                JSONValue visiblityVal = getVisiblity() == null ? JSONNull.getInstance() : new JSONString(getVisiblity().name());;
                result.put("visiblity", visiblityVal);
            }
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)null);
            } else {
                JSONArray childrenVal = new JSONArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValX : getChildren()) {
                    JSONValue childrenValY = childrenValX == null ? JSONNull.getInstance() : ((ExtendedSymbolInformationDto)childrenValX).toJsonElement();;
                    childrenVal.set(childrenVal.size(), childrenValY);
                }
                result.put("children", childrenVal);
            }
            if (getInfo() == null) {
                setInfo((org.eclipse.lsp4j.SymbolInformation)null);
            } else {
                JSONValue infoVal = getInfo() == null ? JSONNull.getInstance() : ((SymbolInformationDto)getInfo()).toJsonElement();;
                result.put("info", infoVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ExtendedSymbolInformationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ExtendedSymbolInformationDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ExtendedSymbolInformationDto result= new ExtendedSymbolInformationDto();
            JSONValue jsonvisiblityJson = json.get("visiblity");
            if (jsonvisiblityJson != null && !(jsonvisiblityJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.Visibility jsonvisiblityVal = org.eclipse.che.jdt.ls.extension.api.Visibility.valueOf(jsonvisiblityJson.isString().stringValue());;
                result.setVisiblity((org.eclipse.che.jdt.ls.extension.api.Visibility)jsonvisiblityVal);
            }
            JSONValue jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isNull() != null)) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>();
                JSONArray jsonchildrenVala = jsonchildrenJson.isArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation jsonchildrenValaX = ExtendedSymbolInformationDto.fromJson((JSONObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)jsonchildrenVal);
            }
            JSONValue jsoninfoJson = json.get("info");
            if (jsoninfoJson != null && !(jsoninfoJson.isNull() != null)) {
                org.eclipse.lsp4j.SymbolInformation jsoninfoVal = SymbolInformationDto.fromJson((JSONObject)jsoninfoJson);;
                result.setInfo((org.eclipse.lsp4j.SymbolInformation)jsoninfoVal);
            }
            return result;
        }
    }

    public static class ExtendedSymbolInformationDtoProvider implements DtoProvider<ExtendedSymbolInformationDto> {
    	public Class<? extends ExtendedSymbolInformationDto> getImplClass() {
    	  	return ExtendedSymbolInformationDto.class;
    	}
    
    	public ExtendedSymbolInformationDto newInstance() {
        	return new ExtendedSymbolInformationDto();
    	}
    
    	public ExtendedSymbolInformationDto fromJson(String json) {
    		return ExtendedSymbolInformationDto.fromJson(json);
    	}
        public ExtendedSymbolInformationDto fromJson(JSONValue json) {
    		return ExtendedSymbolInformationDto.fromJson(json);
    	}
        public ExtendedSymbolInformationDto clone(ExtendedSymbolInformationDto dto) {
            return ExtendedSymbolInformationDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringResultDto extends RefactoringResult implements JsonSerializable {

        public RefactoringResultDto() {
        }

        public RefactoringResultDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult o) {
            if (o.getRefactoringStatus() == null) {
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus refactoringStatusVal = new RefactoringStatusDto(o.getRefactoringStatus());
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)refactoringStatusVal);
            }
            if (o.getCheWorkspaceEdit() == null) {
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit cheWorkspaceEditVal = new CheWorkspaceEditDto(o.getCheWorkspaceEdit());
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)cheWorkspaceEditVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            if (getRefactoringStatus() == null) {
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)null);
            } else {
                JSONValue refactoringStatusVal = getRefactoringStatus() == null ? JSONNull.getInstance() : ((RefactoringStatusDto)getRefactoringStatus()).toJsonElement();;
                result.put("refactoringStatus", refactoringStatusVal);
            }
            if (getCheWorkspaceEdit() == null) {
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)null);
            } else {
                JSONValue cheWorkspaceEditVal = getCheWorkspaceEdit() == null ? JSONNull.getInstance() : ((CheWorkspaceEditDto)getCheWorkspaceEdit()).toJsonElement();;
                result.put("cheWorkspaceEdit", cheWorkspaceEditVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static RefactoringResultDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            RefactoringResultDto result= new RefactoringResultDto();
            JSONValue jsonrefactoringStatusJson = json.get("refactoringStatus");
            if (jsonrefactoringStatusJson != null && !(jsonrefactoringStatusJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus jsonrefactoringStatusVal = RefactoringStatusDto.fromJson((JSONObject)jsonrefactoringStatusJson);;
                result.setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)jsonrefactoringStatusVal);
            }
            JSONValue jsoncheWorkspaceEditJson = json.get("cheWorkspaceEdit");
            if (jsoncheWorkspaceEditJson != null && !(jsoncheWorkspaceEditJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit jsoncheWorkspaceEditVal = CheWorkspaceEditDto.fromJson((JSONObject)jsoncheWorkspaceEditJson);;
                result.setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)jsoncheWorkspaceEditVal);
            }
            return result;
        }
    }

    public static class RefactoringResultDtoProvider implements DtoProvider<RefactoringResultDto> {
    	public Class<? extends RefactoringResultDto> getImplClass() {
    	  	return RefactoringResultDto.class;
    	}
    
    	public RefactoringResultDto newInstance() {
        	return new RefactoringResultDto();
    	}
    
    	public RefactoringResultDto fromJson(String json) {
    		return RefactoringResultDto.fromJson(json);
    	}
        public RefactoringResultDto fromJson(JSONValue json) {
    		return RefactoringResultDto.fromJson(json);
    	}
        public RefactoringResultDto clone(RefactoringResultDto dto) {
            return RefactoringResultDto.fromJson(dto.toJson());
    	}
    }

    public static class ResourceDto extends Resource implements JsonSerializable {

        public ResourceDto() {
        }

        public ResourceDto(org.eclipse.che.jdt.ls.extension.api.dto.Resource o) {
                boolean packVal = (boolean)makeDto(o.isPack());;
                setPack((boolean)packVal);
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue packVal = JSONBoolean.getInstance(isPack());;
                result.put("pack", packVal);
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ResourceDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static ResourceDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            ResourceDto result= new ResourceDto();
            JSONValue jsonpackJson = json.get("pack");
            if (jsonpackJson != null && !(jsonpackJson.isNull() != null)) {
                boolean jsonpackVal = jsonpackJson.isBoolean().booleanValue();
                result.setPack((boolean)jsonpackVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class ResourceDtoProvider implements DtoProvider<ResourceDto> {
    	public Class<? extends ResourceDto> getImplClass() {
    	  	return ResourceDto.class;
    	}
    
    	public ResourceDto newInstance() {
        	return new ResourceDto();
    	}
    
    	public ResourceDto fromJson(String json) {
    		return ResourceDto.fromJson(json);
    	}
        public ResourceDto fromJson(JSONValue json) {
    		return ResourceDto.fromJson(json);
    	}
        public ResourceDto clone(ResourceDto dto) {
            return ResourceDto.fromJson(dto.toJson());
    	}
    }

    public static class JobResultDto extends JobResult implements JsonSerializable {

        public JobResultDto() {
        }

        public JobResultDto(org.eclipse.che.jdt.ls.extension.api.dto.JobResult o) {
                int resultCodeVal = (int)makeDto(o.getResultCode());;
                setResultCode((int)resultCodeVal);
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
            if (o.getSeverity() == null) {
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.Severity severityVal = (org.eclipse.che.jdt.ls.extension.api.Severity)makeDto(o.getSeverity());;
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)severityVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue resultCodeVal = new JSONNumber(getResultCode());;
                result.put("resultCode", resultCodeVal);
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JSONValue messageVal = getMessage() == null ? JSONNull.getInstance() : new JSONString(getMessage());;
                result.put("message", messageVal);
            }
            if (getSeverity() == null) {
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)null);
            } else {
                JSONValue severityVal = getSeverity() == null ? JSONNull.getInstance() : new JSONString(getSeverity().name());;
                result.put("severity", severityVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JobResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static JobResultDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            JobResultDto result= new JobResultDto();
            JSONValue jsonresultCodeJson = json.get("resultCode");
            if (jsonresultCodeJson != null && !(jsonresultCodeJson.isNull() != null)) {
                int jsonresultCodeVal = (int)jsonresultCodeJson.isNumber().doubleValue();;
                result.setResultCode((int)jsonresultCodeVal);
            }
            JSONValue jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isNull() != null)) {
                java.lang.String jsonmessageVal = jsonmessageJson.isString().stringValue();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            JSONValue jsonseverityJson = json.get("severity");
            if (jsonseverityJson != null && !(jsonseverityJson.isNull() != null)) {
                org.eclipse.che.jdt.ls.extension.api.Severity jsonseverityVal = org.eclipse.che.jdt.ls.extension.api.Severity.valueOf(jsonseverityJson.isString().stringValue());;
                result.setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)jsonseverityVal);
            }
            return result;
        }
    }

    public static class JobResultDtoProvider implements DtoProvider<JobResultDto> {
    	public Class<? extends JobResultDto> getImplClass() {
    	  	return JobResultDto.class;
    	}
    
    	public JobResultDto newInstance() {
        	return new JobResultDto();
    	}
    
    	public JobResultDto fromJson(String json) {
    		return JobResultDto.fromJson(json);
    	}
        public JobResultDto fromJson(JSONValue json) {
    		return JobResultDto.fromJson(json);
    	}
        public JobResultDto clone(JobResultDto dto) {
            return JobResultDto.fromJson(dto.toJson());
    	}
    }

    public static class PackageFragmentDto extends PackageFragment implements JsonSerializable {

        public PackageFragmentDto() {
        }

        public PackageFragmentDto(org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment o) {
                boolean defaultPackageVal = (boolean)makeDto(o.isDefaultPackage());;
                setDefaultPackage((boolean)defaultPackageVal);
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JSONValue toJsonElement() {
            JSONObject result = new JSONObject();
            JSONValue defaultPackageVal = JSONBoolean.getInstance(isDefaultPackage());;
                result.put("defaultPackage", defaultPackageVal);
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JSONValue projectUriVal = getProjectUri() == null ? JSONNull.getInstance() : new JSONString(getProjectUri());;
                result.put("projectUri", projectUriVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JSONValue uriVal = getUri() == null ? JSONNull.getInstance() : new JSONString(getUri());;
                result.put("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JSONValue nameVal = getName() == null ? JSONNull.getInstance() : new JSONString(getName());;
                result.put("name", nameVal);
            }
            return result;

        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static PackageFragmentDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(JSONParser.parseStrict(json));
        }
        public static PackageFragmentDto fromJson(JSONValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JSONObject json= jsonVal.isObject();
            PackageFragmentDto result= new PackageFragmentDto();
            JSONValue jsondefaultPackageJson = json.get("defaultPackage");
            if (jsondefaultPackageJson != null && !(jsondefaultPackageJson.isNull() != null)) {
                boolean jsondefaultPackageVal = jsondefaultPackageJson.isBoolean().booleanValue();
                result.setDefaultPackage((boolean)jsondefaultPackageVal);
            }
            JSONValue jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isNull() != null)) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.isString().stringValue();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JSONValue jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isNull() != null)) {
                java.lang.String jsonuriVal = jsonuriJson.isString().stringValue();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JSONValue jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isNull() != null)) {
                java.lang.String jsonnameVal = jsonnameJson.isString().stringValue();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class PackageFragmentDtoProvider implements DtoProvider<PackageFragmentDto> {
    	public Class<? extends PackageFragmentDto> getImplClass() {
    	  	return PackageFragmentDto.class;
    	}
    
    	public PackageFragmentDto newInstance() {
        	return new PackageFragmentDto();
    	}
    
    	public PackageFragmentDto fromJson(String json) {
    		return PackageFragmentDto.fromJson(json);
    	}
        public PackageFragmentDto fromJson(JSONValue json) {
    		return PackageFragmentDto.fromJson(json);
    	}
        public PackageFragmentDto clone(PackageFragmentDto dto) {
            return PackageFragmentDto.fromJson(dto.toJson());
    	}
    }

    public void accept(DtoFactory dtoFactory) {
        dtoFactory.registerProvider(UpdateMavenModulesInfo.class, new UpdateMavenModulesInfoDtoProvider());
        dtoFactory.registerProvider(JavaProjectStructure.class, new JavaProjectStructureDtoProvider());
        dtoFactory.registerProvider(TestPositionParameters.class, new TestPositionParametersDtoProvider());
        dtoFactory.registerProvider(OrganizeImportParams.class, new OrganizeImportParamsDtoProvider());
        dtoFactory.registerProvider(RenameSettings.class, new RenameSettingsDtoProvider());
        dtoFactory.registerProvider(OrganizeImportsResult.class, new OrganizeImportsResultDtoProvider());
        dtoFactory.registerProvider(JavaCoreOptions.class, new JavaCoreOptionsDtoProvider());
        dtoFactory.registerProvider(MoveSettings.class, new MoveSettingsDtoProvider());
        dtoFactory.registerProvider(RefactoringStatusEntry.class, new RefactoringStatusEntryDtoProvider());
        dtoFactory.registerProvider(FileStructureCommandParameters.class, new FileStructureCommandParametersDtoProvider());
        dtoFactory.registerProvider(TestPosition.class, new TestPositionDtoProvider());
        dtoFactory.registerProvider(PackageFragmentRoot.class, new PackageFragmentRootDtoProvider());
        dtoFactory.registerProvider(UpdateWorkspaceParameters.class, new UpdateWorkspaceParametersDtoProvider());
        dtoFactory.registerProvider(RenamingElementInfo.class, new RenamingElementInfoDtoProvider());
        dtoFactory.registerProvider(UpdateClasspathParameters.class, new UpdateClasspathParametersDtoProvider());
        dtoFactory.registerProvider(RenameSelectionParams.class, new RenameSelectionParamsDtoProvider());
        dtoFactory.registerProvider(JdtLsPreferences.class, new JdtLsPreferencesDtoProvider());
        dtoFactory.registerProvider(TestFindParameters.class, new TestFindParametersDtoProvider());
        dtoFactory.registerProvider(ProgressReport.class, new ProgressReportDtoProvider());
        dtoFactory.registerProvider(CreateMoveParams.class, new CreateMoveParamsDtoProvider());
        dtoFactory.registerProvider(CheWorkspaceEdit.class, new CheWorkspaceEditDtoProvider());
        dtoFactory.registerProvider(JarEntry.class, new JarEntryDtoProvider());
        dtoFactory.registerProvider(StatusReport.class, new StatusReportDtoProvider());
        dtoFactory.registerProvider(RefactoringStatus.class, new RefactoringStatusDtoProvider());
        dtoFactory.registerProvider(UsagesResponse.class, new UsagesResponseDtoProvider());
        dtoFactory.registerProvider(ExternalLibrariesParameters.class, new ExternalLibrariesParametersDtoProvider());
        dtoFactory.registerProvider(ReImportMavenProjectsCommandParameters.class, new ReImportMavenProjectsCommandParametersDtoProvider());
        dtoFactory.registerProvider(ResourceLocation.class, new ResourceLocationDtoProvider());
        dtoFactory.registerProvider(ClasspathEntry.class, new ClasspathEntryDtoProvider());
        dtoFactory.registerProvider(SearchResult.class, new SearchResultDtoProvider());
        dtoFactory.registerProvider(CheResourceChange.class, new CheResourceChangeDtoProvider());
        dtoFactory.registerProvider(Jar.class, new JarDtoProvider());
        dtoFactory.registerProvider(ImplementersResponse.class, new ImplementersResponseDtoProvider());
        dtoFactory.registerProvider(ExtendedSymbolInformation.class, new ExtendedSymbolInformationDtoProvider());
        dtoFactory.registerProvider(RefactoringResult.class, new RefactoringResultDtoProvider());
        dtoFactory.registerProvider(Resource.class, new ResourceDtoProvider());
        dtoFactory.registerProvider(JobResult.class, new JobResultDtoProvider());
        dtoFactory.registerProvider(PackageFragment.class, new PackageFragmentDtoProvider());
    }
    public static final Object makeDto(Object obj) {
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo) {
            return new UpdateMavenModulesInfoDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure) {
            return new JavaProjectStructureDto((org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters) {
            return new TestPositionParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams) {
            return new OrganizeImportParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings) {
            return new RenameSettingsDto((org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult) {
            return new OrganizeImportsResultDto((org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions) {
            return new JavaCoreOptionsDto((org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings) {
            return new MoveSettingsDto((org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry) {
            return new RefactoringStatusEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters) {
            return new FileStructureCommandParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestPosition) {
            return new TestPositionDto((org.eclipse.che.jdt.ls.extension.api.dto.TestPosition)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot) {
            return new PackageFragmentRootDto((org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters) {
            return new UpdateWorkspaceParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo) {
            return new RenamingElementInfoDto((org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters) {
            return new UpdateClasspathParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams) {
            return new RenameSelectionParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences) {
            return new JdtLsPreferencesDto((org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters) {
            return new TestFindParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport) {
            return new ProgressReportDto((org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams) {
            return new CreateMoveParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit) {
            return new CheWorkspaceEditDto((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JarEntry) {
            return new JarEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.JarEntry)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.StatusReport) {
            return new StatusReportDto((org.eclipse.che.jdt.ls.extension.api.dto.StatusReport)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus) {
            return new RefactoringStatusDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse) {
            return new UsagesResponseDto((org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters) {
            return new ExternalLibrariesParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters) {
            return new ReImportMavenProjectsCommandParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation) {
            return new ResourceLocationDto((org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry) {
            return new ClasspathEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.SearchResult) {
            return new SearchResultDto((org.eclipse.che.jdt.ls.extension.api.dto.SearchResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange) {
            return new CheResourceChangeDto((org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.Jar) {
            return new JarDto((org.eclipse.che.jdt.ls.extension.api.dto.Jar)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse) {
            return new ImplementersResponseDto((org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation) {
            return new ExtendedSymbolInformationDto((org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult) {
            return new RefactoringResultDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.Resource) {
            return new ResourceDto((org.eclipse.che.jdt.ls.extension.api.dto.Resource)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JobResult) {
            return new JobResultDto((org.eclipse.che.jdt.ls.extension.api.dto.JobResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment) {
            return new PackageFragmentDto((org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment)obj);
        }
        return obj;
    }
}
