/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.che.commons.lang.IoUtil;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.Jar;
import org.eclipse.che.ide.ext.java.shared.JarEntry;
import org.eclipse.che.ide.ext.java.shared.OpenDeclarationDescriptor;
import org.eclipse.che.ide.ext.java.shared.dto.ClassContent;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.model.CompilationUnit;
import org.eclipse.che.ide.ext.java.shared.dto.model.Field;
import org.eclipse.che.ide.ext.java.shared.dto.model.Initializer;
import org.eclipse.che.ide.ext.java.shared.dto.model.JavaProject;
import org.eclipse.che.ide.ext.java.shared.dto.model.Member;
import org.eclipse.che.ide.ext.java.shared.dto.model.Method;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragment;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragmentRoot;
import org.eclipse.che.ide.ext.java.shared.dto.model.Type;
import org.eclipse.che.jdt.javadoc.JavaElementLabels;
import org.eclipse.che.plugin.java.server.SourcesFromBytecodeGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaNavigation {
    private static final Logger LOG = LoggerFactory.getLogger(JavaNavigation.class);
    private static final ArrayList<JarEntry> NO_ENTRIES = new ArrayList(1);
    private static Comparator<JarEntry> comparator = new Comparator<JarEntry>(){

        @Override
        public int compare(JarEntry o1, JarEntry o2) {
            if (o1.getType() == JarEntry.JarEntryType.PACKAGE && o2.getType() != JarEntry.JarEntryType.PACKAGE) {
                return 1;
            }
            if (o2.getType() == JarEntry.JarEntryType.PACKAGE && o1.getType() != JarEntry.JarEntryType.PACKAGE) {
                return 1;
            }
            if (o1.getType() == JarEntry.JarEntryType.CLASS_FILE && o2.getType() != JarEntry.JarEntryType.CLASS_FILE) {
                return 1;
            }
            if (o1.getType() != JarEntry.JarEntryType.CLASS_FILE && o2.getType() == JarEntry.JarEntryType.CLASS_FILE) {
                return 1;
            }
            if (o1.getType() == JarEntry.JarEntryType.FOLDER && o2.getType() != JarEntry.JarEntryType.FOLDER) {
                return 1;
            }
            if (o1.getType() != JarEntry.JarEntryType.FOLDER && o2.getType() == JarEntry.JarEntryType.FOLDER) {
                return 1;
            }
            if (o1.getType() == JarEntry.JarEntryType.FILE && o2.getType() != JarEntry.JarEntryType.FILE) {
                return -1;
            }
            if (o1.getType() != JarEntry.JarEntryType.FILE && o2.getType() == JarEntry.JarEntryType.FILE) {
                return -1;
            }
            if (o1.getType() == o2.getType()) {
                return o1.getName().compareTo(o2.getName());
            }
            return 0;
        }
    };
    private Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
    private boolean fFoldPackages = true;
    private SourcesFromBytecodeGenerator sourcesGenerator;

    @Inject
    public JavaNavigation(SourcesFromBytecodeGenerator sourcesGenerator) {
        this.sourcesGenerator = sourcesGenerator;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        if (a1Len == 0) {
            return a2;
        }
        if (a2Len == 0) {
            return a1;
        }
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    private static IPackageFragment getFolded(IJavaElement[] children, IPackageFragment pack) throws JavaModelException {
        while (JavaNavigation.isEmpty(pack)) {
            IPackageFragment collapsed = JavaNavigation.findSinglePackageChild(pack, children);
            if (collapsed == null) {
                return pack;
            }
            pack = collapsed;
        }
        return pack;
    }

    private static boolean isEmpty(IPackageFragment fragment) throws JavaModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaResources().length == 0;
    }

    private static IPackageFragment findSinglePackageChild(IPackageFragment fragment, IJavaElement[] children) {
        String prefix = fragment.getElementName() + '.';
        int prefixLen = prefix.length();
        IPackageFragment found = null;
        for (int i = 0; i < children.length; ++i) {
            IJavaElement element = children[i];
            String name = element.getElementName();
            if (!name.startsWith(prefix) || name.length() <= prefixLen || name.indexOf(46, prefixLen) != -1) continue;
            if (found == null) {
                found = (IPackageFragment)element;
                continue;
            }
            return null;
        }
        return found;
    }

    public OpenDeclarationDescriptor findDeclaration(IJavaProject project, String fqn, int offset) throws JavaModelException {
        IJavaElement originalElement = null;
        IType type = project.findType(fqn);
        Object codeAssist = type.isBinary() ? type.getClassFile() : type.getCompilationUnit();
        IJavaElement[] elements = null;
        if (codeAssist != null) {
            elements = codeAssist.codeSelect(offset, 0);
        }
        if (elements != null && elements.length > 0) {
            originalElement = elements[0];
        }
        for (IJavaElement element = originalElement; element != null; element = element.getParent()) {
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = ((ICompilationUnit)element).getPrimary();
                return this.compilationUnitNavigation(unit, originalElement);
            }
            if (!(element instanceof IClassFile)) continue;
            return this.classFileNavigation((IClassFile)element, originalElement);
        }
        return null;
    }

    public List<Jar> getProjectDependecyJars(IJavaProject project) throws JavaModelException {
        ArrayList<Jar> jars = new ArrayList<Jar>();
        for (IPackageFragmentRoot fragmentRoot : project.getAllPackageFragmentRoots()) {
            if (!(fragmentRoot instanceof JarPackageFragmentRoot)) continue;
            Jar jar = (Jar)DtoFactory.getInstance().createDto(Jar.class);
            jar.setId(fragmentRoot.hashCode());
            jar.setName(fragmentRoot.getElementName());
            jars.add(jar);
        }
        return jars;
    }

    public List<JarEntry> getPackageFragmentRootContent(IJavaProject project, int hash) throws JavaModelException {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot(project, hash);
        if (packageFragmentRoot == null) {
            return NO_ENTRIES;
        }
        Object[] rootContent = this.getPackageFragmentRootContent(packageFragmentRoot);
        return this.convertToJarEntry(rootContent, packageFragmentRoot);
    }

    public CompilationUnit getCompilationUnitByPath(IJavaProject javaProject, String fqn, boolean isShowingInheritedMembers) throws JavaModelException {
        IClassFile unit;
        IType type = javaProject.findType(fqn);
        CompilationUnit compilationUnit = (CompilationUnit)DtoFactory.newDto(CompilationUnit.class);
        if (type.isBinary()) {
            unit = type.getClassFile();
            compilationUnit.setPath(unit.getType().getFullyQualifiedName());
        } else {
            unit = type.getCompilationUnit();
            compilationUnit.setProjectPath(unit.getJavaProject().getPath().toOSString());
            compilationUnit.setPath(unit.getResource().getFullPath().toOSString());
        }
        compilationUnit.setElementName(unit.getElementName());
        compilationUnit.setHandleIdentifier(unit.getHandleIdentifier());
        compilationUnit.setLabel(org.eclipse.jdt.ui.JavaElementLabels.getElementLabel((IJavaElement)unit, (long)org.eclipse.jdt.ui.JavaElementLabels.ALL_DEFAULT));
        ArrayList<Type> types = new ArrayList<Type>(1);
        Type dtoType = this.convertToDTOType(type);
        dtoType.setPrimary(true);
        types.add(dtoType);
        compilationUnit.setTypes(types);
        if (isShowingInheritedMembers) {
            compilationUnit.setSuperTypes(this.calculateSuperTypes(type));
        }
        return compilationUnit;
    }

    private List<Type> calculateSuperTypes(IType type) throws JavaModelException {
        ArrayList<Type> superTypes = new ArrayList<Type>();
        ITypeHierarchy superTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
        if (superTypeHierarchy != null) {
            IType[] superITypes;
            for (IType iType : superITypes = superTypeHierarchy.getAllSupertypes(type)) {
                superTypes.add(this.convertToDTOType(iType));
            }
        }
        return superTypes;
    }

    private Type convertToDTOType(IType iType) throws JavaModelException {
        IJavaElement[] children;
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        Type type = (Type)DtoFactory.newDto(Type.class);
        this.setRootPath((IMember)iType, (Member)type);
        type.setElementName(iType.getElementName());
        type.setLabel(org.eclipse.jdt.ui.JavaElementLabels.getElementLabel((IJavaElement)iType, (long)org.eclipse.jdt.ui.JavaElementLabels.ALL_DEFAULT));
        type.setHandleIdentifier(iType.getHandleIdentifier());
        type.setFlags(iType.getFlags());
        type.setFileRegion(this.convertToDTORegion(iType.getNameRange()));
        if (!iType.hasChildren()) {
            type.setTypes(types);
            return type;
        }
        block6: for (IJavaElement child : children = iType.getChildren()) {
            switch (child.getElementType()) {
                case 7: {
                    types.add(this.convertToDTOType((IType)child));
                    continue block6;
                }
                case 8: {
                    fields.add(this.convertToDTOField((IField)child));
                    continue block6;
                }
                case 9: {
                    methods.add(this.convertToDTOMethod((IMethod)child));
                    continue block6;
                }
                case 10: {
                    initializers.add(this.convertToDTOInitializer((IInitializer)child));
                    continue block6;
                }
            }
        }
        type.setFields(fields);
        type.setMethods(methods);
        type.setInitializers(initializers);
        type.setTypes(types);
        return type;
    }

    private Field convertToDTOField(IField iField) throws JavaModelException {
        Field field = (Field)DtoFactory.newDto(Field.class);
        this.setRootPath((IMember)iField, (Member)field);
        field.setFileRegion(this.convertToDTORegion(iField.getNameRange()));
        field.setElementName(iField.getElementName());
        field.setHandleIdentifier(iField.getHandleIdentifier());
        field.setFlags(iField.getFlags());
        field.setLabel(org.eclipse.jdt.ui.JavaElementLabels.getElementLabel((IJavaElement)iField, (long)org.eclipse.jdt.ui.JavaElementLabels.ALL_DEFAULT));
        return field;
    }

    private Method convertToDTOMethod(IMethod iMethod) throws JavaModelException {
        Method method = (Method)DtoFactory.newDto(Method.class);
        this.setRootPath((IMember)iMethod, (Member)method);
        method.setFileRegion(this.convertToDTORegion(iMethod.getNameRange()));
        method.setElementName(iMethod.getElementName());
        method.setReturnType(Signature.toString((String)iMethod.getReturnType()));
        method.setHandleIdentifier(iMethod.getHandleIdentifier());
        method.setFlags(iMethod.getFlags());
        method.setLabel(org.eclipse.jdt.ui.JavaElementLabels.getElementLabel((IJavaElement)iMethod, (long)org.eclipse.jdt.ui.JavaElementLabels.ALL_DEFAULT));
        return method;
    }

    private void setRootPath(IMember iMember, Member member) {
        if (iMember.isBinary()) {
            member.setBinary(true);
            member.setRootPath(iMember.getClassFile().getType().getFullyQualifiedName());
            member.setLibId(iMember.getClassFile().getAncestor(3).hashCode());
        } else {
            member.setBinary(false);
            member.setRootPath(iMember.getCompilationUnit().getPath().toOSString());
        }
    }

    private Initializer convertToDTOInitializer(IInitializer iInitializer) throws JavaModelException {
        Initializer initializer = (Initializer)DtoFactory.newDto(Initializer.class);
        initializer.setFileRegion(this.convertToDTORegion(iInitializer.getSourceRange()));
        initializer.setElementName(iInitializer.getElementName());
        initializer.setHandleIdentifier(iInitializer.getHandleIdentifier());
        initializer.setFlags(iInitializer.getFlags());
        initializer.setLabel(org.eclipse.jdt.ui.JavaElementLabels.getElementLabel((IJavaElement)iInitializer, (long)org.eclipse.jdt.ui.JavaElementLabels.ALL_DEFAULT));
        return initializer;
    }

    private Region convertToDTORegion(ISourceRange iSourceRange) {
        Region region = (Region)DtoFactory.newDto(Region.class);
        return iSourceRange == null ? region : region.withLength(iSourceRange.getLength()).withOffset(iSourceRange.getOffset());
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project, int hash) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        IPackageFragmentRoot packageFragmentRoot = null;
        for (IPackageFragmentRoot root : roots) {
            if (root.hashCode() != hash) continue;
            packageFragmentRoot = root;
            break;
        }
        return packageFragmentRoot;
    }

    private List<JarEntry> convertToJarEntry(Object[] rootContent, IPackageFragmentRoot root) throws JavaModelException {
        ArrayList<JarEntry> result = new ArrayList<JarEntry>();
        for (Object o : rootContent) {
            JarEntry entry;
            if (o instanceof IPackageFragment) {
                entry = (JarEntry)DtoFactory.getInstance().createDto(JarEntry.class);
                IPackageFragment packageFragment = (IPackageFragment)o;
                entry.setName(this.getSpecificText((IJavaElement)o));
                entry.setPath(packageFragment.getElementName());
                entry.setType(JarEntry.JarEntryType.PACKAGE);
                result.add(entry);
            }
            if (o instanceof IClassFile) {
                entry = this.getJarClass((IClassFile)o);
                result.add(entry);
            }
            if (!(o instanceof JarEntryResource)) continue;
            result.add(this.getJarEntryResource((JarEntryResource)o));
        }
        Collections.sort(result, comparator);
        return result;
    }

    private JarEntry getJarClass(IClassFile classFile) {
        JarEntry entry = (JarEntry)DtoFactory.getInstance().createDto(JarEntry.class);
        entry.setType(JarEntry.JarEntryType.CLASS_FILE);
        entry.setName(classFile.getElementName());
        entry.setPath(classFile.getType().getFullyQualifiedName());
        return entry;
    }

    private String getSpecificText(IJavaElement element) {
        IPackageFragment fragment;
        Object parent;
        if (element instanceof IPackageFragment && (parent = this.getHierarchicalPackageParent(fragment = (IPackageFragment)element)) instanceof IPackageFragment) {
            return this.getNameDelta((IPackageFragment)parent, fragment);
        }
        return JavaElementLabels.getElementLabel((IJavaElement)element, (long)0L);
    }

    private String getNameDelta(IPackageFragment parent, IPackageFragment fragment) {
        String prefix = parent.getElementName() + '.';
        String fullName = fragment.getElementName();
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    public Object getHierarchicalPackageParent(IPackageFragment child) {
        String realParentName;
        IPackageFragment element;
        String name = child.getElementName();
        IPackageFragmentRoot parent = (IPackageFragmentRoot)child.getParent();
        int index = name.lastIndexOf(46);
        if (index != -1 && (element = parent.getPackageFragment(realParentName = name.substring(0, index))).exists()) {
            try {
                if (this.fFoldPackages && JavaNavigation.isEmpty(element) && JavaNavigation.findSinglePackageChild(element, parent.getChildren()) != null) {
                    return this.getHierarchicalPackageParent(element);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return element;
        }
        return parent;
    }

    private JarEntry getJarEntryResource(JarEntryResource resource) {
        JarEntry entry = (JarEntry)DtoFactory.getInstance().createDto(JarEntry.class);
        if (resource instanceof JarEntryDirectory) {
            entry.setType(JarEntry.JarEntryType.FOLDER);
        }
        if (resource instanceof JarEntryFile) {
            entry.setType(JarEntry.JarEntryType.FILE);
        }
        entry.setName(resource.getName());
        entry.setPath(resource.getFullPath().toOSString());
        return entry;
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        Object[] nonJavaResources = root.getNonJavaResources();
        for (int i = 0; i < nonJavaResources.length; ++i) {
            result.add(nonJavaResources[i]);
        }
        return result.toArray();
    }

    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IPackageFragmentRoot)fragment.getParent(), fragment, result);
        IClassFile[] classFiles = fragment.getClassFiles();
        ArrayList<IClassFile> filtered = new ArrayList<IClassFile>();
        for (IClassFile classFile : classFiles) {
            if (classFile.getElementName().contains("$")) continue;
            filtered.add(classFile);
        }
        Object[] nonPackages = JavaNavigation.concatenate(filtered.toArray(), fragment.getNonJavaResources());
        if (result.isEmpty()) {
            return nonPackages;
        }
        Collections.addAll(result, nonPackages);
        return result.toArray();
    }

    private void getHierarchicalPackageChildren(IPackageFragmentRoot parent, IPackageFragment fragment, Collection<Object> result) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        String prefix = fragment != null ? fragment.getElementName() + '.' : "";
        int prefixLen = prefix.length();
        for (int i = 0; i < children.length; ++i) {
            IJavaElement[] currChildren;
            IPackageFragment curr = (IPackageFragment)children[i];
            String name = curr.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (this.fFoldPackages) {
                    curr = JavaNavigation.getFolded(children, curr);
                }
                result.add(curr);
                continue;
            }
            if (fragment != null || !curr.isDefaultPackage() || (currChildren = curr.getChildren()) == null || currChildren.length < 1) continue;
            result.add(curr);
        }
    }

    private OpenDeclarationDescriptor classFileNavigation(IClassFile classFile, IJavaElement element) throws JavaModelException {
        OpenDeclarationDescriptor dto = (OpenDeclarationDescriptor)DtoFactory.getInstance().createDto(OpenDeclarationDescriptor.class);
        dto.setPath(classFile.getType().getFullyQualifiedName());
        dto.setLibId(classFile.getAncestor(3).hashCode());
        dto.setBinary(true);
        if (classFile.getSourceRange() != null && element instanceof ISourceReference) {
            ISourceRange nameRange = ((ISourceReference)element).getNameRange();
            dto.setOffset(nameRange.getOffset());
            dto.setLength(nameRange.getLength());
        }
        return dto;
    }

    private OpenDeclarationDescriptor compilationUnitNavigation(ICompilationUnit unit, IJavaElement element) throws JavaModelException {
        OpenDeclarationDescriptor dto = (OpenDeclarationDescriptor)DtoFactory.getInstance().createDto(OpenDeclarationDescriptor.class);
        String absolutePath = unit.getPath().toOSString();
        dto.setPath(absolutePath);
        dto.setBinary(false);
        if (element instanceof ISourceReference) {
            ISourceRange nameRange = ((ISourceReference)element).getNameRange();
            dto.setOffset(nameRange.getOffset());
            dto.setLength(nameRange.getLength());
        }
        return dto;
    }

    private Object[] findJarDirectoryChildren(JarEntryDirectory directory, String path) {
        String directoryPath = directory.getFullPath().toOSString();
        if (directoryPath.equals(path)) {
            return directory.getChildren();
        }
        if (path.startsWith(directoryPath)) {
            for (IJarEntryResource resource : directory.getChildren()) {
                String childrenPath = resource.getFullPath().toOSString();
                if (childrenPath.equals(path)) {
                    return resource.getChildren();
                }
                if (!path.startsWith(childrenPath) || !(resource instanceof JarEntryDirectory)) continue;
                this.findJarDirectoryChildren((JarEntryDirectory)resource, path);
            }
        }
        return null;
    }

    public List<JarEntry> getChildren(IJavaProject project, int rootId, String path) throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(project, rootId);
        if (root == null) {
            return NO_ENTRIES;
        }
        if (path.startsWith("/")) {
            Object[] resources;
            for (Object resource : resources = root.getNonJavaResources()) {
                JarEntryDirectory directory;
                Object[] children;
                if (!(resource instanceof JarEntryDirectory) || (children = this.findJarDirectoryChildren(directory = (JarEntryDirectory)resource, path)) == null) continue;
                return this.convertToJarEntry(children, root);
            }
        } else {
            IPackageFragment fragment = root.getPackageFragment(path);
            if (fragment == null) {
                return NO_ENTRIES;
            }
            return this.convertToJarEntry(this.getPackageContent(fragment), root);
        }
        return NO_ENTRIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ClassContent getContent(IJavaProject project, int rootId, String path) throws CoreException {
        block26: {
            block25: {
                Object[] resources;
                IPackageFragmentRoot root;
                block22: {
                    root = this.getPackageFragmentRoot(project, rootId);
                    if (root == null) {
                        return null;
                    }
                    if (!path.startsWith("/")) break block25;
                    if (!(root instanceof JarPackageFragmentRoot)) break block22;
                    JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
                    ZipFile jar = null;
                    try {
                        ClassContent classContent;
                        Throwable throwable;
                        InputStream stream;
                        ZipEntry entry;
                        block23: {
                            block24: {
                                jar = jarPackageFragmentRoot.getJar();
                                entry = jar.getEntry(path.substring(1));
                                if (entry == null) break block22;
                                stream = jar.getInputStream(entry);
                                throwable = null;
                                classContent = this.createContent(IoUtil.readStream((InputStream)stream), false);
                                if (stream == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            stream.close();
                        }
                        return classContent;
                        catch (Throwable throwable3) {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (stream != null) {
                                        if (throwable != null) {
                                            try {
                                                stream.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            stream.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (IOException e) {
                                LOG.error("Can't read file content: " + entry.getName(), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (jar != null) {
                            JavaModelManager.getJavaModelManager().closeZipFile(jar);
                        }
                    }
                }
                for (Object resource : resources = root.getNonJavaResources()) {
                    JarEntryDirectory directory;
                    JarEntryFile file;
                    JarEntryFile file2;
                    if (resource instanceof JarEntryFile && (file2 = (JarEntryFile)resource).getFullPath().toOSString().equals(path)) {
                        return this.readFileContent(file2);
                    }
                    if (!(resource instanceof JarEntryDirectory) || (file = this.findJarFile(directory = (JarEntryDirectory)resource, path)) == null) continue;
                    return this.readFileContent(file);
                }
                break block26;
            }
            return this.getContent(project, path);
        }
        return null;
    }

    public ClassContent getContent(IJavaProject project, String path) throws JavaModelException {
        IType type = project.findType(path);
        if (type != null) {
            if (type.isBinary()) {
                IClassFile classFile = type.getClassFile();
                if (classFile.getSourceRange() != null) {
                    return this.createContent(classFile.getSource(), false);
                }
                return this.createContent(this.sourcesGenerator.generateSource(classFile.getType()), true);
            }
            return this.createContent(type.getCompilationUnit().getSource(), false);
        }
        throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(0, "Can't find type: " + path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClassContent readFileContent(JarEntryFile file) {
        try (InputStream stream = file.getContents();){
            ClassContent classContent = this.createContent(IoUtil.readStream((InputStream)stream), false);
            return classContent;
        }
        catch (IOException | CoreException e) {
            LOG.error("Can't read file content: " + file.getFullPath(), e);
            return null;
        }
    }

    private ClassContent createContent(String content, boolean generated) {
        ClassContent classContent = (ClassContent)DtoFactory.newDto(ClassContent.class);
        classContent.setContent(content);
        classContent.setGenerated(generated);
        return classContent;
    }

    private JarEntryFile findJarFile(JarEntryDirectory directory, String path) {
        for (IJarEntryResource children : directory.getChildren()) {
            JarEntryFile file;
            if (children.isFile() && children.getFullPath().toOSString().equals(path)) {
                return (JarEntryFile)children;
            }
            if (children.isFile() || (file = this.findJarFile((JarEntryDirectory)children, path)) == null) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarEntry getEntry(IJavaProject project, int rootId, String path) throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(project, rootId);
        if (root == null) {
            return null;
        }
        if (path.startsWith("/")) {
            Object[] resources;
            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
            ZipFile jar = null;
            try {
                jar = jarPackageFragmentRoot.getJar();
                ZipEntry entry = jar.getEntry(path.substring(1));
                if (entry != null) {
                    JarEntry result = (JarEntry)DtoFactory.getInstance().createDto(JarEntry.class);
                    result.setType(JarEntry.JarEntryType.FILE);
                    result.setPath(path);
                    result.setName(entry.getName().substring(entry.getName().lastIndexOf("/") + 1));
                    JarEntry jarEntry = result;
                    return jarEntry;
                }
            }
            finally {
                if (jar != null) {
                    JavaModelManager.getJavaModelManager().closeZipFile(jar);
                }
            }
            for (Object resource : resources = root.getNonJavaResources()) {
                JarEntryDirectory directory;
                JarEntryFile file;
                JarEntryFile file2;
                if (resource instanceof JarEntryFile && (file2 = (JarEntryFile)resource).getFullPath().toOSString().equals(path)) {
                    return this.getJarEntryResource((JarEntryResource)file2);
                }
                if (!(resource instanceof JarEntryDirectory) || (file = this.findJarFile(directory = (JarEntryDirectory)resource, path)) == null) continue;
                return this.getJarEntryResource((JarEntryResource)file);
            }
        } else {
            IType type = project.findType(path);
            if (type != null && type.isBinary()) {
                IClassFile classFile = type.getClassFile();
                return this.getJarClass(classFile);
            }
        }
        return null;
    }

    public List<JavaProject> getAllProjectsAndPackages(boolean includePackages) throws JavaModelException {
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        IJavaProject[] javaProjects = javaModel.getJavaProjects();
        ArrayList<JavaProject> result = new ArrayList<JavaProject>();
        for (IJavaProject javaProject : javaProjects) {
            if (!javaProject.exists()) continue;
            JavaProject project = (JavaProject)DtoFactory.newDto(JavaProject.class);
            project.setName(javaProject.getElementName());
            project.setPath(javaProject.getPath().toOSString());
            project.setPackageFragmentRoots(this.toPackageRoots(javaProject, includePackages));
            result.add(project);
        }
        return result;
    }

    private List<PackageFragmentRoot> toPackageRoots(IJavaProject javaProject, boolean includePackages) throws JavaModelException {
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
        ArrayList<PackageFragmentRoot> result = new ArrayList<PackageFragmentRoot>();
        for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots) {
            if (packageFragmentRoot.getKind() != 1 || !javaProject.getPath().isPrefixOf(packageFragmentRoot.getPath())) continue;
            PackageFragmentRoot root = (PackageFragmentRoot)DtoFactory.newDto(PackageFragmentRoot.class);
            root.setPath(packageFragmentRoot.getPath().toOSString());
            root.setProjectPath(packageFragmentRoot.getJavaProject().getPath().toOSString());
            if (includePackages) {
                root.setPackageFragments(this.toPackageFragments(packageFragmentRoot));
            }
            result.add(root);
        }
        return result;
    }

    private List<PackageFragment> toPackageFragments(IPackageFragmentRoot packageFragmentRoot) throws JavaModelException {
        IJavaElement[] children = packageFragmentRoot.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<PackageFragment> result = new ArrayList<PackageFragment>();
        for (IJavaElement child : children) {
            if (!(child instanceof IPackageFragment)) continue;
            IPackageFragment packageFragment = (IPackageFragment)child;
            PackageFragment fragment = (PackageFragment)DtoFactory.newDto(PackageFragment.class);
            fragment.setElementName(packageFragment.getElementName());
            fragment.setPath(packageFragment.getPath().toOSString());
            fragment.setProjectPath(packageFragment.getJavaProject().getPath().toOSString());
            result.add(fragment);
        }
        return result;
    }
}

