/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Path(value="/java/compiler-settings")
public class CompilerSetupService {
    private static final JavaModel JAVA_MODEL = JavaModelManager.getJavaModelManager().getJavaModel();

    @POST
    @Path(value="/set")
    @Consumes(value={"application/json"})
    public void setParameters(@QueryParam(value="projectpath") String projectPath, @NotNull Map<String, String> changedParameters) {
        if (projectPath == null || projectPath.isEmpty()) {
            JavaCore.setOptions(new Hashtable<String, String>(changedParameters));
            return;
        }
        IJavaProject project = JAVA_MODEL.getJavaProject(projectPath);
        project.setOptions(changedParameters);
    }

    @GET
    @Path(value="/all")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> getAllParameters(@QueryParam(value="projectpath") String projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            CompilerOptions options = new CompilerOptions(new HashMap(JavaCore.getOptions()));
            return options.getMap();
        }
        IJavaProject project = JAVA_MODEL.getJavaProject(projectPath);
        Map map = project.getOptions(true);
        CompilerOptions options = new CompilerOptions(map);
        return options.getMap();
    }
}

