/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.Change;
import org.eclipse.che.ide.ext.java.shared.dto.ConflictImportDTO;
import org.eclipse.che.ide.ext.java.shared.dto.OrganizeImportResult;
import org.eclipse.che.ide.ext.java.shared.dto.Problem;
import org.eclipse.che.ide.ext.java.shared.dto.ProposalApplyResult;
import org.eclipse.che.ide.ext.java.shared.dto.ProposalPresentation;
import org.eclipse.che.ide.ext.java.shared.dto.Proposals;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeInfo;
import org.eclipse.che.jdt.JavadocFinder;
import org.eclipse.che.jdt.javadoc.HTMLPrinter;
import org.eclipse.che.jdt.javaeditor.HasLinkedModel;
import org.eclipse.che.jdt.javaeditor.TextViewer;
import org.eclipse.che.jdt.ui.CheActionAcces;
import org.eclipse.che.jface.text.ITextViewer;
import org.eclipse.che.jface.text.contentassist.ICompletionProposal;
import org.eclipse.che.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.che.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.che.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.che.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.format.DocumentChangeListener;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaAllCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.java.RelevanceSorter;
import org.eclipse.jdt.internal.ui.text.java.TemplateCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CodeAssist {
    private static final Logger LOG = LoggerFactory.getLogger(CodeAssist.class);
    private final Cache<String, CodeAssistContext> cache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, CodeAssistContext>(){

        public void onRemoval(RemovalNotification<String, CodeAssistContext> notification) {
            if (notification.getValue() != null) {
                ((CodeAssistContext)notification.getValue()).clean();
            }
        }
    }).build();

    public Proposals computeProposals(IJavaProject project, String fqn, int offset, final String content) throws JavaModelException {
        WorkingCopyOwner copyOwner = new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                return new DocumentAdapter((IOpenable)workingCopy, workingCopy.getPath(), content);
            }
        };
        IType type = project.findType(fqn);
        if (type == null) {
            return null;
        }
        ICompilationUnit compilationUnit = type.isBinary() ? type.getClassFile().getWorkingCopy(copyOwner, null) : type.getCompilationUnit().getWorkingCopy(copyOwner, null);
        IBuffer buffer = compilationUnit.getBuffer();
        Object document = buffer instanceof DocumentAdapter ? ((DocumentAdapter)buffer).getDocument() : new org.eclipse.jdt.internal.core.DocumentAdapter(buffer);
        TextViewer viewer = new TextViewer(document, new Point(offset, 0));
        JavaContentAssistInvocationContext context = new JavaContentAssistInvocationContext((ITextViewer)viewer, offset, compilationUnit);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        proposals.addAll(new JavaAllCompletionProposalComputer().computeCompletionProposals((ContentAssistInvocationContext)context, null));
        proposals.addAll(new TemplateCompletionProposalComputer().computeCompletionProposals((ContentAssistInvocationContext)context, null));
        Collections.sort(proposals, new RelevanceSorter());
        return this.convertProposals(offset, compilationUnit, viewer, proposals);
    }

    private Proposals convertProposals(int offset, ICompilationUnit compilationUnit, TextViewer viewer, List<ICompletionProposal> proposals) {
        Proposals result = (Proposals)DtoFactory.getInstance().createDto(Proposals.class);
        String sessionId = UUID.randomUUID().toString();
        result.setSessionId(sessionId);
        ArrayList<ProposalPresentation> presentations = new ArrayList<ProposalPresentation>();
        for (int i = 0; i < proposals.size(); ++i) {
            String actionId;
            ProposalPresentation presentation = (ProposalPresentation)DtoFactory.getInstance().createDto(ProposalPresentation.class);
            ICompletionProposal proposal = proposals.get(i);
            presentation.setIndex(i);
            presentation.setDisplayString(proposal.getDisplayString());
            String image = proposal.getImage() == null ? null : proposal.getImage().getImg();
            presentation.setImage(image);
            if (proposal instanceof ICompletionProposalExtension4) {
                presentation.setAutoInsertable(((ICompletionProposalExtension4)proposal).isAutoInsertable());
            }
            if (proposal instanceof CheActionAcces && (actionId = ((CheActionAcces)proposal).getActionId()) != null) {
                presentation.setActionId(actionId);
            }
            presentations.add(presentation);
        }
        result.setProposals(presentations);
        this.cache.put((Object)sessionId, (Object)new CodeAssistContext(viewer, offset, proposals, compilationUnit));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProposalApplyResult applyCompletion(String sessionId, int index, boolean insert) {
        CodeAssistContext context = (CodeAssistContext)this.cache.getIfPresent((Object)sessionId);
        if (context != null) {
            try {
                ProposalApplyResult proposalApplyResult = context.apply(index, insert);
                return proposalApplyResult;
            }
            finally {
                this.cache.invalidate((Object)sessionId);
            }
        }
        throw new IllegalArgumentException("CodeAssist context doesn't exist or time of completion was expired");
    }

    public Proposals computeAssistProposals(IJavaProject project, String fqn, int offset, List<Problem> problems) throws CoreException {
        IType type = project.findType(fqn);
        if (type == null) {
            return null;
        }
        if (type.isBinary()) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(966, "Can't calculate Quick Assist on binary file"));
        }
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        IBuffer buffer = compilationUnit.getBuffer();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        bufferManager.connect(compilationUnit.getPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(compilationUnit.getPath(), LocationKind.IFILE);
        IDocument document = textFileBuffer.getDocument();
        TextViewer viewer = new TextViewer(document, new Point(offset, 0));
        AssistContext context = new AssistContext(compilationUnit, offset, 0);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        JavaCorrectionProcessor.collectProposals((IInvocationContext)context, problems, (boolean)true, (boolean)true, proposals);
        return this.convertProposals(offset, compilationUnit, viewer, proposals);
    }

    public String getJavaDoc(String sessionId, int index) {
        CodeAssistContext context = (CodeAssistContext)this.cache.getIfPresent((Object)sessionId);
        if (context != null) {
            return context.getJavadoc(index);
        }
        throw new IllegalArgumentException("CodeAssist context doesn't exist or time of completion was expired");
    }

    public OrganizeImportResult organizeImports(IJavaProject project, String fqn) throws CoreException, BadLocationException {
        ICompilationUnit compilationUnit = this.prepareCompilationUnit(project, fqn);
        return this.createOrganizeImportOperation(compilationUnit, null);
    }

    public List<Change> applyChosenImports(IJavaProject project, String fqn, List<String> chosen) throws CoreException, BadLocationException {
        ICompilationUnit compilationUnit = this.prepareCompilationUnit(project, fqn);
        OrganizeImportResult result = this.createOrganizeImportOperation(compilationUnit, chosen);
        return result.getChanges();
    }

    private OrganizeImportResult createOrganizeImportOperation(ICompilationUnit compilationUnit, List<String> chosen) throws CoreException {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)compilationUnit.getJavaProject());
        OrganizeImportsOperation operation = new OrganizeImportsOperation(compilationUnit, null, settings.importIgnoreLowercase, !compilationUnit.isWorkingCopy(), true, chosen, null);
        NullProgressMonitor monitor = new NullProgressMonitor();
        TextEdit edit = operation.createTextEdit((IProgressMonitor)monitor);
        OrganizeImportResult result = (OrganizeImportResult)DtoFactory.newDto(OrganizeImportResult.class);
        TypeNameMatch[][] choices = operation.getChoices();
        if (chosen != null && !chosen.isEmpty() || choices == null || choices.length == 0) {
            IBuffer buffer = compilationUnit.getBuffer();
            Document document = new Document(buffer.getContents());
            DocumentChangeListener documentChangeListener = new DocumentChangeListener((IDocument)document);
            try {
                edit.apply((IDocument)document);
            }
            catch (BadLocationException e) {
                LOG.debug("Applying Organize import text edits goes wrong:", (Throwable)e);
            }
            result.setChanges(documentChangeListener.getChanges());
            return result;
        }
        result.setConflicts(this.createListOfDTOMatches(choices));
        return result;
    }

    private List<ConflictImportDTO> createListOfDTOMatches(TypeNameMatch[][] choices) {
        ArrayList<ConflictImportDTO> typeMatches = new ArrayList<ConflictImportDTO>();
        for (int i = 0; i < choices.length; ++i) {
            ArrayList<String> nameMatches = new ArrayList<String>();
            TypeNameMatch[] choice = choices[i];
            for (int j = 0; j < choice.length; ++j) {
                nameMatches.add(choice[j].getFullyQualifiedName());
            }
            typeMatches.add(((ConflictImportDTO)DtoFactory.newDto(ConflictImportDTO.class)).withTypeMatches(nameMatches));
        }
        return typeMatches;
    }

    private ICompilationUnit prepareCompilationUnit(IJavaProject project, String fqn) throws JavaModelException {
        IType type = project.findType(fqn);
        if (type == null) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(966, "Can't find a file: " + fqn));
        }
        if (type.isBinary()) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(966, "Can't organize imports on binary file"));
        }
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        return compilationUnit;
    }

    private class CodeAssistContext {
        private TextViewer viewer;
        private int offset;
        private List<ICompletionProposal> proposals;
        private ICompilationUnit cUnit;

        public CodeAssistContext(TextViewer viewer, int offset, List<ICompletionProposal> proposals, ICompilationUnit cUnit) {
            this.viewer = viewer;
            this.offset = offset;
            this.proposals = proposals;
            this.cUnit = cUnit;
        }

        public void clean() {
            if (this.cUnit != null) {
                try {
                    this.cUnit.discardWorkingCopy();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(this.cUnit.getPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LOG.error("Can't disconnect from file buffer: " + this.cUnit.getPath(), (Throwable)e);
                }
            }
        }

        public ProposalApplyResult apply(int index, boolean insert) {
            IDocument document = this.viewer.getDocument();
            final ArrayList changes = new ArrayList();
            document.addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    changes.add(((Change)DtoFactory.newDto(Change.class)).withLength(event.getLength()).withOffset(event.getOffset()).withText(event.getText()));
                }
            });
            try {
                char trigger = '\u0000';
                int stateMask = insert ? 0 : 262144;
                ICompletionProposal completionProposal = this.proposals.get(index);
                ProposalApplyResult result = (ProposalApplyResult)DtoFactory.newDto(ProposalApplyResult.class);
                if (completionProposal instanceof ChangeCorrectionProposal) {
                    result.setChangeInfo(this.prepareChangeInfo((ChangeCorrectionProposal)completionProposal));
                }
                if (completionProposal instanceof ICompletionProposalExtension2) {
                    ICompletionProposalExtension2 completionProposalExtension2 = (ICompletionProposalExtension2)completionProposal;
                    completionProposalExtension2.apply((ITextViewer)this.viewer, trigger, stateMask, this.offset);
                } else if (completionProposal instanceof ICompletionProposalExtension) {
                    ICompletionProposalExtension completionProposalExtension = (ICompletionProposalExtension)completionProposal;
                    completionProposalExtension.apply(document, trigger, this.offset);
                } else {
                    completionProposal.apply(document);
                }
                result.setChanges(changes);
                Point selection = completionProposal.getSelection(document);
                if (selection != null) {
                    result.setSelection(((Region)DtoFactory.newDto(Region.class)).withOffset(selection.x).withLength(selection.y));
                }
                if (completionProposal instanceof HasLinkedModel) {
                    result.setLinkedModeModel(((HasLinkedModel)completionProposal).getLinkedModel());
                }
                return result;
            }
            catch (IndexOutOfBoundsException | CoreException e) {
                throw new IllegalArgumentException("Can't find completion: " + index, e);
            }
        }

        public String getJavadoc(int index) {
            String result;
            ICompletionProposal proposal = this.proposals.get(index);
            if (proposal instanceof ICompletionProposalExtension5) {
                Object info = ((ICompletionProposalExtension5)proposal).getAdditionalProposalInfo(null);
                if (info != null) {
                    result = info.toString();
                } else {
                    StringBuffer buffer = new StringBuffer();
                    HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)JavadocFinder.getStyleSheet());
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"No documentation found.");
                    HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                    result = buffer.toString();
                }
            } else {
                result = proposal.getAdditionalProposalInfo();
            }
            return result;
        }

        private ChangeInfo prepareChangeInfo(ChangeCorrectionProposal changeCorrectionProposal) throws CoreException {
            org.eclipse.ltk.core.refactoring.Change change = changeCorrectionProposal.getChange();
            if (change == null) {
                return null;
            }
            ChangeInfo changeInfo = (ChangeInfo)DtoFactory.newDto(ChangeInfo.class);
            String changeName = change.getName();
            if (changeName.startsWith("Rename") && change instanceof RenameCompilationUnitChange) {
                this.prepareRenameCompilationUnitChange(changeInfo, change);
            } else if (changeName.startsWith("Move")) {
                this.prepareMoveChange(changeInfo, change);
            }
            return changeInfo;
        }

        private void prepareMoveChange(ChangeInfo changeInfo, org.eclipse.ltk.core.refactoring.Change ch) {
            changeInfo.setName(ChangeInfo.ChangeName.MOVE);
            for (org.eclipse.ltk.core.refactoring.Change change : ((CompositeChange)ch).getChildren()) {
                if (!(change instanceof MoveCompilationUnitChange)) continue;
                MoveCompilationUnitChange moveChange = (MoveCompilationUnitChange)change;
                String className = moveChange.getCu().getPath().lastSegment();
                changeInfo.setPath(moveChange.getDestinationPackage().getPath().append(className).toString());
                changeInfo.setOldPath(((CompilationUnit)change.getModifiedElement()).getPath().toString());
            }
        }

        private void prepareRenameCompilationUnitChange(ChangeInfo changeInfo, org.eclipse.ltk.core.refactoring.Change change) {
            changeInfo.setName(ChangeInfo.ChangeName.RENAME_COMPILATION_UNIT);
            RenameCompilationUnitChange renameChange = (RenameCompilationUnitChange)change;
            changeInfo.setPath(renameChange.getResourcePath().removeLastSegments(1).append(renameChange.getNewName()).toString());
            changeInfo.setOldPath(renameChange.getResourcePath().toString());
        }
    }
}

