/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.ImplementationsDescriptorDTO;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.model.Member;
import org.eclipse.che.ide.ext.java.shared.dto.model.Type;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;

@Singleton
public class JavaTypeHierarchy {
    @Inject
    public JavaTypeHierarchy() {
    }

    public ImplementationsDescriptorDTO getImplementations(IJavaProject project, String fqn, int offset) throws JavaModelException {
        ImplementationsDescriptorDTO implementationDescriptor = (ImplementationsDescriptorDTO)DtoFactory.newDto(ImplementationsDescriptorDTO.class);
        IJavaElement element = this.getJavaElement(project, fqn, offset);
        if (element == null) {
            return implementationDescriptor.withImplementations(Collections.emptyList());
        }
        ArrayList<Type> implementations = new ArrayList<Type>();
        implementationDescriptor.setImplementations(implementations);
        switch (element.getElementType()) {
            case 7: {
                this.findSubTypes(element, implementations);
                implementationDescriptor.setMemberName(element.getElementName());
                break;
            }
            case 9: {
                this.findTypesWithSubMethods(element, implementations);
                implementationDescriptor.setMemberName(element.getElementName());
                break;
            }
        }
        return implementationDescriptor;
    }

    private IJavaElement getJavaElement(IJavaProject project, String fqn, int offset) throws JavaModelException {
        IJavaElement originalElement = null;
        IType type = project.findType(fqn);
        Object codeAssist = type.isBinary() ? type.getClassFile() : type.getCompilationUnit();
        IJavaElement[] elements = null;
        if (codeAssist != null) {
            elements = codeAssist.codeSelect(offset, 0);
        }
        if (elements != null && elements.length > 0) {
            originalElement = elements[0];
        }
        return originalElement;
    }

    private void findSubTypes(IJavaElement element, List<Type> implementations) throws JavaModelException {
        IType[] implTypes;
        IType type = (IType)element;
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        for (IType implType : implTypes = typeHierarchy.getAllSubtypes(type)) {
            Type dto = this.convertToTypeDTO(implType);
            implementations.add(dto);
        }
    }

    private void findTypesWithSubMethods(IJavaElement element, List<Type> implementations) throws JavaModelException {
        IMethod selectedMethod = (IMethod)element;
        IType parentType = selectedMethod.getDeclaringType();
        if (parentType == null) {
            return;
        }
        ITypeHierarchy typeHierarchy = parentType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] subTypes = typeHierarchy.getAllSubtypes(parentType);
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(parentType, typeHierarchy);
        for (IType type : subTypes) {
            IMethod method = methodOverrideTester.findOverridingMethodInType(type, selectedMethod);
            if (method == null) continue;
            Type openDeclaration = this.convertToTypeDTO(type);
            this.setRange((Member)openDeclaration, (IMember)method);
            implementations.add(openDeclaration);
        }
    }

    private void setRange(Member member, IMember iMember) throws JavaModelException {
        ISourceRange nameRange = iMember.getNameRange();
        if (iMember.isBinary()) {
            nameRange = iMember.getSourceRange();
        }
        if (nameRange == null) {
            return;
        }
        member.setFileRegion(this.convertToRegionDTO(iMember.getSourceRange()));
    }

    private Type convertToTypeDTO(IType type) throws JavaModelException {
        Type dto = (Type)DtoFactory.newDto(Type.class);
        String typeName = type.getElementName();
        if (typeName.isEmpty()) {
            dto.setElementName("Anonymous in " + type.getParent().getElementName());
        } else {
            dto.setElementName(type.getElementName());
        }
        if (type.isBinary()) {
            dto.setRootPath(type.getFullyQualifiedName());
            dto.setLibId(type.getAncestor(3).hashCode());
            dto.setBinary(true);
        } else {
            dto.setRootPath(type.getPath().toOSString());
            dto.setBinary(false);
        }
        this.setRange((Member)dto, (IMember)type);
        return dto;
    }

    private Region convertToRegionDTO(ISourceRange iSourceRange) {
        Region region = (Region)DtoFactory.newDto(Region.class);
        return iSourceRange == null ? region : region.withLength(iSourceRange.getLength()).withOffset(iSourceRange.getOffset());
    }
}

