/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.nio.file.Paths;
import org.eclipse.che.JavadocUrlProvider;
import org.eclipse.che.inject.DynaModule;
import org.eclipse.che.jdt.rest.UrlContextProvider;
import org.eclipse.che.plugin.java.server.JavaReconcileRequestHandler;
import org.eclipse.che.plugin.java.server.ProjectListeners;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringManager;
import org.eclipse.che.plugin.java.server.rest.CodeAssistService;
import org.eclipse.che.plugin.java.server.rest.CompilerSetupService;
import org.eclipse.che.plugin.java.server.rest.JavaFormatterService;
import org.eclipse.che.plugin.java.server.rest.JavaNavigationService;
import org.eclipse.che.plugin.java.server.rest.JavaReconcileService;
import org.eclipse.che.plugin.java.server.rest.JavadocService;
import org.eclipse.che.plugin.java.server.rest.JavadocUrlProviderImpl;
import org.eclipse.che.plugin.java.server.rest.JdtExceptionMapper;
import org.eclipse.che.plugin.java.server.rest.RefactoringService;
import org.eclipse.che.plugin.java.server.rest.SearchJsonRpcService;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;

@DynaModule
public class JdtGuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(JavadocService.class);
        this.bind(JavaNavigationService.class);
        this.bind(JavaReconcileService.class);
        this.bind(CodeAssistService.class);
        this.bind(JavaFormatterService.class);
        this.bind(JdtExceptionMapper.class);
        this.bind(CompilerSetupService.class);
        this.bind(ResourcesPlugin.class).asEagerSingleton();
        this.bind(JavaPlugin.class).asEagerSingleton();
        this.bind(FileBuffersPlugin.class).asEagerSingleton();
        this.bind(ProjectListeners.class).asEagerSingleton();
        this.bind(RefactoringManager.class).asEagerSingleton();
        this.bind(RefactoringService.class);
        this.bind(SearchJsonRpcService.class).asEagerSingleton();
        this.bind(JavaReconcileRequestHandler.class).asEagerSingleton();
        this.bind(JavadocUrlProvider.class).to(JavadocUrlProviderImpl.class);
        this.requestStaticInjection(new Class[]{UrlContextProvider.class});
    }

    @Provides
    @Named(value="che.jdt.settings.dir")
    @Singleton
    protected String provideSettings(@Named(value="che.workspace.metadata") String wsMetadata) {
        return Paths.get(System.getProperty("user.home"), wsMetadata, "settings").toString();
    }

    @Provides
    @Named(value="che.jdt.workspace.index.dir")
    @Singleton
    protected String provideIndex(@Named(value="che.workspace.metadata") String wsMetadata) {
        return Paths.get(System.getProperty("user.home"), wsMetadata, "index").toString();
    }
}

