/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringPreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatus;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;

public class DtoConverter {
    public static RefactoringStatus toRefactoringStatusDto(org.eclipse.ltk.core.refactoring.RefactoringStatus refactoringStatus) {
        RefactoringStatus status = (RefactoringStatus)DtoFactory.newDto(RefactoringStatus.class);
        DtoConverter.convertRefactoringStatus(status, refactoringStatus);
        return status;
    }

    public static RefactoringResult toRefactoringResultDto(org.eclipse.ltk.core.refactoring.RefactoringStatus refactoringStatus) {
        RefactoringResult result = (RefactoringResult)DtoFactory.newDto(RefactoringResult.class);
        DtoConverter.convertRefactoringStatus((RefactoringStatus)result, refactoringStatus);
        return result;
    }

    public static RefactoringPreview toRefactoringPreview(PreviewNode node) {
        RefactoringPreview dto = (RefactoringPreview)DtoFactory.newDto(RefactoringPreview.class);
        dto.setId(node.getId());
        dto.setText(node.getText());
        dto.setImage(node.getImageDescriptor().getImage());
        dto.setEnabled(true);
        PreviewNode[] children = node.getChildren();
        if (children != null && children.length > 0) {
            ArrayList<RefactoringPreview> list = new ArrayList<RefactoringPreview>(children.length);
            for (PreviewNode child : children) {
                list.add(DtoConverter.toRefactoringPreview(child));
            }
            dto.setChildrens(list);
        }
        return dto;
    }

    private static void convertRefactoringStatus(RefactoringStatus dtoStatus, org.eclipse.ltk.core.refactoring.RefactoringStatus refactoringStatus) {
        dtoStatus.setSeverity(refactoringStatus.getSeverity());
        List entryList = Arrays.stream(refactoringStatus.getEntries()).map(refactoringStatusEntry -> {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)DtoFactory.newDto(RefactoringStatusEntry.class);
            entry.setSeverity(refactoringStatusEntry.getSeverity());
            entry.setMessage(refactoringStatusEntry.getMessage());
            return entry;
        }).collect(Collectors.toList());
        dtoStatus.setEntries(entryList);
    }
}

