/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.refactoring;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.che.commons.schedule.ScheduleRate;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedModeModel;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeCreationResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeEnabledState;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangePreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.LinkedRenameRefactoringApply;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.MoveSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringChange;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringPreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatus;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameRefactoringSession;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ReorgDestination;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ValidateNewName;
import org.eclipse.che.jdt.util.JdtFlags;
import org.eclipse.che.plugin.java.server.refactoring.DtoConverter;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringException;
import org.eclipse.che.plugin.java.server.refactoring.session.MoveRefactoringSession;
import org.eclipse.che.plugin.java.server.refactoring.session.RefactoringSession;
import org.eclipse.che.plugin.java.server.refactoring.session.RenameLinkedModeRefactoringSession;
import org.eclipse.che.plugin.java.server.refactoring.session.RenameSession;
import org.eclipse.che.plugin.java.server.refactoring.session.ReorgRefactoringSession;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RefactoringManager {
    private static final Logger LOG = LoggerFactory.getLogger(RefactoringManager.class);
    private static final AtomicInteger sessionId = new AtomicInteger(1);
    private final Cache<String, RefactoringSession> sessions = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, RefactoringSession>(){

        public void onRemoval(RemovalNotification<String, RefactoringSession> notification) {
            RefactoringSession value = (RefactoringSession)notification.getValue();
            if (value != null) {
                value.dispose();
            }
        }
    }).build();

    private static RenameSupport createRenameSupport(IJavaElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 4: {
                return RenameSupport.create((IPackageFragment)((IPackageFragment)element), (String)newName, (int)flags);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)((ICompilationUnit)element), (String)newName, (int)flags);
            }
            case 7: {
                return RenameSupport.create((IType)((IType)element), (String)newName, (int)flags);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringManager.createRenameSupport((IJavaElement)method.getDeclaringType(), newName, flags);
                }
                return RenameSupport.create((IMethod)((IMethod)element), (String)newName, (int)flags);
            }
            case 8: {
                return RenameSupport.create((IField)((IField)element), (String)newName, (int)flags);
            }
            case 15: {
                return RenameSupport.create((ITypeParameter)((ITypeParameter)element), (String)newName, (int)flags);
            }
            case 14: {
                return RenameSupport.create((ILocalVariable)((ILocalVariable)element), (String)newName, (int)flags);
            }
        }
        return null;
    }

    public String createMoveRefactoringSession(IJavaElement[] javaElements) throws JavaModelException, RefactoringException {
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy((IResource[])new IResource[0], (IJavaElement[])javaElements);
        if (policy.canEnable()) {
            JavaMoveProcessor processor = new JavaMoveProcessor(policy);
            processor.setReorgQueries((IReorgQueries)new NullReorgQueries());
            processor.setCreateTargetQueries(() -> null);
            MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
            MoveRefactoringSession session = new MoveRefactoringSession((Refactoring)refactoring, processor);
            String id = String.format("move-%s", sessionId.getAndIncrement());
            this.sessions.put((Object)id, (Object)session);
            return id;
        }
        throw new RefactoringException("Can't create move refactoring session.");
    }

    @ScheduleRate(initialDelay=1L, period=1L, unit=TimeUnit.HOURS)
    void cacheClenup() {
        this.sessions.cleanUp();
    }

    public RefactoringStatus setRefactoringDestination(ReorgDestination destination) throws RefactoringException, JavaModelException {
        RefactoringSession session = this.getRefactoringSession(destination.getSessionId());
        if (!(session instanceof ReorgRefactoringSession)) {
            throw new RefactoringException("Can't set destination on none reorg refactoring session.");
        }
        ReorgRefactoringSession rs = (ReorgRefactoringSession)session;
        Object dest = this.getDestination(destination.getProjectPath(), destination.getType(), destination.getDestination());
        org.eclipse.ltk.core.refactoring.RefactoringStatus refactoringStatus = rs.verifyDestination(dest);
        return DtoConverter.toRefactoringStatusDto(refactoringStatus);
    }

    private RefactoringSession getRefactoringSession(String sessionId) throws RefactoringException {
        RefactoringSession session = (RefactoringSession)this.sessions.getIfPresent((Object)sessionId);
        if (session == null) {
            throw new RefactoringException("Can't find refactoring session.");
        }
        return session;
    }

    private Object getDestination(String projectPath, ReorgDestination.DestinationType type, String destination) throws RefactoringException, JavaModelException {
        IJavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectPath);
        if (javaProject == null) {
            throw new RefactoringException("Can't find project: " + projectPath);
        }
        switch (type) {
            case PACKAGE: {
                return javaProject.findPackageFragment((IPath)new Path(destination));
            }
        }
        throw new UnsupportedOperationException("Can't use destination for 'RESOURCE' or 'SOURCE_REFERENCE'.");
    }

    public void setMoveSettings(MoveSettings settings) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(settings.getSessionId());
        if (!(session instanceof MoveRefactoringSession)) {
            throw new RefactoringException("Can't set move on none move refactoring session.");
        }
        MoveRefactoringSession refactoring = (MoveRefactoringSession)session;
        refactoring.setUpdateReferences(settings.isUpdateReferences());
        if (settings.isUpdateQualifiedNames()) {
            refactoring.setFilePatterns(settings.getFilePatterns());
        }
        refactoring.setUpdateQualifiedNames(settings.isUpdateQualifiedNames());
    }

    public RefactoringPreview getRefactoringPreview(String sessionId) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(sessionId);
        PreviewNode node = session.getChangePreview();
        return DtoConverter.toRefactoringPreview(node);
    }

    public ChangeCreationResult createChange(String sessionId) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(sessionId);
        return session.createChange();
    }

    public RefactoringResult applyRefactoring(String sessionId) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(sessionId);
        RefactoringResult result = session.apply();
        this.deleteRefactoringSession(sessionId);
        return result;
    }

    private void deleteRefactoringSession(String sessionId) {
        this.sessions.invalidate((Object)sessionId);
    }

    public RenameRefactoringSession createRenameRefactoring(IJavaElement element, ICompilationUnit cu, int offset, boolean lightweight) throws CoreException, RefactoringException {
        RenameRefactoringSession session = (RenameRefactoringSession)DtoFactory.newDto(RenameRefactoringSession.class);
        String id = String.format("rename-%s", sessionId.getAndIncrement());
        session.setSessionId(id);
        session.setOldName(element.getElementName());
        session.setWizardType(this.getWizardType(element));
        if (lightweight && !(element instanceof IPackageFragment)) {
            RenameLinkedModeRefactoringSession refactoringSession = new RenameLinkedModeRefactoringSession(element, cu, offset);
            LinkedModeModel model = refactoringSession.getModel();
            if (model != null) {
                session.setLinkedModeModel(model);
            }
            this.sessions.put((Object)id, (Object)refactoringSession);
            return session;
        }
        RenameSupport renameSupport = RefactoringManager.createRenameSupport(element, null, 1);
        if (renameSupport != null && renameSupport.preCheck().isOK()) {
            RenameRefactoring refactoring = renameSupport.getfRefactoring();
            RenameSession renameSession = new RenameSession(refactoring);
            this.sessions.put((Object)id, (Object)renameSession);
            return session;
        }
        throw new RefactoringException("Can't create refactoring session for element: " + element.getElementName());
    }

    private RenameRefactoringSession.RenameWizard getWizardType(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 4: {
                return RenameRefactoringSession.RenameWizard.PACKAGE;
            }
            case 5: {
                return RenameRefactoringSession.RenameWizard.COMPILATION_UNIT;
            }
            case 7: {
                return RenameRefactoringSession.RenameWizard.TYPE;
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RenameRefactoringSession.RenameWizard.TYPE;
                }
                return RenameRefactoringSession.RenameWizard.METHOD;
            }
            case 8: {
                if (JdtFlags.isEnum((IMember)((IMember)element))) {
                    return RenameRefactoringSession.RenameWizard.ENUM_CONSTANT;
                }
                return RenameRefactoringSession.RenameWizard.FIELD;
            }
            case 15: {
                return RenameRefactoringSession.RenameWizard.TYPE_PARAMETER;
            }
            case 14: {
                return RenameRefactoringSession.RenameWizard.LOCAL_VARIABLE;
            }
        }
        return null;
    }

    public RefactoringResult applyLinkedRename(LinkedRenameRefactoringApply apply) throws RefactoringException, CoreException {
        RefactoringSession session = this.getRefactoringSession(apply.getSessionId());
        if (session instanceof RenameLinkedModeRefactoringSession) {
            RenameLinkedModeRefactoringSession renameSession = (RenameLinkedModeRefactoringSession)session;
            try {
                RefactoringResult refactoringResult = renameSession.doRename(apply.getNewName());
                this.deleteRefactoringSession(apply.getSessionId());
                return refactoringResult;
            }
            catch (InterruptedException | InvocationTargetException | AssertionFailedException e) {
                LOG.error(e.getMessage(), e);
                return DtoConverter.toRefactoringResultDto(org.eclipse.ltk.core.refactoring.RefactoringStatus.createFatalErrorStatus((String)e.getMessage()));
            }
        }
        throw new RefactoringException("There is no RenameLinkedModeRefactoringSession.");
    }

    public void setRenameSettings(RenameSettings settings) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(settings.getSessionId());
        if (!(session instanceof RenameSession)) {
            throw new RefactoringException("Rename settings may be applied only to RenameSession");
        }
        ((RenameSession)session).setSettings(settings);
    }

    public RefactoringStatus renameValidateNewName(ValidateNewName newName) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(newName.getSessionId());
        if (session instanceof RenameSession) {
            return DtoConverter.toRefactoringStatusDto(((RenameSession)session).validateNewName(newName.getNewName()));
        }
        throw new RefactoringException("Validating of new name only available on RenameSession.");
    }

    public void changeChangeEnabled(ChangeEnabledState state) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(state.getSessionId());
        session.updateChangeEnabled(state.getChangeId(), state.isEnabled());
    }

    public ChangePreview getChangePreview(RefactoringChange change) throws RefactoringException {
        RefactoringSession session = this.getRefactoringSession(change.getSessionId());
        PreviewNode previewNode = session.getChangePreview(change.getChangeId());
        try {
            IChangePreviewViewer viewer;
            ChangePreviewViewerDescriptor descriptor = previewNode.getChangePreviewViewerDescriptor();
            if (descriptor != null && (viewer = descriptor.createViewer()) != null) {
                return previewNode.feedInput(viewer, Collections.EMPTY_LIST);
            }
        }
        catch (CoreException e) {
            throw new RefactoringException(e.getMessage());
        }
        return null;
    }

    public void reindexProject(IJavaProject javaProject) throws JavaModelException {
        if (javaProject != null) {
            JavaModelManager.getIndexManager().indexAll(javaProject.getProject());
        }
    }
}

