/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.refactoring.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeCreationResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeInfo;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.plugin.java.server.refactoring.DtoConverter;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;

public abstract class RefactoringSession {
    protected Refactoring refactoring;
    protected PreviewNode previewNode;
    private RefactoringStatus conditionCheckingStatus;
    private Change change;

    public RefactoringSession(Refactoring refactoring) {
        this.refactoring = refactoring;
    }

    public ChangeCreationResult createChange() throws RefactoringException {
        Change change = this.createChange(new CreateChangeOperation(new CheckConditionsOperation(this.refactoring, 4), 4), true);
        RefactoringStatus status = this.conditionCheckingStatus;
        if (change == null && status == null) {
            this.internalSetChange(change);
            throw new RefactoringException("Creating the change has been canceled");
        }
        if (!status.hasFatalError()) {
            this.internalSetChange(change);
        }
        ChangeCreationResult result = (ChangeCreationResult)DtoFactory.newDto(ChangeCreationResult.class);
        result.setStatus(DtoConverter.toRefactoringStatusDto(status));
        result.setCanShowPreviewPage(status.isOK());
        return result;
    }

    private void internalSetChange(Change change) {
        this.change = change;
    }

    private Change createChange(CreateChangeOperation operation, boolean updateStatus) throws RefactoringException {
        CoreException exception = null;
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            exception = e;
        }
        if (updateStatus) {
            RefactoringStatus status = null;
            if (exception != null) {
                status = new RefactoringStatus();
                String msg = exception.getMessage();
                if (msg != null) {
                    status.addFatalError(Messages.format((String)"{0}. See the error log for more details.", (Object)msg));
                } else {
                    status.addFatalError("An unexpected exception occurred while creating a change object. See the error log for more details.");
                }
                JavaPlugin.log((Throwable)exception);
            } else {
                status = operation.getConditionCheckingStatus();
            }
            this.setConditionCheckingStatus(status);
        } else if (exception != null) {
            throw new RefactoringException((Exception)((Object)exception));
        }
        Change change = operation.getChange();
        return change;
    }

    public void setConditionCheckingStatus(RefactoringStatus conditionCheckingStatus) {
        this.conditionCheckingStatus = conditionCheckingStatus;
    }

    public Change getChange() {
        return this.change;
    }

    public RefactoringResult apply() {
        PerformChangeOperation operation = new PerformChangeOperation(this.change);
        FinishResult result = this.internalPerformFinish(operation);
        if (result.isException()) {
            return DtoConverter.toRefactoringResultDto(RefactoringStatus.createErrorStatus((String)"Refactoring failed with Exception."));
        }
        CompositeChange operationChange = (CompositeChange)operation.getUndoChange();
        if (operationChange == null) {
            return DtoConverter.toRefactoringResultDto(new RefactoringStatus());
        }
        Change[] changes = operationChange.getChildren();
        RefactoringStatus validationStatus = operation.getValidationStatus();
        if (validationStatus == null) {
            return DtoConverter.toRefactoringResultDto(new RefactoringStatus());
        }
        ArrayList<ChangeInfo> changesInfo = new ArrayList<ChangeInfo>();
        this.prepareChangesInfo(changes, changesInfo);
        RefactoringResult status = DtoConverter.toRefactoringResultDto(validationStatus);
        status.setChanges(changesInfo);
        return status;
    }

    public void prepareChangesInfo(Change[] changes, List<ChangeInfo> changesInfo) {
        for (Change ch : changes) {
            if (ch instanceof DynamicValidationStateChange) {
                this.prepareChangesInfo(((DynamicValidationStateChange)ch).getChildren(), changesInfo);
                continue;
            }
            ChangeInfo changeInfo = (ChangeInfo)DtoFactory.newDto(ChangeInfo.class);
            String refactoringName = ch.getName();
            if (ch instanceof UndoTextFileChange) {
                changeInfo.setName(ChangeInfo.ChangeName.UPDATE);
                changeInfo.setPath(((CompilationUnit)ch.getModifiedElement()).getPath().toString());
            }
            if (refactoringName.startsWith("Rename")) {
                if (ch instanceof RenameCompilationUnitChange) {
                    this.prepareRenameCompilationUnitChange(changeInfo, ch);
                } else if (ch instanceof RenamePackageChange) {
                    this.prepareRenamePackageChange(changesInfo, changeInfo, ch);
                }
            }
            if (refactoringName.startsWith("Move")) {
                this.prepareMoveChange(changeInfo, ch);
            }
            changesInfo.add(changeInfo);
        }
    }

    private void prepareMoveChange(ChangeInfo changeInfo, Change ch) {
        changeInfo.setName(ChangeInfo.ChangeName.MOVE);
        if (ch instanceof MoveCompilationUnitChange) {
            MoveCompilationUnitChange moveChange = (MoveCompilationUnitChange)ch;
            String className = moveChange.getCu().getPath().lastSegment();
            changeInfo.setOldPath(moveChange.getDestinationPackage().getPath().append(className).toString());
            changeInfo.setPath(((CompilationUnit)ch.getModifiedElement()).getPath().toString());
        }
    }

    private void prepareRenamePackageChange(List<ChangeInfo> changesInfo, ChangeInfo changeInfo, Change ch) {
        changeInfo.setName(ChangeInfo.ChangeName.RENAME_PACKAGE);
        RenamePackageChange renameChange = (RenamePackageChange)ch;
        Path oldPackageName = new Path(renameChange.getOldName().replace('.', '/'));
        Path newPackageName = new Path(renameChange.getNewName().replace('.', '/'));
        changeInfo.setOldPath(renameChange.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append((IPath)newPackageName).toString());
        changeInfo.setPath(renameChange.getResourcePath().toString());
        Set compilationUnits = renameChange.getFCompilationUnitStamps().keySet();
        for (IResource iResource : compilationUnits) {
            ChangeInfo change = (ChangeInfo)DtoFactory.newDto(ChangeInfo.class);
            change.setName(ChangeInfo.ChangeName.UPDATE);
            IPath fullPathOldPath = iResource.getFullPath();
            IPath newPath = renameChange.getResourcePath().append(fullPathOldPath.toFile().getName());
            change.setOldPath(fullPathOldPath.toString());
            change.setPath(newPath.toString());
            changesInfo.add(change);
        }
    }

    private void prepareRenameCompilationUnitChange(ChangeInfo changeInfo, Change ch) {
        changeInfo.setName(ChangeInfo.ChangeName.RENAME_COMPILATION_UNIT);
        changeInfo.setPath(((CompilationUnit)ch.getModifiedElement()).getPath().toString());
        RenameCompilationUnitChange renameChange = (RenameCompilationUnitChange)ch;
        changeInfo.setOldPath(renameChange.getResourcePath().removeLastSegments(1).append(renameChange.getNewName()).toString());
    }

    private FinishResult internalPerformFinish(PerformChangeOperation op) {
        op.setUndoManager(RefactoringCore.getUndoManager(), this.refactoring.getName());
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
            return FinishResult.createException();
        }
        return FinishResult.createOK();
    }

    public PreviewNode getChangePreview() {
        CompositeChange compositeChange;
        if (this.change instanceof CompositeChange) {
            compositeChange = (CompositeChange)this.change;
        } else {
            compositeChange = new CompositeChange("Dummy Change");
            compositeChange.add(this.change);
        }
        this.previewNode = AbstractChangeNode.createNode(null, (Change)compositeChange);
        return this.previewNode;
    }

    public void updateChangeEnabled(String changeId, boolean enabled) throws RefactoringException {
        PreviewNode node = this.findNode(this.previewNode, changeId);
        if (node == null) {
            throw new RefactoringException("Can't find refactoring change to update enabled state.");
        }
        node.setEnabled(enabled);
    }

    private PreviewNode findNode(PreviewNode node, String id) {
        if (node.getId().equals(id)) {
            return node;
        }
        PreviewNode[] children = node.getChildren();
        if (children != null) {
            for (PreviewNode child : children) {
                PreviewNode found = this.findNode(child, id);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public PreviewNode getChangePreview(String changeId) {
        return this.findNode(this.previewNode, changeId);
    }

    public void dispose() {
        if (this.change != null) {
            this.change.dispose();
        }
    }
}

