/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.refactoring.session;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedModeModel;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedPositionGroup;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeCreationResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeInfo;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.plugin.java.server.dto.DtoServerImpls;
import org.eclipse.che.plugin.java.server.refactoring.DtoConverter;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringException;
import org.eclipse.che.plugin.java.server.refactoring.session.RefactoringSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameLinkedModeRefactoringSession
extends RefactoringSession {
    private final IJavaElement element;
    private final ICompilationUnit compilationUnit;
    private final int offset;
    private String fOriginalName;

    public RenameLinkedModeRefactoringSession(IJavaElement element, ICompilationUnit compilationUnit, int offset) {
        super(null);
        this.element = element;
        this.compilationUnit = compilationUnit;
        this.offset = offset;
    }

    @Override
    public ChangeCreationResult createChange() throws RefactoringException {
        return super.createChange();
    }

    @Override
    public Change getChange() {
        return super.getChange();
    }

    @Override
    public RefactoringResult apply() {
        throw new UnsupportedOperationException("apply isn't supported on RenameLinkedModeRefactoringSession");
    }

    public LinkedModeModel getModel() {
        CompilationUnit root = SharedASTProvider.getAST((ITypeRoot)this.compilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        DtoServerImpls.LinkedPositionGroupImpl group = new DtoServerImpls.LinkedPositionGroupImpl();
        ASTNode selectedNode = NodeFinder.perform((ASTNode)root, (int)this.offset, (int)0);
        if (!(selectedNode instanceof SimpleName)) {
            return null;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        this.fOriginalName = nameNode.getIdentifier();
        final int pos = nameNode.getStartPosition();
        SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)root, (SimpleName)nameNode);
        Arrays.sort(sameNodes, new Comparator<ASTNode>(){

            @Override
            public int compare(ASTNode o1, ASTNode o2) {
                return this.rank(o1) - this.rank(o2);
            }

            private int rank(ASTNode node) {
                int relativeRank = node.getStartPosition() + node.getLength() - pos;
                if (relativeRank < 0) {
                    return Integer.MAX_VALUE + relativeRank;
                }
                return relativeRank;
            }
        });
        for (int i = 0; i < sameNodes.length; ++i) {
            SimpleName elem = sameNodes[i];
            DtoServerImpls.RegionImpl position = new DtoServerImpls.RegionImpl();
            position.setOffset(elem.getStartPosition());
            position.setLength(elem.getLength());
            group.addPositions((Region)position);
        }
        DtoServerImpls.LinkedModeModelImpl model = new DtoServerImpls.LinkedModeModelImpl();
        model.addGroups((LinkedPositionGroup)group);
        return model;
    }

    public RefactoringResult doRename(String newName) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.fOriginalName.equals(newName)) {
            return DtoConverter.toRefactoringResultDto(new RefactoringStatus());
        }
        RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
        if (renameSupport == null) {
            return DtoConverter.toRefactoringResultDto(RefactoringStatus.createFatalErrorStatus((String)"Can't create rename refactoring"));
        }
        RefactoringResult refactoringResult = DtoConverter.toRefactoringResultDto(renameSupport.perform());
        PerformChangeOperation operation = renameSupport.getfPerformChangeOperation();
        if (operation == null) {
            return refactoringResult;
        }
        CompositeChange operationChange = (CompositeChange)operation.getUndoChange();
        Change[] changes = operationChange.getChildren();
        ArrayList<ChangeInfo> changesInfo = new ArrayList<ChangeInfo>();
        this.prepareChangesInfo(changes, changesInfo);
        refactoringResult.setChanges(changesInfo);
        return refactoringResult;
    }

    private RenameSupport undoAndCreateRenameSupport(String newName) throws CoreException {
        if (newName.length() == 0) {
            return null;
        }
        RenameJavaElementDescriptor descriptor = this.createRenameDescriptor(this.element, newName);
        return RenameSupport.create((RenameJavaElementDescriptor)descriptor);
    }

    private RenameJavaElementDescriptor createRenameDescriptor(IJavaElement javaElement, String newName) throws JavaModelException {
        String contributionId;
        int elementType = javaElement.getElementType();
        switch (elementType) {
            case 2: {
                contributionId = "org.eclipse.jdt.ui.rename.java.project";
                break;
            }
            case 3: {
                contributionId = "org.eclipse.jdt.ui.rename.source.folder";
                break;
            }
            case 4: {
                contributionId = "org.eclipse.jdt.ui.rename.package";
                break;
            }
            case 5: {
                contributionId = "org.eclipse.jdt.ui.rename.compilationunit";
                break;
            }
            case 7: {
                contributionId = "org.eclipse.jdt.ui.rename.type";
                break;
            }
            case 9: {
                IMethod method = (IMethod)javaElement;
                if (method.isConstructor()) {
                    return this.createRenameDescriptor((IJavaElement)method.getDeclaringType(), newName);
                }
                contributionId = "org.eclipse.jdt.ui.rename.method";
                break;
            }
            case 8: {
                IField field = (IField)javaElement;
                if (field.isEnumConstant()) {
                    contributionId = "org.eclipse.jdt.ui.rename.enum.constant";
                    break;
                }
                contributionId = "org.eclipse.jdt.ui.rename.field";
                break;
            }
            case 15: {
                contributionId = "org.eclipse.jdt.ui.rename.type.parameter";
                break;
            }
            case 14: {
                contributionId = "org.eclipse.jdt.ui.rename.local.variable";
                break;
            }
            default: {
                return null;
            }
        }
        RenameJavaElementDescriptor descriptor = (RenameJavaElementDescriptor)RefactoringCore.getRefactoringContribution((String)contributionId).createDescriptor();
        descriptor.setJavaElement(javaElement);
        descriptor.setNewName(newName);
        if (elementType != 3) {
            descriptor.setUpdateReferences(true);
        }
        switch (elementType) {
            case 8: 
            case 9: {
                descriptor.setDeprecateDelegate(false);
                descriptor.setKeepOriginal(false);
            }
        }
        switch (elementType) {
            case 7: {
                int strategy;
                descriptor.setUpdateSimilarDeclarations(false);
                try {
                    strategy = 1;
                }
                catch (NumberFormatException e) {
                    strategy = 1;
                }
                descriptor.setMatchStrategy(strategy);
            }
        }
        switch (elementType) {
            case 4: {
                descriptor.setUpdateHierarchy(true);
            }
        }
        switch (elementType) {
            case 4: 
            case 7: {
                String fileNamePatterns = "*";
                if (fileNamePatterns == null || fileNamePatterns.length() == 0) break;
                descriptor.setFileNamePatterns(fileNamePatterns);
                boolean updateQualifiedNames = false;
                descriptor.setUpdateQualifiedNames(updateQualifiedNames);
            }
        }
        switch (elementType) {
            case 4: 
            case 7: 
            case 8: {
                boolean updateTextualOccurrences = false;
                descriptor.setUpdateTextualOccurrences(updateTextualOccurrences);
            }
        }
        switch (elementType) {
            case 8: {
                descriptor.setRenameGetters(false);
                descriptor.setRenameSetters(false);
            }
        }
        return descriptor;
    }
}

