/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.classpath.ClasspathEntryDto;
import org.eclipse.che.plugin.java.server.rest.ClasspathServiceInterface;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Path(value="java/classpath/")
public class ClasspathService
implements ClasspathServiceInterface {
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();

    @Override
    @GET
    @Produces(value={"application/json"})
    public List<ClasspathEntryDto> getClasspath(@QueryParam(value="projectpath") String projectPath) throws JavaModelException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        if (entries.length == 0) {
            return Collections.emptyList();
        }
        return this.convertClasspathEntriesToDTO(javaProject, entries);
    }

    private List<ClasspathEntryDto> convertClasspathEntriesToDTO(IJavaProject javaProject, IClasspathEntry[] entries) throws JavaModelException {
        ArrayList<ClasspathEntryDto> entriesDTO = new ArrayList<ClasspathEntryDto>(entries.length);
        for (IClasspathEntry entry : entries) {
            ClasspathEntryDto entryDTO = (ClasspathEntryDto)DtoFactory.getInstance().createDto(ClasspathEntryDto.class);
            entryDTO.withEntryKind(entry.getEntryKind()).withPath(entry.getPath().toOSString());
            if (5 == entry.getEntryKind()) {
                IClasspathEntry[] subEntries = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject).getClasspathEntries();
                entryDTO.withExpandedEntries(this.convertClasspathEntriesToDTO(javaProject, subEntries));
            }
            entriesDTO.add(entryDTO);
        }
        return entriesDTO;
    }
}

