/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.ide.ext.java.shared.dto.Change;
import org.eclipse.che.ide.ext.java.shared.dto.ConflictImportDTO;
import org.eclipse.che.ide.ext.java.shared.dto.OrganizeImportResult;
import org.eclipse.che.ide.ext.java.shared.dto.Problem;
import org.eclipse.che.ide.ext.java.shared.dto.ProposalApplyResult;
import org.eclipse.che.ide.ext.java.shared.dto.Proposals;
import org.eclipse.che.plugin.java.server.CodeAssist;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.text.BadLocationException;

@Path(value="java/code-assist")
public class CodeAssistService {
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
    @Inject
    private CodeAssist codeAssist;

    @POST
    @Path(value="compute/completion")
    @Produces(value={"application/json"})
    public Proposals computeCompletionProposals(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="offset") int offset, String content) throws JavaModelException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        return this.codeAssist.computeProposals(javaProject, fqn, offset, content);
    }

    @GET
    @Path(value="apply/completion")
    @Produces(value={"application/json"})
    public ProposalApplyResult applyCompletion(@QueryParam(value="sessionid") String sessionId, @QueryParam(value="index") int index, @DefaultValue(value="true") @QueryParam(value="insert") boolean insert) {
        return this.codeAssist.applyCompletion(sessionId, index, insert);
    }

    @POST
    @Path(value="compute/assist")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Proposals computeAssistProposals(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="offset") int offset, List<Problem> problems) throws CoreException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        return this.codeAssist.computeAssistProposals(javaProject, fqn, offset, problems);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="compute/info")
    public String getJavaDoc(@QueryParam(value="sessionid") String sessionId, @QueryParam(value="index") int index, @Context UriInfo uriInfo) {
        return this.codeAssist.getJavaDoc(sessionId, index);
    }

    @POST
    @Path(value="/organize-imports")
    @Produces(value={"application/json"})
    public OrganizeImportResult organizeImports(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn) throws NotFoundException, CoreException, BadLocationException {
        IJavaProject project = model.getJavaProject(projectPath);
        return this.codeAssist.organizeImports(project, fqn);
    }

    @POST
    @Path(value="/apply-imports")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Change> applyChosenImports(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, ConflictImportDTO chosen) throws NotFoundException, CoreException, BadLocationException {
        IJavaProject project = model.getJavaProject(projectPath);
        return this.codeAssist.applyChosenImports(project, fqn, chosen.getTypeMatches());
    }
}

