/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.ide.ext.java.shared.Jar;
import org.eclipse.che.ide.ext.java.shared.JarEntry;
import org.eclipse.che.ide.ext.java.shared.OpenDeclarationDescriptor;
import org.eclipse.che.ide.ext.java.shared.dto.ClassContent;
import org.eclipse.che.ide.ext.java.shared.dto.ImplementationsDescriptorDTO;
import org.eclipse.che.ide.ext.java.shared.dto.model.CompilationUnit;
import org.eclipse.che.ide.ext.java.shared.dto.model.JavaProject;
import org.eclipse.che.ide.ext.java.shared.dto.model.MethodParameters;
import org.eclipse.che.plugin.java.server.JavaNavigation;
import org.eclipse.che.plugin.java.server.JavaTypeHierarchy;
import org.eclipse.che.plugin.java.server.ParametersHints;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Path(value="java/navigation")
public class JavaNavigationService {
    JavaModel MODEL = JavaModelManager.getJavaModelManager().getJavaModel();
    @Inject
    private JavaNavigation navigation;
    @Inject
    private JavaTypeHierarchy javaTypeHierarchy;
    @Inject
    private ParametersHints parametersHints;

    @GET
    @Path(value="contentbyfqn")
    @Produces(value={"application/json"})
    public ClassContent getContent(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getContent(project, fqn);
    }

    @GET
    @Path(value="find-declaration")
    @Produces(value={"application/json"})
    public OpenDeclarationDescriptor findDeclaration(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="offset") int offset) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.findDeclaration(project, fqn, offset);
    }

    @GET
    @Path(value="libraries")
    @Produces(value={"application/json"})
    public List<Jar> getExternalLibraries(@QueryParam(value="projectpath") String projectPath) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getProjectDependecyJars(project);
    }

    @GET
    @Path(value="implementations")
    @Produces(value={"application/json"})
    public ImplementationsDescriptorDTO getImplementations(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="offset") int offset) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.javaTypeHierarchy.getImplementations(project, fqn, offset);
    }

    @GET
    @Path(value="lib/children")
    @Produces(value={"application/json"})
    public List<JarEntry> getLibraryChildren(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="root") int rootId) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getPackageFragmentRootContent(project, rootId);
    }

    @GET
    @Path(value="children")
    @Produces(value={"application/json"})
    public List<JarEntry> getChildren(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="path") String path, @QueryParam(value="root") int rootId) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getChildren(project, rootId, path);
    }

    @GET
    @Path(value="compilation-unit")
    @Produces(value={"application/json"})
    public CompilationUnit getCompilationUnit(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="showinherited") boolean showInherited) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getCompilationUnitByPath(project, fqn, showInherited);
    }

    @GET
    @Path(value="content")
    @Produces(value={"application/json"})
    public ClassContent getContent(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="path") String path, @QueryParam(value="root") int rootId) throws CoreException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getContent(project, rootId, path);
    }

    @GET
    @Path(value="entry")
    public JarEntry getEntry(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="path") String path, @QueryParam(value="root") int rootId) throws CoreException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.navigation.getEntry(project, rootId, path);
    }

    @GET
    @Path(value="get/projects/and/packages")
    @Produces(value={"application/json"})
    public List<JavaProject> getProjectsAndPackages(@QueryParam(value="includepackages") boolean includePackages) throws JavaModelException {
        return this.navigation.getAllProjectsAndPackages(includePackages);
    }

    @GET
    @Path(value="parameters")
    public List<MethodParameters> getParameters(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn, @QueryParam(value="offset") int offset, @QueryParam(value="lineStart") int lineStartOffset) throws JavaModelException {
        IJavaProject project = this.MODEL.getJavaProject(projectPath);
        return this.parametersHints.findHints(project, fqn, offset, lineStartOffset);
    }
}

