/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import com.google.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.ide.ext.java.shared.dto.ReconcileResult;
import org.eclipse.che.jdt.javaeditor.JavaReconciler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Path(value="java/reconcile")
public class JavaReconcileService {
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
    @Inject
    private JavaReconciler reconciler;

    @GET
    @Produces(value={"application/json"})
    public ReconcileResult reconcile(@QueryParam(value="projectpath") String projectPath, @QueryParam(value="fqn") String fqn) throws JavaModelException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        return this.reconciler.reconcile(javaProject, fqn);
    }
}

