/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import com.google.inject.Inject;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeCreationResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeEnabledState;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangePreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.CreateMoveRefactoring;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.CreateRenameRefactoring;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ElementToMove;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.LinkedRenameRefactoringApply;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.MoveSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringChange;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringPreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringSession;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatus;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameRefactoringSession;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ReorgDestination;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ValidateNewName;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringException;
import org.eclipse.che.plugin.java.server.refactoring.RefactoringManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;

@javax.ws.rs.Path(value="java/refactoring")
public class RefactoringService {
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
    private RefactoringManager manager;

    @Inject
    public RefactoringService(RefactoringManager manager) {
        this.manager = manager;
    }

    @POST
    @javax.ws.rs.Path(value="move/create")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String createMoveRefactoring(CreateMoveRefactoring cmr) throws JavaModelException, RefactoringException {
        IJavaElement[] javaElements;
        IJavaProject javaProject = model.getJavaProject(cmr.getProjectPath());
        try {
            Function<ElementToMove, IJavaElement> map = javaElement -> {
                try {
                    if (javaElement.isPack()) {
                        return javaProject.findPackageFragment((IPath)new Path(javaElement.getPath()));
                    }
                    IType type = javaProject.findType(javaElement.getPath());
                    if (type == null) {
                        throw new IllegalArgumentException("Can't find type: " + javaElement.getPath());
                    }
                    return type.getCompilationUnit();
                }
                catch (JavaModelException e) {
                    throw new IllegalArgumentException(e);
                }
            };
            javaElements = (IJavaElement[])cmr.getElements().stream().map(map).toArray(IJavaElement[]::new);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof JavaModelException) {
                throw (JavaModelException)e.getCause();
            }
            throw e;
        }
        if (RefactoringAvailabilityTester.isMoveAvailable((IResource[])new IResource[0], (IJavaElement[])javaElements)) {
            return this.manager.createMoveRefactoringSession(javaElements);
        }
        throw new RefactoringException("Can't create move refactoring.");
    }

    @POST
    @javax.ws.rs.Path(value="set/destination")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RefactoringStatus setDestination(ReorgDestination destination) throws RefactoringException, JavaModelException {
        return this.manager.setRefactoringDestination(destination);
    }

    @POST
    @javax.ws.rs.Path(value="set/move/setting")
    @Consumes(value={"application/json"})
    public void setMoveSettings(MoveSettings settings) throws RefactoringException {
        this.manager.setMoveSettings(settings);
    }

    @POST
    @javax.ws.rs.Path(value="create/change")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ChangeCreationResult createChange(RefactoringSession refactoringSession) throws RefactoringException {
        return this.manager.createChange(refactoringSession.getSessionId());
    }

    @POST
    @javax.ws.rs.Path(value="get/preview")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RefactoringPreview getRefactoringPreview(RefactoringSession refactoringSession) throws RefactoringException {
        return this.manager.getRefactoringPreview(refactoringSession.getSessionId());
    }

    @POST
    @javax.ws.rs.Path(value="change/enabled")
    public void changeChangeEnabledState(ChangeEnabledState state) throws RefactoringException {
        this.manager.changeChangeEnabled(state);
    }

    @POST
    @javax.ws.rs.Path(value="change/preview")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ChangePreview getChangePreview(RefactoringChange change) throws RefactoringException {
        return this.manager.getChangePreview(change);
    }

    @POST
    @javax.ws.rs.Path(value="apply")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RefactoringResult applyRefactoring(RefactoringSession session) throws RefactoringException, JavaModelException {
        return this.manager.applyRefactoring(session.getSessionId());
    }

    @POST
    @javax.ws.rs.Path(value="rename/create")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public RenameRefactoringSession createRenameRefactoring(CreateRenameRefactoring settings) throws CoreException, RefactoringException {
        ICompilationUnit elementToRename;
        IJavaProject javaProject = model.getJavaProject(settings.getProjectPath());
        ICompilationUnit cu = null;
        switch (settings.getType()) {
            case COMPILATION_UNIT: {
                elementToRename = javaProject.findType(settings.getPath()).getCompilationUnit();
                break;
            }
            case PACKAGE: {
                elementToRename = javaProject.findPackageFragment((IPath)new Path(settings.getPath()));
                break;
            }
            case JAVA_ELEMENT: {
                cu = javaProject.findType(settings.getPath()).getCompilationUnit();
                elementToRename = this.getSelectionElement(cu, settings.getOffset());
                break;
            }
            default: {
                elementToRename = null;
            }
        }
        if (elementToRename == null) {
            throw new RefactoringException("Can't find java element to rename.");
        }
        return this.manager.createRenameRefactoring((IJavaElement)elementToRename, cu, settings.getOffset(), settings.isRefactorLightweight());
    }

    @POST
    @javax.ws.rs.Path(value="rename/linked/apply")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RefactoringResult applyLinkedModeRename(LinkedRenameRefactoringApply refactoringApply) throws RefactoringException, CoreException {
        return this.manager.applyLinkedRename(refactoringApply);
    }

    @POST
    @javax.ws.rs.Path(value="rename/validate/name")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RefactoringStatus validateNewName(ValidateNewName newName) throws RefactoringException {
        return this.manager.renameValidateNewName(newName);
    }

    @POST
    @javax.ws.rs.Path(value="set/rename/settings")
    @Consumes(value={"application/json"})
    public void setRenameSettings(RenameSettings settings) throws RefactoringException {
        this.manager.setRenameSettings(settings);
    }

    @GET
    @javax.ws.rs.Path(value="reindex")
    @Consumes(value={"text/plain"})
    public Response reindexProject(@QueryParam(value="projectpath") String projectPath) throws JavaModelException {
        this.manager.reindexProject(model.getJavaProject(projectPath));
        return Response.ok().build();
    }

    private IJavaElement getSelectionElement(ICompilationUnit compilationUnit, int offset) throws JavaModelException, RefactoringException {
        IJavaElement[] javaElements = compilationUnit.codeSelect(offset, 0);
        if (javaElements != null && javaElements.length > 0) {
            return javaElements[0];
        }
        throw new RefactoringException("Can't find java element to rename.");
    }
}

