/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.model.ClassFile;
import org.eclipse.che.ide.ext.java.shared.dto.model.CompilationUnit;
import org.eclipse.che.ide.ext.java.shared.dto.model.Field;
import org.eclipse.che.ide.ext.java.shared.dto.model.ImportDeclaration;
import org.eclipse.che.ide.ext.java.shared.dto.model.Initializer;
import org.eclipse.che.ide.ext.java.shared.dto.model.JavaProject;
import org.eclipse.che.ide.ext.java.shared.dto.model.Method;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragment;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragmentRoot;
import org.eclipse.che.ide.ext.java.shared.dto.model.Type;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class JavaElementToDtoConverter {
    public static final int LEVEL_TYPE = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_PACKAGE = 3;
    public static final int LEVEL_PROJECT = 4;
    private static final int[][] JAVA_ELEMENT_TYPES = new int[][]{{7}, {6, 5}, {4}, {2, 3}, {1}};
    private static final int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = JAVA_ELEMENT_TYPES.length - 1;
    private final FastJavaElementProvider contentProvider;
    private Map<Object, Set<Object>> childrens = new HashMap<Object, Set<Object>>();
    private int level;
    private AbstractTextSearchResult result;

    public JavaElementToDtoConverter(AbstractTextSearchResult result) {
        this.result = result;
        this.contentProvider = new FastJavaElementProvider();
        this.level = 4;
    }

    public void addElementToProjectHierarchy(IJavaElement element) {
        this.insert(null, null, element);
    }

    private Object internalGetParent(Object child) {
        return this.contentProvider.getParent(child);
    }

    private Object getParent(Object child) {
        Object possibleParent;
        block5: {
            block4: {
                possibleParent = this.internalGetParent(child);
                if (!(possibleParent instanceof IJavaElement)) break block4;
                IJavaElement javaElement = (IJavaElement)possibleParent;
                for (int j = this.level; j < MAX_LEVEL + 1; ++j) {
                    for (int i = 0; i < JAVA_ELEMENT_TYPES[j].length; ++i) {
                        if (javaElement.getElementType() != JAVA_ELEMENT_TYPES[j][i]) continue;
                        return null;
                    }
                }
                break block5;
            }
            if (!(possibleParent instanceof IResource)) break block5;
            IResource resource = (IResource)possibleParent;
            for (int j = this.level; j < MAX_LEVEL + 1; ++j) {
                for (int i = 0; i < RESOURCE_TYPES[j].length; ++i) {
                    if (resource.getType() != RESOURCE_TYPES[j][i]) continue;
                    return null;
                }
            }
        }
        return possibleParent;
    }

    private void insert(Map<Object, Set<Object>> toAdd, Set<Object> toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.result, child) && toAdd != null) {
            this.insertInto(this.result, child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.childrens);
    }

    private boolean insertInto(Object parent, Object child, Map<Object, Set<Object>> map) {
        Set<Object> children = map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    public List<JavaProject> getProjects() throws JavaModelException {
        Set<Object> objects = this.childrens.get(this.result);
        ArrayList<JavaProject> result = new ArrayList<JavaProject>();
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            JavaProject javaProject = (JavaProject)DtoFactory.newDto(JavaProject.class);
            IJavaProject project = (IJavaProject)object;
            javaProject.setName(project.getElementName());
            String path = project.getPath().toOSString();
            javaProject.setPath(path);
            javaProject.setPackageFragmentRoots(this.getPackageFragmentRoots(object, path));
            result.add(javaProject);
        }
        return result;
    }

    private List<PackageFragmentRoot> getPackageFragmentRoots(Object parent, String projectPath) throws JavaModelException {
        ArrayList<PackageFragmentRoot> result = new ArrayList<PackageFragmentRoot>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IPackageFragmentRoot)) continue;
            PackageFragmentRoot root = (PackageFragmentRoot)DtoFactory.newDto(PackageFragmentRoot.class);
            IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)object;
            root.setProjectPath(projectPath);
            root.setKind(fragmentRoot.getKind());
            root.setPath(fragmentRoot.getPath().toOSString());
            root.setElementName(fragmentRoot.getElementName());
            root.setHandleIdentifier(fragmentRoot.getHandleIdentifier());
            root.setPackageFragments(this.getPackageFragments(fragmentRoot, projectPath));
            result.add(root);
        }
        return result;
    }

    private List<PackageFragment> getPackageFragments(IPackageFragmentRoot parent, String projectPath) throws JavaModelException {
        ArrayList<PackageFragment> result = new ArrayList<PackageFragment>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IPackageFragment)) continue;
            IPackageFragment packageFragment = (IPackageFragment)object;
            PackageFragment fragment = (PackageFragment)DtoFactory.newDto(PackageFragment.class);
            fragment.setProjectPath(projectPath);
            fragment.setPath(packageFragment.getPath().toOSString());
            fragment.setHandleIdentifier(packageFragment.getHandleIdentifier());
            fragment.setElementName(packageFragment.getElementName());
            fragment.setKind(packageFragment.getKind());
            fragment.setDefaultPackage(packageFragment.isDefaultPackage());
            ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();
            ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
            this.addCompilationUnitsAndClassFiles(object, compilationUnits, classFiles);
            fragment.setCompilationUnits(compilationUnits);
            fragment.setClassFiles(classFiles);
            result.add(fragment);
        }
        return result;
    }

    private void addCompilationUnitsAndClassFiles(Object parent, List<CompilationUnit> compilationUnits, List<ClassFile> classFiles) throws JavaModelException {
        Set<Object> childrens = this.childrens.get(parent);
        for (Object children : childrens) {
            if (children instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)children;
                CompilationUnit compilationUnit = (CompilationUnit)DtoFactory.newDto(CompilationUnit.class);
                compilationUnit.setElementName(unit.getElementName());
                compilationUnit.setProjectPath(unit.getJavaProject().getPath().toOSString());
                compilationUnit.setPath(unit.getResource().getFullPath().toOSString());
                compilationUnit.setHandleIdentifier(unit.getHandleIdentifier());
                compilationUnit.setLabel(JavaElementLabels.getElementLabel((IJavaElement)unit, (long)JavaElementLabels.ALL_DEFAULT));
                compilationUnit.setImports(this.getImports(children));
                compilationUnit.setTypes(this.getTypes(children));
                compilationUnits.add(compilationUnit);
                continue;
            }
            if (!(children instanceof IClassFile)) continue;
            ClassFile classFile = (ClassFile)DtoFactory.newDto(ClassFile.class);
            IClassFile clazz = (IClassFile)children;
            classFile.setHandleIdentifier(clazz.getHandleIdentifier());
            classFile.setElementName(clazz.getElementName());
            classFile.setPath(clazz.getType().getFullyQualifiedName());
            classFile.setLabel(JavaElementLabels.getElementLabel((IJavaElement)clazz, (long)JavaElementLabels.ALL_DEFAULT));
            classFile.setProjectPath(clazz.getJavaProject().getPath().toOSString());
            classFile.setType(this.getTypes(children).get(0));
            classFiles.add(classFile);
        }
    }

    private List<ImportDeclaration> getImports(Object parent) throws JavaModelException {
        ArrayList<ImportDeclaration> result = new ArrayList<ImportDeclaration>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            Set<Object> imports;
            if (!(object instanceof IImportContainer) || (imports = this.childrens.get(object)) == null) continue;
            this.addImport(result, imports);
        }
        return result;
    }

    private void addImport(List<ImportDeclaration> result, Set<Object> imports) throws JavaModelException {
        for (Object im : imports) {
            if (!(im instanceof IImportDeclaration)) continue;
            IImportDeclaration dec = (IImportDeclaration)im;
            ImportDeclaration importDeclaration = (ImportDeclaration)DtoFactory.newDto(ImportDeclaration.class);
            importDeclaration.setFlags(dec.getFlags());
            importDeclaration.setHandleIdentifier(dec.getHandleIdentifier());
            importDeclaration.setElementName(dec.getElementName());
            result.add(importDeclaration);
        }
    }

    private List<Type> getTypes(Object parent) throws JavaModelException {
        ArrayList<Type> result = new ArrayList<Type>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IType)) continue;
            IType type = (IType)object;
            Type dtoType = (Type)DtoFactory.newDto(Type.class);
            dtoType.setElementName(type.getElementName());
            dtoType.setLabel(JavaElementLabels.getElementLabel((IJavaElement)type, (long)JavaElementLabels.ALL_DEFAULT));
            dtoType.setHandleIdentifier(type.getHandleIdentifier());
            dtoType.setFlags(type.getFlags());
            dtoType.setTypes(this.getTypes(object));
            dtoType.setFields(this.getFields(object));
            dtoType.setMethods(this.getMethods(object));
            dtoType.setInitializers(this.getInitializes(object));
            if (parent instanceof ITypeRoot) {
                IType primaryType = ((ITypeRoot)parent).findPrimaryType();
                dtoType.setPrimary(type.equals(primaryType));
            } else {
                dtoType.setPrimary(false);
            }
            result.add(dtoType);
        }
        return result;
    }

    private List<Initializer> getInitializes(Object parent) throws JavaModelException {
        ArrayList<Initializer> result = new ArrayList<Initializer>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IInitializer)) continue;
            IInitializer initializer = (IInitializer)object;
            Initializer init = (Initializer)DtoFactory.newDto(Initializer.class);
            init.setElementName(initializer.getElementName());
            init.setHandleIdentifier(initializer.getHandleIdentifier());
            init.setFlags(initializer.getFlags());
            init.setLabel(JavaElementLabels.getElementLabel((IJavaElement)initializer, (long)JavaElementLabels.ALL_DEFAULT));
            result.add(init);
        }
        return result;
    }

    private List<Method> getMethods(Object parent) throws JavaModelException {
        ArrayList<Method> result = new ArrayList<Method>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IMethod)) continue;
            IMethod method = (IMethod)object;
            Method met = (Method)DtoFactory.newDto(Method.class);
            met.setHandleIdentifier(method.getHandleIdentifier());
            met.setFlags(method.getFlags());
            met.setElementName(method.getElementName());
            met.setLabel(JavaElementLabels.getElementLabel((IJavaElement)method, (long)JavaElementLabels.ALL_DEFAULT));
            result.add(met);
        }
        return result;
    }

    private List<Field> getFields(Object parent) throws JavaModelException {
        ArrayList<Field> result = new ArrayList<Field>();
        Set<Object> objects = this.childrens.get(parent);
        if (objects == null) {
            return result;
        }
        for (Object object : objects) {
            if (!(object instanceof IField)) continue;
            IField iField = (IField)object;
            Field field = (Field)DtoFactory.newDto(Field.class);
            field.setElementName(iField.getElementName());
            field.setHandleIdentifier(iField.getHandleIdentifier());
            field.setFlags(iField.getFlags());
            field.setLabel(JavaElementLabels.getElementLabel((IJavaElement)iField, (long)JavaElementLabels.ALL_DEFAULT));
            result.add(field);
        }
        return result;
    }

    static class FastJavaElementProvider
    extends StandardJavaElementContentProvider {
        FastJavaElementProvider() {
        }

        public Object getParent(Object element) {
            Object parent = this.internalGetParent(element);
            if (parent == null && element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                Object javaElement = adaptable.getAdapter(IJavaElement.class);
                if (javaElement != null) {
                    parent = this.internalGetParent(javaElement);
                } else {
                    Object resource = adaptable.getAdapter(IResource.class);
                    if (resource != null) {
                        parent = this.internalGetParent(resource);
                    }
                }
            }
            return parent;
        }
    }
}

