/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.inject.Inject;
import org.eclipse.che.api.core.jsonrpc.commons.JsonRpcException;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.ide.ext.java.shared.dto.JavaClassInfo;
import org.eclipse.che.ide.ext.java.shared.dto.ReconcileResult;
import org.eclipse.che.jdt.javaeditor.JavaReconciler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class JavaReconcileRequestHandler {
    private static final String INCOMING_METHOD = "request:java-reconcile";
    private static final JavaModel JAVA_MODEL = JavaModelManager.getJavaModelManager().getJavaModel();
    @Inject
    private JavaReconciler reconciler;

    @Inject
    public void configureHandler(RequestHandlerConfigurator configurator) {
        configurator.newConfiguration().methodName(INCOMING_METHOD).paramsAsDto(JavaClassInfo.class).resultAsDto(ReconcileResult.class).withFunction(this::getReconcileOperation);
    }

    private ReconcileResult getReconcileOperation(JavaClassInfo javaClassInfo) {
        IJavaProject javaProject = JAVA_MODEL.getJavaProject(javaClassInfo.getProjectPath());
        try {
            return this.reconciler.reconcile(javaProject, javaClassInfo.getFQN());
        }
        catch (JavaModelException e) {
            String error = String.format("Can't reconcile class: %s in project: %s, the reason is %s", javaClassInfo.getFQN(), javaProject.getPath().toOSString(), e.getLocalizedMessage());
            throw new JsonRpcException(500, error);
        }
    }
}

