/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.model.MethodParameters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;

@Singleton
public class ParametersHints {
    public List<MethodParameters> findHints(IJavaProject project, String fqn, int offset, int lineStartOffset) throws JavaModelException {
        IType type = project.findType(fqn);
        if (type.isBinary()) {
            return Collections.emptyList();
        }
        IJavaElement element = this.getSelectedElement(type, offset, lineStartOffset);
        if (element == null) {
            return Collections.emptyList();
        }
        IJavaElement parent = element.getParent();
        if (!(parent instanceof IType) || element.getElementType() != 9) {
            return Collections.emptyList();
        }
        ArrayList<MethodParameters> result = new ArrayList<MethodParameters>();
        this.findHintsRecursive(element, parent, result);
        return result;
    }

    private IJavaElement getSelectedElement(IType type, int offset, int lineStartOffset) throws JavaModelException {
        if (offset <= lineStartOffset) {
            return null;
        }
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        IJavaElement[] javaElements = compilationUnit.codeSelect(offset, 0);
        if (javaElements.length == 0) {
            return this.getSelectedElement(type, --offset, lineStartOffset);
        }
        IJavaElement element = javaElements[0];
        if (element.getElementType() == 9) {
            return element;
        }
        return this.getSelectedElement(type, --offset, lineStartOffset);
    }

    private void findHintsRecursive(IJavaElement method, IJavaElement parent, List<MethodParameters> result) throws JavaModelException {
        IType[] superTypes;
        this.findHints(method, parent, result);
        IType type = (IType)parent;
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        for (IType iType : superTypes = typeHierarchy.getAllSupertypes(type)) {
            this.findHintsRecursive(method, (IJavaElement)iType, result);
        }
    }

    private void findHints(IJavaElement method, IJavaElement parent, List<MethodParameters> result) throws JavaModelException {
        String methodName = method.getElementName();
        for (IMethod iMethod : ((IType)parent).getMethods()) {
            int methodFlag = iMethod.getFlags();
            if (Flags.isPrivate((int)methodFlag) || !methodName.equals(iMethod.getElementName())) continue;
            MethodParameters methodParameters = (MethodParameters)DtoFactory.newDto(MethodParameters.class);
            String parameters = this.getMethodParametersAsString(iMethod);
            methodParameters.setMethodName(methodName);
            methodParameters.setParameters(parameters);
            if (result.contains(methodParameters)) continue;
            result.add(methodParameters);
        }
    }

    private String getMethodParametersAsString(IMethod method) throws JavaModelException {
        ILocalVariable[] parameters = method.getParameters();
        int paramsLength = parameters.length;
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        for (ILocalVariable parameter : parameters) {
            JavaElementLabels.getLocalVariableLabel((ILocalVariable)parameter, (long)32768L, (StringBuffer)buffer);
            if (++index >= paramsLength) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

