/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.che.jdt.dom.ASTNodes;
import org.eclipse.che.jdt.javadoc.JavaElementLabels;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

@Singleton
public class SourcesFromBytecodeGenerator {
    public static final String METHOD_BODY = " /* compiled code */ ";
    private static final String COMMENT = new String("\n // Failed to get sources. Instead, stub sources have been generated.\n // Implementation of methods is unavailable.\n");
    private static final String TAB = "    ";

    public String generateSource(IType type) throws JavaModelException {
        StringBuilder builder = new StringBuilder();
        builder.append(COMMENT);
        builder.append("package ").append(type.getPackageFragment().getElementName()).append(";\n");
        this.generateType(type, builder, TAB);
        return builder.toString();
    }

    private void generateType(IType type, StringBuilder builder, String indent) throws JavaModelException {
        int flags = 0;
        this.appendAnnotationLabels(type.getAnnotations(), flags, builder, indent.substring(TAB.length()));
        builder.append(indent.substring(TAB.length()));
        builder.append(this.getModifiers(type.getFlags(), type.getFlags())).append(' ').append(this.getJavaType(type)).append(' ').append(type.getElementName());
        if (type.isResolved()) {
            BindingKey key = new BindingKey(type.getKey());
            if (key.isParameterizedType()) {
                String[] typeArguments = key.getTypeArguments();
                this.appendTypeArgumentSignaturesLabel((IJavaElement)type, typeArguments, flags, builder);
            } else {
                String[] typeParameters = Signature.getTypeParameters((String)key.toSignature());
                this.appendTypeParameterSignaturesLabel(typeParameters, builder);
            }
        } else {
            this.appendTypeParametersLabels(type.getTypeParameters(), flags, builder);
        }
        if (!"java.lang.Object".equals(type.getSuperclassName()) && !"java.lang.Enum".equals(type.getSuperclassName())) {
            builder.append(" extends ");
            if (type.getSuperclassTypeSignature() != null) {
                builder.append(Signature.toString((String)type.getSuperclassTypeSignature()));
            } else {
                builder.append(type.getSuperclassName());
            }
        }
        if (!type.isAnnotation() && type.getSuperInterfaceNames().length != 0) {
            builder.append(" implements ");
            String[] signatures = type.getSuperInterfaceTypeSignatures();
            if (signatures.length == 0) {
                signatures = type.getSuperInterfaceNames();
            }
            for (String interfaceFqn : signatures) {
                builder.append(Signature.toString((String)interfaceFqn)).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(" {\n");
        ArrayList<Object> fields = new ArrayList<Object>();
        if (type.isEnum()) {
            builder.append(indent);
            for (IField field : type.getFields()) {
                if (field.isEnumConstant()) {
                    builder.append(field.getElementName()).append(", ");
                    continue;
                }
                fields.add(field);
            }
            if (", ".equals(builder.substring(builder.length() - 2))) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append(";\n");
        } else {
            fields.addAll(Arrays.asList(type.getFields()));
        }
        for (IField iField : fields) {
            if (Flags.isSynthetic((int)iField.getFlags())) continue;
            this.appendAnnotationLabels(iField.getAnnotations(), flags, builder, indent);
            builder.append(indent).append(this.getModifiers(iField.getFlags(), type.getFlags()));
            if (builder.charAt(builder.length() - 1) != ' ') {
                builder.append(' ');
            }
            builder.append(Signature.toCharArray((char[])iField.getTypeSignature().toCharArray())).append(' ').append(iField.getElementName());
            if (iField.getConstant() != null) {
                builder.append(" = ");
                if (iField.getConstant() instanceof String) {
                    builder.append('\"').append(iField.getConstant()).append('\"');
                } else {
                    builder.append(iField.getConstant());
                }
            }
            builder.append(";\n");
        }
        builder.append('\n');
        for (IMethod method : type.getMethods()) {
            ITypeParameter[] typeParameters;
            if (method.getElementName().equals("<clinit>") || Flags.isSynthetic((int)method.getFlags())) continue;
            this.appendAnnotationLabels(method.getAnnotations(), flags, builder, indent);
            BindingKey resolvedKey = method.isResolved() ? new BindingKey(method.getKey()) : null;
            String resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            builder.append(indent).append(this.getModifiers(method.getFlags(), type.getFlags()));
            if (builder.charAt(builder.length() - 1) != ' ') {
                builder.append(' ');
            }
            if (resolvedKey != null) {
                if (resolvedKey.isParameterizedMethod()) {
                    String[] typeArgRefs = resolvedKey.getTypeArguments();
                    if (typeArgRefs.length > 0) {
                        this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags, builder);
                        builder.append(' ');
                    }
                } else {
                    String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                    if (typeParameterSigs.length > 0) {
                        this.appendTypeParameterSignaturesLabel(typeParameterSigs, builder);
                        builder.append(' ');
                    }
                }
            } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                this.appendTypeParametersLabels(typeParameters, flags, builder);
                builder.append(' ');
            }
            if (!method.isConstructor()) {
                ILocalVariable[] returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, (String)returnTypeSig, 0L, builder);
                builder.append(' ');
            }
            builder.append(method.getElementName());
            builder.append('(');
            for (ILocalVariable variable : method.getParameters()) {
                builder.append(Signature.toString((String)variable.getTypeSignature()));
                builder.append(' ').append(variable.getElementName()).append(", ");
            }
            if (builder.charAt(builder.length() - 1) == ' ') {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append(')');
            String[] exceptionTypes = method.getExceptionTypes();
            if (exceptionTypes != null && exceptionTypes.length != 0) {
                builder.append(' ').append("throws ");
                for (String exceptionType : exceptionTypes) {
                    builder.append(Signature.toCharArray((char[])exceptionType.toCharArray())).append(", ");
                }
                builder.delete(builder.length() - 2, builder.length());
            }
            if (type.isInterface() || type.isAnnotation()) {
                builder.append(";\n\n");
                continue;
            }
            builder.append(" {").append(METHOD_BODY).append("}\n\n");
        }
        for (IType iType : type.getTypes()) {
            this.generateType(iType, builder, indent + indent);
        }
        builder.append(indent.substring(TAB.length()));
        builder.append("}\n");
    }

    protected void appendAnnotationLabels(IAnnotation[] annotations, long flags, StringBuilder builder, String indent) throws JavaModelException {
        for (IAnnotation annotation : annotations) {
            builder.append(indent);
            this.appendAnnotationLabel(annotation, flags, builder);
            builder.append('\n');
        }
    }

    public void appendAnnotationLabel(IAnnotation annotation, long flags, StringBuilder builder) throws JavaModelException {
        builder.append('@');
        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)annotation.getElementName(), (boolean)false), flags, builder);
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        if (memberValuePairs.length == 0) {
            return;
        }
        builder.append('(');
        for (int i = 0; i < memberValuePairs.length; ++i) {
            if (i > 0) {
                builder.append(JavaElementLabels.COMMA_STRING);
            }
            IMemberValuePair memberValuePair = memberValuePairs[i];
            builder.append(this.getMemberName((IJavaElement)annotation, annotation.getElementName(), memberValuePair.getMemberName()));
            builder.append('=');
            this.appendAnnotationValue(annotation, memberValuePair.getValue(), memberValuePair.getValueKind(), flags, builder);
        }
        builder.append(')');
    }

    protected String getMemberName(IJavaElement enclosingElement, String typeName, String memberName) {
        return memberName;
    }

    private void appendAnnotationValue(IAnnotation annotation, Object value, int valueKind, long flags, StringBuilder builder) throws JavaModelException {
        if (value instanceof Object[]) {
            builder.append('{');
            Object[] values = (Object[])value;
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    builder.append(JavaElementLabels.COMMA_STRING);
                }
                value = values[j];
                this.appendAnnotationValue(annotation, value, valueKind, flags, builder);
            }
            builder.append('}');
        } else {
            switch (valueKind) {
                case 11: {
                    this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)((String)value), (boolean)false), flags, builder);
                    builder.append(".class");
                    break;
                }
                case 12: {
                    String name = (String)value;
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        String type = name.substring(0, lastDot);
                        String field = name.substring(lastDot + 1);
                        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)type, (boolean)false), flags, builder);
                        builder.append('.');
                        builder.append(this.getMemberName((IJavaElement)annotation, type, field));
                        break;
                    }
                }
                case 10: {
                    this.appendAnnotationLabel((IAnnotation)value, flags, builder);
                    break;
                }
                case 9: {
                    builder.append(ASTNodes.getEscapedStringLiteral((String)((String)value)));
                    break;
                }
                case 4: {
                    builder.append(ASTNodes.getEscapedCharacterLiteral((char)((Character)value).charValue()));
                    break;
                }
                default: {
                    builder.append(String.valueOf(value));
                }
            }
        }
    }

    protected String getElementName(IJavaElement element) {
        return element.getElementName();
    }

    private void appendTypeParameterWithBounds(ITypeParameter typeParameter, long flags, StringBuilder builder) throws JavaModelException {
        String[] bounds;
        builder.append(this.getElementName((IJavaElement)typeParameter));
        if (typeParameter.exists() && (bounds = typeParameter.getBoundsSignatures()).length > 0 && (bounds.length != 1 || !"Ljava.lang.Object;".equals(bounds[0]))) {
            builder.append(" extends ");
            for (int j = 0; j < bounds.length; ++j) {
                if (j > 0) {
                    builder.append(" & ");
                }
                this.appendTypeSignatureLabel((IJavaElement)typeParameter, bounds[j], flags, builder);
            }
        }
    }

    private void appendTypeParametersLabels(ITypeParameter[] typeParameters, long flags, StringBuilder builder) throws JavaModelException {
        if (typeParameters.length > 0) {
            builder.append(this.getLT());
            for (int i = 0; i < typeParameters.length; ++i) {
                if (i > 0) {
                    builder.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeParameterWithBounds(typeParameters[i], flags, builder);
            }
            builder.append(this.getGT());
        }
    }

    private void appendTypeParameterSignaturesLabel(String[] typeParamSigs, StringBuilder builder) {
        if (typeParamSigs.length > 0) {
            builder.append(this.getLT());
            for (int i = 0; i < typeParamSigs.length; ++i) {
                if (i > 0) {
                    builder.append(JavaElementLabels.COMMA_STRING);
                }
                builder.append(Signature.getTypeVariable((String)typeParamSigs[i]));
            }
            builder.append(this.getGT());
        }
    }

    private void appendTypeArgumentSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags, StringBuilder builder) {
        if (typeArgsSig.length > 0) {
            builder.append(this.getLT());
            for (int i = 0; i < typeArgsSig.length; ++i) {
                if (i > 0) {
                    builder.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags, builder);
            }
            builder.append(this.getGT());
        }
    }

    protected void appendTypeSignatureLabel(IJavaElement enclosingElement, String typeSig, long flags, StringBuilder builder) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                builder.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                this.appendTypeSignatureLabel(enclosingElement, Signature.getElementType((String)typeSig), flags, builder);
                for (int dim = Signature.getArrayCount((String)typeSig); dim > 0; --dim) {
                    builder.append('[').append(']');
                }
                break;
            }
            case 1: {
                String baseType = this.getSimpleTypeName(enclosingElement, typeSig);
                builder.append(baseType);
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                this.appendTypeArgumentSignaturesLabel(enclosingElement, typeArguments, flags, builder);
                break;
            }
            case 3: {
                builder.append(this.getSimpleTypeName(enclosingElement, typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    builder.append('?');
                    break;
                }
                if (ch == '+') {
                    builder.append("? extends ");
                    this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags, builder);
                    break;
                }
                if (ch != '-') break;
                builder.append("? super ");
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags, builder);
                break;
            }
            case 6: {
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags, builder);
                break;
            }
            case 7: {
                String[] typeBounds = Signature.getIntersectionTypeBounds((String)typeSig);
                this.appendTypeBoundsSignaturesLabel(enclosingElement, typeBounds, flags, builder);
                break;
            }
        }
    }

    private void appendTypeBoundsSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags, StringBuilder builder) {
        for (int i = 0; i < typeArgsSig.length; ++i) {
            if (i > 0) {
                builder.append(" | ");
            }
            this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags, builder);
        }
    }

    protected String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
        return Signature.toString((String)Signature.getTypeErasure((String)typeSig));
    }

    protected String getLT() {
        return "<";
    }

    protected String getGT() {
        return ">";
    }

    private String getJavaType(IType type) throws JavaModelException {
        if (type.isAnnotation()) {
            return "@interface";
        }
        if (type.isClass()) {
            return "class";
        }
        if (type.isInterface()) {
            return "interface";
        }
        if (type.isEnum()) {
            return "enum";
        }
        return "can't determine type";
    }

    private String getModifiers(int flags, int typeFlags) {
        int len;
        StringBuilder modifiers = new StringBuilder();
        if (Flags.isPublic((int)flags)) {
            modifiers.append("public ");
        }
        if (Flags.isProtected((int)flags)) {
            modifiers.append("protected ");
        }
        if (Flags.isPrivate((int)flags)) {
            modifiers.append("private ");
        }
        if (Flags.isStatic((int)flags)) {
            modifiers.append("static ");
        }
        if (Flags.isAbstract((int)flags) && !Flags.isInterface((int)typeFlags)) {
            modifiers.append("abstract ");
        }
        if (Flags.isFinal((int)flags)) {
            modifiers.append("final ");
        }
        if (Flags.isNative((int)flags)) {
            modifiers.append("native ");
        }
        if (Flags.isSynchronized((int)flags)) {
            modifiers.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            modifiers.append("volatile ");
        }
        if ((len = modifiers.length()) == 0) {
            return "";
        }
        modifiers.setLength(len - 1);
        return modifiers.toString();
    }
}

