/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.projecttype;

import com.google.inject.Inject;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.fs.server.PathTransformer;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.handlers.ProjectInitHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class AbstractJavaInitHandler
implements ProjectInitHandler {
    private ResourcesPlugin plugin;
    private PathTransformer pathTransformer;

    @Inject
    void init(ResourcesPlugin plugin, PathTransformer pathTransformer) {
        this.plugin = plugin;
        this.pathTransformer = pathTransformer;
    }

    public final void onProjectInitialized(String wsPath) throws ServerException, ForbiddenException, ConflictException, NotFoundException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(WsPathUtils.absolutize((String)wsPath));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.initializeClasspath(javaProject);
    }

    protected abstract void initializeClasspath(IJavaProject var1) throws ServerException;
}

