/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.search;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.model.JavaProject;
import org.eclipse.che.ide.ext.java.shared.dto.search.FindUsagesResponse;
import org.eclipse.che.plugin.java.server.search.JavaElementToDtoConverter;
import org.eclipse.che.plugin.java.server.search.SearchException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.NewSearchUI;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SearchManager {
    private static final Logger LOG = LoggerFactory.getLogger(SearchManager.class);
    private static final Class<?>[] TYPES_FOR_FIND_USAGE = new Class[]{ICompilationUnit.class, IType.class, IMethod.class, IField.class, IPackageDeclaration.class, IImportDeclaration.class, IPackageFragment.class, ILocalVariable.class, ITypeParameter.class};

    public FindUsagesResponse findUsage(IJavaProject javaProject, String fqn, int offset) throws SearchException {
        try {
            IJavaElement[] elements;
            ICompilationUnit compilationUnit;
            IType type = javaProject.findType(fqn);
            if (type == null) {
                throw new SearchException("Can't find type: " + fqn);
            }
            if (type.isBinary()) {
                compilationUnit = type.getClassFile().getWorkingCopy((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, null);
                if (compilationUnit == null) {
                    throw new SearchException("Can't find sources for: " + fqn + " type");
                }
            } else {
                compilationUnit = type.getCompilationUnit();
            }
            if ((elements = compilationUnit.codeSelect(offset, 0)) != null && elements.length == 1) {
                IJavaElement element = elements[0];
                if (this.isTypeValid(element, TYPES_FOR_FIND_USAGE)) {
                    return this.performFindUsageSearch(element);
                }
                throw new SearchException("Find usage can't search for element: " + element.getElementName());
            }
            throw new SearchException("Can't find element to search, try to move cursor to another place and invoke search again");
        }
        catch (JavaModelException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SearchException(String.format("Can't find project: %s or file for FQN: %s", javaProject.getPath().toOSString(), fqn), e);
        }
        catch (BadLocationException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new SearchException("Some error happened when formatting search result", e);
        }
    }

    private FindUsagesResponse performFindUsageSearch(IJavaElement element) throws JavaModelException, BadLocationException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        boolean isInsideJRE = factory.isInsideJRE(element);
        JavaSearchQuery query = new JavaSearchQuery((QuerySpecification)new ElementQuerySpecification(element, 2, factory.createWorkspaceScope(isInsideJRE), "workspace scope"));
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)query);
        ISearchResult result = query.getSearchResult();
        JavaSearchResult javaResult = (JavaSearchResult)result;
        FindUsagesResponse response = (FindUsagesResponse)DtoFactory.newDto(FindUsagesResponse.class);
        HashMap mapMaches = new HashMap();
        JavaElementToDtoConverter converter = new JavaElementToDtoConverter((AbstractTextSearchResult)javaResult);
        for (Object o : javaResult.getElements()) {
            IJavaElement javaElement = (IJavaElement)o;
            IDocument document = null;
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                if (member.isBinary()) {
                    if (member.getClassFile().getSource() != null) {
                        document = new Document(member.getClassFile().getSource());
                    }
                } else {
                    document = this.getDocument(member.getCompilationUnit());
                }
            } else if (javaElement instanceof IPackageDeclaration) {
                ICompilationUnit ancestor = (ICompilationUnit)javaElement.getAncestor(5);
                document = this.getDocument(ancestor);
            }
            converter.addElementToProjectHierarchy(javaElement);
            Match[] matches = javaResult.getMatches(o);
            ArrayList<org.eclipse.che.ide.ext.java.shared.dto.search.Match> matchList = new ArrayList<org.eclipse.che.ide.ext.java.shared.dto.search.Match>();
            for (Match match : matches) {
                org.eclipse.che.ide.ext.java.shared.dto.search.Match dtoMatch = (org.eclipse.che.ide.ext.java.shared.dto.search.Match)DtoFactory.newDto(org.eclipse.che.ide.ext.java.shared.dto.search.Match.class);
                if (document != null) {
                    IRegion lineInformation = document.getLineInformationOfOffset(match.getOffset());
                    int offsetInLine = match.getOffset() - lineInformation.getOffset();
                    Region matchInLine = ((Region)DtoFactory.newDto(Region.class)).withOffset(offsetInLine).withLength(match.getLength());
                    dtoMatch.setMatchInLine(matchInLine);
                    dtoMatch.setMatchLineNumber(document.getLineOfOffset(match.getOffset()));
                    dtoMatch.setMatchedLine(document.get(lineInformation.getOffset(), lineInformation.getLength()));
                }
                dtoMatch.setFileMatchRegion(((Region)DtoFactory.newDto(Region.class)).withOffset(match.getOffset()).withLength(match.getLength()));
                matchList.add(dtoMatch);
            }
            mapMaches.put(javaElement.getHandleIdentifier(), matchList);
        }
        List<JavaProject> projects = converter.getProjects();
        response.setProjects(projects);
        response.setMatches(mapMaches);
        response.setSearchElementLabel(JavaElementLabels.getElementLabel((IJavaElement)element, (long)JavaElementLabels.ALL_DEFAULT));
        return response;
    }

    private IDocument getDocument(ICompilationUnit ancestor) throws JavaModelException {
        IBuffer buffer = ancestor.getBuffer();
        Object document = buffer instanceof DocumentAdapter ? ((DocumentAdapter)buffer).getDocument() : new org.eclipse.jdt.internal.core.DocumentAdapter(buffer);
        return document;
    }

    private boolean isTypeValid(IJavaElement element, Class<?>[] classes) {
        if (element == null) {
            return false;
        }
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(element)) continue;
            if (element.getElementType() == 4) {
                return this.hasChildren((IPackageFragment)element);
            }
            return true;
        }
        return false;
    }

    private boolean hasChildren(IPackageFragment packageFragment) {
        try {
            return packageFragment.hasChildren();
        }
        catch (JavaModelException ex) {
            return false;
        }
    }
}

