/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.core.notification.EventSubscriber;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.impl.RootDirPathProvider;
import org.eclipse.che.api.project.server.notification.ProjectCreatedEvent;
import org.eclipse.che.api.project.server.notification.ProjectItemModifiedEvent;
import org.eclipse.che.api.project.server.type.ProjectTypeRegistry;
import org.eclipse.che.jdt.core.resources.ResourceChangedEvent;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectListeners {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectListeners.class);
    private final File workspace;
    private final ProjectManager projectRegistry;
    private final ProjectTypeRegistry projectTypeRegistry;

    @Inject
    public ProjectListeners(RootDirPathProvider pathProvider, EventService eventService, ProjectManager projectRegistry, ProjectTypeRegistry projectTypeRegistry) {
        this.projectRegistry = projectRegistry;
        this.projectTypeRegistry = projectTypeRegistry;
        this.workspace = new File(pathProvider.get());
        eventService.subscribe((EventSubscriber)new ProjectCreated());
        eventService.subscribe((EventSubscriber)new EventSubscriber<ProjectItemModifiedEvent>(){

            public void onEvent(ProjectItemModifiedEvent event) {
                ProjectListeners.this.handleEvent(event);
            }
        });
    }

    public void handleEvent(ProjectItemModifiedEvent event) {
        ITextFileBufferManager manager;
        ITextFileBuffer fileBuffer;
        String eventPath = event.getPath();
        if (!this.isJavaProject(event.getProject())) {
            return;
        }
        try {
            JavaModelManager.getJavaModelManager().deltaState.resourceChanged((IResourceChangeEvent)new ResourceChangedEvent(this.workspace, event));
        }
        catch (Throwable t) {
            LOG.error("Can't update java model in " + eventPath, t);
        }
        if (event.getType() == ProjectItemModifiedEvent.EventType.UPDATED && (fileBuffer = (manager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer((IPath)new Path(eventPath), LocationKind.IFILE)) != null) {
            try {
                fileBuffer.revert((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LOG.error("Can't read file content: " + eventPath, (Throwable)e);
            }
        }
    }

    private boolean isJavaProject(String projectPath) {
        try {
            String wsPath = WsPathUtils.absolutize((String)projectPath);
            ProjectConfig project = (ProjectConfig)this.projectRegistry.get(wsPath).orElseThrow(() -> new NotFoundException("Can't find project"));
            String type = project.getType();
            return this.projectTypeRegistry.getProjectType(type).isTypeOf("java");
        }
        catch (NotFoundException e) {
            LOG.error("Can't find project " + projectPath, (Throwable)e);
            return false;
        }
    }

    private class ProjectCreated
    implements EventSubscriber<ProjectCreatedEvent> {
        private ProjectCreated() {
        }

        public void onEvent(ProjectCreatedEvent event) {
            if (!ProjectListeners.this.isJavaProject(event.getProjectPath())) {
                return;
            }
            try {
                JavaModelManager.getJavaModelManager().deltaState.resourceChanged((IResourceChangeEvent)new ResourceChangedEvent(ProjectListeners.this.workspace, event));
            }
            catch (Throwable t) {
                LOG.error("Can't update java model " + event.getProjectPath(), t);
            }
        }
    }
}

