/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.JavadocUrlProvider;
import org.eclipse.che.jdt.JavadocFinder;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Path(value="java/javadoc")
public class JavadocService {
    private final JavadocUrlProvider urlProvider;

    @Inject
    public JavadocService(JavadocUrlProvider urlProvider) {
        this.urlProvider = urlProvider;
    }

    @GET
    @Path(value="find")
    @Produces(value={"text/html"})
    public String findJavadoc(@QueryParam(value="fqn") String fqn, @QueryParam(value="projectpath") String projectPath, @QueryParam(value="offset") int offset) throws JavaModelException {
        IJavaProject project = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectPath);
        String urlPart = this.urlProvider.getJavadocUrl(projectPath);
        return new JavadocFinder(urlPart).findJavadoc(project, fqn, offset);
    }

    @GET
    @Path(value="get")
    @Produces(value={"text/html"})
    public String get(@QueryParam(value="handle") String handle, @QueryParam(value="projectpath") String projectPath) {
        IJavaProject project = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectPath);
        String urlPart = this.urlProvider.getJavadocUrl(projectPath);
        return new JavadocFinder(urlPart).findJavadoc4Handle(project, handle);
    }
}

