/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import com.google.inject.Inject;
import org.eclipse.che.api.core.jsonrpc.commons.JsonRpcException;
import org.eclipse.che.api.core.jsonrpc.commons.RequestHandlerConfigurator;
import org.eclipse.che.ide.ext.java.shared.dto.search.FindUsagesRequest;
import org.eclipse.che.ide.ext.java.shared.dto.search.FindUsagesResponse;
import org.eclipse.che.plugin.java.server.search.SearchException;
import org.eclipse.che.plugin.java.server.search.SearchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

public class SearchJsonRpcService {
    private final SearchManager manager;

    @Inject
    public SearchJsonRpcService(SearchManager manager) {
        this.manager = manager;
    }

    @Inject
    private void configureFindUsagesRequest(RequestHandlerConfigurator requestHandlerConfigurator) {
        requestHandlerConfigurator.newConfiguration().methodName("javaSearch/findUsages").paramsAsDto(FindUsagesRequest.class).resultAsDto(FindUsagesResponse.class).withFunction(this::findUsages);
    }

    private FindUsagesResponse findUsages(FindUsagesRequest request) {
        try {
            JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject javaProject = javaModel.getJavaProject(request.getProjectPath());
            return this.manager.findUsage(javaProject, request.getFQN(), request.getOffset());
        }
        catch (SearchException e) {
            throw new JsonRpcException(-27000, e.getMessage());
        }
    }
}

