/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.refactoring.session;

import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameSettings;
import org.eclipse.che.plugin.java.server.refactoring.session.RefactoringSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IRenameSubpackages;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public class RenameSession
extends RefactoringSession {
    public RenameSession(RenameRefactoring refactoring) {
        super((Refactoring)refactoring);
    }

    public void setSettings(RenameSettings settings) {
        ITextUpdating textUpdating;
        ISimilarDeclarationUpdating similarDeclarationUpdating;
        IRenameSubpackages renameSubpackages;
        IReferenceUpdating referenceUpdating;
        IQualifiedNameUpdating nameUpdating;
        IDelegateUpdating delegateUpdating = (IDelegateUpdating)this.refactoring.getAdapter(IDelegateUpdating.class);
        if (delegateUpdating != null && delegateUpdating.canEnableDelegateUpdating()) {
            delegateUpdating.setDelegateUpdating(settings.isDelegateUpdating());
            delegateUpdating.setDeprecateDelegates(settings.isDeprecateDelegates());
        }
        if ((nameUpdating = (IQualifiedNameUpdating)this.refactoring.getAdapter(IQualifiedNameUpdating.class)) != null && nameUpdating.canEnableQualifiedNameUpdating()) {
            nameUpdating.setUpdateQualifiedNames(settings.isUpdateQualifiedNames());
            if (settings.isUpdateQualifiedNames()) {
                nameUpdating.setFilePatterns(settings.getFilePatterns());
            }
        }
        if ((referenceUpdating = (IReferenceUpdating)this.refactoring.getAdapter(IReferenceUpdating.class)) != null) {
            referenceUpdating.setUpdateReferences(settings.isUpdateReferences());
        }
        if ((renameSubpackages = (IRenameSubpackages)this.refactoring.getAdapter(IRenameSubpackages.class)) != null) {
            renameSubpackages.setRenameSubpackages(settings.isUpdateSubpackages());
        }
        if ((similarDeclarationUpdating = (ISimilarDeclarationUpdating)this.refactoring.getAdapter(ISimilarDeclarationUpdating.class)) != null) {
            similarDeclarationUpdating.setUpdateSimilarDeclarations(settings.isUpdateSimilarDeclarations());
            if (settings.isUpdateSimilarDeclarations()) {
                similarDeclarationUpdating.setMatchStrategy(settings.getMachStrategy());
            }
        }
        if ((textUpdating = (ITextUpdating)this.refactoring.getAdapter(ITextUpdating.class)) != null && textUpdating.canEnableTextUpdating()) {
            textUpdating.setUpdateTextualMatches(settings.isUpdateTextualMatches());
        }
    }

    public RefactoringStatus validateNewName(String newName) {
        INameUpdating updating = this.getNameUpdating();
        updating.setNewElementName(newName);
        try {
            return updating.checkNewElementName(newName);
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
            return RefactoringStatus.createFatalErrorStatus((String)"An unexpected exception occurred. See the error log for more details.");
        }
    }

    private INameUpdating getNameUpdating() {
        return (INameUpdating)this.refactoring.getAdapter(INameUpdating.class);
    }
}

