/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.fs.server.FsManager;
import org.eclipse.che.api.fs.server.PathTransformer;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.ide.ext.java.shared.dto.Change;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.format.Formatter;
import org.eclipse.jface.text.BadLocationException;

@Path(value="java/formatter/")
public class JavaFormatterService {
    private static final String CHE_FOLDER = ".che";
    private static final String CHE_FORMATTER_XML = "che-formatter.xml";
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
    private final FsManager fsManager;
    private final PathTransformer pathTransformer;
    private Formatter formatter;

    @Inject
    public JavaFormatterService(FsManager fsManager, PathTransformer pathTransformer, Formatter formatter) {
        this.fsManager = fsManager;
        this.pathTransformer = pathTransformer;
        this.formatter = formatter;
    }

    @POST
    @Path(value="/format")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates edits that describe how to format the given string")
    @ApiResponses(value={@ApiResponse(code=200, message="The response contains all changes after formating"), @ApiResponse(code=500, message="Internal server error occurred")})
    public List<Change> getFormatChanges(@ApiParam(value="Path to the root project") @QueryParam(value="projectpath") String projectPath, @ApiParam(value="The given offset to start recording the edits (inclusive)") @QueryParam(value="offset") int offset, @ApiParam(value="The given length to stop recording the edits (exclusive)") @QueryParam(value="length") int length, @ApiParam(value="The content to format. Java code formatting is supported only") String content) throws BadLocationException, IllegalArgumentException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        String formatterPath = ".che/che-formatter.xml";
        File file = null;
        IFile iFile = javaProject.getProject().getFile(formatterPath);
        if (iFile != null) {
            file = iFile.getLocation().toFile();
        }
        if (file == null || !file.exists()) {
            file = this.getFormatterFromRootFolder(formatterPath);
        }
        return this.formatter.getFormatChanges(file, content, offset, length);
    }

    @POST
    @Path(value="update/workspace")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Updates configuration of the jav formatter for the workspace")
    @ApiResponses(value={@ApiResponse(code=200, message="Formatter was imported successfully"), @ApiResponse(code=500, message="Internal server error occurred")})
    public void updateRootFormatter(@ApiParam(value="The content of the formatter. Eclipse code formatting is supported only") String content) throws ServerException {
        try {
            String cheFormatterWsPath;
            String rootCheFolderWsPath = WsPathUtils.absolutize((String)CHE_FOLDER);
            if (!this.fsManager.existsAsDir(rootCheFolderWsPath)) {
                this.fsManager.createDir(rootCheFolderWsPath);
            }
            if (!this.fsManager.existsAsFile(cheFormatterWsPath = WsPathUtils.resolve((String)rootCheFolderWsPath, (String)CHE_FORMATTER_XML))) {
                this.fsManager.createFile(cheFormatterWsPath, content);
            } else {
                this.fsManager.update(cheFormatterWsPath, content);
            }
        }
        catch (ConflictException | NotFoundException | ServerException e) {
            throw new ServerException(e);
        }
    }

    @POST
    @Path(value="update/project")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Updates configuration of the jav formatter for the project")
    @ApiResponses(value={@ApiResponse(code=200, message="Formatter was imported successfully"), @ApiResponse(code=404, message="The project was not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    public void updateProjectFormatter(@ApiParam(value="Path to the root project") @QueryParam(value="projectpath") String projectPath, @ApiParam(value="The content of the formatter. Eclipse code formatting is supported only") String content) throws ServerException, NotFoundException {
        try {
            String cheFormatterWsPath;
            String projectWsPath = WsPathUtils.absolutize((String)projectPath);
            String projectCheFolderWsPath = WsPathUtils.resolve((String)projectWsPath, (String)CHE_FOLDER);
            if (!this.fsManager.existsAsDir(projectCheFolderWsPath)) {
                this.fsManager.createDir(projectCheFolderWsPath);
            }
            if (!this.fsManager.existsAsFile(cheFormatterWsPath = WsPathUtils.resolve((String)projectCheFolderWsPath, (String)CHE_FORMATTER_XML))) {
                this.fsManager.createFile(cheFormatterWsPath, content);
            } else {
                this.fsManager.update(cheFormatterWsPath, content);
            }
        }
        catch (ConflictException | NotFoundException e) {
            throw new ServerException(e);
        }
    }

    private File getFormatterFromRootFolder(String formatterPath) {
        return this.fsManager.toIoFile(WsPathUtils.absolutize((String)formatterPath));
    }
}

