/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.projecttype;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.che.api.fs.server.PathTransformer;
import org.eclipse.che.api.project.server.type.ReadonlyValueProvider;
import org.eclipse.che.api.project.server.type.ValueProvider;
import org.eclipse.che.api.project.server.type.ValueProviderFactory;
import org.eclipse.che.api.project.server.type.ValueStorageException;

@Singleton
public class JavaValueProviderFactory
implements ValueProviderFactory {
    private final PathTransformer pathTransformer;

    @Inject
    public JavaValueProviderFactory(PathTransformer pathTransformer) {
        this.pathTransformer = pathTransformer;
    }

    public ValueProvider newInstance(String wsPath) {
        return new JavaValueProvider(this.pathTransformer.transform(wsPath));
    }

    private static class JavaValueProvider
    extends ReadonlyValueProvider {
        private final Path projectFsPath;
        private boolean containsJavaFiles;
        private boolean initialized = false;

        JavaValueProvider(Path projectFsPath) {
            this.projectFsPath = projectFsPath;
            this.initialized = false;
        }

        private boolean hasJavaFilesInFolder() {
            try {
                final AtomicBoolean detectedJavaFiles = new AtomicBoolean();
                Files.walkFileTree(this.projectFsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toFile().getName().endsWith(".java")) {
                            detectedJavaFiles.getAndSet(true);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                return detectedJavaFiles.get();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to get files from from: " + this.projectFsPath, e);
            }
        }

        private void init() throws ValueStorageException {
            try {
                this.containsJavaFiles = this.hasJavaFilesInFolder();
            }
            catch (IllegalStateException e) {
                throw new ValueStorageException(String.format("Unable to get files from ''%s'' because of %s", this.projectFsPath, e.getMessage()));
            }
            this.initialized = true;
        }

        public List<String> getValues(String attributeName) throws ValueStorageException {
            if (!this.initialized) {
                this.init();
            }
            if (attributeName.equals("languageVersion")) {
                return Collections.singletonList(System.getProperty("java.version"));
            }
            if ("containsJavaFiles".equals(attributeName)) {
                return Collections.singletonList(String.valueOf(this.containsJavaFiles));
            }
            return null;
        }
    }
}

