/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.fs.server.FsManager;
import org.eclipse.che.api.fs.server.WsPathUtils;

@Path(value="java/formatter/")
public class JavaFormatterService {
    public static final String CHE_FOLDER = ".che";
    public static final String CHE_FORMATTER_XML = "che-formatter.xml";
    private final FsManager fsManager;

    @Inject
    public JavaFormatterService(FsManager fsManager) {
        this.fsManager = fsManager;
    }

    @POST
    @Path(value="update/workspace")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Updates configuration of the jav formatter for the workspace")
    @ApiResponses(value={@ApiResponse(code=200, message="Formatter was imported successfully"), @ApiResponse(code=500, message="Internal server error occurred")})
    public void updateRootFormatter(@ApiParam(value="The content of the formatter. Eclipse code formatting is supported only") String content) throws ServerException {
        try {
            String cheFormatterWsPath;
            String rootCheFolderWsPath = WsPathUtils.absolutize((String)CHE_FOLDER);
            if (!this.fsManager.existsAsDir(rootCheFolderWsPath)) {
                this.fsManager.createDir(rootCheFolderWsPath);
            }
            if (!this.fsManager.existsAsFile(cheFormatterWsPath = WsPathUtils.resolve((String)rootCheFolderWsPath, (String)CHE_FORMATTER_XML))) {
                this.fsManager.createFile(cheFormatterWsPath, content);
            } else {
                this.fsManager.update(cheFormatterWsPath, content);
            }
        }
        catch (ConflictException | NotFoundException | ServerException e) {
            throw new ServerException(e);
        }
    }

    @POST
    @Path(value="update/project")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Updates configuration of the jav formatter for the project")
    @ApiResponses(value={@ApiResponse(code=200, message="Formatter was imported successfully"), @ApiResponse(code=404, message="The project was not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    public void updateProjectFormatter(@ApiParam(value="Path to the root project") @QueryParam(value="projectpath") String projectPath, @ApiParam(value="The content of the formatter. Eclipse code formatting is supported only") String content) throws ServerException, NotFoundException {
        try {
            String cheFormatterWsPath;
            String projectWsPath = WsPathUtils.absolutize((String)projectPath);
            String projectCheFolderWsPath = WsPathUtils.resolve((String)projectWsPath, (String)CHE_FOLDER);
            if (!this.fsManager.existsAsDir(projectCheFolderWsPath)) {
                this.fsManager.createDir(projectCheFolderWsPath);
            }
            if (!this.fsManager.existsAsFile(cheFormatterWsPath = WsPathUtils.resolve((String)projectCheFolderWsPath, (String)CHE_FORMATTER_XML))) {
                this.fsManager.createFile(cheFormatterWsPath, content);
            } else {
                this.fsManager.update(cheFormatterWsPath, content);
            }
        }
        catch (ConflictException | NotFoundException e) {
            throw new ServerException(e);
        }
    }
}

