/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.server.dto;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.dto.server.DtoFactoryVisitor;
import org.eclipse.che.dto.server.DtoProvider;
import org.eclipse.che.dto.server.JsonArrayImpl;
import org.eclipse.che.dto.server.JsonSerializable;
import org.eclipse.che.dto.server.JsonStringMapImpl;
import org.eclipse.che.dto.shared.DTOImpl;
import org.eclipse.che.ide.ext.java.shared.Jar;
import org.eclipse.che.ide.ext.java.shared.JarEntry;
import org.eclipse.che.ide.ext.java.shared.OpenDeclarationDescriptor;
import org.eclipse.che.ide.ext.java.shared.dto.Change;
import org.eclipse.che.ide.ext.java.shared.dto.ClassContent;
import org.eclipse.che.ide.ext.java.shared.dto.ConflictImportDTO;
import org.eclipse.che.ide.ext.java.shared.dto.HighlightedPosition;
import org.eclipse.che.ide.ext.java.shared.dto.ImplementationsDescriptorDTO;
import org.eclipse.che.ide.ext.java.shared.dto.JavaClassInfo;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedData;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedModeModel;
import org.eclipse.che.ide.ext.java.shared.dto.LinkedPositionGroup;
import org.eclipse.che.ide.ext.java.shared.dto.OrganizeImportResult;
import org.eclipse.che.ide.ext.java.shared.dto.Problem;
import org.eclipse.che.ide.ext.java.shared.dto.ProposalApplyResult;
import org.eclipse.che.ide.ext.java.shared.dto.ProposalPresentation;
import org.eclipse.che.ide.ext.java.shared.dto.Proposals;
import org.eclipse.che.ide.ext.java.shared.dto.ReconcileResult;
import org.eclipse.che.ide.ext.java.shared.dto.Region;
import org.eclipse.che.ide.ext.java.shared.dto.classpath.ClasspathEntryDto;
import org.eclipse.che.ide.ext.java.shared.dto.model.ClassFile;
import org.eclipse.che.ide.ext.java.shared.dto.model.CompilationUnit;
import org.eclipse.che.ide.ext.java.shared.dto.model.Field;
import org.eclipse.che.ide.ext.java.shared.dto.model.ImportDeclaration;
import org.eclipse.che.ide.ext.java.shared.dto.model.Initializer;
import org.eclipse.che.ide.ext.java.shared.dto.model.JavaProject;
import org.eclipse.che.ide.ext.java.shared.dto.model.Method;
import org.eclipse.che.ide.ext.java.shared.dto.model.MethodParameters;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragment;
import org.eclipse.che.ide.ext.java.shared.dto.model.PackageFragmentRoot;
import org.eclipse.che.ide.ext.java.shared.dto.model.Type;
import org.eclipse.che.ide.ext.java.shared.dto.model.TypeParameter;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeCreationResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeEnabledState;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangeInfo;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ChangePreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.CreateMoveRefactoring;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.CreateRenameRefactoring;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ElementToMove;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.LinkedRenameRefactoringApply;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.MoveSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringChange;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringPreview;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringResult;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringSession;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatus;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RefactoringStatusEntry;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameRefactoringSession;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.RenameSettings;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ReorgDestination;
import org.eclipse.che.ide.ext.java.shared.dto.refactoring.ValidateNewName;
import org.eclipse.che.ide.ext.java.shared.dto.search.FindUsagesRequest;
import org.eclipse.che.ide.ext.java.shared.dto.search.FindUsagesResponse;
import org.eclipse.che.ide.ext.java.shared.dto.search.Match;

public class DtoServerImpls
implements DtoFactoryVisitor {
    private static final Gson gson = DtoFactory.getInstance().getGson();

    public void accept(DtoFactory dtoFactory) {
        dtoFactory.registerProvider(Jar.class, (DtoProvider)new DtoProvider<Jar>(){

            public Class<? extends Jar> getImplClass() {
                return JarImpl.class;
            }

            public Jar newInstance() {
                return JarImpl.make();
            }

            public Jar fromJson(String json) {
                return JarImpl.fromJsonString(json);
            }

            public Jar fromJson(JsonElement json) {
                return JarImpl.fromJsonElement(json);
            }

            public Jar clone(Jar origin) {
                return new JarImpl(origin);
            }
        });
        dtoFactory.registerProvider(JarEntry.class, (DtoProvider)new DtoProvider<JarEntry>(){

            public Class<? extends JarEntry> getImplClass() {
                return JarEntryImpl.class;
            }

            public JarEntry newInstance() {
                return JarEntryImpl.make();
            }

            public JarEntry fromJson(String json) {
                return JarEntryImpl.fromJsonString(json);
            }

            public JarEntry fromJson(JsonElement json) {
                return JarEntryImpl.fromJsonElement(json);
            }

            public JarEntry clone(JarEntry origin) {
                return new JarEntryImpl(origin);
            }
        });
        dtoFactory.registerProvider(OpenDeclarationDescriptor.class, (DtoProvider)new DtoProvider<OpenDeclarationDescriptor>(){

            public Class<? extends OpenDeclarationDescriptor> getImplClass() {
                return OpenDeclarationDescriptorImpl.class;
            }

            public OpenDeclarationDescriptor newInstance() {
                return OpenDeclarationDescriptorImpl.make();
            }

            public OpenDeclarationDescriptor fromJson(String json) {
                return OpenDeclarationDescriptorImpl.fromJsonString(json);
            }

            public OpenDeclarationDescriptor fromJson(JsonElement json) {
                return OpenDeclarationDescriptorImpl.fromJsonElement(json);
            }

            public OpenDeclarationDescriptor clone(OpenDeclarationDescriptor origin) {
                return new OpenDeclarationDescriptorImpl(origin);
            }
        });
        dtoFactory.registerProvider(Change.class, (DtoProvider)new DtoProvider<Change>(){

            public Class<? extends Change> getImplClass() {
                return ChangeImpl.class;
            }

            public Change newInstance() {
                return ChangeImpl.make();
            }

            public Change fromJson(String json) {
                return ChangeImpl.fromJsonString(json);
            }

            public Change fromJson(JsonElement json) {
                return ChangeImpl.fromJsonElement(json);
            }

            public Change clone(Change origin) {
                return new ChangeImpl(origin);
            }
        });
        dtoFactory.registerProvider(ClassContent.class, (DtoProvider)new DtoProvider<ClassContent>(){

            public Class<? extends ClassContent> getImplClass() {
                return ClassContentImpl.class;
            }

            public ClassContent newInstance() {
                return ClassContentImpl.make();
            }

            public ClassContent fromJson(String json) {
                return ClassContentImpl.fromJsonString(json);
            }

            public ClassContent fromJson(JsonElement json) {
                return ClassContentImpl.fromJsonElement(json);
            }

            public ClassContent clone(ClassContent origin) {
                return new ClassContentImpl(origin);
            }
        });
        dtoFactory.registerProvider(ConflictImportDTO.class, (DtoProvider)new DtoProvider<ConflictImportDTO>(){

            public Class<? extends ConflictImportDTO> getImplClass() {
                return ConflictImportDTOImpl.class;
            }

            public ConflictImportDTO newInstance() {
                return ConflictImportDTOImpl.make();
            }

            public ConflictImportDTO fromJson(String json) {
                return ConflictImportDTOImpl.fromJsonString(json);
            }

            public ConflictImportDTO fromJson(JsonElement json) {
                return ConflictImportDTOImpl.fromJsonElement(json);
            }

            public ConflictImportDTO clone(ConflictImportDTO origin) {
                return new ConflictImportDTOImpl(origin);
            }
        });
        dtoFactory.registerProvider(HighlightedPosition.class, (DtoProvider)new DtoProvider<HighlightedPosition>(){

            public Class<? extends HighlightedPosition> getImplClass() {
                return HighlightedPositionImpl.class;
            }

            public HighlightedPosition newInstance() {
                return HighlightedPositionImpl.make();
            }

            public HighlightedPosition fromJson(String json) {
                return HighlightedPositionImpl.fromJsonString(json);
            }

            public HighlightedPosition fromJson(JsonElement json) {
                return HighlightedPositionImpl.fromJsonElement(json);
            }

            public HighlightedPosition clone(HighlightedPosition origin) {
                return new HighlightedPositionImpl(origin);
            }
        });
        dtoFactory.registerProvider(ImplementationsDescriptorDTO.class, (DtoProvider)new DtoProvider<ImplementationsDescriptorDTO>(){

            public Class<? extends ImplementationsDescriptorDTO> getImplClass() {
                return ImplementationsDescriptorDTOImpl.class;
            }

            public ImplementationsDescriptorDTO newInstance() {
                return ImplementationsDescriptorDTOImpl.make();
            }

            public ImplementationsDescriptorDTO fromJson(String json) {
                return ImplementationsDescriptorDTOImpl.fromJsonString(json);
            }

            public ImplementationsDescriptorDTO fromJson(JsonElement json) {
                return ImplementationsDescriptorDTOImpl.fromJsonElement(json);
            }

            public ImplementationsDescriptorDTO clone(ImplementationsDescriptorDTO origin) {
                return new ImplementationsDescriptorDTOImpl(origin);
            }
        });
        dtoFactory.registerProvider(JavaClassInfo.class, (DtoProvider)new DtoProvider<JavaClassInfo>(){

            public Class<? extends JavaClassInfo> getImplClass() {
                return JavaClassInfoImpl.class;
            }

            public JavaClassInfo newInstance() {
                return JavaClassInfoImpl.make();
            }

            public JavaClassInfo fromJson(String json) {
                return JavaClassInfoImpl.fromJsonString(json);
            }

            public JavaClassInfo fromJson(JsonElement json) {
                return JavaClassInfoImpl.fromJsonElement(json);
            }

            public JavaClassInfo clone(JavaClassInfo origin) {
                return new JavaClassInfoImpl(origin);
            }
        });
        dtoFactory.registerProvider(LinkedData.class, (DtoProvider)new DtoProvider<LinkedData>(){

            public Class<? extends LinkedData> getImplClass() {
                return LinkedDataImpl.class;
            }

            public LinkedData newInstance() {
                return LinkedDataImpl.make();
            }

            public LinkedData fromJson(String json) {
                return LinkedDataImpl.fromJsonString(json);
            }

            public LinkedData fromJson(JsonElement json) {
                return LinkedDataImpl.fromJsonElement(json);
            }

            public LinkedData clone(LinkedData origin) {
                return new LinkedDataImpl(origin);
            }
        });
        dtoFactory.registerProvider(LinkedModeModel.class, (DtoProvider)new DtoProvider<LinkedModeModel>(){

            public Class<? extends LinkedModeModel> getImplClass() {
                return LinkedModeModelImpl.class;
            }

            public LinkedModeModel newInstance() {
                return LinkedModeModelImpl.make();
            }

            public LinkedModeModel fromJson(String json) {
                return LinkedModeModelImpl.fromJsonString(json);
            }

            public LinkedModeModel fromJson(JsonElement json) {
                return LinkedModeModelImpl.fromJsonElement(json);
            }

            public LinkedModeModel clone(LinkedModeModel origin) {
                return new LinkedModeModelImpl(origin);
            }
        });
        dtoFactory.registerProvider(LinkedPositionGroup.class, (DtoProvider)new DtoProvider<LinkedPositionGroup>(){

            public Class<? extends LinkedPositionGroup> getImplClass() {
                return LinkedPositionGroupImpl.class;
            }

            public LinkedPositionGroup newInstance() {
                return LinkedPositionGroupImpl.make();
            }

            public LinkedPositionGroup fromJson(String json) {
                return LinkedPositionGroupImpl.fromJsonString(json);
            }

            public LinkedPositionGroup fromJson(JsonElement json) {
                return LinkedPositionGroupImpl.fromJsonElement(json);
            }

            public LinkedPositionGroup clone(LinkedPositionGroup origin) {
                return new LinkedPositionGroupImpl(origin);
            }
        });
        dtoFactory.registerProvider(OrganizeImportResult.class, (DtoProvider)new DtoProvider<OrganizeImportResult>(){

            public Class<? extends OrganizeImportResult> getImplClass() {
                return OrganizeImportResultImpl.class;
            }

            public OrganizeImportResult newInstance() {
                return OrganizeImportResultImpl.make();
            }

            public OrganizeImportResult fromJson(String json) {
                return OrganizeImportResultImpl.fromJsonString(json);
            }

            public OrganizeImportResult fromJson(JsonElement json) {
                return OrganizeImportResultImpl.fromJsonElement(json);
            }

            public OrganizeImportResult clone(OrganizeImportResult origin) {
                return new OrganizeImportResultImpl(origin);
            }
        });
        dtoFactory.registerProvider(Problem.class, (DtoProvider)new DtoProvider<Problem>(){

            public Class<? extends Problem> getImplClass() {
                return ProblemImpl.class;
            }

            public Problem newInstance() {
                return ProblemImpl.make();
            }

            public Problem fromJson(String json) {
                return ProblemImpl.fromJsonString(json);
            }

            public Problem fromJson(JsonElement json) {
                return ProblemImpl.fromJsonElement(json);
            }

            public Problem clone(Problem origin) {
                return new ProblemImpl(origin);
            }
        });
        dtoFactory.registerProvider(ProposalApplyResult.class, (DtoProvider)new DtoProvider<ProposalApplyResult>(){

            public Class<? extends ProposalApplyResult> getImplClass() {
                return ProposalApplyResultImpl.class;
            }

            public ProposalApplyResult newInstance() {
                return ProposalApplyResultImpl.make();
            }

            public ProposalApplyResult fromJson(String json) {
                return ProposalApplyResultImpl.fromJsonString(json);
            }

            public ProposalApplyResult fromJson(JsonElement json) {
                return ProposalApplyResultImpl.fromJsonElement(json);
            }

            public ProposalApplyResult clone(ProposalApplyResult origin) {
                return new ProposalApplyResultImpl(origin);
            }
        });
        dtoFactory.registerProvider(ProposalPresentation.class, (DtoProvider)new DtoProvider<ProposalPresentation>(){

            public Class<? extends ProposalPresentation> getImplClass() {
                return ProposalPresentationImpl.class;
            }

            public ProposalPresentation newInstance() {
                return ProposalPresentationImpl.make();
            }

            public ProposalPresentation fromJson(String json) {
                return ProposalPresentationImpl.fromJsonString(json);
            }

            public ProposalPresentation fromJson(JsonElement json) {
                return ProposalPresentationImpl.fromJsonElement(json);
            }

            public ProposalPresentation clone(ProposalPresentation origin) {
                return new ProposalPresentationImpl(origin);
            }
        });
        dtoFactory.registerProvider(Proposals.class, (DtoProvider)new DtoProvider<Proposals>(){

            public Class<? extends Proposals> getImplClass() {
                return ProposalsImpl.class;
            }

            public Proposals newInstance() {
                return ProposalsImpl.make();
            }

            public Proposals fromJson(String json) {
                return ProposalsImpl.fromJsonString(json);
            }

            public Proposals fromJson(JsonElement json) {
                return ProposalsImpl.fromJsonElement(json);
            }

            public Proposals clone(Proposals origin) {
                return new ProposalsImpl(origin);
            }
        });
        dtoFactory.registerProvider(ReconcileResult.class, (DtoProvider)new DtoProvider<ReconcileResult>(){

            public Class<? extends ReconcileResult> getImplClass() {
                return ReconcileResultImpl.class;
            }

            public ReconcileResult newInstance() {
                return ReconcileResultImpl.make();
            }

            public ReconcileResult fromJson(String json) {
                return ReconcileResultImpl.fromJsonString(json);
            }

            public ReconcileResult fromJson(JsonElement json) {
                return ReconcileResultImpl.fromJsonElement(json);
            }

            public ReconcileResult clone(ReconcileResult origin) {
                return new ReconcileResultImpl(origin);
            }
        });
        dtoFactory.registerProvider(Region.class, (DtoProvider)new DtoProvider<Region>(){

            public Class<? extends Region> getImplClass() {
                return RegionImpl.class;
            }

            public Region newInstance() {
                return RegionImpl.make();
            }

            public Region fromJson(String json) {
                return RegionImpl.fromJsonString(json);
            }

            public Region fromJson(JsonElement json) {
                return RegionImpl.fromJsonElement(json);
            }

            public Region clone(Region origin) {
                return new RegionImpl(origin);
            }
        });
        dtoFactory.registerProvider(ClasspathEntryDto.class, (DtoProvider)new DtoProvider<ClasspathEntryDto>(){

            public Class<? extends ClasspathEntryDto> getImplClass() {
                return ClasspathEntryDtoImpl.class;
            }

            public ClasspathEntryDto newInstance() {
                return ClasspathEntryDtoImpl.make();
            }

            public ClasspathEntryDto fromJson(String json) {
                return ClasspathEntryDtoImpl.fromJsonString(json);
            }

            public ClasspathEntryDto fromJson(JsonElement json) {
                return ClasspathEntryDtoImpl.fromJsonElement(json);
            }

            public ClasspathEntryDto clone(ClasspathEntryDto origin) {
                return new ClasspathEntryDtoImpl(origin);
            }
        });
        dtoFactory.registerProvider(ClassFile.class, (DtoProvider)new DtoProvider<ClassFile>(){

            public Class<? extends ClassFile> getImplClass() {
                return ClassFileImpl.class;
            }

            public ClassFile newInstance() {
                return ClassFileImpl.make();
            }

            public ClassFile fromJson(String json) {
                return ClassFileImpl.fromJsonString(json);
            }

            public ClassFile fromJson(JsonElement json) {
                return ClassFileImpl.fromJsonElement(json);
            }

            public ClassFile clone(ClassFile origin) {
                return new ClassFileImpl(origin);
            }
        });
        dtoFactory.registerProvider(CompilationUnit.class, (DtoProvider)new DtoProvider<CompilationUnit>(){

            public Class<? extends CompilationUnit> getImplClass() {
                return CompilationUnitImpl.class;
            }

            public CompilationUnit newInstance() {
                return CompilationUnitImpl.make();
            }

            public CompilationUnit fromJson(String json) {
                return CompilationUnitImpl.fromJsonString(json);
            }

            public CompilationUnit fromJson(JsonElement json) {
                return CompilationUnitImpl.fromJsonElement(json);
            }

            public CompilationUnit clone(CompilationUnit origin) {
                return new CompilationUnitImpl(origin);
            }
        });
        dtoFactory.registerProvider(Field.class, (DtoProvider)new DtoProvider<Field>(){

            public Class<? extends Field> getImplClass() {
                return FieldImpl.class;
            }

            public Field newInstance() {
                return FieldImpl.make();
            }

            public Field fromJson(String json) {
                return FieldImpl.fromJsonString(json);
            }

            public Field fromJson(JsonElement json) {
                return FieldImpl.fromJsonElement(json);
            }

            public Field clone(Field origin) {
                return new FieldImpl(origin);
            }
        });
        dtoFactory.registerProvider(ImportDeclaration.class, (DtoProvider)new DtoProvider<ImportDeclaration>(){

            public Class<? extends ImportDeclaration> getImplClass() {
                return ImportDeclarationImpl.class;
            }

            public ImportDeclaration newInstance() {
                return ImportDeclarationImpl.make();
            }

            public ImportDeclaration fromJson(String json) {
                return ImportDeclarationImpl.fromJsonString(json);
            }

            public ImportDeclaration fromJson(JsonElement json) {
                return ImportDeclarationImpl.fromJsonElement(json);
            }

            public ImportDeclaration clone(ImportDeclaration origin) {
                return new ImportDeclarationImpl(origin);
            }
        });
        dtoFactory.registerProvider(Initializer.class, (DtoProvider)new DtoProvider<Initializer>(){

            public Class<? extends Initializer> getImplClass() {
                return InitializerImpl.class;
            }

            public Initializer newInstance() {
                return InitializerImpl.make();
            }

            public Initializer fromJson(String json) {
                return InitializerImpl.fromJsonString(json);
            }

            public Initializer fromJson(JsonElement json) {
                return InitializerImpl.fromJsonElement(json);
            }

            public Initializer clone(Initializer origin) {
                return new InitializerImpl(origin);
            }
        });
        dtoFactory.registerProvider(JavaProject.class, (DtoProvider)new DtoProvider<JavaProject>(){

            public Class<? extends JavaProject> getImplClass() {
                return JavaProjectImpl.class;
            }

            public JavaProject newInstance() {
                return JavaProjectImpl.make();
            }

            public JavaProject fromJson(String json) {
                return JavaProjectImpl.fromJsonString(json);
            }

            public JavaProject fromJson(JsonElement json) {
                return JavaProjectImpl.fromJsonElement(json);
            }

            public JavaProject clone(JavaProject origin) {
                return new JavaProjectImpl(origin);
            }
        });
        dtoFactory.registerProvider(Method.class, (DtoProvider)new DtoProvider<Method>(){

            public Class<? extends Method> getImplClass() {
                return MethodImpl.class;
            }

            public Method newInstance() {
                return MethodImpl.make();
            }

            public Method fromJson(String json) {
                return MethodImpl.fromJsonString(json);
            }

            public Method fromJson(JsonElement json) {
                return MethodImpl.fromJsonElement(json);
            }

            public Method clone(Method origin) {
                return new MethodImpl(origin);
            }
        });
        dtoFactory.registerProvider(MethodParameters.class, (DtoProvider)new DtoProvider<MethodParameters>(){

            public Class<? extends MethodParameters> getImplClass() {
                return MethodParametersImpl.class;
            }

            public MethodParameters newInstance() {
                return MethodParametersImpl.make();
            }

            public MethodParameters fromJson(String json) {
                return MethodParametersImpl.fromJsonString(json);
            }

            public MethodParameters fromJson(JsonElement json) {
                return MethodParametersImpl.fromJsonElement(json);
            }

            public MethodParameters clone(MethodParameters origin) {
                return new MethodParametersImpl(origin);
            }
        });
        dtoFactory.registerProvider(PackageFragment.class, (DtoProvider)new DtoProvider<PackageFragment>(){

            public Class<? extends PackageFragment> getImplClass() {
                return PackageFragmentImpl.class;
            }

            public PackageFragment newInstance() {
                return PackageFragmentImpl.make();
            }

            public PackageFragment fromJson(String json) {
                return PackageFragmentImpl.fromJsonString(json);
            }

            public PackageFragment fromJson(JsonElement json) {
                return PackageFragmentImpl.fromJsonElement(json);
            }

            public PackageFragment clone(PackageFragment origin) {
                return new PackageFragmentImpl(origin);
            }
        });
        dtoFactory.registerProvider(PackageFragmentRoot.class, (DtoProvider)new DtoProvider<PackageFragmentRoot>(){

            public Class<? extends PackageFragmentRoot> getImplClass() {
                return PackageFragmentRootImpl.class;
            }

            public PackageFragmentRoot newInstance() {
                return PackageFragmentRootImpl.make();
            }

            public PackageFragmentRoot fromJson(String json) {
                return PackageFragmentRootImpl.fromJsonString(json);
            }

            public PackageFragmentRoot fromJson(JsonElement json) {
                return PackageFragmentRootImpl.fromJsonElement(json);
            }

            public PackageFragmentRoot clone(PackageFragmentRoot origin) {
                return new PackageFragmentRootImpl(origin);
            }
        });
        dtoFactory.registerProvider(Type.class, (DtoProvider)new DtoProvider<Type>(){

            public Class<? extends Type> getImplClass() {
                return TypeImpl.class;
            }

            public Type newInstance() {
                return TypeImpl.make();
            }

            public Type fromJson(String json) {
                return TypeImpl.fromJsonString(json);
            }

            public Type fromJson(JsonElement json) {
                return TypeImpl.fromJsonElement(json);
            }

            public Type clone(Type origin) {
                return new TypeImpl(origin);
            }
        });
        dtoFactory.registerProvider(TypeParameter.class, (DtoProvider)new DtoProvider<TypeParameter>(){

            public Class<? extends TypeParameter> getImplClass() {
                return TypeParameterImpl.class;
            }

            public TypeParameter newInstance() {
                return TypeParameterImpl.make();
            }

            public TypeParameter fromJson(String json) {
                return TypeParameterImpl.fromJsonString(json);
            }

            public TypeParameter fromJson(JsonElement json) {
                return TypeParameterImpl.fromJsonElement(json);
            }

            public TypeParameter clone(TypeParameter origin) {
                return new TypeParameterImpl(origin);
            }
        });
        dtoFactory.registerProvider(ChangeCreationResult.class, (DtoProvider)new DtoProvider<ChangeCreationResult>(){

            public Class<? extends ChangeCreationResult> getImplClass() {
                return ChangeCreationResultImpl.class;
            }

            public ChangeCreationResult newInstance() {
                return ChangeCreationResultImpl.make();
            }

            public ChangeCreationResult fromJson(String json) {
                return ChangeCreationResultImpl.fromJsonString(json);
            }

            public ChangeCreationResult fromJson(JsonElement json) {
                return ChangeCreationResultImpl.fromJsonElement(json);
            }

            public ChangeCreationResult clone(ChangeCreationResult origin) {
                return new ChangeCreationResultImpl(origin);
            }
        });
        dtoFactory.registerProvider(ChangeEnabledState.class, (DtoProvider)new DtoProvider<ChangeEnabledState>(){

            public Class<? extends ChangeEnabledState> getImplClass() {
                return ChangeEnabledStateImpl.class;
            }

            public ChangeEnabledState newInstance() {
                return ChangeEnabledStateImpl.make();
            }

            public ChangeEnabledState fromJson(String json) {
                return ChangeEnabledStateImpl.fromJsonString(json);
            }

            public ChangeEnabledState fromJson(JsonElement json) {
                return ChangeEnabledStateImpl.fromJsonElement(json);
            }

            public ChangeEnabledState clone(ChangeEnabledState origin) {
                return new ChangeEnabledStateImpl(origin);
            }
        });
        dtoFactory.registerProvider(ChangeInfo.class, (DtoProvider)new DtoProvider<ChangeInfo>(){

            public Class<? extends ChangeInfo> getImplClass() {
                return ChangeInfoImpl.class;
            }

            public ChangeInfo newInstance() {
                return ChangeInfoImpl.make();
            }

            public ChangeInfo fromJson(String json) {
                return ChangeInfoImpl.fromJsonString(json);
            }

            public ChangeInfo fromJson(JsonElement json) {
                return ChangeInfoImpl.fromJsonElement(json);
            }

            public ChangeInfo clone(ChangeInfo origin) {
                return new ChangeInfoImpl(origin);
            }
        });
        dtoFactory.registerProvider(ChangePreview.class, (DtoProvider)new DtoProvider<ChangePreview>(){

            public Class<? extends ChangePreview> getImplClass() {
                return ChangePreviewImpl.class;
            }

            public ChangePreview newInstance() {
                return ChangePreviewImpl.make();
            }

            public ChangePreview fromJson(String json) {
                return ChangePreviewImpl.fromJsonString(json);
            }

            public ChangePreview fromJson(JsonElement json) {
                return ChangePreviewImpl.fromJsonElement(json);
            }

            public ChangePreview clone(ChangePreview origin) {
                return new ChangePreviewImpl(origin);
            }
        });
        dtoFactory.registerProvider(CreateMoveRefactoring.class, (DtoProvider)new DtoProvider<CreateMoveRefactoring>(){

            public Class<? extends CreateMoveRefactoring> getImplClass() {
                return CreateMoveRefactoringImpl.class;
            }

            public CreateMoveRefactoring newInstance() {
                return CreateMoveRefactoringImpl.make();
            }

            public CreateMoveRefactoring fromJson(String json) {
                return CreateMoveRefactoringImpl.fromJsonString(json);
            }

            public CreateMoveRefactoring fromJson(JsonElement json) {
                return CreateMoveRefactoringImpl.fromJsonElement(json);
            }

            public CreateMoveRefactoring clone(CreateMoveRefactoring origin) {
                return new CreateMoveRefactoringImpl(origin);
            }
        });
        dtoFactory.registerProvider(CreateRenameRefactoring.class, (DtoProvider)new DtoProvider<CreateRenameRefactoring>(){

            public Class<? extends CreateRenameRefactoring> getImplClass() {
                return CreateRenameRefactoringImpl.class;
            }

            public CreateRenameRefactoring newInstance() {
                return CreateRenameRefactoringImpl.make();
            }

            public CreateRenameRefactoring fromJson(String json) {
                return CreateRenameRefactoringImpl.fromJsonString(json);
            }

            public CreateRenameRefactoring fromJson(JsonElement json) {
                return CreateRenameRefactoringImpl.fromJsonElement(json);
            }

            public CreateRenameRefactoring clone(CreateRenameRefactoring origin) {
                return new CreateRenameRefactoringImpl(origin);
            }
        });
        dtoFactory.registerProvider(ElementToMove.class, (DtoProvider)new DtoProvider<ElementToMove>(){

            public Class<? extends ElementToMove> getImplClass() {
                return ElementToMoveImpl.class;
            }

            public ElementToMove newInstance() {
                return ElementToMoveImpl.make();
            }

            public ElementToMove fromJson(String json) {
                return ElementToMoveImpl.fromJsonString(json);
            }

            public ElementToMove fromJson(JsonElement json) {
                return ElementToMoveImpl.fromJsonElement(json);
            }

            public ElementToMove clone(ElementToMove origin) {
                return new ElementToMoveImpl(origin);
            }
        });
        dtoFactory.registerProvider(LinkedRenameRefactoringApply.class, (DtoProvider)new DtoProvider<LinkedRenameRefactoringApply>(){

            public Class<? extends LinkedRenameRefactoringApply> getImplClass() {
                return LinkedRenameRefactoringApplyImpl.class;
            }

            public LinkedRenameRefactoringApply newInstance() {
                return LinkedRenameRefactoringApplyImpl.make();
            }

            public LinkedRenameRefactoringApply fromJson(String json) {
                return LinkedRenameRefactoringApplyImpl.fromJsonString(json);
            }

            public LinkedRenameRefactoringApply fromJson(JsonElement json) {
                return LinkedRenameRefactoringApplyImpl.fromJsonElement(json);
            }

            public LinkedRenameRefactoringApply clone(LinkedRenameRefactoringApply origin) {
                return new LinkedRenameRefactoringApplyImpl(origin);
            }
        });
        dtoFactory.registerProvider(MoveSettings.class, (DtoProvider)new DtoProvider<MoveSettings>(){

            public Class<? extends MoveSettings> getImplClass() {
                return MoveSettingsImpl.class;
            }

            public MoveSettings newInstance() {
                return MoveSettingsImpl.make();
            }

            public MoveSettings fromJson(String json) {
                return MoveSettingsImpl.fromJsonString(json);
            }

            public MoveSettings fromJson(JsonElement json) {
                return MoveSettingsImpl.fromJsonElement(json);
            }

            public MoveSettings clone(MoveSettings origin) {
                return new MoveSettingsImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringChange.class, (DtoProvider)new DtoProvider<RefactoringChange>(){

            public Class<? extends RefactoringChange> getImplClass() {
                return RefactoringChangeImpl.class;
            }

            public RefactoringChange newInstance() {
                return RefactoringChangeImpl.make();
            }

            public RefactoringChange fromJson(String json) {
                return RefactoringChangeImpl.fromJsonString(json);
            }

            public RefactoringChange fromJson(JsonElement json) {
                return RefactoringChangeImpl.fromJsonElement(json);
            }

            public RefactoringChange clone(RefactoringChange origin) {
                return new RefactoringChangeImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringPreview.class, (DtoProvider)new DtoProvider<RefactoringPreview>(){

            public Class<? extends RefactoringPreview> getImplClass() {
                return RefactoringPreviewImpl.class;
            }

            public RefactoringPreview newInstance() {
                return RefactoringPreviewImpl.make();
            }

            public RefactoringPreview fromJson(String json) {
                return RefactoringPreviewImpl.fromJsonString(json);
            }

            public RefactoringPreview fromJson(JsonElement json) {
                return RefactoringPreviewImpl.fromJsonElement(json);
            }

            public RefactoringPreview clone(RefactoringPreview origin) {
                return new RefactoringPreviewImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringResult.class, (DtoProvider)new DtoProvider<RefactoringResult>(){

            public Class<? extends RefactoringResult> getImplClass() {
                return RefactoringResultImpl.class;
            }

            public RefactoringResult newInstance() {
                return RefactoringResultImpl.make();
            }

            public RefactoringResult fromJson(String json) {
                return RefactoringResultImpl.fromJsonString(json);
            }

            public RefactoringResult fromJson(JsonElement json) {
                return RefactoringResultImpl.fromJsonElement(json);
            }

            public RefactoringResult clone(RefactoringResult origin) {
                return new RefactoringResultImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringSession.class, (DtoProvider)new DtoProvider<RefactoringSession>(){

            public Class<? extends RefactoringSession> getImplClass() {
                return RefactoringSessionImpl.class;
            }

            public RefactoringSession newInstance() {
                return RefactoringSessionImpl.make();
            }

            public RefactoringSession fromJson(String json) {
                return RefactoringSessionImpl.fromJsonString(json);
            }

            public RefactoringSession fromJson(JsonElement json) {
                return RefactoringSessionImpl.fromJsonElement(json);
            }

            public RefactoringSession clone(RefactoringSession origin) {
                return new RefactoringSessionImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringStatus.class, (DtoProvider)new DtoProvider<RefactoringStatus>(){

            public Class<? extends RefactoringStatus> getImplClass() {
                return RefactoringStatusImpl.class;
            }

            public RefactoringStatus newInstance() {
                return RefactoringStatusImpl.make();
            }

            public RefactoringStatus fromJson(String json) {
                return RefactoringStatusImpl.fromJsonString(json);
            }

            public RefactoringStatus fromJson(JsonElement json) {
                return RefactoringStatusImpl.fromJsonElement(json);
            }

            public RefactoringStatus clone(RefactoringStatus origin) {
                return new RefactoringStatusImpl(origin);
            }
        });
        dtoFactory.registerProvider(RefactoringStatusEntry.class, (DtoProvider)new DtoProvider<RefactoringStatusEntry>(){

            public Class<? extends RefactoringStatusEntry> getImplClass() {
                return RefactoringStatusEntryImpl.class;
            }

            public RefactoringStatusEntry newInstance() {
                return RefactoringStatusEntryImpl.make();
            }

            public RefactoringStatusEntry fromJson(String json) {
                return RefactoringStatusEntryImpl.fromJsonString(json);
            }

            public RefactoringStatusEntry fromJson(JsonElement json) {
                return RefactoringStatusEntryImpl.fromJsonElement(json);
            }

            public RefactoringStatusEntry clone(RefactoringStatusEntry origin) {
                return new RefactoringStatusEntryImpl(origin);
            }
        });
        dtoFactory.registerProvider(RenameRefactoringSession.class, (DtoProvider)new DtoProvider<RenameRefactoringSession>(){

            public Class<? extends RenameRefactoringSession> getImplClass() {
                return RenameRefactoringSessionImpl.class;
            }

            public RenameRefactoringSession newInstance() {
                return RenameRefactoringSessionImpl.make();
            }

            public RenameRefactoringSession fromJson(String json) {
                return RenameRefactoringSessionImpl.fromJsonString(json);
            }

            public RenameRefactoringSession fromJson(JsonElement json) {
                return RenameRefactoringSessionImpl.fromJsonElement(json);
            }

            public RenameRefactoringSession clone(RenameRefactoringSession origin) {
                return new RenameRefactoringSessionImpl(origin);
            }
        });
        dtoFactory.registerProvider(RenameSettings.class, (DtoProvider)new DtoProvider<RenameSettings>(){

            public Class<? extends RenameSettings> getImplClass() {
                return RenameSettingsImpl.class;
            }

            public RenameSettings newInstance() {
                return RenameSettingsImpl.make();
            }

            public RenameSettings fromJson(String json) {
                return RenameSettingsImpl.fromJsonString(json);
            }

            public RenameSettings fromJson(JsonElement json) {
                return RenameSettingsImpl.fromJsonElement(json);
            }

            public RenameSettings clone(RenameSettings origin) {
                return new RenameSettingsImpl(origin);
            }
        });
        dtoFactory.registerProvider(ReorgDestination.class, (DtoProvider)new DtoProvider<ReorgDestination>(){

            public Class<? extends ReorgDestination> getImplClass() {
                return ReorgDestinationImpl.class;
            }

            public ReorgDestination newInstance() {
                return ReorgDestinationImpl.make();
            }

            public ReorgDestination fromJson(String json) {
                return ReorgDestinationImpl.fromJsonString(json);
            }

            public ReorgDestination fromJson(JsonElement json) {
                return ReorgDestinationImpl.fromJsonElement(json);
            }

            public ReorgDestination clone(ReorgDestination origin) {
                return new ReorgDestinationImpl(origin);
            }
        });
        dtoFactory.registerProvider(ValidateNewName.class, (DtoProvider)new DtoProvider<ValidateNewName>(){

            public Class<? extends ValidateNewName> getImplClass() {
                return ValidateNewNameImpl.class;
            }

            public ValidateNewName newInstance() {
                return ValidateNewNameImpl.make();
            }

            public ValidateNewName fromJson(String json) {
                return ValidateNewNameImpl.fromJsonString(json);
            }

            public ValidateNewName fromJson(JsonElement json) {
                return ValidateNewNameImpl.fromJsonElement(json);
            }

            public ValidateNewName clone(ValidateNewName origin) {
                return new ValidateNewNameImpl(origin);
            }
        });
        dtoFactory.registerProvider(FindUsagesRequest.class, (DtoProvider)new DtoProvider<FindUsagesRequest>(){

            public Class<? extends FindUsagesRequest> getImplClass() {
                return FindUsagesRequestImpl.class;
            }

            public FindUsagesRequest newInstance() {
                return FindUsagesRequestImpl.make();
            }

            public FindUsagesRequest fromJson(String json) {
                return FindUsagesRequestImpl.fromJsonString(json);
            }

            public FindUsagesRequest fromJson(JsonElement json) {
                return FindUsagesRequestImpl.fromJsonElement(json);
            }

            public FindUsagesRequest clone(FindUsagesRequest origin) {
                return new FindUsagesRequestImpl(origin);
            }
        });
        dtoFactory.registerProvider(FindUsagesResponse.class, (DtoProvider)new DtoProvider<FindUsagesResponse>(){

            public Class<? extends FindUsagesResponse> getImplClass() {
                return FindUsagesResponseImpl.class;
            }

            public FindUsagesResponse newInstance() {
                return FindUsagesResponseImpl.make();
            }

            public FindUsagesResponse fromJson(String json) {
                return FindUsagesResponseImpl.fromJsonString(json);
            }

            public FindUsagesResponse fromJson(JsonElement json) {
                return FindUsagesResponseImpl.fromJsonElement(json);
            }

            public FindUsagesResponse clone(FindUsagesResponse origin) {
                return new FindUsagesResponseImpl(origin);
            }
        });
        dtoFactory.registerProvider(Match.class, (DtoProvider)new DtoProvider<Match>(){

            public Class<? extends Match> getImplClass() {
                return MatchImpl.class;
            }

            public Match newInstance() {
                return MatchImpl.make();
            }

            public Match fromJson(String json) {
                return MatchImpl.fromJsonString(json);
            }

            public Match fromJson(JsonElement json) {
                return MatchImpl.fromJsonElement(json);
            }

            public Match clone(Match origin) {
                return new MatchImpl(origin);
            }
        });
    }

    @DTOImpl(value="server")
    public static class MatchImpl
    implements Match,
    JsonSerializable {
        protected Region matchInLine;
        protected String matchedLine;
        protected int matchLineNumber;
        protected Region fileMatchRegion;

        public static MatchImpl make() {
            return new MatchImpl();
        }

        public MatchImpl() {
        }

        @Override
        public Region getMatchInLine() {
            return this.matchInLine;
        }

        @Override
        public void setMatchInLine(Region v) {
            this.matchInLine = v;
        }

        @Override
        public String getMatchedLine() {
            return this.matchedLine;
        }

        @Override
        public void setMatchedLine(String v) {
            this.matchedLine = v;
        }

        @Override
        public int getMatchLineNumber() {
            return this.matchLineNumber;
        }

        @Override
        public void setMatchLineNumber(int v) {
            this.matchLineNumber = v;
        }

        @Override
        public Region getFileMatchRegion() {
            return this.fileMatchRegion;
        }

        @Override
        public void setFileMatchRegion(Region v) {
            this.fileMatchRegion = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MatchImpl)) {
                return false;
            }
            MatchImpl other = (MatchImpl)o;
            if (this.matchInLine != null ? !this.matchInLine.equals(other.matchInLine) : other.matchInLine != null) {
                return false;
            }
            if (this.matchedLine != null ? !this.matchedLine.equals(other.matchedLine) : other.matchedLine != null) {
                return false;
            }
            if (this.matchLineNumber != other.matchLineNumber) {
                return false;
            }
            return !(this.fileMatchRegion != null ? !this.fileMatchRegion.equals(other.fileMatchRegion) : other.fileMatchRegion != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.matchInLine != null ? this.matchInLine.hashCode() : 0);
            hash = hash * 31 + (this.matchedLine != null ? this.matchedLine.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.matchLineNumber).hashCode();
            hash = hash * 31 + (this.fileMatchRegion != null ? this.fileMatchRegion.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static MatchImpl fromJsonElement(JsonElement jsonElem) {
            return (MatchImpl)gson.fromJson(jsonElem, MatchImpl.class);
        }

        public static MatchImpl fromJsonString(String jsonString) {
            return (MatchImpl)gson.fromJson(jsonString, MatchImpl.class);
        }

        public MatchImpl(Match origin) {
            Region matchInLineIn = origin.getMatchInLine();
            this.matchInLine = matchInLineIn == null ? null : new RegionImpl(matchInLineIn);
            this.matchedLine = origin.getMatchedLine();
            this.matchLineNumber = origin.getMatchLineNumber();
            Region fileMatchRegionIn = origin.getFileMatchRegion();
            this.fileMatchRegion = fileMatchRegionIn == null ? null : new RegionImpl(fileMatchRegionIn);
        }

        public Match withMatchInLine(Region v) {
            this.matchInLine = v;
            return this;
        }

        public Match withMatchedLine(String v) {
            this.matchedLine = v;
            return this;
        }

        public Match withMatchLineNumber(int v) {
            this.matchLineNumber = v;
            return this;
        }

        public Match withFileMatchRegion(Region v) {
            this.fileMatchRegion = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class FindUsagesResponseImpl
    implements FindUsagesResponse,
    JsonSerializable {
        protected List<JavaProject> projects;
        protected Map<String, List<Match>> matches;
        protected String searchElementLabel;

        public static FindUsagesResponseImpl make() {
            return new FindUsagesResponseImpl();
        }

        public FindUsagesResponseImpl() {
        }

        @Override
        public List<JavaProject> getProjects() {
            this.ensureProjects();
            return new JsonArrayImpl(this.projects);
        }

        @Override
        public void setProjects(List<JavaProject> v) {
            this.projects = v;
        }

        public void addProjects(JavaProject v) {
            this.ensureProjects();
            this.projects.add(v);
        }

        public void clearProjects() {
            this.ensureProjects();
            this.projects.clear();
        }

        protected void ensureProjects() {
            if (this.projects == null) {
                this.projects = new ArrayList<JavaProject>();
            }
        }

        @Override
        public Map<String, List<Match>> getMatches() {
            this.ensureMatches();
            return new JsonStringMapImpl(this.matches);
        }

        @Override
        public void setMatches(Map<String, List<Match>> v) {
            this.matches = v;
        }

        public void putMatches(String k, List<Match> v) {
            this.ensureMatches();
            this.matches.put(k, v);
        }

        public void clearMatches() {
            this.ensureMatches();
            this.matches.clear();
        }

        protected void ensureMatches() {
            if (this.matches == null) {
                this.matches = new HashMap<String, List<Match>>();
            }
        }

        @Override
        public String getSearchElementLabel() {
            return this.searchElementLabel;
        }

        @Override
        public void setSearchElementLabel(String v) {
            this.searchElementLabel = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FindUsagesResponseImpl)) {
                return false;
            }
            FindUsagesResponseImpl other = (FindUsagesResponseImpl)o;
            this.ensureProjects();
            other.ensureProjects();
            if (this.projects != null ? !this.projects.equals(other.projects) : other.projects != null) {
                return false;
            }
            this.ensureMatches();
            other.ensureMatches();
            if (this.matches != null ? !this.matches.equals(other.matches) : other.matches != null) {
                return false;
            }
            return !(this.searchElementLabel != null ? !this.searchElementLabel.equals(other.searchElementLabel) : other.searchElementLabel != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureProjects();
            hash = hash * 31 + (this.projects != null ? this.projects.hashCode() : 0);
            this.ensureMatches();
            hash = hash * 31 + (this.matches != null ? this.matches.hashCode() : 0);
            hash = hash * 31 + (this.searchElementLabel != null ? this.searchElementLabel.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static FindUsagesResponseImpl fromJsonElement(JsonElement jsonElem) {
            return (FindUsagesResponseImpl)gson.fromJson(jsonElem, FindUsagesResponseImpl.class);
        }

        public static FindUsagesResponseImpl fromJsonString(String jsonString) {
            return (FindUsagesResponseImpl)gson.fromJson(jsonString, FindUsagesResponseImpl.class);
        }

        public FindUsagesResponseImpl(FindUsagesResponse origin) {
            Map<String, List<Match>> matchesIn;
            List<JavaProject> projectsIn = origin.getProjects();
            if (projectsIn != null) {
                ArrayList<JavaProject> projectsOut = new ArrayList<JavaProject>();
                for (JavaProject projectsIn_ : projectsIn) {
                    projectsOut.add(projectsIn_ == null ? null : new JavaProjectImpl(projectsIn_));
                }
                this.projects = projectsOut;
            }
            if ((matchesIn = origin.getMatches()) != null) {
                HashMap<String, List<Match>> matchesOut = new HashMap<String, List<Match>>();
                for (Map.Entry<String, List<Match>> entry0 : matchesIn.entrySet()) {
                    List<Match> matchesIn_ = entry0.getValue();
                    if (matchesIn_ == null) continue;
                    ArrayList<MatchImpl> matchesOut_ = new ArrayList<MatchImpl>();
                    for (Match matchesIn__ : matchesIn_) {
                        matchesOut_.add(matchesIn__ == null ? null : new MatchImpl(matchesIn__));
                    }
                    matchesOut.put(entry0.getKey(), matchesOut_);
                }
                this.matches = matchesOut;
            }
            this.searchElementLabel = origin.getSearchElementLabel();
        }

        public FindUsagesResponse withProjects(List<JavaProject> v) {
            this.projects = v;
            return this;
        }

        public FindUsagesResponse withMatches(Map<String, List<Match>> v) {
            this.matches = v;
            return this;
        }

        public FindUsagesResponse withSearchElementLabel(String v) {
            this.searchElementLabel = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class FindUsagesRequestImpl
    implements FindUsagesRequest,
    JsonSerializable {
        protected String fQN;
        protected String projectPath;
        protected int offset;

        public static FindUsagesRequestImpl make() {
            return new FindUsagesRequestImpl();
        }

        public FindUsagesRequestImpl() {
        }

        @Override
        public String getFQN() {
            return this.fQN;
        }

        @Override
        public void setFQN(String v) {
            this.fQN = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FindUsagesRequestImpl)) {
                return false;
            }
            FindUsagesRequestImpl other = (FindUsagesRequestImpl)o;
            if (this.fQN != null ? !this.fQN.equals(other.fQN) : other.fQN != null) {
                return false;
            }
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            return this.offset == other.offset;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.fQN != null ? this.fQN.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static FindUsagesRequestImpl fromJsonElement(JsonElement jsonElem) {
            return (FindUsagesRequestImpl)gson.fromJson(jsonElem, FindUsagesRequestImpl.class);
        }

        public static FindUsagesRequestImpl fromJsonString(String jsonString) {
            return (FindUsagesRequestImpl)gson.fromJson(jsonString, FindUsagesRequestImpl.class);
        }

        public FindUsagesRequestImpl(FindUsagesRequest origin) {
            this.fQN = origin.getFQN();
            this.projectPath = origin.getProjectPath();
            this.offset = origin.getOffset();
        }

        public FindUsagesRequest withFQN(String v) {
            this.fQN = v;
            return this;
        }

        public FindUsagesRequest withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public FindUsagesRequest withOffset(int v) {
            this.offset = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ValidateNewNameImpl
    extends RefactoringSessionImpl
    implements ValidateNewName,
    JsonSerializable {
        protected String newName;

        public static ValidateNewNameImpl make() {
            return new ValidateNewNameImpl();
        }

        public ValidateNewNameImpl() {
        }

        @Override
        public String getNewName() {
            return this.newName;
        }

        @Override
        public void setNewName(String v) {
            this.newName = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ValidateNewNameImpl)) {
                return false;
            }
            ValidateNewNameImpl other = (ValidateNewNameImpl)o;
            if (this.newName != null ? !this.newName.equals(other.newName) : other.newName != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.newName != null ? this.newName.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static ValidateNewNameImpl fromJsonElement(JsonElement jsonElem) {
            return (ValidateNewNameImpl)gson.fromJson(jsonElem, ValidateNewNameImpl.class);
        }

        public static ValidateNewNameImpl fromJsonString(String jsonString) {
            return (ValidateNewNameImpl)gson.fromJson(jsonString, ValidateNewNameImpl.class);
        }

        public ValidateNewNameImpl(ValidateNewName origin) {
            this.newName = origin.getNewName();
            this.sessionId = origin.getSessionId();
        }

        public ValidateNewName withNewName(String v) {
            this.newName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ReorgDestinationImpl
    extends RefactoringSessionImpl
    implements ReorgDestination,
    JsonSerializable {
        protected String destination;
        protected ReorgDestination.DestinationType type;
        protected String projectPath;

        public static ReorgDestinationImpl make() {
            return new ReorgDestinationImpl();
        }

        public ReorgDestinationImpl() {
        }

        @Override
        public String getDestination() {
            return this.destination;
        }

        @Override
        public void setDestination(String v) {
            this.destination = v;
        }

        @Override
        public ReorgDestination.DestinationType getType() {
            return this.type;
        }

        @Override
        public void setType(ReorgDestination.DestinationType v) {
            this.type = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ReorgDestinationImpl)) {
                return false;
            }
            ReorgDestinationImpl other = (ReorgDestinationImpl)o;
            if (this.destination != null ? !this.destination.equals(other.destination) : other.destination != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals((Object)other.type) : other.type != null) {
                return false;
            }
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.destination != null ? this.destination.hashCode() : 0);
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static ReorgDestinationImpl fromJsonElement(JsonElement jsonElem) {
            return (ReorgDestinationImpl)gson.fromJson(jsonElem, ReorgDestinationImpl.class);
        }

        public static ReorgDestinationImpl fromJsonString(String jsonString) {
            return (ReorgDestinationImpl)gson.fromJson(jsonString, ReorgDestinationImpl.class);
        }

        public ReorgDestinationImpl(ReorgDestination origin) {
            this.destination = origin.getDestination();
            this.type = origin.getType();
            this.projectPath = origin.getProjectPath();
            this.sessionId = origin.getSessionId();
        }

        public ReorgDestination withDestination(String v) {
            this.destination = v;
            return this;
        }

        public ReorgDestination withType(ReorgDestination.DestinationType v) {
            this.type = v;
            return this;
        }

        public ReorgDestination withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RenameSettingsImpl
    extends RefactoringSessionImpl
    implements RenameSettings,
    JsonSerializable {
        protected boolean deprecateDelegates;
        protected String filePatterns;
        protected int machStrategy;
        protected boolean updateReferences;
        protected boolean updateQualifiedNames;
        protected boolean updateSubpackages;
        protected boolean delegateUpdating;
        protected boolean updateSimilarDeclarations;
        protected boolean updateTextualMatches;

        public static RenameSettingsImpl make() {
            return new RenameSettingsImpl();
        }

        public RenameSettingsImpl() {
        }

        @Override
        public boolean isDeprecateDelegates() {
            return this.deprecateDelegates;
        }

        @Override
        public void setDeprecateDelegates(boolean v) {
            this.deprecateDelegates = v;
        }

        @Override
        public String getFilePatterns() {
            return this.filePatterns;
        }

        @Override
        public void setFilePatterns(String v) {
            this.filePatterns = v;
        }

        @Override
        public int getMachStrategy() {
            return this.machStrategy;
        }

        @Override
        public void setMachStrategy(int v) {
            this.machStrategy = v;
        }

        @Override
        public boolean isUpdateReferences() {
            return this.updateReferences;
        }

        @Override
        public void setUpdateReferences(boolean v) {
            this.updateReferences = v;
        }

        @Override
        public boolean isUpdateQualifiedNames() {
            return this.updateQualifiedNames;
        }

        @Override
        public void setUpdateQualifiedNames(boolean v) {
            this.updateQualifiedNames = v;
        }

        @Override
        public boolean isUpdateSubpackages() {
            return this.updateSubpackages;
        }

        @Override
        public void setUpdateSubpackages(boolean v) {
            this.updateSubpackages = v;
        }

        @Override
        public boolean isDelegateUpdating() {
            return this.delegateUpdating;
        }

        @Override
        public void setDelegateUpdating(boolean v) {
            this.delegateUpdating = v;
        }

        @Override
        public boolean isUpdateSimilarDeclarations() {
            return this.updateSimilarDeclarations;
        }

        @Override
        public void setUpdateSimilarDeclarations(boolean v) {
            this.updateSimilarDeclarations = v;
        }

        @Override
        public boolean isUpdateTextualMatches() {
            return this.updateTextualMatches;
        }

        @Override
        public void setUpdateTextualMatches(boolean v) {
            this.updateTextualMatches = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RenameSettingsImpl)) {
                return false;
            }
            RenameSettingsImpl other = (RenameSettingsImpl)o;
            if (this.deprecateDelegates != other.deprecateDelegates) {
                return false;
            }
            if (this.filePatterns != null ? !this.filePatterns.equals(other.filePatterns) : other.filePatterns != null) {
                return false;
            }
            if (this.machStrategy != other.machStrategy) {
                return false;
            }
            if (this.updateReferences != other.updateReferences) {
                return false;
            }
            if (this.updateQualifiedNames != other.updateQualifiedNames) {
                return false;
            }
            if (this.updateSubpackages != other.updateSubpackages) {
                return false;
            }
            if (this.delegateUpdating != other.delegateUpdating) {
                return false;
            }
            if (this.updateSimilarDeclarations != other.updateSimilarDeclarations) {
                return false;
            }
            if (this.updateTextualMatches != other.updateTextualMatches) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.deprecateDelegates).hashCode();
            hash = hash * 31 + (this.filePatterns != null ? this.filePatterns.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.machStrategy).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateReferences).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateQualifiedNames).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateSubpackages).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.delegateUpdating).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateSimilarDeclarations).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateTextualMatches).hashCode();
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static RenameSettingsImpl fromJsonElement(JsonElement jsonElem) {
            return (RenameSettingsImpl)gson.fromJson(jsonElem, RenameSettingsImpl.class);
        }

        public static RenameSettingsImpl fromJsonString(String jsonString) {
            return (RenameSettingsImpl)gson.fromJson(jsonString, RenameSettingsImpl.class);
        }

        public RenameSettingsImpl(RenameSettings origin) {
            this.deprecateDelegates = origin.isDeprecateDelegates();
            this.filePatterns = origin.getFilePatterns();
            this.machStrategy = origin.getMachStrategy();
            this.updateReferences = origin.isUpdateReferences();
            this.updateQualifiedNames = origin.isUpdateQualifiedNames();
            this.updateSubpackages = origin.isUpdateSubpackages();
            this.delegateUpdating = origin.isDelegateUpdating();
            this.updateSimilarDeclarations = origin.isUpdateSimilarDeclarations();
            this.updateTextualMatches = origin.isUpdateTextualMatches();
            this.sessionId = origin.getSessionId();
        }

        public RenameSettings withDeprecateDelegates(boolean v) {
            this.deprecateDelegates = v;
            return this;
        }

        public RenameSettings withFilePatterns(String v) {
            this.filePatterns = v;
            return this;
        }

        public RenameSettings withMachStrategy(int v) {
            this.machStrategy = v;
            return this;
        }

        public RenameSettings withUpdateReferences(boolean v) {
            this.updateReferences = v;
            return this;
        }

        public RenameSettings withUpdateQualifiedNames(boolean v) {
            this.updateQualifiedNames = v;
            return this;
        }

        public RenameSettings withUpdateSubpackages(boolean v) {
            this.updateSubpackages = v;
            return this;
        }

        public RenameSettings withDelegateUpdating(boolean v) {
            this.delegateUpdating = v;
            return this;
        }

        public RenameSettings withUpdateSimilarDeclarations(boolean v) {
            this.updateSimilarDeclarations = v;
            return this;
        }

        public RenameSettings withUpdateTextualMatches(boolean v) {
            this.updateTextualMatches = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RenameRefactoringSessionImpl
    extends RefactoringSessionImpl
    implements RenameRefactoringSession,
    JsonSerializable {
        protected LinkedModeModel linkedModeModel;
        protected RenameRefactoringSession.RenameWizard wizardType;
        protected String oldName;

        public static RenameRefactoringSessionImpl make() {
            return new RenameRefactoringSessionImpl();
        }

        public RenameRefactoringSessionImpl() {
        }

        @Override
        public LinkedModeModel getLinkedModeModel() {
            return this.linkedModeModel;
        }

        @Override
        public void setLinkedModeModel(LinkedModeModel v) {
            this.linkedModeModel = v;
        }

        @Override
        public RenameRefactoringSession.RenameWizard getWizardType() {
            return this.wizardType;
        }

        @Override
        public void setWizardType(RenameRefactoringSession.RenameWizard v) {
            this.wizardType = v;
        }

        @Override
        public String getOldName() {
            return this.oldName;
        }

        @Override
        public void setOldName(String v) {
            this.oldName = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RenameRefactoringSessionImpl)) {
                return false;
            }
            RenameRefactoringSessionImpl other = (RenameRefactoringSessionImpl)o;
            if (this.linkedModeModel != null ? !this.linkedModeModel.equals(other.linkedModeModel) : other.linkedModeModel != null) {
                return false;
            }
            if (this.wizardType != null ? !this.wizardType.equals((Object)other.wizardType) : other.wizardType != null) {
                return false;
            }
            if (this.oldName != null ? !this.oldName.equals(other.oldName) : other.oldName != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.linkedModeModel != null ? this.linkedModeModel.hashCode() : 0);
            hash = hash * 31 + (this.wizardType != null ? this.wizardType.hashCode() : 0);
            hash = hash * 31 + (this.oldName != null ? this.oldName.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static RenameRefactoringSessionImpl fromJsonElement(JsonElement jsonElem) {
            return (RenameRefactoringSessionImpl)gson.fromJson(jsonElem, RenameRefactoringSessionImpl.class);
        }

        public static RenameRefactoringSessionImpl fromJsonString(String jsonString) {
            return (RenameRefactoringSessionImpl)gson.fromJson(jsonString, RenameRefactoringSessionImpl.class);
        }

        public RenameRefactoringSessionImpl(RenameRefactoringSession origin) {
            LinkedModeModel linkedModeModelIn = origin.getLinkedModeModel();
            this.linkedModeModel = linkedModeModelIn == null ? null : new LinkedModeModelImpl(linkedModeModelIn);
            this.wizardType = origin.getWizardType();
            this.oldName = origin.getOldName();
            this.sessionId = origin.getSessionId();
        }

        public RenameRefactoringSession withLinkedModeModel(LinkedModeModel v) {
            this.linkedModeModel = v;
            return this;
        }

        public RenameRefactoringSession withWizardType(RenameRefactoringSession.RenameWizard v) {
            this.wizardType = v;
            return this;
        }

        public RenameRefactoringSession withOldName(String v) {
            this.oldName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringStatusEntryImpl
    implements RefactoringStatusEntry,
    JsonSerializable {
        protected int severity;
        protected String message;

        public static RefactoringStatusEntryImpl make() {
            return new RefactoringStatusEntryImpl();
        }

        public RefactoringStatusEntryImpl() {
        }

        @Override
        public int getSeverity() {
            return this.severity;
        }

        @Override
        public void setSeverity(int v) {
            this.severity = v;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void setMessage(String v) {
            this.message = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefactoringStatusEntryImpl)) {
                return false;
            }
            RefactoringStatusEntryImpl other = (RefactoringStatusEntryImpl)o;
            if (this.severity != other.severity) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(other.message) : other.message != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.severity).hashCode();
            hash = hash * 31 + (this.message != null ? this.message.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static RefactoringStatusEntryImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringStatusEntryImpl)gson.fromJson(jsonElem, RefactoringStatusEntryImpl.class);
        }

        public static RefactoringStatusEntryImpl fromJsonString(String jsonString) {
            return (RefactoringStatusEntryImpl)gson.fromJson(jsonString, RefactoringStatusEntryImpl.class);
        }

        public RefactoringStatusEntryImpl(RefactoringStatusEntry origin) {
            this.severity = origin.getSeverity();
            this.message = origin.getMessage();
        }

        public RefactoringStatusEntry withSeverity(int v) {
            this.severity = v;
            return this;
        }

        public RefactoringStatusEntry withMessage(String v) {
            this.message = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringStatusImpl
    implements RefactoringStatus,
    JsonSerializable {
        protected int severity;
        protected List<RefactoringStatusEntry> entries;

        public static RefactoringStatusImpl make() {
            return new RefactoringStatusImpl();
        }

        public RefactoringStatusImpl() {
        }

        @Override
        public int getSeverity() {
            return this.severity;
        }

        @Override
        public void setSeverity(int v) {
            this.severity = v;
        }

        @Override
        public List<RefactoringStatusEntry> getEntries() {
            this.ensureEntries();
            return new JsonArrayImpl(this.entries);
        }

        @Override
        public void setEntries(List<RefactoringStatusEntry> v) {
            this.entries = v;
        }

        public void addEntries(RefactoringStatusEntry v) {
            this.ensureEntries();
            this.entries.add(v);
        }

        public void clearEntries() {
            this.ensureEntries();
            this.entries.clear();
        }

        protected void ensureEntries() {
            if (this.entries == null) {
                this.entries = new ArrayList<RefactoringStatusEntry>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefactoringStatusImpl)) {
                return false;
            }
            RefactoringStatusImpl other = (RefactoringStatusImpl)o;
            if (this.severity != other.severity) {
                return false;
            }
            this.ensureEntries();
            other.ensureEntries();
            return !(this.entries != null ? !this.entries.equals(other.entries) : other.entries != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.severity).hashCode();
            this.ensureEntries();
            hash = hash * 31 + (this.entries != null ? this.entries.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static RefactoringStatusImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringStatusImpl)gson.fromJson(jsonElem, RefactoringStatusImpl.class);
        }

        public static RefactoringStatusImpl fromJsonString(String jsonString) {
            return (RefactoringStatusImpl)gson.fromJson(jsonString, RefactoringStatusImpl.class);
        }

        public RefactoringStatusImpl(RefactoringStatus origin) {
            this.severity = origin.getSeverity();
            List<RefactoringStatusEntry> entriesIn = origin.getEntries();
            if (entriesIn != null) {
                ArrayList<RefactoringStatusEntry> entriesOut = new ArrayList<RefactoringStatusEntry>();
                for (RefactoringStatusEntry entriesIn_ : entriesIn) {
                    entriesOut.add(entriesIn_ == null ? null : new RefactoringStatusEntryImpl(entriesIn_));
                }
                this.entries = entriesOut;
            }
        }

        public RefactoringStatus withSeverity(int v) {
            this.severity = v;
            return this;
        }

        public RefactoringStatus withEntries(List<RefactoringStatusEntry> v) {
            this.entries = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringSessionImpl
    implements RefactoringSession,
    JsonSerializable {
        protected String sessionId;

        public static RefactoringSessionImpl make() {
            return new RefactoringSessionImpl();
        }

        public RefactoringSessionImpl() {
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public void setSessionId(String v) {
            this.sessionId = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefactoringSessionImpl)) {
                return false;
            }
            RefactoringSessionImpl other = (RefactoringSessionImpl)o;
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static RefactoringSessionImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringSessionImpl)gson.fromJson(jsonElem, RefactoringSessionImpl.class);
        }

        public static RefactoringSessionImpl fromJsonString(String jsonString) {
            return (RefactoringSessionImpl)gson.fromJson(jsonString, RefactoringSessionImpl.class);
        }

        public RefactoringSessionImpl(RefactoringSession origin) {
            this.sessionId = origin.getSessionId();
        }

        public RefactoringSession withSessionId(String v) {
            this.sessionId = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringResultImpl
    extends RefactoringStatusImpl
    implements RefactoringResult,
    JsonSerializable {
        protected List<ChangeInfo> changes;

        public static RefactoringResultImpl make() {
            return new RefactoringResultImpl();
        }

        public RefactoringResultImpl() {
        }

        @Override
        public List<ChangeInfo> getChanges() {
            this.ensureChanges();
            return new JsonArrayImpl(this.changes);
        }

        @Override
        public void setChanges(List<ChangeInfo> v) {
            this.changes = v;
        }

        public void addChanges(ChangeInfo v) {
            this.ensureChanges();
            this.changes.add(v);
        }

        public void clearChanges() {
            this.ensureChanges();
            this.changes.clear();
        }

        protected void ensureChanges() {
            if (this.changes == null) {
                this.changes = new ArrayList<ChangeInfo>();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RefactoringResultImpl)) {
                return false;
            }
            RefactoringResultImpl other = (RefactoringResultImpl)o;
            this.ensureChanges();
            other.ensureChanges();
            if (this.changes != null ? !this.changes.equals(other.changes) : other.changes != null) {
                return false;
            }
            if (this.severity != other.severity) {
                return false;
            }
            this.ensureEntries();
            other.ensureEntries();
            return !(this.entries != null ? !this.entries.equals(other.entries) : other.entries != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            this.ensureChanges();
            hash = hash * 31 + (this.changes != null ? this.changes.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.severity).hashCode();
            this.ensureEntries();
            hash = hash * 31 + (this.entries != null ? this.entries.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static RefactoringResultImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringResultImpl)gson.fromJson(jsonElem, RefactoringResultImpl.class);
        }

        public static RefactoringResultImpl fromJsonString(String jsonString) {
            return (RefactoringResultImpl)gson.fromJson(jsonString, RefactoringResultImpl.class);
        }

        public RefactoringResultImpl(RefactoringResult origin) {
            List<ChangeInfo> changesIn = origin.getChanges();
            if (changesIn != null) {
                ArrayList<ChangeInfo> changesOut = new ArrayList<ChangeInfo>();
                for (ChangeInfo changesIn_ : changesIn) {
                    changesOut.add(changesIn_ == null ? null : new ChangeInfoImpl(changesIn_));
                }
                this.changes = changesOut;
            }
            this.severity = origin.getSeverity();
            List<RefactoringStatusEntry> entriesIn = origin.getEntries();
            if (entriesIn != null) {
                ArrayList<RefactoringStatusEntryImpl> entriesOut = new ArrayList<RefactoringStatusEntryImpl>();
                for (RefactoringStatusEntry entriesIn_ : entriesIn) {
                    entriesOut.add(entriesIn_ == null ? null : new RefactoringStatusEntryImpl(entriesIn_));
                }
                this.entries = entriesOut;
            }
        }

        public RefactoringResult withChanges(List<ChangeInfo> v) {
            this.changes = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringPreviewImpl
    implements RefactoringPreview,
    JsonSerializable {
        protected List<RefactoringPreview> childrens;
        protected String text;
        protected boolean enabled;
        protected String id;
        protected String image;

        public static RefactoringPreviewImpl make() {
            return new RefactoringPreviewImpl();
        }

        public RefactoringPreviewImpl() {
        }

        @Override
        public List<RefactoringPreview> getChildrens() {
            this.ensureChildrens();
            return new JsonArrayImpl(this.childrens);
        }

        @Override
        public void setChildrens(List<RefactoringPreview> v) {
            this.childrens = v;
        }

        public void addChildrens(RefactoringPreview v) {
            this.ensureChildrens();
            this.childrens.add(v);
        }

        public void clearChildrens() {
            this.ensureChildrens();
            this.childrens.clear();
        }

        protected void ensureChildrens() {
            if (this.childrens == null) {
                this.childrens = new ArrayList<RefactoringPreview>();
            }
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String v) {
            this.text = v;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean v) {
            this.enabled = v;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String v) {
            this.id = v;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public void setImage(String v) {
            this.image = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefactoringPreviewImpl)) {
                return false;
            }
            RefactoringPreviewImpl other = (RefactoringPreviewImpl)o;
            this.ensureChildrens();
            other.ensureChildrens();
            if (this.childrens != null ? !this.childrens.equals(other.childrens) : other.childrens != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(other.text) : other.text != null) {
                return false;
            }
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.id != null ? !this.id.equals(other.id) : other.id != null) {
                return false;
            }
            return !(this.image != null ? !this.image.equals(other.image) : other.image != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureChildrens();
            hash = hash * 31 + (this.childrens != null ? this.childrens.hashCode() : 0);
            hash = hash * 31 + (this.text != null ? this.text.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.enabled).hashCode();
            hash = hash * 31 + (this.id != null ? this.id.hashCode() : 0);
            hash = hash * 31 + (this.image != null ? this.image.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static RefactoringPreviewImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringPreviewImpl)gson.fromJson(jsonElem, RefactoringPreviewImpl.class);
        }

        public static RefactoringPreviewImpl fromJsonString(String jsonString) {
            return (RefactoringPreviewImpl)gson.fromJson(jsonString, RefactoringPreviewImpl.class);
        }

        public RefactoringPreviewImpl(RefactoringPreview origin) {
            List<RefactoringPreview> childrensIn = origin.getChildrens();
            if (childrensIn != null) {
                ArrayList<RefactoringPreview> childrensOut = new ArrayList<RefactoringPreview>();
                for (RefactoringPreview childrensIn_ : childrensIn) {
                    childrensOut.add(childrensIn_ == null ? null : new RefactoringPreviewImpl(childrensIn_));
                }
                this.childrens = childrensOut;
            }
            this.text = origin.getText();
            this.enabled = origin.isEnabled();
            this.id = origin.getId();
            this.image = origin.getImage();
        }

        public RefactoringPreview withChildrens(List<RefactoringPreview> v) {
            this.childrens = v;
            return this;
        }

        public RefactoringPreview withText(String v) {
            this.text = v;
            return this;
        }

        public RefactoringPreview withEnabled(boolean v) {
            this.enabled = v;
            return this;
        }

        public RefactoringPreview withId(String v) {
            this.id = v;
            return this;
        }

        public RefactoringPreview withImage(String v) {
            this.image = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RefactoringChangeImpl
    extends RefactoringSessionImpl
    implements RefactoringChange,
    JsonSerializable {
        protected String changeId;

        public static RefactoringChangeImpl make() {
            return new RefactoringChangeImpl();
        }

        public RefactoringChangeImpl() {
        }

        @Override
        public String getChangeId() {
            return this.changeId;
        }

        @Override
        public void setChangeId(String v) {
            this.changeId = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RefactoringChangeImpl)) {
                return false;
            }
            RefactoringChangeImpl other = (RefactoringChangeImpl)o;
            if (this.changeId != null ? !this.changeId.equals(other.changeId) : other.changeId != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.changeId != null ? this.changeId.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static RefactoringChangeImpl fromJsonElement(JsonElement jsonElem) {
            return (RefactoringChangeImpl)gson.fromJson(jsonElem, RefactoringChangeImpl.class);
        }

        public static RefactoringChangeImpl fromJsonString(String jsonString) {
            return (RefactoringChangeImpl)gson.fromJson(jsonString, RefactoringChangeImpl.class);
        }

        public RefactoringChangeImpl(RefactoringChange origin) {
            this.changeId = origin.getChangeId();
            this.sessionId = origin.getSessionId();
        }

        public RefactoringChange withChangeId(String v) {
            this.changeId = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class MoveSettingsImpl
    extends RefactoringSessionImpl
    implements MoveSettings,
    JsonSerializable {
        protected String filePatterns;
        protected boolean updateReferences;
        protected boolean updateQualifiedNames;

        public static MoveSettingsImpl make() {
            return new MoveSettingsImpl();
        }

        public MoveSettingsImpl() {
        }

        @Override
        public String getFilePatterns() {
            return this.filePatterns;
        }

        @Override
        public void setFilePatterns(String v) {
            this.filePatterns = v;
        }

        @Override
        public boolean isUpdateReferences() {
            return this.updateReferences;
        }

        @Override
        public void setUpdateReferences(boolean v) {
            this.updateReferences = v;
        }

        @Override
        public boolean isUpdateQualifiedNames() {
            return this.updateQualifiedNames;
        }

        @Override
        public void setUpdateQualifiedNames(boolean v) {
            this.updateQualifiedNames = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MoveSettingsImpl)) {
                return false;
            }
            MoveSettingsImpl other = (MoveSettingsImpl)o;
            if (this.filePatterns != null ? !this.filePatterns.equals(other.filePatterns) : other.filePatterns != null) {
                return false;
            }
            if (this.updateReferences != other.updateReferences) {
                return false;
            }
            if (this.updateQualifiedNames != other.updateQualifiedNames) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.filePatterns != null ? this.filePatterns.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.updateReferences).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.updateQualifiedNames).hashCode();
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static MoveSettingsImpl fromJsonElement(JsonElement jsonElem) {
            return (MoveSettingsImpl)gson.fromJson(jsonElem, MoveSettingsImpl.class);
        }

        public static MoveSettingsImpl fromJsonString(String jsonString) {
            return (MoveSettingsImpl)gson.fromJson(jsonString, MoveSettingsImpl.class);
        }

        public MoveSettingsImpl(MoveSettings origin) {
            this.filePatterns = origin.getFilePatterns();
            this.updateReferences = origin.isUpdateReferences();
            this.updateQualifiedNames = origin.isUpdateQualifiedNames();
            this.sessionId = origin.getSessionId();
        }

        public MoveSettings withFilePatterns(String v) {
            this.filePatterns = v;
            return this;
        }

        public MoveSettings withUpdateReferences(boolean v) {
            this.updateReferences = v;
            return this;
        }

        public MoveSettings withUpdateQualifiedNames(boolean v) {
            this.updateQualifiedNames = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class LinkedRenameRefactoringApplyImpl
    extends RefactoringSessionImpl
    implements LinkedRenameRefactoringApply,
    JsonSerializable {
        protected String newName;

        public static LinkedRenameRefactoringApplyImpl make() {
            return new LinkedRenameRefactoringApplyImpl();
        }

        public LinkedRenameRefactoringApplyImpl() {
        }

        @Override
        public String getNewName() {
            return this.newName;
        }

        @Override
        public void setNewName(String v) {
            this.newName = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LinkedRenameRefactoringApplyImpl)) {
                return false;
            }
            LinkedRenameRefactoringApplyImpl other = (LinkedRenameRefactoringApplyImpl)o;
            if (this.newName != null ? !this.newName.equals(other.newName) : other.newName != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.newName != null ? this.newName.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static LinkedRenameRefactoringApplyImpl fromJsonElement(JsonElement jsonElem) {
            return (LinkedRenameRefactoringApplyImpl)gson.fromJson(jsonElem, LinkedRenameRefactoringApplyImpl.class);
        }

        public static LinkedRenameRefactoringApplyImpl fromJsonString(String jsonString) {
            return (LinkedRenameRefactoringApplyImpl)gson.fromJson(jsonString, LinkedRenameRefactoringApplyImpl.class);
        }

        public LinkedRenameRefactoringApplyImpl(LinkedRenameRefactoringApply origin) {
            this.newName = origin.getNewName();
            this.sessionId = origin.getSessionId();
        }

        public LinkedRenameRefactoringApply withNewName(String v) {
            this.newName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ElementToMoveImpl
    implements ElementToMove,
    JsonSerializable {
        protected boolean pack;
        protected String path;

        public static ElementToMoveImpl make() {
            return new ElementToMoveImpl();
        }

        public ElementToMoveImpl() {
        }

        @Override
        public boolean isPack() {
            return this.pack;
        }

        @Override
        public void setPack(boolean v) {
            this.pack = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ElementToMoveImpl)) {
                return false;
            }
            ElementToMoveImpl other = (ElementToMoveImpl)o;
            if (this.pack != other.pack) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.pack).hashCode();
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ElementToMoveImpl fromJsonElement(JsonElement jsonElem) {
            return (ElementToMoveImpl)gson.fromJson(jsonElem, ElementToMoveImpl.class);
        }

        public static ElementToMoveImpl fromJsonString(String jsonString) {
            return (ElementToMoveImpl)gson.fromJson(jsonString, ElementToMoveImpl.class);
        }

        public ElementToMoveImpl(ElementToMove origin) {
            this.pack = origin.isPack();
            this.path = origin.getPath();
        }

        public ElementToMove withPack(boolean v) {
            this.pack = v;
            return this;
        }

        public ElementToMove withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class CreateRenameRefactoringImpl
    implements CreateRenameRefactoring,
    JsonSerializable {
        protected CreateRenameRefactoring.RenameType type;
        protected String projectPath;
        protected boolean refactorLightweight;
        protected int offset;
        protected String path;

        public static CreateRenameRefactoringImpl make() {
            return new CreateRenameRefactoringImpl();
        }

        public CreateRenameRefactoringImpl() {
        }

        @Override
        public CreateRenameRefactoring.RenameType getType() {
            return this.type;
        }

        @Override
        public void setType(CreateRenameRefactoring.RenameType v) {
            this.type = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public boolean isRefactorLightweight() {
            return this.refactorLightweight;
        }

        @Override
        public void setRefactorLightweight(boolean v) {
            this.refactorLightweight = v;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CreateRenameRefactoringImpl)) {
                return false;
            }
            CreateRenameRefactoringImpl other = (CreateRenameRefactoringImpl)o;
            if (this.type != null ? !this.type.equals((Object)other.type) : other.type != null) {
                return false;
            }
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            if (this.refactorLightweight != other.refactorLightweight) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.refactorLightweight).hashCode();
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static CreateRenameRefactoringImpl fromJsonElement(JsonElement jsonElem) {
            return (CreateRenameRefactoringImpl)gson.fromJson(jsonElem, CreateRenameRefactoringImpl.class);
        }

        public static CreateRenameRefactoringImpl fromJsonString(String jsonString) {
            return (CreateRenameRefactoringImpl)gson.fromJson(jsonString, CreateRenameRefactoringImpl.class);
        }

        public CreateRenameRefactoringImpl(CreateRenameRefactoring origin) {
            this.type = origin.getType();
            this.projectPath = origin.getProjectPath();
            this.refactorLightweight = origin.isRefactorLightweight();
            this.offset = origin.getOffset();
            this.path = origin.getPath();
        }

        public CreateRenameRefactoring withType(CreateRenameRefactoring.RenameType v) {
            this.type = v;
            return this;
        }

        public CreateRenameRefactoring withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public CreateRenameRefactoring withRefactorLightweight(boolean v) {
            this.refactorLightweight = v;
            return this;
        }

        public CreateRenameRefactoring withOffset(int v) {
            this.offset = v;
            return this;
        }

        public CreateRenameRefactoring withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class CreateMoveRefactoringImpl
    implements CreateMoveRefactoring,
    JsonSerializable {
        protected List<ElementToMove> elements;
        protected String projectPath;

        public static CreateMoveRefactoringImpl make() {
            return new CreateMoveRefactoringImpl();
        }

        public CreateMoveRefactoringImpl() {
        }

        @Override
        public List<ElementToMove> getElements() {
            this.ensureElements();
            return new JsonArrayImpl(this.elements);
        }

        @Override
        public void setElements(List<ElementToMove> v) {
            this.elements = v;
        }

        public void addElements(ElementToMove v) {
            this.ensureElements();
            this.elements.add(v);
        }

        public void clearElements() {
            this.ensureElements();
            this.elements.clear();
        }

        protected void ensureElements() {
            if (this.elements == null) {
                this.elements = new ArrayList<ElementToMove>();
            }
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CreateMoveRefactoringImpl)) {
                return false;
            }
            CreateMoveRefactoringImpl other = (CreateMoveRefactoringImpl)o;
            this.ensureElements();
            other.ensureElements();
            if (this.elements != null ? !this.elements.equals(other.elements) : other.elements != null) {
                return false;
            }
            return !(this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureElements();
            hash = hash * 31 + (this.elements != null ? this.elements.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static CreateMoveRefactoringImpl fromJsonElement(JsonElement jsonElem) {
            return (CreateMoveRefactoringImpl)gson.fromJson(jsonElem, CreateMoveRefactoringImpl.class);
        }

        public static CreateMoveRefactoringImpl fromJsonString(String jsonString) {
            return (CreateMoveRefactoringImpl)gson.fromJson(jsonString, CreateMoveRefactoringImpl.class);
        }

        public CreateMoveRefactoringImpl(CreateMoveRefactoring origin) {
            List<ElementToMove> elementsIn = origin.getElements();
            if (elementsIn != null) {
                ArrayList<ElementToMove> elementsOut = new ArrayList<ElementToMove>();
                for (ElementToMove elementsIn_ : elementsIn) {
                    elementsOut.add(elementsIn_ == null ? null : new ElementToMoveImpl(elementsIn_));
                }
                this.elements = elementsOut;
            }
            this.projectPath = origin.getProjectPath();
        }

        public CreateMoveRefactoring withElements(List<ElementToMove> v) {
            this.elements = v;
            return this;
        }

        public CreateMoveRefactoring withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ChangePreviewImpl
    implements ChangePreview,
    JsonSerializable {
        protected String oldContent;
        protected String newContent;
        protected String fileName;

        public static ChangePreviewImpl make() {
            return new ChangePreviewImpl();
        }

        public ChangePreviewImpl() {
        }

        @Override
        public String getOldContent() {
            return this.oldContent;
        }

        @Override
        public void setOldContent(String v) {
            this.oldContent = v;
        }

        @Override
        public String getNewContent() {
            return this.newContent;
        }

        @Override
        public void setNewContent(String v) {
            this.newContent = v;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void setFileName(String v) {
            this.fileName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChangePreviewImpl)) {
                return false;
            }
            ChangePreviewImpl other = (ChangePreviewImpl)o;
            if (this.oldContent != null ? !this.oldContent.equals(other.oldContent) : other.oldContent != null) {
                return false;
            }
            if (this.newContent != null ? !this.newContent.equals(other.newContent) : other.newContent != null) {
                return false;
            }
            return !(this.fileName != null ? !this.fileName.equals(other.fileName) : other.fileName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.oldContent != null ? this.oldContent.hashCode() : 0);
            hash = hash * 31 + (this.newContent != null ? this.newContent.hashCode() : 0);
            hash = hash * 31 + (this.fileName != null ? this.fileName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ChangePreviewImpl fromJsonElement(JsonElement jsonElem) {
            return (ChangePreviewImpl)gson.fromJson(jsonElem, ChangePreviewImpl.class);
        }

        public static ChangePreviewImpl fromJsonString(String jsonString) {
            return (ChangePreviewImpl)gson.fromJson(jsonString, ChangePreviewImpl.class);
        }

        public ChangePreviewImpl(ChangePreview origin) {
            this.oldContent = origin.getOldContent();
            this.newContent = origin.getNewContent();
            this.fileName = origin.getFileName();
        }

        public ChangePreview withOldContent(String v) {
            this.oldContent = v;
            return this;
        }

        public ChangePreview withNewContent(String v) {
            this.newContent = v;
            return this;
        }

        public ChangePreview withFileName(String v) {
            this.fileName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ChangeInfoImpl
    implements ChangeInfo,
    JsonSerializable {
        protected ChangeInfo.ChangeName name;
        protected String oldPath;
        protected String path;

        public static ChangeInfoImpl make() {
            return new ChangeInfoImpl();
        }

        public ChangeInfoImpl() {
        }

        @Override
        public ChangeInfo.ChangeName getName() {
            return this.name;
        }

        @Override
        public void setName(ChangeInfo.ChangeName v) {
            this.name = v;
        }

        @Override
        public String getOldPath() {
            return this.oldPath;
        }

        @Override
        public void setOldPath(String v) {
            this.oldPath = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChangeInfoImpl)) {
                return false;
            }
            ChangeInfoImpl other = (ChangeInfoImpl)o;
            if (this.name != null ? !this.name.equals((Object)other.name) : other.name != null) {
                return false;
            }
            if (this.oldPath != null ? !this.oldPath.equals(other.oldPath) : other.oldPath != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            hash = hash * 31 + (this.oldPath != null ? this.oldPath.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ChangeInfoImpl fromJsonElement(JsonElement jsonElem) {
            return (ChangeInfoImpl)gson.fromJson(jsonElem, ChangeInfoImpl.class);
        }

        public static ChangeInfoImpl fromJsonString(String jsonString) {
            return (ChangeInfoImpl)gson.fromJson(jsonString, ChangeInfoImpl.class);
        }

        public ChangeInfoImpl(ChangeInfo origin) {
            this.name = origin.getName();
            this.oldPath = origin.getOldPath();
            this.path = origin.getPath();
        }

        public ChangeInfo withName(ChangeInfo.ChangeName v) {
            this.name = v;
            return this;
        }

        public ChangeInfo withOldPath(String v) {
            this.oldPath = v;
            return this;
        }

        public ChangeInfo withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ChangeEnabledStateImpl
    extends RefactoringChangeImpl
    implements ChangeEnabledState,
    JsonSerializable {
        protected boolean enabled;

        public static ChangeEnabledStateImpl make() {
            return new ChangeEnabledStateImpl();
        }

        public ChangeEnabledStateImpl() {
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean v) {
            this.enabled = v;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ChangeEnabledStateImpl)) {
                return false;
            }
            ChangeEnabledStateImpl other = (ChangeEnabledStateImpl)o;
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.changeId != null ? !this.changeId.equals(other.changeId) : other.changeId != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.enabled).hashCode();
            hash = hash * 31 + (this.changeId != null ? this.changeId.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        @Override
        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        @Override
        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        @Override
        public String toJson() {
            return gson.toJson((Object)this);
        }

        @Override
        public String toString() {
            return this.toJson();
        }

        public static ChangeEnabledStateImpl fromJsonElement(JsonElement jsonElem) {
            return (ChangeEnabledStateImpl)gson.fromJson(jsonElem, ChangeEnabledStateImpl.class);
        }

        public static ChangeEnabledStateImpl fromJsonString(String jsonString) {
            return (ChangeEnabledStateImpl)gson.fromJson(jsonString, ChangeEnabledStateImpl.class);
        }

        public ChangeEnabledStateImpl(ChangeEnabledState origin) {
            this.enabled = origin.isEnabled();
            this.changeId = origin.getChangeId();
            this.sessionId = origin.getSessionId();
        }

        public ChangeEnabledState withEnabled(boolean v) {
            this.enabled = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ChangeCreationResultImpl
    implements ChangeCreationResult,
    JsonSerializable {
        protected boolean canShowPreviewPage;
        protected RefactoringStatus status;

        public static ChangeCreationResultImpl make() {
            return new ChangeCreationResultImpl();
        }

        public ChangeCreationResultImpl() {
        }

        @Override
        public boolean isCanShowPreviewPage() {
            return this.canShowPreviewPage;
        }

        @Override
        public void setCanShowPreviewPage(boolean v) {
            this.canShowPreviewPage = v;
        }

        @Override
        public RefactoringStatus getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(RefactoringStatus v) {
            this.status = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChangeCreationResultImpl)) {
                return false;
            }
            ChangeCreationResultImpl other = (ChangeCreationResultImpl)o;
            if (this.canShowPreviewPage != other.canShowPreviewPage) {
                return false;
            }
            return !(this.status != null ? !this.status.equals(other.status) : other.status != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.canShowPreviewPage).hashCode();
            hash = hash * 31 + (this.status != null ? this.status.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ChangeCreationResultImpl fromJsonElement(JsonElement jsonElem) {
            return (ChangeCreationResultImpl)gson.fromJson(jsonElem, ChangeCreationResultImpl.class);
        }

        public static ChangeCreationResultImpl fromJsonString(String jsonString) {
            return (ChangeCreationResultImpl)gson.fromJson(jsonString, ChangeCreationResultImpl.class);
        }

        public ChangeCreationResultImpl(ChangeCreationResult origin) {
            this.canShowPreviewPage = origin.isCanShowPreviewPage();
            RefactoringStatus statusIn = origin.getStatus();
            this.status = statusIn == null ? null : new RefactoringStatusImpl(statusIn);
        }

        public ChangeCreationResult withCanShowPreviewPage(boolean v) {
            this.canShowPreviewPage = v;
            return this;
        }

        public ChangeCreationResult withStatus(RefactoringStatus v) {
            this.status = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class TypeParameterImpl
    implements TypeParameter,
    JsonSerializable {
        protected String handleIdentifier;
        protected List<String> bounds;
        protected String elementName;

        public static TypeParameterImpl make() {
            return new TypeParameterImpl();
        }

        public TypeParameterImpl() {
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public List<String> getBounds() {
            this.ensureBounds();
            return new JsonArrayImpl(this.bounds);
        }

        @Override
        public void setBounds(List<String> v) {
            this.bounds = v;
        }

        public void addBounds(String v) {
            this.ensureBounds();
            this.bounds.add(v);
        }

        public void clearBounds() {
            this.ensureBounds();
            this.bounds.clear();
        }

        protected void ensureBounds() {
            if (this.bounds == null) {
                this.bounds = new ArrayList<String>();
            }
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TypeParameterImpl)) {
                return false;
            }
            TypeParameterImpl other = (TypeParameterImpl)o;
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            this.ensureBounds();
            other.ensureBounds();
            if (this.bounds != null ? !this.bounds.equals(other.bounds) : other.bounds != null) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            this.ensureBounds();
            hash = hash * 31 + (this.bounds != null ? this.bounds.hashCode() : 0);
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static TypeParameterImpl fromJsonElement(JsonElement jsonElem) {
            return (TypeParameterImpl)gson.fromJson(jsonElem, TypeParameterImpl.class);
        }

        public static TypeParameterImpl fromJsonString(String jsonString) {
            return (TypeParameterImpl)gson.fromJson(jsonString, TypeParameterImpl.class);
        }

        public TypeParameterImpl(TypeParameter origin) {
            this.handleIdentifier = origin.getHandleIdentifier();
            List<String> boundsIn = origin.getBounds();
            if (boundsIn != null) {
                ArrayList<String> boundsOut = new ArrayList<String>();
                for (String boundsIn_ : boundsIn) {
                    boundsOut.add(boundsIn_);
                }
                this.bounds = boundsOut;
            }
            this.elementName = origin.getElementName();
        }

        public TypeParameter withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public TypeParameter withBounds(List<String> v) {
            this.bounds = v;
            return this;
        }

        public TypeParameter withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class TypeImpl
    implements Type,
    JsonSerializable {
        protected String label;
        protected boolean binary;
        protected int libId;
        protected String elementName;
        protected Region fileRegion;
        protected List<Field> fields;
        protected boolean primary;
        protected String handleIdentifier;
        protected List<Type> types;
        protected String rootPath;
        protected int flags;
        protected List<Method> methods;
        protected List<Initializer> initializers;

        public static TypeImpl make() {
            return new TypeImpl();
        }

        public TypeImpl() {
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public boolean isBinary() {
            return this.binary;
        }

        @Override
        public void setBinary(boolean v) {
            this.binary = v;
        }

        @Override
        public int getLibId() {
            return this.libId;
        }

        @Override
        public void setLibId(int v) {
            this.libId = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        @Override
        public Region getFileRegion() {
            return this.fileRegion;
        }

        @Override
        public void setFileRegion(Region v) {
            this.fileRegion = v;
        }

        @Override
        public List<Field> getFields() {
            this.ensureFields();
            return new JsonArrayImpl(this.fields);
        }

        @Override
        public void setFields(List<Field> v) {
            this.fields = v;
        }

        public void addFields(Field v) {
            this.ensureFields();
            this.fields.add(v);
        }

        public void clearFields() {
            this.ensureFields();
            this.fields.clear();
        }

        protected void ensureFields() {
            if (this.fields == null) {
                this.fields = new ArrayList<Field>();
            }
        }

        @Override
        public boolean isPrimary() {
            return this.primary;
        }

        @Override
        public void setPrimary(boolean v) {
            this.primary = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public List<Type> getTypes() {
            this.ensureTypes();
            return new JsonArrayImpl(this.types);
        }

        @Override
        public void setTypes(List<Type> v) {
            this.types = v;
        }

        public void addTypes(Type v) {
            this.ensureTypes();
            this.types.add(v);
        }

        public void clearTypes() {
            this.ensureTypes();
            this.types.clear();
        }

        protected void ensureTypes() {
            if (this.types == null) {
                this.types = new ArrayList<Type>();
            }
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }

        @Override
        public void setRootPath(String v) {
            this.rootPath = v;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int v) {
            this.flags = v;
        }

        @Override
        public List<Method> getMethods() {
            this.ensureMethods();
            return new JsonArrayImpl(this.methods);
        }

        @Override
        public void setMethods(List<Method> v) {
            this.methods = v;
        }

        public void addMethods(Method v) {
            this.ensureMethods();
            this.methods.add(v);
        }

        public void clearMethods() {
            this.ensureMethods();
            this.methods.clear();
        }

        protected void ensureMethods() {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
        }

        @Override
        public List<Initializer> getInitializers() {
            this.ensureInitializers();
            return new JsonArrayImpl(this.initializers);
        }

        @Override
        public void setInitializers(List<Initializer> v) {
            this.initializers = v;
        }

        public void addInitializers(Initializer v) {
            this.ensureInitializers();
            this.initializers.add(v);
        }

        public void clearInitializers() {
            this.ensureInitializers();
            this.initializers.clear();
        }

        protected void ensureInitializers() {
            if (this.initializers == null) {
                this.initializers = new ArrayList<Initializer>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof TypeImpl)) {
                return false;
            }
            TypeImpl other = (TypeImpl)o;
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.binary != other.binary) {
                return false;
            }
            if (this.libId != other.libId) {
                return false;
            }
            if (this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null) {
                return false;
            }
            if (this.fileRegion != null ? !this.fileRegion.equals(other.fileRegion) : other.fileRegion != null) {
                return false;
            }
            this.ensureFields();
            other.ensureFields();
            if (this.fields != null ? !this.fields.equals(other.fields) : other.fields != null) {
                return false;
            }
            if (this.primary != other.primary) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            this.ensureTypes();
            other.ensureTypes();
            if (this.types != null ? !this.types.equals(other.types) : other.types != null) {
                return false;
            }
            if (this.rootPath != null ? !this.rootPath.equals(other.rootPath) : other.rootPath != null) {
                return false;
            }
            if (this.flags != other.flags) {
                return false;
            }
            this.ensureMethods();
            other.ensureMethods();
            if (this.methods != null ? !this.methods.equals(other.methods) : other.methods != null) {
                return false;
            }
            this.ensureInitializers();
            other.ensureInitializers();
            return !(this.initializers != null ? !this.initializers.equals(other.initializers) : other.initializers != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.binary).hashCode();
            hash = hash * 31 + Integer.valueOf(this.libId).hashCode();
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            hash = hash * 31 + (this.fileRegion != null ? this.fileRegion.hashCode() : 0);
            this.ensureFields();
            hash = hash * 31 + (this.fields != null ? this.fields.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.primary).hashCode();
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            this.ensureTypes();
            hash = hash * 31 + (this.types != null ? this.types.hashCode() : 0);
            hash = hash * 31 + (this.rootPath != null ? this.rootPath.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.flags).hashCode();
            this.ensureMethods();
            hash = hash * 31 + (this.methods != null ? this.methods.hashCode() : 0);
            this.ensureInitializers();
            hash = hash * 31 + (this.initializers != null ? this.initializers.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static TypeImpl fromJsonElement(JsonElement jsonElem) {
            return (TypeImpl)gson.fromJson(jsonElem, TypeImpl.class);
        }

        public static TypeImpl fromJsonString(String jsonString) {
            return (TypeImpl)gson.fromJson(jsonString, TypeImpl.class);
        }

        public TypeImpl(Type origin) {
            List<Initializer> list;
            this.label = origin.getLabel();
            this.binary = origin.isBinary();
            this.libId = origin.getLibId();
            this.elementName = origin.getElementName();
            Region fileRegionIn = origin.getFileRegion();
            this.fileRegion = fileRegionIn == null ? null : new RegionImpl(fileRegionIn);
            List<Field> fieldsIn = origin.getFields();
            if (fieldsIn != null) {
                ArrayList<Field> fieldsOut = new ArrayList<Field>();
                for (Field field : fieldsIn) {
                    fieldsOut.add(field == null ? null : new FieldImpl(field));
                }
                this.fields = fieldsOut;
            }
            this.primary = origin.isPrimary();
            this.handleIdentifier = origin.getHandleIdentifier();
            List<Type> typesIn = origin.getTypes();
            if (typesIn != null) {
                ArrayList<Type> typesOut = new ArrayList<Type>();
                for (Type type : typesIn) {
                    typesOut.add(type == null ? null : new TypeImpl(type));
                }
                this.types = typesOut;
            }
            this.rootPath = origin.getRootPath();
            this.flags = origin.getFlags();
            List<Method> methodsIn = origin.getMethods();
            if (methodsIn != null) {
                ArrayList<Method> arrayList = new ArrayList<Method>();
                for (Method methodsIn_ : methodsIn) {
                    arrayList.add(methodsIn_ == null ? null : new MethodImpl(methodsIn_));
                }
                this.methods = arrayList;
            }
            if ((list = origin.getInitializers()) != null) {
                ArrayList<Initializer> arrayList = new ArrayList<Initializer>();
                for (Initializer initializersIn_ : list) {
                    arrayList.add(initializersIn_ == null ? null : new InitializerImpl(initializersIn_));
                }
                this.initializers = arrayList;
            }
        }

        public Type withLabel(String v) {
            this.label = v;
            return this;
        }

        public Type withBinary(boolean v) {
            this.binary = v;
            return this;
        }

        public Type withLibId(int v) {
            this.libId = v;
            return this;
        }

        public Type withElementName(String v) {
            this.elementName = v;
            return this;
        }

        public Type withFileRegion(Region v) {
            this.fileRegion = v;
            return this;
        }

        public Type withFields(List<Field> v) {
            this.fields = v;
            return this;
        }

        public Type withPrimary(boolean v) {
            this.primary = v;
            return this;
        }

        public Type withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public Type withTypes(List<Type> v) {
            this.types = v;
            return this;
        }

        public Type withRootPath(String v) {
            this.rootPath = v;
            return this;
        }

        public Type withFlags(int v) {
            this.flags = v;
            return this;
        }

        public Type withMethods(List<Method> v) {
            this.methods = v;
            return this;
        }

        public Type withInitializers(List<Initializer> v) {
            this.initializers = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class PackageFragmentRootImpl
    implements PackageFragmentRoot,
    JsonSerializable {
        protected String projectPath;
        protected String handleIdentifier;
        protected String path;
        protected int kind;
        protected List<PackageFragment> packageFragments;
        protected String elementName;

        public static PackageFragmentRootImpl make() {
            return new PackageFragmentRootImpl();
        }

        public PackageFragmentRootImpl() {
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        @Override
        public int getKind() {
            return this.kind;
        }

        @Override
        public void setKind(int v) {
            this.kind = v;
        }

        @Override
        public List<PackageFragment> getPackageFragments() {
            this.ensurePackageFragments();
            return new JsonArrayImpl(this.packageFragments);
        }

        @Override
        public void setPackageFragments(List<PackageFragment> v) {
            this.packageFragments = v;
        }

        public void addPackageFragments(PackageFragment v) {
            this.ensurePackageFragments();
            this.packageFragments.add(v);
        }

        public void clearPackageFragments() {
            this.ensurePackageFragments();
            this.packageFragments.clear();
        }

        protected void ensurePackageFragments() {
            if (this.packageFragments == null) {
                this.packageFragments = new ArrayList<PackageFragment>();
            }
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PackageFragmentRootImpl)) {
                return false;
            }
            PackageFragmentRootImpl other = (PackageFragmentRootImpl)o;
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            this.ensurePackageFragments();
            other.ensurePackageFragments();
            if (this.packageFragments != null ? !this.packageFragments.equals(other.packageFragments) : other.packageFragments != null) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.kind).hashCode();
            this.ensurePackageFragments();
            hash = hash * 31 + (this.packageFragments != null ? this.packageFragments.hashCode() : 0);
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static PackageFragmentRootImpl fromJsonElement(JsonElement jsonElem) {
            return (PackageFragmentRootImpl)gson.fromJson(jsonElem, PackageFragmentRootImpl.class);
        }

        public static PackageFragmentRootImpl fromJsonString(String jsonString) {
            return (PackageFragmentRootImpl)gson.fromJson(jsonString, PackageFragmentRootImpl.class);
        }

        public PackageFragmentRootImpl(PackageFragmentRoot origin) {
            this.projectPath = origin.getProjectPath();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.path = origin.getPath();
            this.kind = origin.getKind();
            List<PackageFragment> packageFragmentsIn = origin.getPackageFragments();
            if (packageFragmentsIn != null) {
                ArrayList<PackageFragment> packageFragmentsOut = new ArrayList<PackageFragment>();
                for (PackageFragment packageFragmentsIn_ : packageFragmentsIn) {
                    packageFragmentsOut.add(packageFragmentsIn_ == null ? null : new PackageFragmentImpl(packageFragmentsIn_));
                }
                this.packageFragments = packageFragmentsOut;
            }
            this.elementName = origin.getElementName();
        }

        public PackageFragmentRoot withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public PackageFragmentRoot withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public PackageFragmentRoot withPath(String v) {
            this.path = v;
            return this;
        }

        public PackageFragmentRoot withKind(int v) {
            this.kind = v;
            return this;
        }

        public PackageFragmentRoot withPackageFragments(List<PackageFragment> v) {
            this.packageFragments = v;
            return this;
        }

        public PackageFragmentRoot withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class PackageFragmentImpl
    implements PackageFragment,
    JsonSerializable {
        protected String projectPath;
        protected String handleIdentifier;
        protected String path;
        protected boolean defaultPackage;
        protected int kind;
        protected List<CompilationUnit> compilationUnits;
        protected List<ClassFile> classFiles;
        protected String elementName;

        public static PackageFragmentImpl make() {
            return new PackageFragmentImpl();
        }

        public PackageFragmentImpl() {
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        @Override
        public boolean isDefaultPackage() {
            return this.defaultPackage;
        }

        @Override
        public void setDefaultPackage(boolean v) {
            this.defaultPackage = v;
        }

        @Override
        public int getKind() {
            return this.kind;
        }

        @Override
        public void setKind(int v) {
            this.kind = v;
        }

        @Override
        public List<CompilationUnit> getCompilationUnits() {
            this.ensureCompilationUnits();
            return new JsonArrayImpl(this.compilationUnits);
        }

        @Override
        public void setCompilationUnits(List<CompilationUnit> v) {
            this.compilationUnits = v;
        }

        public void addCompilationUnits(CompilationUnit v) {
            this.ensureCompilationUnits();
            this.compilationUnits.add(v);
        }

        public void clearCompilationUnits() {
            this.ensureCompilationUnits();
            this.compilationUnits.clear();
        }

        protected void ensureCompilationUnits() {
            if (this.compilationUnits == null) {
                this.compilationUnits = new ArrayList<CompilationUnit>();
            }
        }

        @Override
        public List<ClassFile> getClassFiles() {
            this.ensureClassFiles();
            return new JsonArrayImpl(this.classFiles);
        }

        @Override
        public void setClassFiles(List<ClassFile> v) {
            this.classFiles = v;
        }

        public void addClassFiles(ClassFile v) {
            this.ensureClassFiles();
            this.classFiles.add(v);
        }

        public void clearClassFiles() {
            this.ensureClassFiles();
            this.classFiles.clear();
        }

        protected void ensureClassFiles() {
            if (this.classFiles == null) {
                this.classFiles = new ArrayList<ClassFile>();
            }
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PackageFragmentImpl)) {
                return false;
            }
            PackageFragmentImpl other = (PackageFragmentImpl)o;
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
                return false;
            }
            if (this.defaultPackage != other.defaultPackage) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            this.ensureCompilationUnits();
            other.ensureCompilationUnits();
            if (this.compilationUnits != null ? !this.compilationUnits.equals(other.compilationUnits) : other.compilationUnits != null) {
                return false;
            }
            this.ensureClassFiles();
            other.ensureClassFiles();
            if (this.classFiles != null ? !this.classFiles.equals(other.classFiles) : other.classFiles != null) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.defaultPackage).hashCode();
            hash = hash * 31 + Integer.valueOf(this.kind).hashCode();
            this.ensureCompilationUnits();
            hash = hash * 31 + (this.compilationUnits != null ? this.compilationUnits.hashCode() : 0);
            this.ensureClassFiles();
            hash = hash * 31 + (this.classFiles != null ? this.classFiles.hashCode() : 0);
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static PackageFragmentImpl fromJsonElement(JsonElement jsonElem) {
            return (PackageFragmentImpl)gson.fromJson(jsonElem, PackageFragmentImpl.class);
        }

        public static PackageFragmentImpl fromJsonString(String jsonString) {
            return (PackageFragmentImpl)gson.fromJson(jsonString, PackageFragmentImpl.class);
        }

        public PackageFragmentImpl(PackageFragment origin) {
            List<ClassFile> classFilesIn;
            this.projectPath = origin.getProjectPath();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.path = origin.getPath();
            this.defaultPackage = origin.isDefaultPackage();
            this.kind = origin.getKind();
            List<CompilationUnit> compilationUnitsIn = origin.getCompilationUnits();
            if (compilationUnitsIn != null) {
                ArrayList<CompilationUnit> compilationUnitsOut = new ArrayList<CompilationUnit>();
                for (CompilationUnit compilationUnitsIn_ : compilationUnitsIn) {
                    compilationUnitsOut.add(compilationUnitsIn_ == null ? null : new CompilationUnitImpl(compilationUnitsIn_));
                }
                this.compilationUnits = compilationUnitsOut;
            }
            if ((classFilesIn = origin.getClassFiles()) != null) {
                ArrayList<ClassFile> classFilesOut = new ArrayList<ClassFile>();
                for (ClassFile classFilesIn_ : classFilesIn) {
                    classFilesOut.add(classFilesIn_ == null ? null : new ClassFileImpl(classFilesIn_));
                }
                this.classFiles = classFilesOut;
            }
            this.elementName = origin.getElementName();
        }

        public PackageFragment withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public PackageFragment withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public PackageFragment withPath(String v) {
            this.path = v;
            return this;
        }

        public PackageFragment withDefaultPackage(boolean v) {
            this.defaultPackage = v;
            return this;
        }

        public PackageFragment withKind(int v) {
            this.kind = v;
            return this;
        }

        public PackageFragment withCompilationUnits(List<CompilationUnit> v) {
            this.compilationUnits = v;
            return this;
        }

        public PackageFragment withClassFiles(List<ClassFile> v) {
            this.classFiles = v;
            return this;
        }

        public PackageFragment withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class MethodParametersImpl
    implements MethodParameters,
    JsonSerializable {
        protected String methodName;
        protected String parameters;

        public static MethodParametersImpl make() {
            return new MethodParametersImpl();
        }

        public MethodParametersImpl() {
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public void setMethodName(String v) {
            this.methodName = v;
        }

        @Override
        public String getParameters() {
            return this.parameters;
        }

        @Override
        public void setParameters(String v) {
            this.parameters = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodParametersImpl)) {
                return false;
            }
            MethodParametersImpl other = (MethodParametersImpl)o;
            if (this.methodName != null ? !this.methodName.equals(other.methodName) : other.methodName != null) {
                return false;
            }
            return !(this.parameters != null ? !this.parameters.equals(other.parameters) : other.parameters != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.methodName != null ? this.methodName.hashCode() : 0);
            hash = hash * 31 + (this.parameters != null ? this.parameters.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static MethodParametersImpl fromJsonElement(JsonElement jsonElem) {
            return (MethodParametersImpl)gson.fromJson(jsonElem, MethodParametersImpl.class);
        }

        public static MethodParametersImpl fromJsonString(String jsonString) {
            return (MethodParametersImpl)gson.fromJson(jsonString, MethodParametersImpl.class);
        }

        public MethodParametersImpl(MethodParameters origin) {
            this.methodName = origin.getMethodName();
            this.parameters = origin.getParameters();
        }

        public MethodParameters withMethodName(String v) {
            this.methodName = v;
            return this;
        }

        public MethodParameters withParameters(String v) {
            this.parameters = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class MethodImpl
    implements Method,
    JsonSerializable {
        protected Region fileRegion;
        protected String label;
        protected String returnType;
        protected String handleIdentifier;
        protected boolean binary;
        protected int libId;
        protected String rootPath;
        protected int flags;
        protected String elementName;

        public static MethodImpl make() {
            return new MethodImpl();
        }

        public MethodImpl() {
        }

        @Override
        public Region getFileRegion() {
            return this.fileRegion;
        }

        @Override
        public void setFileRegion(Region v) {
            this.fileRegion = v;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public String getReturnType() {
            return this.returnType;
        }

        @Override
        public void setReturnType(String v) {
            this.returnType = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public boolean isBinary() {
            return this.binary;
        }

        @Override
        public void setBinary(boolean v) {
            this.binary = v;
        }

        @Override
        public int getLibId() {
            return this.libId;
        }

        @Override
        public void setLibId(int v) {
            this.libId = v;
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }

        @Override
        public void setRootPath(String v) {
            this.rootPath = v;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int v) {
            this.flags = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodImpl)) {
                return false;
            }
            MethodImpl other = (MethodImpl)o;
            if (this.fileRegion != null ? !this.fileRegion.equals(other.fileRegion) : other.fileRegion != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.returnType != null ? !this.returnType.equals(other.returnType) : other.returnType != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.binary != other.binary) {
                return false;
            }
            if (this.libId != other.libId) {
                return false;
            }
            if (this.rootPath != null ? !this.rootPath.equals(other.rootPath) : other.rootPath != null) {
                return false;
            }
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.fileRegion != null ? this.fileRegion.hashCode() : 0);
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.returnType != null ? this.returnType.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.binary).hashCode();
            hash = hash * 31 + Integer.valueOf(this.libId).hashCode();
            hash = hash * 31 + (this.rootPath != null ? this.rootPath.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.flags).hashCode();
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static MethodImpl fromJsonElement(JsonElement jsonElem) {
            return (MethodImpl)gson.fromJson(jsonElem, MethodImpl.class);
        }

        public static MethodImpl fromJsonString(String jsonString) {
            return (MethodImpl)gson.fromJson(jsonString, MethodImpl.class);
        }

        public MethodImpl(Method origin) {
            Region fileRegionIn = origin.getFileRegion();
            this.fileRegion = fileRegionIn == null ? null : new RegionImpl(fileRegionIn);
            this.label = origin.getLabel();
            this.returnType = origin.getReturnType();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.binary = origin.isBinary();
            this.libId = origin.getLibId();
            this.rootPath = origin.getRootPath();
            this.flags = origin.getFlags();
            this.elementName = origin.getElementName();
        }

        public Method withFileRegion(Region v) {
            this.fileRegion = v;
            return this;
        }

        public Method withLabel(String v) {
            this.label = v;
            return this;
        }

        public Method withReturnType(String v) {
            this.returnType = v;
            return this;
        }

        public Method withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public Method withBinary(boolean v) {
            this.binary = v;
            return this;
        }

        public Method withLibId(int v) {
            this.libId = v;
            return this;
        }

        public Method withRootPath(String v) {
            this.rootPath = v;
            return this;
        }

        public Method withFlags(int v) {
            this.flags = v;
            return this;
        }

        public Method withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class JavaProjectImpl
    implements JavaProject,
    JsonSerializable {
        protected String name;
        protected List<PackageFragmentRoot> packageFragmentRoots;
        protected String path;

        public static JavaProjectImpl make() {
            return new JavaProjectImpl();
        }

        public JavaProjectImpl() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String v) {
            this.name = v;
        }

        @Override
        public List<PackageFragmentRoot> getPackageFragmentRoots() {
            this.ensurePackageFragmentRoots();
            return new JsonArrayImpl(this.packageFragmentRoots);
        }

        @Override
        public void setPackageFragmentRoots(List<PackageFragmentRoot> v) {
            this.packageFragmentRoots = v;
        }

        public void addPackageFragmentRoots(PackageFragmentRoot v) {
            this.ensurePackageFragmentRoots();
            this.packageFragmentRoots.add(v);
        }

        public void clearPackageFragmentRoots() {
            this.ensurePackageFragmentRoots();
            this.packageFragmentRoots.clear();
        }

        protected void ensurePackageFragmentRoots() {
            if (this.packageFragmentRoots == null) {
                this.packageFragmentRoots = new ArrayList<PackageFragmentRoot>();
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JavaProjectImpl)) {
                return false;
            }
            JavaProjectImpl other = (JavaProjectImpl)o;
            if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
                return false;
            }
            this.ensurePackageFragmentRoots();
            other.ensurePackageFragmentRoots();
            if (this.packageFragmentRoots != null ? !this.packageFragmentRoots.equals(other.packageFragmentRoots) : other.packageFragmentRoots != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            this.ensurePackageFragmentRoots();
            hash = hash * 31 + (this.packageFragmentRoots != null ? this.packageFragmentRoots.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static JavaProjectImpl fromJsonElement(JsonElement jsonElem) {
            return (JavaProjectImpl)gson.fromJson(jsonElem, JavaProjectImpl.class);
        }

        public static JavaProjectImpl fromJsonString(String jsonString) {
            return (JavaProjectImpl)gson.fromJson(jsonString, JavaProjectImpl.class);
        }

        public JavaProjectImpl(JavaProject origin) {
            this.name = origin.getName();
            List<PackageFragmentRoot> packageFragmentRootsIn = origin.getPackageFragmentRoots();
            if (packageFragmentRootsIn != null) {
                ArrayList<PackageFragmentRoot> packageFragmentRootsOut = new ArrayList<PackageFragmentRoot>();
                for (PackageFragmentRoot packageFragmentRootsIn_ : packageFragmentRootsIn) {
                    packageFragmentRootsOut.add(packageFragmentRootsIn_ == null ? null : new PackageFragmentRootImpl(packageFragmentRootsIn_));
                }
                this.packageFragmentRoots = packageFragmentRootsOut;
            }
            this.path = origin.getPath();
        }

        public JavaProject withName(String v) {
            this.name = v;
            return this;
        }

        public JavaProject withPackageFragmentRoots(List<PackageFragmentRoot> v) {
            this.packageFragmentRoots = v;
            return this;
        }

        public JavaProject withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class InitializerImpl
    implements Initializer,
    JsonSerializable {
        protected Region fileRegion;
        protected String label;
        protected String handleIdentifier;
        protected boolean binary;
        protected int libId;
        protected String rootPath;
        protected int flags;
        protected String elementName;

        public static InitializerImpl make() {
            return new InitializerImpl();
        }

        public InitializerImpl() {
        }

        @Override
        public Region getFileRegion() {
            return this.fileRegion;
        }

        @Override
        public void setFileRegion(Region v) {
            this.fileRegion = v;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public boolean isBinary() {
            return this.binary;
        }

        @Override
        public void setBinary(boolean v) {
            this.binary = v;
        }

        @Override
        public int getLibId() {
            return this.libId;
        }

        @Override
        public void setLibId(int v) {
            this.libId = v;
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }

        @Override
        public void setRootPath(String v) {
            this.rootPath = v;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int v) {
            this.flags = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof InitializerImpl)) {
                return false;
            }
            InitializerImpl other = (InitializerImpl)o;
            if (this.fileRegion != null ? !this.fileRegion.equals(other.fileRegion) : other.fileRegion != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.binary != other.binary) {
                return false;
            }
            if (this.libId != other.libId) {
                return false;
            }
            if (this.rootPath != null ? !this.rootPath.equals(other.rootPath) : other.rootPath != null) {
                return false;
            }
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.fileRegion != null ? this.fileRegion.hashCode() : 0);
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.binary).hashCode();
            hash = hash * 31 + Integer.valueOf(this.libId).hashCode();
            hash = hash * 31 + (this.rootPath != null ? this.rootPath.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.flags).hashCode();
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static InitializerImpl fromJsonElement(JsonElement jsonElem) {
            return (InitializerImpl)gson.fromJson(jsonElem, InitializerImpl.class);
        }

        public static InitializerImpl fromJsonString(String jsonString) {
            return (InitializerImpl)gson.fromJson(jsonString, InitializerImpl.class);
        }

        public InitializerImpl(Initializer origin) {
            Region fileRegionIn = origin.getFileRegion();
            this.fileRegion = fileRegionIn == null ? null : new RegionImpl(fileRegionIn);
            this.label = origin.getLabel();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.binary = origin.isBinary();
            this.libId = origin.getLibId();
            this.rootPath = origin.getRootPath();
            this.flags = origin.getFlags();
            this.elementName = origin.getElementName();
        }

        public Initializer withFileRegion(Region v) {
            this.fileRegion = v;
            return this;
        }

        public Initializer withLabel(String v) {
            this.label = v;
            return this;
        }

        public Initializer withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public Initializer withBinary(boolean v) {
            this.binary = v;
            return this;
        }

        public Initializer withLibId(int v) {
            this.libId = v;
            return this;
        }

        public Initializer withRootPath(String v) {
            this.rootPath = v;
            return this;
        }

        public Initializer withFlags(int v) {
            this.flags = v;
            return this;
        }

        public Initializer withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ImportDeclarationImpl
    implements ImportDeclaration,
    JsonSerializable {
        protected String handleIdentifier;
        protected int flags;
        protected String elementName;

        public static ImportDeclarationImpl make() {
            return new ImportDeclarationImpl();
        }

        public ImportDeclarationImpl() {
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int v) {
            this.flags = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImportDeclarationImpl)) {
                return false;
            }
            ImportDeclarationImpl other = (ImportDeclarationImpl)o;
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.flags).hashCode();
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ImportDeclarationImpl fromJsonElement(JsonElement jsonElem) {
            return (ImportDeclarationImpl)gson.fromJson(jsonElem, ImportDeclarationImpl.class);
        }

        public static ImportDeclarationImpl fromJsonString(String jsonString) {
            return (ImportDeclarationImpl)gson.fromJson(jsonString, ImportDeclarationImpl.class);
        }

        public ImportDeclarationImpl(ImportDeclaration origin) {
            this.handleIdentifier = origin.getHandleIdentifier();
            this.flags = origin.getFlags();
            this.elementName = origin.getElementName();
        }

        public ImportDeclaration withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public ImportDeclaration withFlags(int v) {
            this.flags = v;
            return this;
        }

        public ImportDeclaration withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class FieldImpl
    implements Field,
    JsonSerializable {
        protected Region fileRegion;
        protected String label;
        protected String handleIdentifier;
        protected boolean binary;
        protected int libId;
        protected String rootPath;
        protected int flags;
        protected String elementName;

        public static FieldImpl make() {
            return new FieldImpl();
        }

        public FieldImpl() {
        }

        @Override
        public Region getFileRegion() {
            return this.fileRegion;
        }

        @Override
        public void setFileRegion(Region v) {
            this.fileRegion = v;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public boolean isBinary() {
            return this.binary;
        }

        @Override
        public void setBinary(boolean v) {
            this.binary = v;
        }

        @Override
        public int getLibId() {
            return this.libId;
        }

        @Override
        public void setLibId(int v) {
            this.libId = v;
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }

        @Override
        public void setRootPath(String v) {
            this.rootPath = v;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public void setFlags(int v) {
            this.flags = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldImpl)) {
                return false;
            }
            FieldImpl other = (FieldImpl)o;
            if (this.fileRegion != null ? !this.fileRegion.equals(other.fileRegion) : other.fileRegion != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.binary != other.binary) {
                return false;
            }
            if (this.libId != other.libId) {
                return false;
            }
            if (this.rootPath != null ? !this.rootPath.equals(other.rootPath) : other.rootPath != null) {
                return false;
            }
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.fileRegion != null ? this.fileRegion.hashCode() : 0);
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.binary).hashCode();
            hash = hash * 31 + Integer.valueOf(this.libId).hashCode();
            hash = hash * 31 + (this.rootPath != null ? this.rootPath.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.flags).hashCode();
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static FieldImpl fromJsonElement(JsonElement jsonElem) {
            return (FieldImpl)gson.fromJson(jsonElem, FieldImpl.class);
        }

        public static FieldImpl fromJsonString(String jsonString) {
            return (FieldImpl)gson.fromJson(jsonString, FieldImpl.class);
        }

        public FieldImpl(Field origin) {
            Region fileRegionIn = origin.getFileRegion();
            this.fileRegion = fileRegionIn == null ? null : new RegionImpl(fileRegionIn);
            this.label = origin.getLabel();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.binary = origin.isBinary();
            this.libId = origin.getLibId();
            this.rootPath = origin.getRootPath();
            this.flags = origin.getFlags();
            this.elementName = origin.getElementName();
        }

        public Field withFileRegion(Region v) {
            this.fileRegion = v;
            return this;
        }

        public Field withLabel(String v) {
            this.label = v;
            return this;
        }

        public Field withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public Field withBinary(boolean v) {
            this.binary = v;
            return this;
        }

        public Field withLibId(int v) {
            this.libId = v;
            return this;
        }

        public Field withRootPath(String v) {
            this.rootPath = v;
            return this;
        }

        public Field withFlags(int v) {
            this.flags = v;
            return this;
        }

        public Field withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class CompilationUnitImpl
    implements CompilationUnit,
    JsonSerializable {
        protected List<ImportDeclaration> imports;
        protected String label;
        protected String projectPath;
        protected String handleIdentifier;
        protected String path;
        protected List<Type> types;
        protected List<Type> superTypes;
        protected String elementName;

        public static CompilationUnitImpl make() {
            return new CompilationUnitImpl();
        }

        public CompilationUnitImpl() {
        }

        @Override
        public List<ImportDeclaration> getImports() {
            this.ensureImports();
            return new JsonArrayImpl(this.imports);
        }

        @Override
        public void setImports(List<ImportDeclaration> v) {
            this.imports = v;
        }

        public void addImports(ImportDeclaration v) {
            this.ensureImports();
            this.imports.add(v);
        }

        public void clearImports() {
            this.ensureImports();
            this.imports.clear();
        }

        protected void ensureImports() {
            if (this.imports == null) {
                this.imports = new ArrayList<ImportDeclaration>();
            }
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        @Override
        public List<Type> getTypes() {
            this.ensureTypes();
            return new JsonArrayImpl(this.types);
        }

        @Override
        public void setTypes(List<Type> v) {
            this.types = v;
        }

        public void addTypes(Type v) {
            this.ensureTypes();
            this.types.add(v);
        }

        public void clearTypes() {
            this.ensureTypes();
            this.types.clear();
        }

        protected void ensureTypes() {
            if (this.types == null) {
                this.types = new ArrayList<Type>();
            }
        }

        @Override
        public List<Type> getSuperTypes() {
            this.ensureSuperTypes();
            return new JsonArrayImpl(this.superTypes);
        }

        @Override
        public void setSuperTypes(List<Type> v) {
            this.superTypes = v;
        }

        public void addSuperTypes(Type v) {
            this.ensureSuperTypes();
            this.superTypes.add(v);
        }

        public void clearSuperTypes() {
            this.ensureSuperTypes();
            this.superTypes.clear();
        }

        protected void ensureSuperTypes() {
            if (this.superTypes == null) {
                this.superTypes = new ArrayList<Type>();
            }
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompilationUnitImpl)) {
                return false;
            }
            CompilationUnitImpl other = (CompilationUnitImpl)o;
            this.ensureImports();
            other.ensureImports();
            if (this.imports != null ? !this.imports.equals(other.imports) : other.imports != null) {
                return false;
            }
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
                return false;
            }
            this.ensureTypes();
            other.ensureTypes();
            if (this.types != null ? !this.types.equals(other.types) : other.types != null) {
                return false;
            }
            this.ensureSuperTypes();
            other.ensureSuperTypes();
            if (this.superTypes != null ? !this.superTypes.equals(other.superTypes) : other.superTypes != null) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureImports();
            hash = hash * 31 + (this.imports != null ? this.imports.hashCode() : 0);
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            this.ensureTypes();
            hash = hash * 31 + (this.types != null ? this.types.hashCode() : 0);
            this.ensureSuperTypes();
            hash = hash * 31 + (this.superTypes != null ? this.superTypes.hashCode() : 0);
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static CompilationUnitImpl fromJsonElement(JsonElement jsonElem) {
            return (CompilationUnitImpl)gson.fromJson(jsonElem, CompilationUnitImpl.class);
        }

        public static CompilationUnitImpl fromJsonString(String jsonString) {
            return (CompilationUnitImpl)gson.fromJson(jsonString, CompilationUnitImpl.class);
        }

        public CompilationUnitImpl(CompilationUnit origin) {
            List<Type> superTypesIn;
            List<ImportDeclaration> importsIn = origin.getImports();
            if (importsIn != null) {
                ArrayList<ImportDeclaration> importsOut = new ArrayList<ImportDeclaration>();
                for (ImportDeclaration importDeclaration : importsIn) {
                    importsOut.add(importDeclaration == null ? null : new ImportDeclarationImpl(importDeclaration));
                }
                this.imports = importsOut;
            }
            this.label = origin.getLabel();
            this.projectPath = origin.getProjectPath();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.path = origin.getPath();
            List<Type> typesIn = origin.getTypes();
            if (typesIn != null) {
                ArrayList<Type> typesOut = new ArrayList<Type>();
                for (Type typesIn_ : typesIn) {
                    typesOut.add(typesIn_ == null ? null : new TypeImpl(typesIn_));
                }
                this.types = typesOut;
            }
            if ((superTypesIn = origin.getSuperTypes()) != null) {
                ArrayList<Type> arrayList = new ArrayList<Type>();
                for (Type superTypesIn_ : superTypesIn) {
                    arrayList.add(superTypesIn_ == null ? null : new TypeImpl(superTypesIn_));
                }
                this.superTypes = arrayList;
            }
            this.elementName = origin.getElementName();
        }

        public CompilationUnit withImports(List<ImportDeclaration> v) {
            this.imports = v;
            return this;
        }

        public CompilationUnit withLabel(String v) {
            this.label = v;
            return this;
        }

        public CompilationUnit withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public CompilationUnit withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public CompilationUnit withPath(String v) {
            this.path = v;
            return this;
        }

        public CompilationUnit withTypes(List<Type> v) {
            this.types = v;
            return this;
        }

        public CompilationUnit withSuperTypes(List<Type> v) {
            this.superTypes = v;
            return this;
        }

        public CompilationUnit withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ClassFileImpl
    implements ClassFile,
    JsonSerializable {
        protected String label;
        protected Type type;
        protected String projectPath;
        protected String handleIdentifier;
        protected String path;
        protected String elementName;

        public static ClassFileImpl make() {
            return new ClassFileImpl();
        }

        public ClassFileImpl() {
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String v) {
            this.label = v;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public void setType(Type v) {
            this.type = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        @Override
        public String getHandleIdentifier() {
            return this.handleIdentifier;
        }

        @Override
        public void setHandleIdentifier(String v) {
            this.handleIdentifier = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public void setElementName(String v) {
            this.elementName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassFileImpl)) {
                return false;
            }
            ClassFileImpl other = (ClassFileImpl)o;
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(other.type) : other.type != null) {
                return false;
            }
            if (this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null) {
                return false;
            }
            if (this.handleIdentifier != null ? !this.handleIdentifier.equals(other.handleIdentifier) : other.handleIdentifier != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
                return false;
            }
            return !(this.elementName != null ? !this.elementName.equals(other.elementName) : other.elementName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            hash = hash * 31 + (this.handleIdentifier != null ? this.handleIdentifier.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            hash = hash * 31 + (this.elementName != null ? this.elementName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ClassFileImpl fromJsonElement(JsonElement jsonElem) {
            return (ClassFileImpl)gson.fromJson(jsonElem, ClassFileImpl.class);
        }

        public static ClassFileImpl fromJsonString(String jsonString) {
            return (ClassFileImpl)gson.fromJson(jsonString, ClassFileImpl.class);
        }

        public ClassFileImpl(ClassFile origin) {
            this.label = origin.getLabel();
            Type typeIn = origin.getType();
            this.type = typeIn == null ? null : new TypeImpl(typeIn);
            this.projectPath = origin.getProjectPath();
            this.handleIdentifier = origin.getHandleIdentifier();
            this.path = origin.getPath();
            this.elementName = origin.getElementName();
        }

        public ClassFile withLabel(String v) {
            this.label = v;
            return this;
        }

        public ClassFile withType(Type v) {
            this.type = v;
            return this;
        }

        public ClassFile withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }

        public ClassFile withHandleIdentifier(String v) {
            this.handleIdentifier = v;
            return this;
        }

        public ClassFile withPath(String v) {
            this.path = v;
            return this;
        }

        public ClassFile withElementName(String v) {
            this.elementName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ClasspathEntryDtoImpl
    implements ClasspathEntryDto,
    JsonSerializable {
        protected List<ClasspathEntryDto> expandedEntries;
        protected int entryKind;
        protected String path;

        public static ClasspathEntryDtoImpl make() {
            return new ClasspathEntryDtoImpl();
        }

        public ClasspathEntryDtoImpl() {
        }

        @Override
        public List<ClasspathEntryDto> getExpandedEntries() {
            this.ensureExpandedEntries();
            return new JsonArrayImpl(this.expandedEntries);
        }

        @Override
        public void setExpandedEntries(List<ClasspathEntryDto> v) {
            this.expandedEntries = v;
        }

        public void addExpandedEntries(ClasspathEntryDto v) {
            this.ensureExpandedEntries();
            this.expandedEntries.add(v);
        }

        public void clearExpandedEntries() {
            this.ensureExpandedEntries();
            this.expandedEntries.clear();
        }

        protected void ensureExpandedEntries() {
            if (this.expandedEntries == null) {
                this.expandedEntries = new ArrayList<ClasspathEntryDto>();
            }
        }

        @Override
        public int getEntryKind() {
            return this.entryKind;
        }

        @Override
        public void setEntryKind(int v) {
            this.entryKind = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClasspathEntryDtoImpl)) {
                return false;
            }
            ClasspathEntryDtoImpl other = (ClasspathEntryDtoImpl)o;
            this.ensureExpandedEntries();
            other.ensureExpandedEntries();
            if (this.expandedEntries != null ? !this.expandedEntries.equals(other.expandedEntries) : other.expandedEntries != null) {
                return false;
            }
            if (this.entryKind != other.entryKind) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureExpandedEntries();
            hash = hash * 31 + (this.expandedEntries != null ? this.expandedEntries.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.entryKind).hashCode();
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ClasspathEntryDtoImpl fromJsonElement(JsonElement jsonElem) {
            return (ClasspathEntryDtoImpl)gson.fromJson(jsonElem, ClasspathEntryDtoImpl.class);
        }

        public static ClasspathEntryDtoImpl fromJsonString(String jsonString) {
            return (ClasspathEntryDtoImpl)gson.fromJson(jsonString, ClasspathEntryDtoImpl.class);
        }

        public ClasspathEntryDtoImpl(ClasspathEntryDto origin) {
            List<ClasspathEntryDto> expandedEntriesIn = origin.getExpandedEntries();
            if (expandedEntriesIn != null) {
                ArrayList<ClasspathEntryDto> expandedEntriesOut = new ArrayList<ClasspathEntryDto>();
                for (ClasspathEntryDto expandedEntriesIn_ : expandedEntriesIn) {
                    expandedEntriesOut.add(expandedEntriesIn_ == null ? null : new ClasspathEntryDtoImpl(expandedEntriesIn_));
                }
                this.expandedEntries = expandedEntriesOut;
            }
            this.entryKind = origin.getEntryKind();
            this.path = origin.getPath();
        }

        @Override
        public ClasspathEntryDto withExpandedEntries(List<ClasspathEntryDto> v) {
            this.expandedEntries = v;
            return this;
        }

        @Override
        public ClasspathEntryDto withEntryKind(int v) {
            this.entryKind = v;
            return this;
        }

        @Override
        public ClasspathEntryDto withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class RegionImpl
    implements Region,
    JsonSerializable {
        protected int offset;
        protected int length;

        public static RegionImpl make() {
            return new RegionImpl();
        }

        public RegionImpl() {
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setLength(int v) {
            this.length = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegionImpl)) {
                return false;
            }
            RegionImpl other = (RegionImpl)o;
            if (this.offset != other.offset) {
                return false;
            }
            return this.length == other.length;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            hash = hash * 31 + Integer.valueOf(this.length).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static RegionImpl fromJsonElement(JsonElement jsonElem) {
            return (RegionImpl)gson.fromJson(jsonElem, RegionImpl.class);
        }

        public static RegionImpl fromJsonString(String jsonString) {
            return (RegionImpl)gson.fromJson(jsonString, RegionImpl.class);
        }

        public RegionImpl(Region origin) {
            this.offset = origin.getOffset();
            this.length = origin.getLength();
        }

        @Override
        public Region withOffset(int v) {
            this.offset = v;
            return this;
        }

        @Override
        public Region withLength(int v) {
            this.length = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ReconcileResultImpl
    implements ReconcileResult,
    JsonSerializable {
        protected List<HighlightedPosition> highlightedPositions;
        protected String fileLocation;
        protected List<Problem> problems;

        public static ReconcileResultImpl make() {
            return new ReconcileResultImpl();
        }

        public ReconcileResultImpl() {
        }

        @Override
        public List<HighlightedPosition> getHighlightedPositions() {
            this.ensureHighlightedPositions();
            return new JsonArrayImpl(this.highlightedPositions);
        }

        @Override
        public void setHighlightedPositions(List<HighlightedPosition> v) {
            this.highlightedPositions = v;
        }

        public void addHighlightedPositions(HighlightedPosition v) {
            this.ensureHighlightedPositions();
            this.highlightedPositions.add(v);
        }

        public void clearHighlightedPositions() {
            this.ensureHighlightedPositions();
            this.highlightedPositions.clear();
        }

        protected void ensureHighlightedPositions() {
            if (this.highlightedPositions == null) {
                this.highlightedPositions = new ArrayList<HighlightedPosition>();
            }
        }

        @Override
        public String getFileLocation() {
            return this.fileLocation;
        }

        @Override
        public void setFileLocation(String v) {
            this.fileLocation = v;
        }

        @Override
        public List<Problem> getProblems() {
            this.ensureProblems();
            return new JsonArrayImpl(this.problems);
        }

        @Override
        public void setProblems(List<Problem> v) {
            this.problems = v;
        }

        public void addProblems(Problem v) {
            this.ensureProblems();
            this.problems.add(v);
        }

        public void clearProblems() {
            this.ensureProblems();
            this.problems.clear();
        }

        protected void ensureProblems() {
            if (this.problems == null) {
                this.problems = new ArrayList<Problem>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReconcileResultImpl)) {
                return false;
            }
            ReconcileResultImpl other = (ReconcileResultImpl)o;
            this.ensureHighlightedPositions();
            other.ensureHighlightedPositions();
            if (this.highlightedPositions != null ? !this.highlightedPositions.equals(other.highlightedPositions) : other.highlightedPositions != null) {
                return false;
            }
            if (this.fileLocation != null ? !this.fileLocation.equals(other.fileLocation) : other.fileLocation != null) {
                return false;
            }
            this.ensureProblems();
            other.ensureProblems();
            return !(this.problems != null ? !this.problems.equals(other.problems) : other.problems != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureHighlightedPositions();
            hash = hash * 31 + (this.highlightedPositions != null ? this.highlightedPositions.hashCode() : 0);
            hash = hash * 31 + (this.fileLocation != null ? this.fileLocation.hashCode() : 0);
            this.ensureProblems();
            hash = hash * 31 + (this.problems != null ? this.problems.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ReconcileResultImpl fromJsonElement(JsonElement jsonElem) {
            return (ReconcileResultImpl)gson.fromJson(jsonElem, ReconcileResultImpl.class);
        }

        public static ReconcileResultImpl fromJsonString(String jsonString) {
            return (ReconcileResultImpl)gson.fromJson(jsonString, ReconcileResultImpl.class);
        }

        public ReconcileResultImpl(ReconcileResult origin) {
            List<HighlightedPosition> highlightedPositionsIn = origin.getHighlightedPositions();
            if (highlightedPositionsIn != null) {
                ArrayList<HighlightedPosition> highlightedPositionsOut = new ArrayList<HighlightedPosition>();
                for (HighlightedPosition highlightedPositionsIn_ : highlightedPositionsIn) {
                    highlightedPositionsOut.add(highlightedPositionsIn_ == null ? null : new HighlightedPositionImpl(highlightedPositionsIn_));
                }
                this.highlightedPositions = highlightedPositionsOut;
            }
            this.fileLocation = origin.getFileLocation();
            List<Problem> problemsIn = origin.getProblems();
            if (problemsIn != null) {
                ArrayList<Problem> problemsOut = new ArrayList<Problem>();
                for (Problem problemsIn_ : problemsIn) {
                    problemsOut.add(problemsIn_ == null ? null : new ProblemImpl(problemsIn_));
                }
                this.problems = problemsOut;
            }
        }

        @Override
        public ReconcileResult withHighlightedPositions(List<HighlightedPosition> v) {
            this.highlightedPositions = v;
            return this;
        }

        @Override
        public ReconcileResult withFileLocation(String v) {
            this.fileLocation = v;
            return this;
        }

        @Override
        public ReconcileResult withProblems(List<Problem> v) {
            this.problems = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ProposalsImpl
    implements Proposals,
    JsonSerializable {
        protected List<ProposalPresentation> proposals;
        protected String sessionId;

        public static ProposalsImpl make() {
            return new ProposalsImpl();
        }

        public ProposalsImpl() {
        }

        @Override
        public List<ProposalPresentation> getProposals() {
            this.ensureProposals();
            return new JsonArrayImpl(this.proposals);
        }

        @Override
        public void setProposals(List<ProposalPresentation> v) {
            this.proposals = v;
        }

        public void addProposals(ProposalPresentation v) {
            this.ensureProposals();
            this.proposals.add(v);
        }

        public void clearProposals() {
            this.ensureProposals();
            this.proposals.clear();
        }

        protected void ensureProposals() {
            if (this.proposals == null) {
                this.proposals = new ArrayList<ProposalPresentation>();
            }
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        @Override
        public void setSessionId(String v) {
            this.sessionId = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProposalsImpl)) {
                return false;
            }
            ProposalsImpl other = (ProposalsImpl)o;
            this.ensureProposals();
            other.ensureProposals();
            if (this.proposals != null ? !this.proposals.equals(other.proposals) : other.proposals != null) {
                return false;
            }
            return !(this.sessionId != null ? !this.sessionId.equals(other.sessionId) : other.sessionId != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureProposals();
            hash = hash * 31 + (this.proposals != null ? this.proposals.hashCode() : 0);
            hash = hash * 31 + (this.sessionId != null ? this.sessionId.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ProposalsImpl fromJsonElement(JsonElement jsonElem) {
            return (ProposalsImpl)gson.fromJson(jsonElem, ProposalsImpl.class);
        }

        public static ProposalsImpl fromJsonString(String jsonString) {
            return (ProposalsImpl)gson.fromJson(jsonString, ProposalsImpl.class);
        }

        public ProposalsImpl(Proposals origin) {
            List<ProposalPresentation> proposalsIn = origin.getProposals();
            if (proposalsIn != null) {
                ArrayList<ProposalPresentation> proposalsOut = new ArrayList<ProposalPresentation>();
                for (ProposalPresentation proposalsIn_ : proposalsIn) {
                    proposalsOut.add(proposalsIn_ == null ? null : new ProposalPresentationImpl(proposalsIn_));
                }
                this.proposals = proposalsOut;
            }
            this.sessionId = origin.getSessionId();
        }

        public Proposals withProposals(List<ProposalPresentation> v) {
            this.proposals = v;
            return this;
        }

        public Proposals withSessionId(String v) {
            this.sessionId = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ProposalPresentationImpl
    implements ProposalPresentation,
    JsonSerializable {
        protected boolean autoInsertable;
        protected int index;
        protected String actionId;
        protected String displayString;
        protected String image;

        public static ProposalPresentationImpl make() {
            return new ProposalPresentationImpl();
        }

        public ProposalPresentationImpl() {
        }

        @Override
        public boolean isAutoInsertable() {
            return this.autoInsertable;
        }

        @Override
        public void setAutoInsertable(boolean v) {
            this.autoInsertable = v;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int v) {
            this.index = v;
        }

        @Override
        public String getActionId() {
            return this.actionId;
        }

        @Override
        public void setActionId(String v) {
            this.actionId = v;
        }

        @Override
        public String getDisplayString() {
            return this.displayString;
        }

        @Override
        public void setDisplayString(String v) {
            this.displayString = v;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public void setImage(String v) {
            this.image = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProposalPresentationImpl)) {
                return false;
            }
            ProposalPresentationImpl other = (ProposalPresentationImpl)o;
            if (this.autoInsertable != other.autoInsertable) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            if (this.actionId != null ? !this.actionId.equals(other.actionId) : other.actionId != null) {
                return false;
            }
            if (this.displayString != null ? !this.displayString.equals(other.displayString) : other.displayString != null) {
                return false;
            }
            return !(this.image != null ? !this.image.equals(other.image) : other.image != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.autoInsertable).hashCode();
            hash = hash * 31 + Integer.valueOf(this.index).hashCode();
            hash = hash * 31 + (this.actionId != null ? this.actionId.hashCode() : 0);
            hash = hash * 31 + (this.displayString != null ? this.displayString.hashCode() : 0);
            hash = hash * 31 + (this.image != null ? this.image.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ProposalPresentationImpl fromJsonElement(JsonElement jsonElem) {
            return (ProposalPresentationImpl)gson.fromJson(jsonElem, ProposalPresentationImpl.class);
        }

        public static ProposalPresentationImpl fromJsonString(String jsonString) {
            return (ProposalPresentationImpl)gson.fromJson(jsonString, ProposalPresentationImpl.class);
        }

        public ProposalPresentationImpl(ProposalPresentation origin) {
            this.autoInsertable = origin.isAutoInsertable();
            this.index = origin.getIndex();
            this.actionId = origin.getActionId();
            this.displayString = origin.getDisplayString();
            this.image = origin.getImage();
        }

        public ProposalPresentation withAutoInsertable(boolean v) {
            this.autoInsertable = v;
            return this;
        }

        public ProposalPresentation withIndex(int v) {
            this.index = v;
            return this;
        }

        public ProposalPresentation withActionId(String v) {
            this.actionId = v;
            return this;
        }

        public ProposalPresentation withDisplayString(String v) {
            this.displayString = v;
            return this;
        }

        public ProposalPresentation withImage(String v) {
            this.image = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ProposalApplyResultImpl
    implements ProposalApplyResult,
    JsonSerializable {
        protected Region selection;
        protected LinkedModeModel linkedModeModel;
        protected List<Change> changes;
        protected ChangeInfo changeInfo;

        public static ProposalApplyResultImpl make() {
            return new ProposalApplyResultImpl();
        }

        public ProposalApplyResultImpl() {
        }

        @Override
        public Region getSelection() {
            return this.selection;
        }

        @Override
        public void setSelection(Region v) {
            this.selection = v;
        }

        @Override
        public LinkedModeModel getLinkedModeModel() {
            return this.linkedModeModel;
        }

        @Override
        public void setLinkedModeModel(LinkedModeModel v) {
            this.linkedModeModel = v;
        }

        @Override
        public List<Change> getChanges() {
            this.ensureChanges();
            return new JsonArrayImpl(this.changes);
        }

        @Override
        public void setChanges(List<Change> v) {
            this.changes = v;
        }

        public void addChanges(Change v) {
            this.ensureChanges();
            this.changes.add(v);
        }

        public void clearChanges() {
            this.ensureChanges();
            this.changes.clear();
        }

        protected void ensureChanges() {
            if (this.changes == null) {
                this.changes = new ArrayList<Change>();
            }
        }

        @Override
        public ChangeInfo getChangeInfo() {
            return this.changeInfo;
        }

        @Override
        public void setChangeInfo(ChangeInfo v) {
            this.changeInfo = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProposalApplyResultImpl)) {
                return false;
            }
            ProposalApplyResultImpl other = (ProposalApplyResultImpl)o;
            if (this.selection != null ? !this.selection.equals(other.selection) : other.selection != null) {
                return false;
            }
            if (this.linkedModeModel != null ? !this.linkedModeModel.equals(other.linkedModeModel) : other.linkedModeModel != null) {
                return false;
            }
            this.ensureChanges();
            other.ensureChanges();
            if (this.changes != null ? !this.changes.equals(other.changes) : other.changes != null) {
                return false;
            }
            return !(this.changeInfo != null ? !this.changeInfo.equals(other.changeInfo) : other.changeInfo != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.selection != null ? this.selection.hashCode() : 0);
            hash = hash * 31 + (this.linkedModeModel != null ? this.linkedModeModel.hashCode() : 0);
            this.ensureChanges();
            hash = hash * 31 + (this.changes != null ? this.changes.hashCode() : 0);
            hash = hash * 31 + (this.changeInfo != null ? this.changeInfo.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ProposalApplyResultImpl fromJsonElement(JsonElement jsonElem) {
            return (ProposalApplyResultImpl)gson.fromJson(jsonElem, ProposalApplyResultImpl.class);
        }

        public static ProposalApplyResultImpl fromJsonString(String jsonString) {
            return (ProposalApplyResultImpl)gson.fromJson(jsonString, ProposalApplyResultImpl.class);
        }

        public ProposalApplyResultImpl(ProposalApplyResult origin) {
            ChangeInfo changeInfoIn;
            Region selectionIn = origin.getSelection();
            this.selection = selectionIn == null ? null : new RegionImpl(selectionIn);
            LinkedModeModel linkedModeModelIn = origin.getLinkedModeModel();
            this.linkedModeModel = linkedModeModelIn == null ? null : new LinkedModeModelImpl(linkedModeModelIn);
            List<Change> changesIn = origin.getChanges();
            if (changesIn != null) {
                ArrayList<Change> changesOut = new ArrayList<Change>();
                for (Change changesIn_ : changesIn) {
                    changesOut.add(changesIn_ == null ? null : new ChangeImpl(changesIn_));
                }
                this.changes = changesOut;
            }
            this.changeInfo = (changeInfoIn = origin.getChangeInfo()) == null ? null : new ChangeInfoImpl(changeInfoIn);
        }

        public ProposalApplyResult withSelection(Region v) {
            this.selection = v;
            return this;
        }

        public ProposalApplyResult withLinkedModeModel(LinkedModeModel v) {
            this.linkedModeModel = v;
            return this;
        }

        public ProposalApplyResult withChanges(List<Change> v) {
            this.changes = v;
            return this;
        }

        public ProposalApplyResult withChangeInfo(ChangeInfo v) {
            this.changeInfo = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ProblemImpl
    implements Problem,
    JsonSerializable {
        protected int sourceStart;
        protected boolean error;
        protected boolean warning;
        protected int sourceLineNumber;
        protected List<String> arguments;
        protected String message;
        protected int iD;
        protected int sourceEnd;
        protected String originatingFileName;

        public static ProblemImpl make() {
            return new ProblemImpl();
        }

        public ProblemImpl() {
        }

        @Override
        public int getSourceStart() {
            return this.sourceStart;
        }

        @Override
        public void setSourceStart(int v) {
            this.sourceStart = v;
        }

        @Override
        public boolean isError() {
            return this.error;
        }

        @Override
        public void setError(boolean v) {
            this.error = v;
        }

        @Override
        public boolean isWarning() {
            return this.warning;
        }

        @Override
        public void setWarning(boolean v) {
            this.warning = v;
        }

        @Override
        public int getSourceLineNumber() {
            return this.sourceLineNumber;
        }

        @Override
        public void setSourceLineNumber(int v) {
            this.sourceLineNumber = v;
        }

        @Override
        public List<String> getArguments() {
            this.ensureArguments();
            return new JsonArrayImpl(this.arguments);
        }

        @Override
        public void setArguments(List<String> v) {
            this.arguments = v;
        }

        public void addArguments(String v) {
            this.ensureArguments();
            this.arguments.add(v);
        }

        public void clearArguments() {
            this.ensureArguments();
            this.arguments.clear();
        }

        protected void ensureArguments() {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void setMessage(String v) {
            this.message = v;
        }

        @Override
        public int getID() {
            return this.iD;
        }

        @Override
        public void setID(int v) {
            this.iD = v;
        }

        @Override
        public int getSourceEnd() {
            return this.sourceEnd;
        }

        @Override
        public void setSourceEnd(int v) {
            this.sourceEnd = v;
        }

        @Override
        public String getOriginatingFileName() {
            return this.originatingFileName;
        }

        @Override
        public void setOriginatingFileName(String v) {
            this.originatingFileName = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProblemImpl)) {
                return false;
            }
            ProblemImpl other = (ProblemImpl)o;
            if (this.sourceStart != other.sourceStart) {
                return false;
            }
            if (this.error != other.error) {
                return false;
            }
            if (this.warning != other.warning) {
                return false;
            }
            if (this.sourceLineNumber != other.sourceLineNumber) {
                return false;
            }
            this.ensureArguments();
            other.ensureArguments();
            if (this.arguments != null ? !this.arguments.equals(other.arguments) : other.arguments != null) {
                return false;
            }
            if (this.message != null ? !this.message.equals(other.message) : other.message != null) {
                return false;
            }
            if (this.iD != other.iD) {
                return false;
            }
            if (this.sourceEnd != other.sourceEnd) {
                return false;
            }
            return !(this.originatingFileName != null ? !this.originatingFileName.equals(other.originatingFileName) : other.originatingFileName != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.sourceStart).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.error).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.warning).hashCode();
            hash = hash * 31 + Integer.valueOf(this.sourceLineNumber).hashCode();
            this.ensureArguments();
            hash = hash * 31 + (this.arguments != null ? this.arguments.hashCode() : 0);
            hash = hash * 31 + (this.message != null ? this.message.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.iD).hashCode();
            hash = hash * 31 + Integer.valueOf(this.sourceEnd).hashCode();
            hash = hash * 31 + (this.originatingFileName != null ? this.originatingFileName.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ProblemImpl fromJsonElement(JsonElement jsonElem) {
            return (ProblemImpl)gson.fromJson(jsonElem, ProblemImpl.class);
        }

        public static ProblemImpl fromJsonString(String jsonString) {
            return (ProblemImpl)gson.fromJson(jsonString, ProblemImpl.class);
        }

        public ProblemImpl(Problem origin) {
            this.sourceStart = origin.getSourceStart();
            this.error = origin.isError();
            this.warning = origin.isWarning();
            this.sourceLineNumber = origin.getSourceLineNumber();
            List<String> argumentsIn = origin.getArguments();
            if (argumentsIn != null) {
                ArrayList<String> argumentsOut = new ArrayList<String>();
                for (String argumentsIn_ : argumentsIn) {
                    argumentsOut.add(argumentsIn_);
                }
                this.arguments = argumentsOut;
            }
            this.message = origin.getMessage();
            this.iD = origin.getID();
            this.sourceEnd = origin.getSourceEnd();
            this.originatingFileName = origin.getOriginatingFileName();
        }

        @Override
        public Problem withSourceStart(int v) {
            this.sourceStart = v;
            return this;
        }

        @Override
        public Problem withError(boolean v) {
            this.error = v;
            return this;
        }

        @Override
        public Problem withWarning(boolean v) {
            this.warning = v;
            return this;
        }

        @Override
        public Problem withSourceLineNumber(int v) {
            this.sourceLineNumber = v;
            return this;
        }

        @Override
        public Problem withArguments(List<String> v) {
            this.arguments = v;
            return this;
        }

        @Override
        public Problem withMessage(String v) {
            this.message = v;
            return this;
        }

        @Override
        public Problem withID(int v) {
            this.iD = v;
            return this;
        }

        @Override
        public Problem withSourceEnd(int v) {
            this.sourceEnd = v;
            return this;
        }

        @Override
        public Problem withOriginatingFileName(String v) {
            this.originatingFileName = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class OrganizeImportResultImpl
    implements OrganizeImportResult,
    JsonSerializable {
        protected List<Change> changes;
        protected List<ConflictImportDTO> conflicts;

        public static OrganizeImportResultImpl make() {
            return new OrganizeImportResultImpl();
        }

        public OrganizeImportResultImpl() {
        }

        @Override
        public List<Change> getChanges() {
            this.ensureChanges();
            return new JsonArrayImpl(this.changes);
        }

        @Override
        public void setChanges(List<Change> v) {
            this.changes = v;
        }

        public void addChanges(Change v) {
            this.ensureChanges();
            this.changes.add(v);
        }

        public void clearChanges() {
            this.ensureChanges();
            this.changes.clear();
        }

        protected void ensureChanges() {
            if (this.changes == null) {
                this.changes = new ArrayList<Change>();
            }
        }

        @Override
        public List<ConflictImportDTO> getConflicts() {
            this.ensureConflicts();
            return new JsonArrayImpl(this.conflicts);
        }

        @Override
        public void setConflicts(List<ConflictImportDTO> v) {
            this.conflicts = v;
        }

        public void addConflicts(ConflictImportDTO v) {
            this.ensureConflicts();
            this.conflicts.add(v);
        }

        public void clearConflicts() {
            this.ensureConflicts();
            this.conflicts.clear();
        }

        protected void ensureConflicts() {
            if (this.conflicts == null) {
                this.conflicts = new ArrayList<ConflictImportDTO>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof OrganizeImportResultImpl)) {
                return false;
            }
            OrganizeImportResultImpl other = (OrganizeImportResultImpl)o;
            this.ensureChanges();
            other.ensureChanges();
            if (this.changes != null ? !this.changes.equals(other.changes) : other.changes != null) {
                return false;
            }
            this.ensureConflicts();
            other.ensureConflicts();
            return !(this.conflicts != null ? !this.conflicts.equals(other.conflicts) : other.conflicts != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureChanges();
            hash = hash * 31 + (this.changes != null ? this.changes.hashCode() : 0);
            this.ensureConflicts();
            hash = hash * 31 + (this.conflicts != null ? this.conflicts.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static OrganizeImportResultImpl fromJsonElement(JsonElement jsonElem) {
            return (OrganizeImportResultImpl)gson.fromJson(jsonElem, OrganizeImportResultImpl.class);
        }

        public static OrganizeImportResultImpl fromJsonString(String jsonString) {
            return (OrganizeImportResultImpl)gson.fromJson(jsonString, OrganizeImportResultImpl.class);
        }

        public OrganizeImportResultImpl(OrganizeImportResult origin) {
            List<ConflictImportDTO> conflictsIn;
            List<Change> changesIn = origin.getChanges();
            if (changesIn != null) {
                ArrayList<Change> changesOut = new ArrayList<Change>();
                for (Change changesIn_ : changesIn) {
                    changesOut.add(changesIn_ == null ? null : new ChangeImpl(changesIn_));
                }
                this.changes = changesOut;
            }
            if ((conflictsIn = origin.getConflicts()) != null) {
                ArrayList<ConflictImportDTO> conflictsOut = new ArrayList<ConflictImportDTO>();
                for (ConflictImportDTO conflictsIn_ : conflictsIn) {
                    conflictsOut.add(conflictsIn_ == null ? null : new ConflictImportDTOImpl(conflictsIn_));
                }
                this.conflicts = conflictsOut;
            }
        }

        public OrganizeImportResult withChanges(List<Change> v) {
            this.changes = v;
            return this;
        }

        public OrganizeImportResult withConflicts(List<ConflictImportDTO> v) {
            this.conflicts = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class LinkedPositionGroupImpl
    implements LinkedPositionGroup,
    JsonSerializable {
        protected List<Region> positions;
        protected LinkedData data;

        public static LinkedPositionGroupImpl make() {
            return new LinkedPositionGroupImpl();
        }

        public LinkedPositionGroupImpl() {
        }

        @Override
        public List<Region> getPositions() {
            this.ensurePositions();
            return new JsonArrayImpl(this.positions);
        }

        @Override
        public void setPositions(List<Region> v) {
            this.positions = v;
        }

        public void addPositions(Region v) {
            this.ensurePositions();
            this.positions.add(v);
        }

        public void clearPositions() {
            this.ensurePositions();
            this.positions.clear();
        }

        protected void ensurePositions() {
            if (this.positions == null) {
                this.positions = new ArrayList<Region>();
            }
        }

        @Override
        public LinkedData getData() {
            return this.data;
        }

        @Override
        public void setData(LinkedData v) {
            this.data = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkedPositionGroupImpl)) {
                return false;
            }
            LinkedPositionGroupImpl other = (LinkedPositionGroupImpl)o;
            this.ensurePositions();
            other.ensurePositions();
            if (this.positions != null ? !this.positions.equals(other.positions) : other.positions != null) {
                return false;
            }
            return !(this.data != null ? !this.data.equals(other.data) : other.data != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensurePositions();
            hash = hash * 31 + (this.positions != null ? this.positions.hashCode() : 0);
            hash = hash * 31 + (this.data != null ? this.data.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static LinkedPositionGroupImpl fromJsonElement(JsonElement jsonElem) {
            return (LinkedPositionGroupImpl)gson.fromJson(jsonElem, LinkedPositionGroupImpl.class);
        }

        public static LinkedPositionGroupImpl fromJsonString(String jsonString) {
            return (LinkedPositionGroupImpl)gson.fromJson(jsonString, LinkedPositionGroupImpl.class);
        }

        public LinkedPositionGroupImpl(LinkedPositionGroup origin) {
            LinkedData dataIn;
            List<Region> positionsIn = origin.getPositions();
            if (positionsIn != null) {
                ArrayList<Region> positionsOut = new ArrayList<Region>();
                for (Region positionsIn_ : positionsIn) {
                    positionsOut.add(positionsIn_ == null ? null : new RegionImpl(positionsIn_));
                }
                this.positions = positionsOut;
            }
            this.data = (dataIn = origin.getData()) == null ? null : new LinkedDataImpl(dataIn);
        }

        public LinkedPositionGroup withPositions(List<Region> v) {
            this.positions = v;
            return this;
        }

        public LinkedPositionGroup withData(LinkedData v) {
            this.data = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class LinkedModeModelImpl
    implements LinkedModeModel,
    JsonSerializable {
        protected int escapePosition;
        protected List<LinkedPositionGroup> groups;

        public static LinkedModeModelImpl make() {
            return new LinkedModeModelImpl();
        }

        public LinkedModeModelImpl() {
        }

        @Override
        public int getEscapePosition() {
            return this.escapePosition;
        }

        @Override
        public void setEscapePosition(int v) {
            this.escapePosition = v;
        }

        @Override
        public List<LinkedPositionGroup> getGroups() {
            this.ensureGroups();
            return new JsonArrayImpl(this.groups);
        }

        @Override
        public void setGroups(List<LinkedPositionGroup> v) {
            this.groups = v;
        }

        public void addGroups(LinkedPositionGroup v) {
            this.ensureGroups();
            this.groups.add(v);
        }

        public void clearGroups() {
            this.ensureGroups();
            this.groups.clear();
        }

        protected void ensureGroups() {
            if (this.groups == null) {
                this.groups = new ArrayList<LinkedPositionGroup>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkedModeModelImpl)) {
                return false;
            }
            LinkedModeModelImpl other = (LinkedModeModelImpl)o;
            if (this.escapePosition != other.escapePosition) {
                return false;
            }
            this.ensureGroups();
            other.ensureGroups();
            return !(this.groups != null ? !this.groups.equals(other.groups) : other.groups != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.escapePosition).hashCode();
            this.ensureGroups();
            hash = hash * 31 + (this.groups != null ? this.groups.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static LinkedModeModelImpl fromJsonElement(JsonElement jsonElem) {
            return (LinkedModeModelImpl)gson.fromJson(jsonElem, LinkedModeModelImpl.class);
        }

        public static LinkedModeModelImpl fromJsonString(String jsonString) {
            return (LinkedModeModelImpl)gson.fromJson(jsonString, LinkedModeModelImpl.class);
        }

        public LinkedModeModelImpl(LinkedModeModel origin) {
            this.escapePosition = origin.getEscapePosition();
            List<LinkedPositionGroup> groupsIn = origin.getGroups();
            if (groupsIn != null) {
                ArrayList<LinkedPositionGroup> groupsOut = new ArrayList<LinkedPositionGroup>();
                for (LinkedPositionGroup groupsIn_ : groupsIn) {
                    groupsOut.add(groupsIn_ == null ? null : new LinkedPositionGroupImpl(groupsIn_));
                }
                this.groups = groupsOut;
            }
        }

        public LinkedModeModel withEscapePosition(int v) {
            this.escapePosition = v;
            return this;
        }

        public LinkedModeModel withGroups(List<LinkedPositionGroup> v) {
            this.groups = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class LinkedDataImpl
    implements LinkedData,
    JsonSerializable {
        protected List<String> values;

        public static LinkedDataImpl make() {
            return new LinkedDataImpl();
        }

        public LinkedDataImpl() {
        }

        @Override
        public List<String> getValues() {
            this.ensureValues();
            return new JsonArrayImpl(this.values);
        }

        @Override
        public void setValues(List<String> v) {
            this.values = v;
        }

        public void addValues(String v) {
            this.ensureValues();
            this.values.add(v);
        }

        public void clearValues() {
            this.ensureValues();
            this.values.clear();
        }

        protected void ensureValues() {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkedDataImpl)) {
                return false;
            }
            LinkedDataImpl other = (LinkedDataImpl)o;
            this.ensureValues();
            other.ensureValues();
            return !(this.values != null ? !this.values.equals(other.values) : other.values != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureValues();
            hash = hash * 31 + (this.values != null ? this.values.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static LinkedDataImpl fromJsonElement(JsonElement jsonElem) {
            return (LinkedDataImpl)gson.fromJson(jsonElem, LinkedDataImpl.class);
        }

        public static LinkedDataImpl fromJsonString(String jsonString) {
            return (LinkedDataImpl)gson.fromJson(jsonString, LinkedDataImpl.class);
        }

        public LinkedDataImpl(LinkedData origin) {
            List<String> valuesIn = origin.getValues();
            if (valuesIn != null) {
                ArrayList<String> valuesOut = new ArrayList<String>();
                for (String valuesIn_ : valuesIn) {
                    valuesOut.add(valuesIn_);
                }
                this.values = valuesOut;
            }
        }

        public LinkedData withValues(List<String> v) {
            this.values = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class JavaClassInfoImpl
    implements JavaClassInfo,
    JsonSerializable {
        protected String fQN;
        protected String projectPath;

        public static JavaClassInfoImpl make() {
            return new JavaClassInfoImpl();
        }

        public JavaClassInfoImpl() {
        }

        @Override
        public String getFQN() {
            return this.fQN;
        }

        public void setFQN(String v) {
            this.fQN = v;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        public void setProjectPath(String v) {
            this.projectPath = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JavaClassInfoImpl)) {
                return false;
            }
            JavaClassInfoImpl other = (JavaClassInfoImpl)o;
            if (this.fQN != null ? !this.fQN.equals(other.fQN) : other.fQN != null) {
                return false;
            }
            return !(this.projectPath != null ? !this.projectPath.equals(other.projectPath) : other.projectPath != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.fQN != null ? this.fQN.hashCode() : 0);
            hash = hash * 31 + (this.projectPath != null ? this.projectPath.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static JavaClassInfoImpl fromJsonElement(JsonElement jsonElem) {
            return (JavaClassInfoImpl)gson.fromJson(jsonElem, JavaClassInfoImpl.class);
        }

        public static JavaClassInfoImpl fromJsonString(String jsonString) {
            return (JavaClassInfoImpl)gson.fromJson(jsonString, JavaClassInfoImpl.class);
        }

        public JavaClassInfoImpl(JavaClassInfo origin) {
            this.fQN = origin.getFQN();
            this.projectPath = origin.getProjectPath();
        }

        @Override
        public JavaClassInfo withFQN(String v) {
            this.fQN = v;
            return this;
        }

        @Override
        public JavaClassInfo withProjectPath(String v) {
            this.projectPath = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ImplementationsDescriptorDTOImpl
    implements ImplementationsDescriptorDTO,
    JsonSerializable {
        protected String memberName;
        protected List<Type> implementations;

        public static ImplementationsDescriptorDTOImpl make() {
            return new ImplementationsDescriptorDTOImpl();
        }

        public ImplementationsDescriptorDTOImpl() {
        }

        @Override
        public String getMemberName() {
            return this.memberName;
        }

        @Override
        public void setMemberName(String v) {
            this.memberName = v;
        }

        @Override
        public List<Type> getImplementations() {
            this.ensureImplementations();
            return new JsonArrayImpl(this.implementations);
        }

        @Override
        public void setImplementations(List<Type> v) {
            this.implementations = v;
        }

        public void addImplementations(Type v) {
            this.ensureImplementations();
            this.implementations.add(v);
        }

        public void clearImplementations() {
            this.ensureImplementations();
            this.implementations.clear();
        }

        protected void ensureImplementations() {
            if (this.implementations == null) {
                this.implementations = new ArrayList<Type>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ImplementationsDescriptorDTOImpl)) {
                return false;
            }
            ImplementationsDescriptorDTOImpl other = (ImplementationsDescriptorDTOImpl)o;
            if (this.memberName != null ? !this.memberName.equals(other.memberName) : other.memberName != null) {
                return false;
            }
            this.ensureImplementations();
            other.ensureImplementations();
            return !(this.implementations != null ? !this.implementations.equals(other.implementations) : other.implementations != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.memberName != null ? this.memberName.hashCode() : 0);
            this.ensureImplementations();
            hash = hash * 31 + (this.implementations != null ? this.implementations.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ImplementationsDescriptorDTOImpl fromJsonElement(JsonElement jsonElem) {
            return (ImplementationsDescriptorDTOImpl)gson.fromJson(jsonElem, ImplementationsDescriptorDTOImpl.class);
        }

        public static ImplementationsDescriptorDTOImpl fromJsonString(String jsonString) {
            return (ImplementationsDescriptorDTOImpl)gson.fromJson(jsonString, ImplementationsDescriptorDTOImpl.class);
        }

        public ImplementationsDescriptorDTOImpl(ImplementationsDescriptorDTO origin) {
            this.memberName = origin.getMemberName();
            List<Type> implementationsIn = origin.getImplementations();
            if (implementationsIn != null) {
                ArrayList<Type> implementationsOut = new ArrayList<Type>();
                for (Type implementationsIn_ : implementationsIn) {
                    implementationsOut.add(implementationsIn_ == null ? null : new TypeImpl(implementationsIn_));
                }
                this.implementations = implementationsOut;
            }
        }

        @Override
        public ImplementationsDescriptorDTO withMemberName(String v) {
            this.memberName = v;
            return this;
        }

        @Override
        public ImplementationsDescriptorDTO withImplementations(List<Type> v) {
            this.implementations = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class HighlightedPositionImpl
    implements HighlightedPosition,
    JsonSerializable {
        protected String type;
        protected int offset;
        protected int length;

        public static HighlightedPositionImpl make() {
            return new HighlightedPositionImpl();
        }

        public HighlightedPositionImpl() {
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public void setType(String v) {
            this.type = v;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setLength(int v) {
            this.length = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HighlightedPositionImpl)) {
                return false;
            }
            HighlightedPositionImpl other = (HighlightedPositionImpl)o;
            if (this.type != null ? !this.type.equals(other.type) : other.type != null) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.length == other.length;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            hash = hash * 31 + Integer.valueOf(this.length).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static HighlightedPositionImpl fromJsonElement(JsonElement jsonElem) {
            return (HighlightedPositionImpl)gson.fromJson(jsonElem, HighlightedPositionImpl.class);
        }

        public static HighlightedPositionImpl fromJsonString(String jsonString) {
            return (HighlightedPositionImpl)gson.fromJson(jsonString, HighlightedPositionImpl.class);
        }

        public HighlightedPositionImpl(HighlightedPosition origin) {
            this.type = origin.getType();
            this.offset = origin.getOffset();
            this.length = origin.getLength();
        }

        public HighlightedPosition withType(String v) {
            this.type = v;
            return this;
        }

        public HighlightedPosition withOffset(int v) {
            this.offset = v;
            return this;
        }

        public HighlightedPosition withLength(int v) {
            this.length = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ConflictImportDTOImpl
    implements ConflictImportDTO,
    JsonSerializable {
        protected List<String> typeMatches;

        public static ConflictImportDTOImpl make() {
            return new ConflictImportDTOImpl();
        }

        public ConflictImportDTOImpl() {
        }

        @Override
        public List<String> getTypeMatches() {
            this.ensureTypeMatches();
            return new JsonArrayImpl(this.typeMatches);
        }

        @Override
        public void setTypeMatches(List<String> v) {
            this.typeMatches = v;
        }

        public void addTypeMatches(String v) {
            this.ensureTypeMatches();
            this.typeMatches.add(v);
        }

        public void clearTypeMatches() {
            this.ensureTypeMatches();
            this.typeMatches.clear();
        }

        protected void ensureTypeMatches() {
            if (this.typeMatches == null) {
                this.typeMatches = new ArrayList<String>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConflictImportDTOImpl)) {
                return false;
            }
            ConflictImportDTOImpl other = (ConflictImportDTOImpl)o;
            this.ensureTypeMatches();
            other.ensureTypeMatches();
            return !(this.typeMatches != null ? !this.typeMatches.equals(other.typeMatches) : other.typeMatches != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureTypeMatches();
            hash = hash * 31 + (this.typeMatches != null ? this.typeMatches.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ConflictImportDTOImpl fromJsonElement(JsonElement jsonElem) {
            return (ConflictImportDTOImpl)gson.fromJson(jsonElem, ConflictImportDTOImpl.class);
        }

        public static ConflictImportDTOImpl fromJsonString(String jsonString) {
            return (ConflictImportDTOImpl)gson.fromJson(jsonString, ConflictImportDTOImpl.class);
        }

        public ConflictImportDTOImpl(ConflictImportDTO origin) {
            List<String> typeMatchesIn = origin.getTypeMatches();
            if (typeMatchesIn != null) {
                ArrayList<String> typeMatchesOut = new ArrayList<String>();
                for (String typeMatchesIn_ : typeMatchesIn) {
                    typeMatchesOut.add(typeMatchesIn_);
                }
                this.typeMatches = typeMatchesOut;
            }
        }

        @Override
        public ConflictImportDTO withTypeMatches(List<String> v) {
            this.typeMatches = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ClassContentImpl
    implements ClassContent,
    JsonSerializable {
        protected boolean generated;
        protected String content;

        public static ClassContentImpl make() {
            return new ClassContentImpl();
        }

        public ClassContentImpl() {
        }

        @Override
        public boolean isGenerated() {
            return this.generated;
        }

        @Override
        public void setGenerated(boolean v) {
            this.generated = v;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public void setContent(String v) {
            this.content = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassContentImpl)) {
                return false;
            }
            ClassContentImpl other = (ClassContentImpl)o;
            if (this.generated != other.generated) {
                return false;
            }
            return !(this.content != null ? !this.content.equals(other.content) : other.content != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Boolean.valueOf(this.generated).hashCode();
            hash = hash * 31 + (this.content != null ? this.content.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ClassContentImpl fromJsonElement(JsonElement jsonElem) {
            return (ClassContentImpl)gson.fromJson(jsonElem, ClassContentImpl.class);
        }

        public static ClassContentImpl fromJsonString(String jsonString) {
            return (ClassContentImpl)gson.fromJson(jsonString, ClassContentImpl.class);
        }

        public ClassContentImpl(ClassContent origin) {
            this.generated = origin.isGenerated();
            this.content = origin.getContent();
        }

        public ClassContent withGenerated(boolean v) {
            this.generated = v;
            return this;
        }

        public ClassContent withContent(String v) {
            this.content = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class ChangeImpl
    implements Change,
    JsonSerializable {
        protected String text;
        protected int offset;
        protected int length;

        public static ChangeImpl make() {
            return new ChangeImpl();
        }

        public ChangeImpl() {
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String v) {
            this.text = v;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setLength(int v) {
            this.length = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChangeImpl)) {
                return false;
            }
            ChangeImpl other = (ChangeImpl)o;
            if (this.text != null ? !this.text.equals(other.text) : other.text != null) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.length == other.length;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.text != null ? this.text.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            hash = hash * 31 + Integer.valueOf(this.length).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static ChangeImpl fromJsonElement(JsonElement jsonElem) {
            return (ChangeImpl)gson.fromJson(jsonElem, ChangeImpl.class);
        }

        public static ChangeImpl fromJsonString(String jsonString) {
            return (ChangeImpl)gson.fromJson(jsonString, ChangeImpl.class);
        }

        public ChangeImpl(Change origin) {
            this.text = origin.getText();
            this.offset = origin.getOffset();
            this.length = origin.getLength();
        }

        @Override
        public Change withText(String v) {
            this.text = v;
            return this;
        }

        @Override
        public Change withOffset(int v) {
            this.offset = v;
            return this;
        }

        @Override
        public Change withLength(int v) {
            this.length = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class OpenDeclarationDescriptorImpl
    implements OpenDeclarationDescriptor,
    JsonSerializable {
        protected int offset;
        protected String path;
        protected boolean binary;
        protected int length;
        protected int libId;

        public static OpenDeclarationDescriptorImpl make() {
            return new OpenDeclarationDescriptorImpl();
        }

        public OpenDeclarationDescriptorImpl() {
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public void setOffset(int v) {
            this.offset = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        @Override
        public boolean isBinary() {
            return this.binary;
        }

        @Override
        public void setBinary(boolean v) {
            this.binary = v;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void setLength(int v) {
            this.length = v;
        }

        @Override
        public int getLibId() {
            return this.libId;
        }

        @Override
        public void setLibId(int v) {
            this.libId = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof OpenDeclarationDescriptorImpl)) {
                return false;
            }
            OpenDeclarationDescriptorImpl other = (OpenDeclarationDescriptorImpl)o;
            if (this.offset != other.offset) {
                return false;
            }
            if (this.path != null ? !this.path.equals(other.path) : other.path != null) {
                return false;
            }
            if (this.binary != other.binary) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            return this.libId == other.libId;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + Integer.valueOf(this.offset).hashCode();
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.binary).hashCode();
            hash = hash * 31 + Integer.valueOf(this.length).hashCode();
            hash = hash * 31 + Integer.valueOf(this.libId).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static OpenDeclarationDescriptorImpl fromJsonElement(JsonElement jsonElem) {
            return (OpenDeclarationDescriptorImpl)gson.fromJson(jsonElem, OpenDeclarationDescriptorImpl.class);
        }

        public static OpenDeclarationDescriptorImpl fromJsonString(String jsonString) {
            return (OpenDeclarationDescriptorImpl)gson.fromJson(jsonString, OpenDeclarationDescriptorImpl.class);
        }

        public OpenDeclarationDescriptorImpl(OpenDeclarationDescriptor origin) {
            this.offset = origin.getOffset();
            this.path = origin.getPath();
            this.binary = origin.isBinary();
            this.length = origin.getLength();
            this.libId = origin.getLibId();
        }

        public OpenDeclarationDescriptor withOffset(int v) {
            this.offset = v;
            return this;
        }

        public OpenDeclarationDescriptor withPath(String v) {
            this.path = v;
            return this;
        }

        public OpenDeclarationDescriptor withBinary(boolean v) {
            this.binary = v;
            return this;
        }

        public OpenDeclarationDescriptor withLength(int v) {
            this.length = v;
            return this;
        }

        public OpenDeclarationDescriptor withLibId(int v) {
            this.libId = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class JarEntryImpl
    implements JarEntry,
    JsonSerializable {
        protected String name;
        protected JarEntry.JarEntryType type;
        protected String path;

        public static JarEntryImpl make() {
            return new JarEntryImpl();
        }

        public JarEntryImpl() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String v) {
            this.name = v;
        }

        @Override
        public JarEntry.JarEntryType getType() {
            return this.type;
        }

        @Override
        public void setType(JarEntry.JarEntryType v) {
            this.type = v;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String v) {
            this.path = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JarEntryImpl)) {
                return false;
            }
            JarEntryImpl other = (JarEntryImpl)o;
            if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals((Object)other.type) : other.type != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(other.path) : other.path != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static JarEntryImpl fromJsonElement(JsonElement jsonElem) {
            return (JarEntryImpl)gson.fromJson(jsonElem, JarEntryImpl.class);
        }

        public static JarEntryImpl fromJsonString(String jsonString) {
            return (JarEntryImpl)gson.fromJson(jsonString, JarEntryImpl.class);
        }

        public JarEntryImpl(JarEntry origin) {
            this.name = origin.getName();
            this.type = origin.getType();
            this.path = origin.getPath();
        }

        public JarEntry withName(String v) {
            this.name = v;
            return this;
        }

        public JarEntry withType(JarEntry.JarEntryType v) {
            this.type = v;
            return this;
        }

        public JarEntry withPath(String v) {
            this.path = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class JarImpl
    implements Jar,
    JsonSerializable {
        protected String name;
        protected int id;

        public static JarImpl make() {
            return new JarImpl();
        }

        public JarImpl() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String v) {
            this.name = v;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int v) {
            this.id = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JarImpl)) {
                return false;
            }
            JarImpl other = (JarImpl)o;
            if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
                return false;
            }
            return this.id == other.id;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.id).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static JarImpl fromJsonElement(JsonElement jsonElem) {
            return (JarImpl)gson.fromJson(jsonElem, JarImpl.class);
        }

        public static JarImpl fromJsonString(String jsonString) {
            return (JarImpl)gson.fromJson(jsonString, JarImpl.class);
        }

        public JarImpl(Jar origin) {
            this.name = origin.getName();
            this.id = origin.getId();
        }

        public Jar withName(String v) {
            this.name = v;
            return this;
        }

        public Jar withId(int v) {
            this.id = v;
            return this;
        }
    }
}

