/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.ide.maven.tools.BuildBase;
import org.eclipse.che.ide.maven.tools.Plugin;
import org.eclipse.che.ide.maven.tools.Resource;

public class Build
extends BuildBase {
    private static final ElementMapper<Resource> RESOURCE_MAPPER = new ResourceMapper();
    private static final ElementMapper<Plugin> PLUGIN_MAPPER = new PluginMapper();
    private String sourceDirectory;
    private String testSourceDirectory;
    private String scriptSourceDirectory;
    private String outputDirectory;
    private String testOutputDirectory;
    private List<Resource> resources;
    private List<Plugin> plugins;
    Element buildElement;

    public Build() {
    }

    Build(Element buildElement) {
        super(buildElement);
        this.buildElement = buildElement;
        this.sourceDirectory = buildElement.getChildText("sourceDirectory");
        this.testSourceDirectory = buildElement.getChildText("testSourceDirectory");
        this.scriptSourceDirectory = buildElement.getChildText("scriptSourceDirectory");
        this.outputDirectory = buildElement.getChildText("outputDirectory");
        this.testOutputDirectory = buildElement.getChildText("testOutputDirectory");
        if (buildElement.hasSingleChild("resources")) {
            this.resources = buildElement.getSingleChild("resources").getChildren(RESOURCE_MAPPER);
        }
        if (buildElement.hasSingleChild("plugins")) {
            this.plugins = buildElement.getSingleChild("plugins").getChildren(PLUGIN_MAPPER);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public Build setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        if (!this.isNew()) {
            if (outputDirectory == null) {
                this.buildElement.removeChild("outputDirectory");
            } else if (this.buildElement.hasSingleChild("outputDirectory")) {
                this.buildElement.getSingleChild("outputDirectory").setText(outputDirectory);
            } else {
                this.buildElement.appendChild(NewElement.createElement((String)"outputDirectory", (String)outputDirectory));
            }
        }
        return this;
    }

    public Build setScriptSourceDirectory(String scriptSourceDirectory) {
        this.scriptSourceDirectory = scriptSourceDirectory;
        if (!this.isNew()) {
            if (scriptSourceDirectory == null) {
                this.buildElement.removeChild("scriptSourceDirectory");
            } else if (this.buildElement.hasSingleChild("scriptSourceDirectory")) {
                this.buildElement.getSingleChild("scriptSourceDirectory").setText(scriptSourceDirectory);
            } else {
                this.buildElement.appendChild(NewElement.createElement((String)"scriptSourceDirectory", (String)scriptSourceDirectory));
            }
        }
        return this;
    }

    public Build setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        if (!this.isNew()) {
            if (sourceDirectory == null) {
                this.buildElement.removeChild("sourceDirectory");
            } else if (this.buildElement.hasSingleChild("sourceDirectory")) {
                this.buildElement.getSingleChild("sourceDirectory").setText(sourceDirectory);
            } else {
                this.buildElement.appendChild(NewElement.createElement((String)"sourceDirectory", (String)sourceDirectory));
            }
        }
        return this;
    }

    public Build setTestOutputDirectory(String testOutputDirectory) {
        this.testOutputDirectory = testOutputDirectory;
        if (!this.isNew()) {
            if (testOutputDirectory == null) {
                this.buildElement.removeChild("testOutputDirectory");
            } else if (this.buildElement.hasSingleChild("testOutputDirectory")) {
                this.buildElement.getSingleChild("testOutputDirectory").setText(testOutputDirectory);
            } else {
                this.buildElement.appendChild(NewElement.createElement((String)"testOutputDirectory", (String)testOutputDirectory));
            }
        }
        return this;
    }

    public Build setTestSourceDirectory(String testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
        if (!this.isNew()) {
            if (testSourceDirectory == null) {
                this.buildElement.removeChild("testSourceDirectory");
            } else if (this.buildElement.hasSingleChild("testSourceDirectory")) {
                this.buildElement.getSingleChild("testSourceDirectory").setText(testSourceDirectory);
            } else {
                this.buildElement.appendChild(NewElement.createElement((String)"testSourceDirectory", (String)testSourceDirectory));
            }
        }
        return this;
    }

    @Override
    public List<Resource> getResources() {
        if (this.resources == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Resource>(this.resources);
    }

    @Override
    public Build setResources(Collection<? extends Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            this.removeResources();
        } else {
            this.setResources0(resources);
        }
        return this;
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Plugin>(this.plugins);
    }

    public Map<String, Plugin> getPluginsAsMap() {
        HashMap<String, Plugin> pluginsMap = new HashMap<String, Plugin>();
        for (Plugin plugin : this.plugins()) {
            pluginsMap.put(plugin.getId(), plugin);
        }
        return pluginsMap;
    }

    public Build setPlugins(Collection<? extends Plugin> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            this.removePlugins();
        } else {
            this.setPlugins0(plugins);
        }
        return this;
    }

    private void removePlugins() {
        if (!this.isNew()) {
            this.buildElement.removeChild("plugins");
        }
        this.plugins = null;
    }

    private void setPlugins0(Collection<? extends Plugin> plugins) {
        this.plugins = new ArrayList<Plugin>(plugins);
        if (this.isNew()) {
            return;
        }
        if (this.buildElement.hasSingleChild("plugins")) {
            Element pluginsElement = this.buildElement.getSingleChild("plugins");
            for (Element element : pluginsElement.getChildren()) {
                element.remove();
            }
            for (Plugin plugin : plugins) {
                pluginsElement.appendChild(plugin.asXMLElement());
            }
        } else {
            this.buildElement.appendChild(this.newPluginsElement(plugins));
        }
    }

    private List<Plugin> plugins() {
        return this.plugins == null ? (this.plugins = new ArrayList<Plugin>()) : this.plugins;
    }

    public NewElement asXMLElement() {
        List<Resource> testResources;
        NewElement xmlBuildElement = NewElement.createElement((String)"build");
        if (!Strings.isNullOrEmpty((String)this.getDefaultGoal())) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"defaultGoal", (String)this.getDefaultGoal()));
        }
        if (!Strings.isNullOrEmpty((String)this.getFinalName())) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"finalName", (String)this.getFinalName()));
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            xmlBuildElement.appendChild(this.newResourcesElement(this.resources));
        }
        if ((testResources = this.getTestResources()) != null && !testResources.isEmpty()) {
            xmlBuildElement.appendChild(this.newTestResourcesElement(testResources));
        }
        if (this.sourceDirectory != null) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"sourceDirectory", (String)this.sourceDirectory));
        }
        if (this.testSourceDirectory != null) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"testSourceDirectory", (String)this.testSourceDirectory));
        }
        if (this.scriptSourceDirectory != null) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"scriptSourceDirectory", (String)this.scriptSourceDirectory));
        }
        if (this.outputDirectory != null) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"outputDirectory", (String)this.outputDirectory));
        }
        if (this.testOutputDirectory != null) {
            xmlBuildElement.appendChild(NewElement.createElement((String)"testOutputDirectory", (String)this.testOutputDirectory));
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            xmlBuildElement.appendChild(this.newResourcesElement(this.resources));
        }
        if (this.plugins != null && !this.plugins.isEmpty()) {
            xmlBuildElement.appendChild(this.newPluginsElement(this.plugins));
        }
        return xmlBuildElement;
    }

    private boolean isNew() {
        return this.buildElement == null;
    }

    private NewElement newPluginsElement(Collection<? extends Plugin> plugins) {
        NewElement xmlPlugins = NewElement.createElement((String)"plugins");
        for (Plugin plugin : plugins) {
            xmlPlugins.appendChild(plugin.asXMLElement());
        }
        return xmlPlugins;
    }

    private NewElement newResourcesElement(List<Resource> resources) {
        NewElement resourcesElement = NewElement.createElement((String)"resources");
        for (Resource resource : resources) {
            resourcesElement.appendChild(resource.asXMLElement());
        }
        return resourcesElement;
    }

    private void setResources0(Collection<? extends Resource> resources) {
        this.resources = new ArrayList<Resource>(resources);
        if (this.isNew()) {
            return;
        }
        if (this.buildElement.hasSingleChild("resources")) {
            Element resourcesElement = this.buildElement.getSingleChild("resources");
            for (Element element : resourcesElement.getChildren()) {
                element.remove();
            }
            for (Resource resource : resources) {
                resourcesElement.appendChild(resource.asXMLElement());
                resource.resourceElement = resourcesElement.getLastChild();
            }
        } else {
            this.buildElement.appendChild(this.newResourcesElement(this.resources));
        }
    }

    private void removeResources() {
        if (!this.isNew()) {
            this.buildElement.removeChild("resources");
        }
        this.resources = null;
    }

    private static class PluginMapper
    implements ElementMapper<Plugin> {
        private PluginMapper() {
        }

        public Plugin map(Element element) {
            return new Plugin(element);
        }
    }

    private static class ResourceMapper
    implements ElementMapper<Resource> {
        private ResourceMapper() {
        }

        public Resource map(Element element) {
            return new Resource(element);
        }
    }
}

