/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;

public class Plugin {
    private String artifactId;
    private String groupId;
    private String version;
    private Map<String, String> configuration;
    Element pluginElement;

    public Plugin() {
    }

    Plugin(Element element) {
        this.pluginElement = element;
        if (element.hasSingleChild("artifactId")) {
            this.artifactId = element.getChildText("artifactId");
        }
        if (element.hasSingleChild("groupId")) {
            this.groupId = element.getChildText("groupId");
        }
        if (element.hasSingleChild("version")) {
            this.groupId = element.getChildText("version");
        }
        if (element.hasSingleChild("configuration")) {
            this.configuration = this.fetchConfiguration(element.getSingleChild("configuration"));
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Map<String, String> getConfiguration() {
        if (this.configuration == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.configuration);
    }

    public Plugin setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        if (!this.isNew()) {
            if (artifactId == null) {
                this.pluginElement.removeChild("artifactId");
            } else if (this.pluginElement.hasSingleChild("artifactId")) {
                this.pluginElement.getSingleChild("artifactId").setText(artifactId);
            } else {
                this.pluginElement.insertChild(NewElement.createElement((String)"artifactId", (String)artifactId), XMLTreeLocation.after((String)"groupId").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Plugin setVersion(String version) {
        this.version = version;
        if (!this.isNew()) {
            if (version == null) {
                this.pluginElement.removeChild("version");
            } else if (this.pluginElement.hasSingleChild("version")) {
                this.pluginElement.getSingleChild("version").setText(version);
            } else {
                this.pluginElement.insertChild(NewElement.createElement((String)"version", (String)version), XMLTreeLocation.after((String)"artifactId").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public Plugin setGroupId(String groupId) {
        this.groupId = groupId;
        if (!this.isNew()) {
            if (groupId == null) {
                this.pluginElement.removeChild("groupId");
            } else if (this.pluginElement.hasSingleChild("groupId")) {
                this.pluginElement.getSingleChild("groupId").setText(groupId);
            } else {
                this.pluginElement.insertChild(NewElement.createElement((String)"groupId", (String)groupId), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public Plugin setConfiguration(Map<String, String> configuration) {
        if (configuration == null || configuration.isEmpty()) {
            this.removeConfiguration();
        } else {
            this.setConfiguration0(configuration);
        }
        return this;
    }

    public Plugin setConfigProperty(String name, String value) {
        Objects.requireNonNull(name, "Configuration property name should not be null");
        Objects.requireNonNull(value, "Configuration property value should not be null");
        if (!this.isNew()) {
            this.addConfigPropertyToXML(name, value);
        }
        this.configuration().put(name, value);
        return this;
    }

    public Plugin removeConfigProperty(String name) {
        Objects.requireNonNull(name, "Configuration property name should ne null");
        if (this.configuration().remove(name) != null && !this.isNew()) {
            this.removeConfigPropertyFromXML(name);
        }
        return this;
    }

    public String getId() {
        return this.groupId + ':' + this.artifactId;
    }

    public String toString() {
        return this.getId();
    }

    private void removeConfigPropertyFromXML(String name) {
        if (this.configuration.isEmpty()) {
            this.pluginElement.removeChild("configuration");
        } else {
            this.pluginElement.getSingleChild("configuration").removeChild(name);
        }
    }

    private void addConfigPropertyToXML(String name, String value) {
        if (this.configuration().containsKey(name)) {
            this.pluginElement.getSingleChild("configuration").getSingleChild(name).setText(value);
        } else if (this.configuration.isEmpty()) {
            this.pluginElement.appendChild(NewElement.createElement((String)"configuration", (NewElement[])new NewElement[]{NewElement.createElement((String)name, (String)value)}));
        } else {
            this.pluginElement.getSingleChild("configuration").appendChild(NewElement.createElement((String)name, (String)value));
        }
    }

    private Map<String, String> configuration() {
        return this.configuration == null ? (this.configuration = new HashMap<String, String>()) : this.configuration;
    }

    private void setConfiguration0(Map<String, String> configuration) {
        this.configuration = new HashMap<String, String>(configuration);
        if (this.isNew()) {
            return;
        }
        if (this.pluginElement.hasSingleChild("configuration")) {
            Element confElement = this.pluginElement.getSingleChild("configuration");
            for (Element element : confElement.getChildren()) {
                element.remove();
            }
            for (Map.Entry entry : configuration.entrySet()) {
                confElement.appendChild(NewElement.createElement((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        } else {
            NewElement newConfiguration = NewElement.createElement((String)"configuration");
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                newConfiguration.appendChild(NewElement.createElement((String)entry.getKey(), (String)entry.getValue()));
            }
            this.pluginElement.appendChild(newConfiguration);
        }
    }

    private void removeConfiguration() {
        if (!this.isNew()) {
            this.pluginElement.removeChild("properties");
        }
        this.configuration = null;
    }

    private Map<String, String> fetchConfiguration(Element element) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Element configProperty : element.getChildren()) {
            if (configProperty.hasChildren()) continue;
            configuration.put(configProperty.getName(), configProperty.getText());
        }
        return configuration;
    }

    NewElement asXMLElement() {
        NewElement xmlPlugin = NewElement.createElement((String)"plugin");
        if (this.groupId != null) {
            xmlPlugin.appendChild(NewElement.createElement((String)"groupId", (String)this.groupId));
        }
        if (this.artifactId != null) {
            xmlPlugin.appendChild(NewElement.createElement((String)"artifactId", (String)this.artifactId));
        }
        if (this.version != null) {
            xmlPlugin.appendChild(NewElement.createElement((String)"version", (String)this.version));
        }
        if (this.configuration != null && !this.configuration.isEmpty()) {
            NewElement configElement = NewElement.createElement((String)"configuration");
            for (Map.Entry<String, String> configProperty : this.configuration.entrySet()) {
                configElement.appendChild(NewElement.createElement((String)configProperty.getKey(), (String)configProperty.getValue()));
            }
            xmlPlugin.appendChild(configElement);
        }
        return xmlPlugin;
    }

    private boolean isNew() {
        return this.pluginElement == null;
    }
}

