/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;

public class RepositoryPolicy {
    Element element;
    private Boolean isEnabled;
    private String checksumPolicy;
    private String updatePolicy;

    public RepositoryPolicy(boolean isEnabled, String checksumPolicy, String updatePolicy) {
        this.isEnabled = isEnabled;
        this.checksumPolicy = checksumPolicy;
        this.updatePolicy = updatePolicy;
    }

    public RepositoryPolicy() {
    }

    RepositoryPolicy(Element element) {
        this.element = element;
        this.isEnabled = Boolean.parseBoolean(element.getChildText("enabled"));
        this.updatePolicy = element.getChildText("updatePolicy");
        this.checksumPolicy = element.getChildText("checksumPolicy");
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public RepositoryPolicy setEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (this.element != null) {
            if (isEnabled == null) {
                this.element.removeChild("enabled");
            } else if (this.element.hasSingleChild("enabled")) {
                this.element.getSingleChild("enabled").setText(Boolean.toString(isEnabled));
            } else {
                this.element.insertChild(NewElement.createElement((String)"enabled", (String)Boolean.toString(isEnabled)), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public RepositoryPolicy setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
        if (this.element != null) {
            if (checksumPolicy == null) {
                this.element.removeChild("checksumPolicy");
            } else if (this.element.hasSingleChild("checksumPolicy")) {
                this.element.getSingleChild("checksumPolicy").setText(checksumPolicy);
            } else {
                this.element.insertChild(NewElement.createElement((String)"checksumPolicy", (String)checksumPolicy), XMLTreeLocation.inTheEnd());
            }
        }
        return this;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public RepositoryPolicy setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
        if (this.element != null) {
            if (updatePolicy == null) {
                this.element.removeChild("updatePolicy");
            } else if (this.element.hasSingleChild("updatePolicy")) {
                this.element.getSingleChild("updatePolicy").setText(updatePolicy);
            } else {
                this.element.insertChild(NewElement.createElement((String)"updatePolicy", (String)updatePolicy), XMLTreeLocation.after((String)"enabled").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    NewElement asXMLElement(String parentName) {
        NewElement xmlPolicy = NewElement.createElement((String)parentName);
        if (this.isEnabled != null) {
            xmlPolicy.appendChild(NewElement.createElement((String)"enabled", (String)Boolean.toString(this.isEnabled)));
        }
        if (this.checksumPolicy != null) {
            xmlPolicy.appendChild(NewElement.createElement((String)"checksumPolicy", (String)this.checksumPolicy));
        }
        if (this.updatePolicy != null) {
            xmlPolicy.appendChild(NewElement.createElement((String)"updatePolicy", (String)this.updatePolicy));
        }
        return xmlPolicy;
    }

    void remove() {
        if (this.element != null) {
            this.element.remove();
            this.element = null;
        }
    }
}

