/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import com.google.common.base.Strings;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.ide.maven.tools.ActivationFile;
import org.eclipse.che.ide.maven.tools.ActivationOS;
import org.eclipse.che.ide.maven.tools.ActivationProperty;

public class Activation {
    public Element element;
    private String activeByDefault;
    private ActivationOS os;
    private ActivationFile file;
    private ActivationProperty property;
    private String jdk;

    public Activation(Element element) {
        this.element = element;
        if (element.hasSingleChild("activeByDefault")) {
            this.activeByDefault = element.getChildText("activeByDefault");
        }
        if (element.hasSingleChild("os")) {
            this.os = new ActivationOS(element.getSingleChild("os"));
        }
        if (element.hasSingleChild("file")) {
            this.file = new ActivationFile(element.getSingleChild("file"));
        }
        if (element.hasSingleChild("property")) {
            this.property = new ActivationProperty(element.getSingleChild("property"));
        }
        if (element.hasSingleChild("jdk")) {
            this.jdk = element.getChildText("jdk");
        }
    }

    public String isActiveByDefault() {
        return this.activeByDefault;
    }

    public Activation setActiveByDefault(String activeByDefault) {
        this.activeByDefault = activeByDefault;
        if (!this.isNew()) {
            if (Strings.isNullOrEmpty((String)activeByDefault)) {
                this.element.removeChild("activeByDefault");
            } else if (this.element.hasSingleChild("activeByDefault")) {
                this.element.getSingleChild("activeByDefault").setText(activeByDefault);
            } else {
                this.element.appendChild(NewElement.createElement((String)"activeByDefault", (String)activeByDefault));
            }
        }
        return this;
    }

    public ActivationOS getOs() {
        return this.os;
    }

    public Activation setOs(ActivationOS os) {
        this.os = os;
        if (!this.isNew()) {
            if (os == null) {
                this.element.removeChild("os");
            } else if (this.element.hasSingleChild("os")) {
                this.element.removeChild("os");
                this.element.appendChild(os.asXMLElement());
            } else {
                this.element.appendChild(os.asXMLElement());
            }
        }
        return this;
    }

    public ActivationFile getFile() {
        return this.file;
    }

    public Activation setFile(ActivationFile file) {
        this.file = file;
        if (!this.isNew()) {
            if (file == null) {
                this.element.removeChild("file");
            } else if (this.element.hasSingleChild("file")) {
                this.element.removeChild("file");
                this.element.appendChild(file.asXMLElement());
            } else {
                this.element.appendChild(file.asXMLElement());
            }
        }
        return this;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public Activation setProperty(ActivationProperty property) {
        this.property = property;
        if (!this.isNew()) {
            if (property == null) {
                this.element.removeChild("property");
            } else if (this.element.hasSingleChild("property")) {
                this.element.removeChild("property");
                this.element.appendChild(property.asXMLElement());
            } else {
                this.element.appendChild(property.asXMLElement());
            }
        }
        return this;
    }

    public String getJdk() {
        return this.jdk;
    }

    public Activation setJdk(String jdk) {
        this.jdk = jdk;
        if (!this.isNew()) {
            if (Strings.isNullOrEmpty((String)jdk)) {
                this.element.removeChild("jdk");
            } else if (this.element.hasSingleChild("jdk")) {
                this.element.getSingleChild("jdk").setText(jdk);
            } else {
                this.element.appendChild(NewElement.createElement((String)"jdk", (String)jdk));
            }
        }
        return this;
    }

    public void remove() {
        if (this.element != null) {
            this.element.remove();
            this.element = null;
        }
    }

    private boolean isNew() {
        return this.element == null;
    }

    public NewElement asXMLElement() {
        NewElement activation = NewElement.createElement((String)"activation");
        if (!Strings.isNullOrEmpty((String)this.activeByDefault)) {
            activation.appendChild(NewElement.createElement((String)"activeByDefault", (String)this.activeByDefault));
        }
        if (this.os != null) {
            activation.appendChild(this.os.asXMLElement());
        }
        if (this.file != null) {
            activation.appendChild(this.file.asXMLElement());
        }
        if (this.property != null) {
            activation.appendChild(this.property.asXMLElement());
        }
        if (!Strings.isNullOrEmpty((String)this.jdk)) {
            activation.appendChild(NewElement.createElement((String)"jdk", (String)this.jdk));
        }
        return activation;
    }
}

