/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.ide.maven.tools.Dependency;

public class Dependencies {
    private List<Dependency> dependencies;
    Element dependenciesParent;

    Dependencies(Element dependenciesParent) {
        this(dependenciesParent, new ArrayList<Dependency>());
    }

    Dependencies(Element dependenciesParent, List<Dependency> dependencies) {
        this.dependenciesParent = dependenciesParent;
        this.dependencies = dependencies;
    }

    public List<Dependency> get() {
        return new ArrayList<Dependency>(this.dependencies());
    }

    private List<Dependency> dependencies() {
        return this.dependencies == null ? (this.dependencies = new ArrayList<Dependency>()) : this.dependencies;
    }

    public Dependencies add(Dependency dependency) {
        this.dependencies.add(Objects.requireNonNull(dependency, "Required not null dependency"));
        if (!this.isNew()) {
            this.addDependencyToXML(dependency);
        }
        return this;
    }

    public Dependencies remove(Dependency dependency) {
        if (this.dependencies().remove(Objects.requireNonNull(dependency, "Required not null dependency")) && !this.isNew()) {
            this.removeDependencyFromXML(dependency);
        }
        return this;
    }

    public Dependencies set(Collection<? extends Dependency> newDependencies) {
        if (newDependencies == null || newDependencies.isEmpty()) {
            this.removeDependencies();
        } else if (this.isNew()) {
            this.dependencies = new ArrayList<Dependency>(newDependencies);
        } else {
            this.setDependencies(newDependencies);
        }
        return this;
    }

    private void removeDependencies() {
        if (!this.isNew()) {
            this.dependenciesParent.removeChild("dependencies");
        }
        this.dependencies = null;
    }

    public Dependency first() {
        return this.dependencies().isEmpty() ? null : this.dependencies.get(0);
    }

    public Dependency last() {
        return this.dependencies().isEmpty() ? null : this.dependencies.get(this.dependencies.size() - 1);
    }

    void remove() {
        this.dependencies = null;
    }

    NewElement asXMLElement() {
        NewElement newDependencies = NewElement.createElement((String)"dependencies");
        for (Dependency dependency : this.dependencies) {
            newDependencies.appendChild(dependency.asXMLElement());
        }
        return newDependencies;
    }

    private void addDependencyToXML(Dependency dependency) {
        if (this.dependenciesParent.hasSingleChild("dependencies")) {
            this.dependenciesParent.getSingleChild("dependencies").appendChild(dependency.asXMLElement());
        } else {
            this.dependenciesParent.appendChild(NewElement.createElement((String)"dependencies", (NewElement[])new NewElement[]{dependency.asXMLElement()}));
        }
        dependency.dependencyElement = this.dependenciesParent.getSingleChild("dependencies").getLastChild();
    }

    private void removeDependencyFromXML(Dependency dependency) {
        if (this.dependencies.isEmpty()) {
            this.dependenciesParent.removeChild("dependencies");
            dependency.dependencyElement = null;
        } else {
            dependency.remove();
        }
    }

    private void setDependencies(Collection<? extends Dependency> newDependencies) {
        for (Dependency dependency : this.dependencies) {
            dependency.remove();
        }
        this.dependencies = new ArrayList<Dependency>(newDependencies.size());
        for (Dependency dependency : newDependencies) {
            this.add(dependency);
        }
    }

    private boolean isNew() {
        return this.dependenciesParent == null;
    }
}

