/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;
import org.eclipse.che.ide.maven.tools.Exclusion;

public class Dependency {
    private static final ToExclusionMapper TO_EXCLUSION_MAPPER = new ToExclusionMapper();
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;
    private String scope;
    private String optional;
    private List<Exclusion> exclusions;
    Element dependencyElement;

    public Dependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public Dependency() {
    }

    Dependency(Element element) {
        this.dependencyElement = element;
        this.artifactId = element.getChildText("artifactId");
        this.groupId = element.getChildText("groupId");
        this.version = element.getChildText("version");
        this.classifier = element.getChildText("classifier");
        this.optional = element.getChildText("optional");
        this.scope = element.getChildText("scope");
        this.type = element.getChildText("type");
        if (element.hasSingleChild("exclusions")) {
            this.exclusions = element.getSingleChild("exclusions").getChildren((ElementMapper)TO_EXCLUSION_MAPPER);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public List<Exclusion> getExclusions() {
        if (this.exclusions == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Exclusion>(this.exclusions);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getOptional() {
        return this.optional;
    }

    public String getScope() {
        return this.scope == null ? "compile" : this.scope;
    }

    public String getType() {
        return this.type == null ? "jar" : this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public Dependency addExclusion(Exclusion exclusion) {
        Objects.requireNonNull(exclusion, "Required not null exclusion");
        this.exclusions().add(exclusion);
        if (!this.isNew()) {
            if (this.dependencyElement.hasSingleChild("exclusions")) {
                this.dependencyElement.getSingleChild("exclusions").appendChild(exclusion.asXMLElement());
            } else {
                this.dependencyElement.appendChild(NewElement.createElement((String)"exclusions", (NewElement[])new NewElement[]{exclusion.asXMLElement()}));
            }
            exclusion.exclusionElement = this.dependencyElement.getSingleChild("exclusions").getLastChild();
        }
        return this;
    }

    public Dependency removeExclusion(Exclusion exclusion) {
        Objects.requireNonNull(exclusion, "Required not null exclusion");
        this.exclusions().remove(exclusion);
        if (!this.isNew() && this.exclusions.isEmpty()) {
            this.dependencyElement.removeChild("exclusions");
            exclusion.exclusionElement = null;
        } else {
            exclusion.remove();
        }
        return this;
    }

    public Dependency setExclusions(Collection<? extends Exclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            this.removeExclusions();
        } else if (this.isNew()) {
            this.exclusions = new ArrayList<Exclusion>(exclusions);
        } else {
            this.setExclusions0(exclusions);
        }
        return this;
    }

    public Dependency setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        if (!this.isNew()) {
            if (artifactId == null) {
                this.dependencyElement.removeChild("artifactId");
            } else if (this.dependencyElement.hasSingleChild("artifactId")) {
                this.dependencyElement.getSingleChild("artifactId").setText(artifactId);
            } else {
                this.dependencyElement.insertChild(NewElement.createElement((String)"artifactId", (String)artifactId), XMLTreeLocation.after((String)"groupId").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public Dependency setClassifier(String classifier) {
        this.classifier = classifier;
        if (!this.isNew()) {
            if (classifier == null) {
                this.dependencyElement.removeChild("classifier");
            } else if (this.dependencyElement.hasSingleChild("classifier")) {
                this.dependencyElement.getSingleChild("classifier").setText(classifier);
            } else {
                this.dependencyElement.insertChild(NewElement.createElement((String)"classifier", (String)classifier), XMLTreeLocation.before((String)"exclusions").or(XMLTreeLocation.inTheEnd()));
            }
        }
        return this;
    }

    public Dependency setGroupId(String groupId) {
        this.groupId = groupId;
        if (!this.isNew()) {
            if (groupId == null) {
                this.dependencyElement.removeChild("groupId");
            } else if (this.dependencyElement.hasSingleChild("groupId")) {
                this.dependencyElement.getSingleChild("groupId").setText(groupId);
            } else {
                this.dependencyElement.insertChild(NewElement.createElement((String)"groupId", (String)groupId), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public Dependency setOptional(String optional) {
        this.optional = optional;
        if (!this.isNew()) {
            if (optional == null) {
                this.dependencyElement.removeChild("optional");
            } else if (this.dependencyElement.hasSingleChild("optional")) {
                this.dependencyElement.getSingleChild("optional").setText(optional);
            } else {
                this.dependencyElement.insertChild(NewElement.createElement((String)"optional", (String)optional), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public Dependency setScope(String scope) {
        this.scope = scope;
        if (!this.isNew()) {
            if (scope == null) {
                this.dependencyElement.removeChild("scope");
            } else if (this.dependencyElement.hasSingleChild("scope")) {
                this.dependencyElement.getSingleChild("scope").setText(scope);
            } else {
                this.dependencyElement.appendChild(NewElement.createElement((String)"scope", (String)scope));
            }
        }
        return this;
    }

    public Dependency setType(String type) {
        this.type = type;
        if (!this.isNew()) {
            if (type == null) {
                this.dependencyElement.removeChild("type");
            } else if (this.dependencyElement.hasSingleChild("type")) {
                this.dependencyElement.getSingleChild("type").setText(type);
            } else {
                this.dependencyElement.appendChild(NewElement.createElement((String)"type", (String)type));
            }
        }
        return this;
    }

    public Dependency setVersion(String version) {
        this.version = version;
        if (!this.isNew()) {
            if (version == null) {
                this.dependencyElement.removeChild("version");
            } else if (this.dependencyElement.hasChild("version")) {
                this.dependencyElement.getSingleChild("version").setText(version);
            } else {
                this.dependencyElement.insertChild(NewElement.createElement((String)"version", (String)version), XMLTreeLocation.afterAnyOf((String[])new String[]{"artifactId", "groupId"}).or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public boolean isOptional() {
        return Boolean.parseBoolean(this.optional);
    }

    public Dependency setOptional(boolean optional) {
        return this.setOptional(String.valueOf(optional));
    }

    public String toString() {
        return "Dependency {groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", type=" + this.type + "}";
    }

    public void remove() {
        if (!this.isNew()) {
            this.dependencyElement.remove();
            this.dependencyElement = null;
        }
    }

    NewElement asXMLElement() {
        NewElement newElement = NewElement.createElement((String)"dependency");
        newElement.appendChild(NewElement.createElement((String)"groupId", (String)this.groupId));
        newElement.appendChild(NewElement.createElement((String)"artifactId", (String)this.artifactId));
        newElement.appendChild(NewElement.createElement((String)"version", (String)this.version));
        if (this.scope != null && !this.scope.equals("compile")) {
            newElement.appendChild(NewElement.createElement((String)"scope", (String)this.scope));
        }
        if (this.type != null && !this.type.equals("jar")) {
            newElement.appendChild(NewElement.createElement((String)"type", (String)this.type));
        }
        if (this.classifier != null) {
            newElement.appendChild(NewElement.createElement((String)"classifier", (String)this.classifier));
        }
        if (this.optional != null) {
            newElement.appendChild(NewElement.createElement((String)"optional", (String)this.optional));
        }
        if (this.exclusions != null) {
            NewElement exclusionsEl = NewElement.createElement((String)"exclusions");
            for (Exclusion exclusion : this.exclusions) {
                exclusionsEl.appendChild(exclusion.asXMLElement());
            }
            exclusionsEl.appendChild(exclusionsEl);
        }
        return newElement;
    }

    private void setExclusions0(Collection<? extends Exclusion> exclusions) {
        for (Exclusion exclusion : this.exclusions()) {
            exclusion.remove();
        }
        this.exclusions = new ArrayList<Exclusion>(exclusions.size());
        for (Exclusion exclusion : exclusions) {
            this.addExclusion(exclusion);
        }
    }

    private void removeExclusions() {
        if (!this.isNew()) {
            this.dependencyElement.removeChild("exclusions");
        }
        this.exclusions = null;
    }

    private List<Exclusion> exclusions() {
        return this.exclusions == null ? (this.exclusions = new LinkedList<Exclusion>()) : this.exclusions;
    }

    private boolean isNew() {
        return this.dependencyElement == null;
    }

    private static class ToExclusionMapper
    implements ElementMapper<Exclusion> {
        private ToExclusionMapper() {
        }

        public Exclusion map(Element element) {
            return new Exclusion(element);
        }
    }
}

