/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.che.api.core.util.CommandLine;
import org.eclipse.che.api.core.util.LineConsumer;
import org.eclipse.che.api.core.util.ProcessUtil;
import org.eclipse.che.api.core.util.SystemInfo;
import org.eclipse.che.ide.maven.tools.Build;
import org.eclipse.che.ide.maven.tools.MavenArtifact;
import org.eclipse.che.ide.maven.tools.Model;
import org.eclipse.che.ide.maven.tools.Parent;
import org.eclipse.che.ide.maven.tools.Resource;

public class MavenUtils {
    public static final Pattern MAVEN_LOGGER_PREFIX_REMOVER = Pattern.compile("(\\[INFO\\]|\\[WARNING\\]|\\[DEBUG\\]|\\[ERROR\\])\\s+(.*)");

    private MavenUtils() {
    }

    public static String removeLoggerPrefix(String origin) {
        Matcher matcher = MAVEN_LOGGER_PREFIX_REMOVER.matcher(origin);
        if (matcher.matches()) {
            return origin.substring(matcher.start(2));
        }
        return origin;
    }

    public static List<Model> getModules(File sources) throws IOException {
        LinkedList<Model> modules = new LinkedList<Model>();
        MavenUtils.addModules(Model.readFrom(sources), modules);
        return modules;
    }

    private static void addModules(Model model, List<Model> modules) throws IOException {
        if (!"pom".equals(model.getPackaging())) {
            return;
        }
        for (String module : model.getModules()) {
            Path modulePom = model.getProjectDirectory().toPath().resolve(module).resolve("pom.xml");
            if (!Files.exists(modulePom, new LinkOption[0])) continue;
            Model child = Model.readFrom(modulePom);
            String relativePath = modulePom.getParent().relativize(model.getPomFile().toPath()).toString();
            child.setParent(new Parent(model.getGroupId(), model.getArtifactId(), model.getVersion()).setRelativePath(relativePath));
            modules.add(child);
            MavenUtils.addModules(child, modules);
        }
    }

    public static MavenArtifact parseMavenArtifact(String line) {
        String[] segments;
        if (line != null && (segments = MavenUtils.removeLoggerPrefix(line).split(":")).length >= 5) {
            String scope;
            String classifier;
            String version;
            String groupId = segments[0];
            String artifactId = segments[1];
            String type = segments[2];
            if (segments.length == 5) {
                version = segments[3];
                classifier = null;
                scope = segments[4];
            } else {
                version = segments[4];
                classifier = segments[3];
                scope = segments[5];
            }
            return new MavenArtifact(groupId, artifactId, type, classifier, version, scope);
        }
        return null;
    }

    public static String getMavenExecCommand() {
        File mvnHome = MavenUtils.getMavenHome();
        if (mvnHome != null) {
            String mvn = "bin" + File.separatorChar + "mvn";
            return new File(mvnHome, mvn).getAbsolutePath();
        }
        return "mvn";
    }

    public static File getMavenHome() {
        File m2Home;
        String m2HomeEnv = System.getenv("M2_HOME");
        if (m2HomeEnv == null) {
            return null;
        }
        if (SystemInfo.isWindows() && m2HomeEnv.contains(" ")) {
            m2HomeEnv = "\"" + m2HomeEnv + "\"";
        }
        return (m2Home = new File(m2HomeEnv)).exists() ? m2Home : null;
    }

    public static String getGroupId(Model model) {
        Parent parent;
        String groupId = model.getGroupId();
        if (groupId == null && (parent = model.getParent()) != null) {
            groupId = parent.getGroupId();
        }
        return groupId;
    }

    public static String getVersion(Model model) {
        Parent parent;
        String version = model.getVersion();
        if (version == null && (parent = model.getParent()) != null) {
            version = parent.getVersion();
        }
        return version;
    }

    public static List<String> getSourceDirectories(Model model) {
        LinkedList<String> list = new LinkedList<String>();
        Build build = model.getBuild();
        if (build != null) {
            if (build.getSourceDirectory() != null) {
                list.add(build.getSourceDirectory());
            } else if (build.getTestSourceDirectory() != null) {
                list.add(build.getTestSourceDirectory());
            }
        }
        if (list.isEmpty()) {
            list.add("src/main/java");
            list.add("src/test/java");
        }
        return list;
    }

    public static List<String> getSourceDirectories(File pom) throws IOException {
        return MavenUtils.getSourceDirectories(Model.readFrom(pom));
    }

    public static List<String> getResourceDirectories(Model model) {
        LinkedList<String> list = new LinkedList<String>();
        Build build = model.getBuild();
        if (build != null && build.getResources() != null && !build.getResources().isEmpty()) {
            for (Resource resource : build.getResources()) {
                list.add(resource.getDirectory());
            }
        }
        if (list.isEmpty()) {
            list.add("src/main/resources");
            list.add("src/test/resources");
        }
        return list;
    }

    public static List<String> getResourceDirectories(File pom) throws IOException {
        return MavenUtils.getResourceDirectories(Model.readFrom(pom));
    }

    public static Map<String, String> getMavenVersionInformation() throws IOException {
        final HashMap<String, String> versionInfo = new HashMap<String, String>();
        LineConsumer cmdOutput = new LineConsumer(){

            public void writeLine(String line) throws IOException {
                String key = null;
                int valueStart = 0;
                int l = line.length();
                if (line.startsWith("Apache Maven")) {
                    key = "Maven version";
                } else {
                    int keyEnd;
                    for (keyEnd = 0; keyEnd < l; ++keyEnd) {
                        if (line.charAt(keyEnd) != ':') continue;
                        valueStart = keyEnd + 1;
                        break;
                    }
                    if (keyEnd > 0) {
                        key = line.substring(0, keyEnd);
                    }
                }
                if (key != null) {
                    while (valueStart < l && Character.isWhitespace(line.charAt(valueStart))) {
                        ++valueStart;
                    }
                    if ("Maven version".equals(key)) {
                        int valueEnd;
                        for (valueEnd = valueStart; valueEnd < l && '(' != line.charAt(valueEnd); ++valueEnd) {
                        }
                        String value = line.substring(valueStart, valueEnd).trim();
                        versionInfo.put(key, value);
                    } else {
                        String value = line.substring(valueStart);
                        versionInfo.put(key, value);
                    }
                }
            }

            public void close() throws IOException {
            }
        };
        MavenUtils.readMavenVersionInformation(cmdOutput);
        return versionInfo;
    }

    private static void readMavenVersionInformation(LineConsumer cmdOutput) throws IOException {
        CommandLine commandLine = new CommandLine(new String[]{MavenUtils.getMavenExecCommand()}).add(new String[]{"-version"});
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(commandLine.toShellCommand()).redirectErrorStream(true);
        Process process = processBuilder.start();
        ProcessUtil.process((Process)process, (LineConsumer)cmdOutput, (LineConsumer)LineConsumer.DEV_NULL);
    }
}

