/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;
import org.eclipse.che.ide.maven.tools.RepositoryPolicy;

public class Repository {
    Element element;
    private String id;
    private String name;
    private String url;
    private String layout;
    private RepositoryPolicy snapshots;
    private RepositoryPolicy releases;

    public Repository() {
    }

    Repository(Element element) {
        this.element = element;
        this.id = element.getChildText("id");
        this.name = element.getChildText("name");
        this.url = element.getChildText("url");
        this.layout = element.getChildText("layout");
        if (element.hasSingleChild("snapshots")) {
            this.snapshots = new RepositoryPolicy(element.getSingleChild("snapshots"));
        }
        if (element.hasSingleChild("releases")) {
            this.releases = new RepositoryPolicy(element.getSingleChild("releases"));
        }
    }

    public String getId() {
        return this.id;
    }

    public Repository setId(String id) {
        this.id = id;
        if (this.element != null) {
            if (id == null) {
                this.element.removeChild("id");
            } else if (this.element.hasSingleChild("id")) {
                this.element.getSingleChild("id").setText(id);
            } else {
                this.element.insertChild(NewElement.createElement((String)"id", (String)id), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Repository setName(String name) {
        this.name = name;
        if (this.element != null) {
            if (name == null) {
                this.element.removeChild("name");
            } else if (this.element.hasSingleChild("name")) {
                this.element.getSingleChild("name").setText(name);
            } else {
                this.element.insertChild(NewElement.createElement((String)"name", (String)name), XMLTreeLocation.after((String)"id").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Repository setUrl(String url) {
        this.url = url;
        if (this.element != null) {
            if (url == null) {
                this.element.removeChild("url");
            } else if (this.element.hasSingleChild("url")) {
                this.element.getSingleChild("url").setText(url);
            } else {
                this.element.insertChild(NewElement.createElement((String)"url", (String)url), XMLTreeLocation.afterAnyOf((String[])new String[]{"name", "id"}).or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public String getLayout() {
        return this.layout;
    }

    public Repository setLayout(String layout) {
        this.layout = layout;
        if (this.element != null) {
            if (layout == null) {
                this.element.removeChild("layout");
            } else if (this.element.hasSingleChild("layout")) {
                this.element.getSingleChild("layout").setText(layout);
            } else {
                this.element.insertChild(NewElement.createElement((String)"layout", (String)layout), XMLTreeLocation.beforeAnyOf((String[])new String[]{"snapshots", "releases"}).or(XMLTreeLocation.inTheEnd()));
            }
        }
        return this;
    }

    public RepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    public Repository setSnapshots(RepositoryPolicy snapshots) {
        this.snapshots = snapshots;
        if (this.element != null) {
            if (snapshots == null) {
                this.element.removeChild("snapshots");
            } else if (this.element.hasSingleChild("snapshots")) {
                snapshots.element = this.element.getSingleChild("snapshots").replaceWith(snapshots.asXMLElement("snapshots"));
            } else {
                this.element.insertChild(snapshots.asXMLElement("snapshots"), XMLTreeLocation.before((String)"releases").or(XMLTreeLocation.inTheEnd()));
                snapshots.element = this.element.getSingleChild("snapshots");
            }
        }
        return this;
    }

    public RepositoryPolicy getReleases() {
        return this.releases;
    }

    public Repository setReleases(RepositoryPolicy releases) {
        this.releases = releases;
        if (this.element != null) {
            if (releases == null) {
                this.element.removeChild("releases");
            } else if (this.element.hasSingleChild("releases")) {
                releases.element = this.element.getSingleChild("releases").replaceWith(releases.asXMLElement("releases"));
            } else {
                this.element.appendChild(releases.asXMLElement("releases"));
                releases.element = this.element.getSingleChild("releases");
            }
        }
        return this;
    }

    NewElement asXMLElement() {
        NewElement repository = NewElement.createElement((String)"repository");
        if (this.id != null) {
            repository.appendChild(NewElement.createElement((String)"id", (String)this.id));
        }
        if (this.name != null) {
            repository.appendChild(NewElement.createElement((String)"name", (String)this.name));
        }
        if (this.url != null) {
            repository.appendChild(NewElement.createElement((String)"url", (String)this.url));
        }
        if (this.layout != null) {
            repository.appendChild(NewElement.createElement((String)"layout", (String)this.layout));
        }
        if (this.snapshots != null) {
            repository.appendChild(this.snapshots.asXMLElement("snapshots"));
        }
        if (this.releases != null) {
            repository.appendChild(this.releases.asXMLElement("releases"));
        }
        return repository;
    }

    void remove() {
        if (this.element != null) {
            this.element.remove();
            this.element = null;
            if (this.getSnapshots() != null) {
                this.getSnapshots().remove();
            }
            if (this.getReleases() != null) {
                this.getReleases().remove();
            }
        }
    }
}

