/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;
import org.eclipse.che.ide.maven.tools.Resource;

public class BuildBase {
    private static final ElementMapper<Resource> RESOURCE_MAPPER = new ResourceMapper();
    public Element element;
    private String finalName;
    private String defaultGoal;
    private List<Resource> resources;
    private List<Resource> testResources;

    BuildBase() {
    }

    BuildBase(Element element) {
        this.element = element;
        if (element.hasSingleChild("finalName")) {
            this.finalName = element.getChildText("finalName");
        }
        if (element.hasSingleChild("defaultGoal")) {
            this.defaultGoal = element.getChildText("defaultGoal");
        }
        if (element.hasSingleChild("resources")) {
            this.resources = element.getSingleChild("resources").getChildren(RESOURCE_MAPPER);
        }
        if (element.hasSingleChild("testResources")) {
            this.testResources = element.getSingleChild("testResources").getChildren(RESOURCE_MAPPER);
        }
    }

    public String getFinalName() {
        return this.finalName;
    }

    public BuildBase setFinalName(String finalName) {
        this.finalName = finalName;
        if (!this.isNew()) {
            if (Strings.isNullOrEmpty((String)finalName)) {
                this.element.removeChild("finalName");
            } else if (this.element.hasSingleChild("finalName")) {
                this.element.getSingleChild("finalName").setText(finalName);
            } else {
                this.element.insertChild(NewElement.createElement((String)"finalName", (String)finalName), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    public BuildBase setDefaultGoal(String defaultGoal) {
        this.defaultGoal = defaultGoal;
        if (!this.isNew()) {
            if (Strings.isNullOrEmpty((String)defaultGoal)) {
                this.element.removeChild("defaultGoal");
            } else if (this.element.hasSingleChild("defaultGoal")) {
                this.element.getSingleChild("defaultGoal").setText(defaultGoal);
            } else {
                this.element.insertChild(NewElement.createElement((String)"defaultGoal", (String)defaultGoal), XMLTreeLocation.after((String)"finalName").or(XMLTreeLocation.inTheEnd()));
            }
        }
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public BuildBase setResources(Collection<? extends Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            this.removeResources();
        } else {
            this.setResources0(resources);
        }
        return this;
    }

    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public BuildBase setTestResources(List<Resource> testResources) {
        if (testResources == null || testResources.isEmpty()) {
            this.removeTestResources();
        } else {
            this.setTestResources0(testResources);
        }
        return this;
    }

    public void remove() {
        if (this.element != null) {
            this.element.remove();
            this.element = null;
        }
    }

    private void setResources0(Collection<? extends Resource> resources) {
        this.resources = new ArrayList<Resource>(resources);
        if (this.isNew()) {
            return;
        }
        if (this.element.hasSingleChild("resources")) {
            Element resourcesElement = this.element.getSingleChild("resources");
            for (Element element : resourcesElement.getChildren()) {
                element.remove();
            }
            for (Resource resource : resources) {
                resourcesElement.appendChild(resource.asXMLElement());
                resource.resourceElement = resourcesElement.getLastChild();
            }
        } else {
            this.element.appendChild(this.newResourcesElement(this.resources));
        }
    }

    private void removeResources() {
        if (!this.isNew()) {
            this.element.removeChild("resources");
        }
        this.resources = null;
    }

    private void setTestResources0(Collection<? extends Resource> resources) {
        this.testResources = new ArrayList<Resource>(resources);
        if (this.isNew()) {
            return;
        }
        if (this.element.hasSingleChild("testResources")) {
            Element resourcesElement = this.element.getSingleChild("testResources");
            for (Element element : resourcesElement.getChildren()) {
                element.remove();
            }
            for (Resource resource : resources) {
                resourcesElement.appendChild(resource.asXMLElement());
                resource.resourceElement = resourcesElement.getLastChild();
            }
        } else {
            this.element.appendChild(this.newResourcesElement(this.testResources));
        }
    }

    private void removeTestResources() {
        if (!this.isNew()) {
            this.element.removeChild("testResources");
        }
        this.testResources = null;
    }

    private NewElement newResourcesElement(List<Resource> resources) {
        NewElement resourcesElement = NewElement.createElement((String)"resources");
        for (Resource resource : resources) {
            resourcesElement.appendChild(resource.asXMLElement());
        }
        return resourcesElement;
    }

    protected NewElement newTestResourcesElement(List<Resource> resources) {
        NewElement resourcesElement = NewElement.createElement((String)"testResources");
        for (Resource resource : resources) {
            resourcesElement.appendChild(resource.asXMLElement());
        }
        return resourcesElement;
    }

    private boolean isNew() {
        return this.element == null;
    }

    private static class ElementTextMapper
    implements ElementMapper<String> {
        private ElementTextMapper() {
        }

        public String map(Element element) {
            return element.getText();
        }
    }

    private static class ResourceMapper
    implements ElementMapper<Resource> {
        private ResourceMapper() {
        }

        public Resource map(Element element) {
            return new Resource(element);
        }
    }
}

