/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTree;
import org.eclipse.che.commons.xml.XMLTreeLocation;
import org.eclipse.che.ide.maven.tools.Build;
import org.eclipse.che.ide.maven.tools.Dependencies;
import org.eclipse.che.ide.maven.tools.Dependency;
import org.eclipse.che.ide.maven.tools.DependencyManagement;
import org.eclipse.che.ide.maven.tools.Parent;
import org.eclipse.che.ide.maven.tools.Profile;
import org.eclipse.che.ide.maven.tools.Repository;

public final class Model {
    private static final ToModuleMapper TO_MODULE_MAPPER = new ToModuleMapper();
    private static final ToProfileMapper TO_PROFILE_MAPPER = new ToProfileMapper();
    private static final ToDependencyMapper TO_DEPENDENCY_MAPPER = new ToDependencyMapper();
    private static final ToRepositoryMapper TO_REPOSITORY_MAPPER = new ToRepositoryMapper();
    private String modelVersion;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private String name;
    private String description;
    private Parent parent;
    private Build build;
    private DependencyManagement dependencyManagement;
    private Map<String, String> properties;
    private List<String> modules;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;
    private List<Profile> profiles;
    private Dependencies dependencies;
    private File pom;
    private final XMLTree tree;
    private final Element root;

    public static Model readFrom(InputStream is) throws IOException {
        return Model.fetchModel(XMLTree.from((InputStream)Objects.requireNonNull(is, "Required not null input stream")));
    }

    public static Model readFrom(File file) throws IOException {
        Objects.requireNonNull(file, "Required not null file");
        if (file.isDirectory()) {
            return Model.readFrom(new File(file, "pom.xml"));
        }
        return Model.fetchModel(XMLTree.from((File)file)).setPomFile(file);
    }

    public static Model readFrom(Path path) throws IOException {
        return Model.readFrom(Objects.requireNonNull(path.toFile(), "Required not null model"));
    }

    public static Model createModel() {
        XMLTree tree = XMLTree.create((String)"project");
        tree.getRoot().setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0").setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").setAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        return new Model(tree);
    }

    private Model(XMLTree tree) {
        this.tree = tree;
        this.root = tree.getRoot();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public Parent getParent() {
        return this.parent;
    }

    public String getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies().get();
    }

    public Dependencies dependencies() {
        if (this.dependencies == null) {
            this.dependencies = new Dependencies(this.root);
        }
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<String> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.modules);
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Repository>(this.repositories);
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Profile>(this.profiles);
    }

    public Model setProfiles(Collection<? extends Profile> profiles) {
        for (Profile profile : this.profiles()) {
            profile.remove();
        }
        if (profiles != null && !profiles.isEmpty()) {
            for (Profile profile : profiles) {
                this.addProfile(profile);
            }
        } else {
            this.root.removeChild("profiles");
            this.profiles = null;
        }
        return this;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Repository>(this.pluginRepositories);
    }

    public Model addPluginRepository(Repository pluginRepository) {
        Objects.requireNonNull(pluginRepository, "Required not null plugin repository");
        this.pluginRepositories().add(pluginRepository);
        if (this.root.hasSingleChild("pluginRepositories")) {
            this.root.getSingleChild("pluginRepositories").appendChild(pluginRepository.asXMLElement());
            pluginRepository.element = this.root.getLastChild();
        } else {
            this.root.insertChild(NewElement.createElement((String)"pluginRepositories", (NewElement[])new NewElement[]{pluginRepository.asXMLElement()}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"build", "reporting", "profiles"}).or(XMLTreeLocation.inTheEnd()));
            pluginRepository.element = this.root.getSingleChild("pluginRepositories").getFirstChild();
        }
        return this;
    }

    public Model setPluginRepositories(Collection<? extends Repository> pluginRepositories) {
        for (Repository repository : this.pluginRepositories()) {
            repository.remove();
        }
        if (pluginRepositories != null && !pluginRepositories.isEmpty()) {
            for (Repository repository : pluginRepositories) {
                this.addPluginRepository(repository);
            }
        } else {
            this.root.removeChild("pluginRepositories");
            this.pluginRepositories = null;
        }
        return this;
    }

    public Model addRepository(Repository repository) {
        Objects.requireNonNull(repository, "Required not null repository");
        this.repositories().add(repository);
        if (this.root.hasSingleChild("repositories")) {
            this.root.getSingleChild("repositories").appendChild(repository.asXMLElement());
            repository.element = this.root.getLastChild();
        } else {
            this.root.insertChild(NewElement.createElement((String)"repositories", (NewElement[])new NewElement[]{repository.asXMLElement()}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"pluginRepositories", "build", "reporting", "profiles"}).or(XMLTreeLocation.inTheEnd()));
            repository.element = this.root.getSingleChild("repositories").getFirstChild();
        }
        return this;
    }

    public Model addProfile(Profile profile) {
        Objects.requireNonNull(profile, "Required not null profile");
        this.profiles().add(profile);
        if (this.root.hasSingleChild("profiles")) {
            this.root.getSingleChild("profiles").appendChild(profile.asXMLElement());
            profile.element = this.root.getLastChild();
        } else {
            this.root.insertChild(NewElement.createElement((String)"profiles", (NewElement[])new NewElement[]{profile.asXMLElement()}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"name", "build", "modules"}).or(XMLTreeLocation.inTheEnd()));
            profile.element = this.root.getSingleChild("profiles").getFirstChild();
        }
        return this;
    }

    public Model setRepositories(Collection<? extends Repository> repositories) {
        for (Repository repository : this.repositories()) {
            repository.remove();
        }
        if (repositories != null && !repositories.isEmpty()) {
            for (Repository repository : repositories) {
                this.addRepository(repository);
            }
        } else {
            this.root.removeChild("repositories");
            this.repositories = null;
        }
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.properties);
    }

    public Model addModule(String newModule) {
        Objects.requireNonNull(newModule, "Required not null module");
        this.modules().add(newModule);
        if (this.root.hasSingleChild("modules")) {
            this.root.getSingleChild("modules").appendChild(NewElement.createElement((String)"module", (String)newModule));
        } else {
            this.root.insertChild(NewElement.createElement((String)"modules", (NewElement[])new NewElement[]{NewElement.createElement((String)"module", (String)newModule)}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"dependencyManagement", "dependencies", "build"}).or(XMLTreeLocation.inTheEnd()));
        }
        return this;
    }

    public Model addProperty(String name, String value) {
        Objects.requireNonNull(name, "Property name should not be null");
        Objects.requireNonNull(value, "Property value should not be null");
        this.addPropertyToXML(name, value);
        this.properties().put(name, value);
        return this;
    }

    public Model removeProperty(String name) {
        if (this.properties().remove(Objects.requireNonNull(name, "Property name should not be null")) != null) {
            this.removePropertyFromXML(name);
        }
        return this;
    }

    public Model removeModule(String module) {
        if (this.modules().remove(Objects.requireNonNull(module, "Required not null module"))) {
            this.removeModuleFromXML(module);
        }
        return this;
    }

    public Model setBuild(Build build) {
        this.build = build;
        if (build == null) {
            this.root.removeChild("build");
        } else if (this.root.hasSingleChild("build")) {
            build.buildElement = this.root.getSingleChild("build").replaceWith(build.asXMLElement());
        } else {
            this.root.appendChild(this.build.asXMLElement());
            build.buildElement = this.root.getSingleChild("build");
        }
        return this;
    }

    public Model setParent(Parent parent) {
        this.parent = parent;
        if (parent == null) {
            this.root.removeChild("parent");
        } else if (this.root.hasSingleChild("parent")) {
            parent.parentElement = this.root.getSingleChild("parent").replaceWith(parent.asXMLElement());
        } else {
            this.root.insertChild(this.parent.asXMLElement(), XMLTreeLocation.after((String)"modelVersion").or(XMLTreeLocation.inTheBegin()));
            parent.parentElement = this.root.getSingleChild("parent");
        }
        return this;
    }

    public Model setDependencyManagement(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
        if (dependencyManagement == null) {
            this.root.removeChild("dependencyManagement");
        } else if (this.root.hasSingleChild("dependencyManagement")) {
            dependencyManagement.dmElement = this.root.getSingleChild("dependencyManagement").replaceWith(dependencyManagement.asXMLElement());
        } else {
            this.root.insertChild(this.dependencyManagement.asXMLElement(), XMLTreeLocation.beforeAnyOf((String[])new String[]{"dependencies", "build"}).or(XMLTreeLocation.inTheEnd()));
            dependencyManagement.dmElement = this.root.getSingleChild("dependencyManagement");
        }
        return this;
    }

    public Model setModules(Collection<String> modules) {
        if (modules == null || modules.isEmpty()) {
            this.removeModules();
        } else {
            this.setModules0(modules);
        }
        return this;
    }

    public Model setProperties(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            this.removeProperties();
        } else {
            this.setProperties0(properties);
        }
        return this;
    }

    public Model setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        if (artifactId == null) {
            this.root.removeChild("artifactId");
        } else if (!this.root.hasSingleChild("artifactId")) {
            this.root.insertChild(NewElement.createElement((String)"artifactId", (String)artifactId), XMLTreeLocation.afterAnyOf((String[])new String[]{"groupId", "parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/artifactId", artifactId);
        }
        return this;
    }

    public Model setDescription(String description) {
        this.description = description;
        if (description == null) {
            this.root.removeChild("description");
        } else if (!this.root.hasSingleChild("description")) {
            this.root.insertChild(NewElement.createElement((String)"description", (String)description), XMLTreeLocation.afterAnyOf((String[])new String[]{"name", "version", "artifactId", "groupId", "parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/artifactId", this.artifactId);
        }
        return this;
    }

    public Model setGroupId(String groupId) {
        this.groupId = groupId;
        if (groupId == null) {
            this.root.removeChild("groupId");
        } else if (!this.root.hasSingleChild("groupId")) {
            this.root.insertChild(NewElement.createElement((String)"groupId", (String)groupId), XMLTreeLocation.afterAnyOf((String[])new String[]{"parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/groupId", groupId);
        }
        return this;
    }

    public Model setVersion(String version) {
        this.version = version;
        if (version == null) {
            this.root.removeChild("version");
        } else if (!this.root.hasSingleChild("version")) {
            this.root.insertChild(NewElement.createElement((String)"version", (String)version), XMLTreeLocation.afterAnyOf((String[])new String[]{"artifactId", "groupId", "parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/version", version);
        }
        return this;
    }

    public Model setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        if (modelVersion == null) {
            this.root.removeChild("modelVersion");
        } else if (!this.root.hasSingleChild("modelVersion")) {
            this.root.insertChild(NewElement.createElement((String)"modelVersion", (String)modelVersion), XMLTreeLocation.inTheBegin());
        } else {
            this.tree.updateText("/project/modelVersion", modelVersion);
        }
        return this;
    }

    public Model setName(String name) {
        this.name = name;
        if (name == null) {
            this.root.removeChild("name");
        } else if (!this.root.hasSingleChild("name")) {
            this.root.insertChild(NewElement.createElement((String)"name", (String)name), XMLTreeLocation.afterAnyOf((String[])new String[]{"packaging", "version", "artifactId", "groupId", "parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/name", name);
        }
        return this;
    }

    public Model setPackaging(String packaging) {
        this.packaging = packaging;
        if (packaging == null) {
            this.root.removeChild("packaging");
        } else if (!this.root.hasSingleChild("packaging")) {
            this.root.insertChild(NewElement.createElement((String)"packaging", (String)packaging), XMLTreeLocation.afterAnyOf((String[])new String[]{"version", "artifactId", "groupId", "parent", "modelVersion"}).or(XMLTreeLocation.inTheBegin()));
        } else {
            this.tree.updateText("/project/packaging", packaging);
        }
        return this;
    }

    public Model setPomFile(File pom) {
        this.pom = pom;
        return this;
    }

    public String getId() {
        return (this.version == null ? "[inherited]" : this.groupId) + ':' + this.artifactId + ':' + this.packaging + ':' + (this.version == null ? "[inherited]" : this.version);
    }

    public File getPomFile() {
        return this.pom;
    }

    public File getProjectDirectory() {
        return this.pom == null ? null : this.pom.getParentFile();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.tree.writeTo(os);
    }

    public void writeTo(File file) throws IOException {
        this.tree.writeTo(file);
    }

    public void save() throws IOException {
        if (this.pom == null) {
            throw new IllegalStateException("Model is not associated with any pom file");
        }
        this.writeTo(this.pom);
    }

    public String toString() {
        return this.getId();
    }

    private Map<String, String> properties() {
        return this.properties == null ? (this.properties = new HashMap<String, String>()) : this.properties;
    }

    private List<String> modules() {
        return this.modules == null ? (this.modules = new ArrayList<String>()) : this.modules;
    }

    private List<Repository> repositories() {
        return this.repositories == null ? (this.repositories = new ArrayList<Repository>()) : this.repositories;
    }

    private List<Profile> profiles() {
        return this.profiles == null ? (this.profiles = new ArrayList<Profile>()) : this.profiles;
    }

    private List<Repository> pluginRepositories() {
        return this.pluginRepositories == null ? (this.pluginRepositories = new ArrayList<Repository>()) : this.pluginRepositories;
    }

    private void addPropertyToXML(String key, String value) {
        if (this.properties().containsKey(key)) {
            this.root.getSingleChild("properties").getSingleChild(key).setText(value);
        } else if (this.properties.isEmpty()) {
            this.root.insertChild(NewElement.createElement((String)"properties", (NewElement[])new NewElement[]{NewElement.createElement((String)key, (String)value)}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"dependencyManagement", "dependencies", "build"}).or(XMLTreeLocation.inTheEnd()));
        } else {
            this.root.getSingleChild("properties").appendChild(NewElement.createElement((String)key, (String)value));
        }
    }

    private void removeProperties() {
        this.root.removeChild("properties");
        this.properties = null;
    }

    private void setProperties0(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
        if (this.root.hasSingleChild("properties")) {
            Element propertiesElement = this.root.getSingleChild("properties");
            for (Element element : propertiesElement.getChildren()) {
                element.remove();
            }
            for (Map.Entry entry : properties.entrySet()) {
                propertiesElement.appendChild(NewElement.createElement((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        } else {
            NewElement newProperties = NewElement.createElement((String)"properties");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                newProperties.appendChild(NewElement.createElement((String)entry.getKey(), (String)entry.getValue()));
            }
            this.root.insertChild(newProperties, XMLTreeLocation.beforeAnyOf((String[])new String[]{"dependencyManagement", "dependencies", "build"}).or(XMLTreeLocation.inTheEnd()));
        }
    }

    private void removeModules() {
        this.root.removeChild("modules");
        this.modules = null;
    }

    private void setModules0(Collection<String> modules) {
        this.modules = new ArrayList<String>(modules);
        if (this.root.hasSingleChild("modules")) {
            Element modulesElement = this.root.getSingleChild("modules");
            for (Element element : modulesElement.getChildren()) {
                element.remove();
            }
            for (String string : modules) {
                modulesElement.appendChild(NewElement.createElement((String)"module", (String)string));
            }
        } else {
            NewElement newModules = NewElement.createElement((String)"modules");
            for (String string : modules) {
                newModules.appendChild(NewElement.createElement((String)"module", (String)string));
            }
            this.root.insertChild(newModules, XMLTreeLocation.beforeAnyOf((String[])new String[]{"properties", "dependencyManagement", "dependencies", "build"}).or(XMLTreeLocation.inTheEnd()));
        }
    }

    private void removeModuleFromXML(String module) {
        if (this.modules.isEmpty()) {
            this.root.removeChild("modules");
        } else {
            for (Element element : this.root.getSingleChild("modules").getChildren()) {
                if (!module.equals(element.getText())) continue;
                element.remove();
            }
        }
    }

    private void removePropertyFromXML(String key) {
        if (this.properties.isEmpty()) {
            this.root.removeChild("properties");
        } else {
            this.root.getSingleChild("properties").removeChild(key);
        }
    }

    private static Model fetchModel(XMLTree tree) {
        Model model = new Model(tree);
        Element root = tree.getRoot();
        model.modelVersion = root.getChildText("modelVersion");
        model.groupId = root.getChildText("groupId");
        model.artifactId = root.getChildText("artifactId");
        model.version = root.getChildText("version");
        model.name = root.getChildText("name");
        model.description = root.getChildText("description");
        model.packaging = root.getChildText("packaging");
        if (root.hasSingleChild("parent")) {
            model.parent = new Parent(root.getSingleChild("parent"));
        }
        if (root.hasSingleChild("dependencyManagement")) {
            Element dm = tree.getSingleElement("/project/dependencyManagement");
            List dependencies = tree.getElements("/project/dependencyManagement/dependencies/dependency", (ElementMapper)TO_DEPENDENCY_MAPPER);
            model.dependencyManagement = new DependencyManagement(dm, dependencies);
        }
        if (root.hasSingleChild("build")) {
            model.build = new Build(root.getSingleChild("build"));
        }
        if (root.hasSingleChild("dependencies")) {
            List dependencies = tree.getElements("/project/dependencies/dependency", (ElementMapper)TO_DEPENDENCY_MAPPER);
            model.dependencies = new Dependencies(root, dependencies);
        }
        if (root.hasSingleChild("modules")) {
            model.modules = tree.getElements("/project/modules/module", (ElementMapper)TO_MODULE_MAPPER);
        }
        if (root.hasSingleChild("profiles")) {
            model.profiles = tree.getElements("/project/profiles/profile", (ElementMapper)TO_PROFILE_MAPPER);
        }
        if (root.hasSingleChild("repositories")) {
            model.repositories = tree.getElements("/project/repositories/repository", (ElementMapper)TO_REPOSITORY_MAPPER);
        }
        if (root.hasSingleChild("pluginRepositories")) {
            model.pluginRepositories = tree.getElements("/project/pluginRepositories/repository", (ElementMapper)TO_REPOSITORY_MAPPER);
        }
        if (root.hasSingleChild("properties")) {
            model.properties = Model.fetchProperties(root.getSingleChild("properties"));
        }
        return model;
    }

    private static Map<String, String> fetchProperties(Element propertiesElement) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element property : propertiesElement.getChildren()) {
            properties.put(property.getName(), property.getText());
        }
        return properties;
    }

    private static class ToRepositoryMapper
    implements ElementMapper<Repository> {
        private ToRepositoryMapper() {
        }

        public Repository map(Element element) {
            return new Repository(element);
        }
    }

    private static class ToProfileMapper
    implements ElementMapper<Profile> {
        private ToProfileMapper() {
        }

        public Profile map(Element element) {
            return new Profile(element);
        }
    }

    private static class ToModuleMapper
    implements ElementMapper<String> {
        private ToModuleMapper() {
        }

        public String map(Element element) {
            return element.getText();
        }
    }

    private static class ToDependencyMapper
    implements ElementMapper<Dependency> {
        private ToDependencyMapper() {
        }

        public Dependency map(Element element) {
            return new Dependency(element);
        }
    }
}

