/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;

public class Parent {
    private String groupId;
    private String artifactId;
    private String version;
    private String relativePath;
    Element parentElement;

    public Parent() {
    }

    public Parent(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    Parent(Element element) {
        this.parentElement = element;
        this.groupId = element.getChildText("groupId");
        this.artifactId = element.getChildText("artifactId");
        this.version = element.getChildText("version");
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRelativePath() {
        return this.relativePath == null ? "../pom.xml" : this.relativePath;
    }

    public Parent setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        if (!this.isNew()) {
            if (artifactId == null) {
                this.parentElement.removeChild("artifactId");
            } else if (this.parentElement.hasSingleChild("artifactId")) {
                this.parentElement.getSingleChild("artifactId").setText(artifactId);
            } else {
                this.parentElement.insertChild(NewElement.createElement((String)"artifactId", (String)artifactId), XMLTreeLocation.after((String)"groupId").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public Parent setGroupId(String groupId) {
        this.groupId = groupId;
        if (!this.isNew()) {
            if (groupId == null) {
                this.parentElement.removeChild("groupId");
            } else if (this.parentElement.hasSingleChild("groupId")) {
                this.parentElement.getSingleChild("groupId").setText(groupId);
            } else {
                this.parentElement.insertChild(NewElement.createElement((String)"groupId", (String)groupId), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public Parent setVersion(String version) {
        this.version = version;
        if (!this.isNew()) {
            if (version == null) {
                this.parentElement.removeChild("version");
            } else if (this.parentElement.hasSingleChild("version")) {
                this.parentElement.getSingleChild("version").setText(version);
            } else {
                this.parentElement.insertChild(NewElement.createElement((String)"version", (String)version), XMLTreeLocation.before((String)"relativePath").or(XMLTreeLocation.inTheEnd()));
            }
        }
        return this;
    }

    public Parent setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        if (!this.isNew()) {
            if (relativePath == null) {
                this.parentElement.removeChild("relativePath");
            } else if (this.parentElement.hasSingleChild("relativePath")) {
                this.parentElement.getSingleChild("relativePath").setText(relativePath);
            } else {
                this.parentElement.appendChild(NewElement.createElement((String)"relativePath", (String)relativePath));
            }
        }
        return this;
    }

    public String getId() {
        return this.groupId + ':' + this.artifactId + ":pom:" + this.version;
    }

    public String toString() {
        return this.getId();
    }

    NewElement asXMLElement() {
        NewElement newParent = NewElement.createElement((String)"parent");
        if (this.groupId != null) {
            newParent.appendChild(NewElement.createElement((String)"groupId", (String)this.groupId));
        }
        if (this.artifactId != null) {
            newParent.appendChild(NewElement.createElement((String)"artifactId", (String)this.artifactId));
        }
        if (this.version != null) {
            newParent.appendChild(NewElement.createElement((String)"version", (String)this.version));
        }
        if (this.relativePath != null) {
            newParent.appendChild(NewElement.createElement((String)"relativePath", (String)this.relativePath));
        }
        return newParent;
    }

    private boolean isNew() {
        return this.parentElement == null;
    }
}

