/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;
import org.eclipse.che.ide.maven.tools.Activation;
import org.eclipse.che.ide.maven.tools.Build;
import org.eclipse.che.ide.maven.tools.Dependencies;
import org.eclipse.che.ide.maven.tools.Dependency;
import org.eclipse.che.ide.maven.tools.DependencyManagement;
import org.eclipse.che.ide.maven.tools.Repository;

public class Profile {
    public static final String SOURCE_POM = "pom";
    private static final ElementMapper<String> TEXT_MAPPER = new ElementTextMapper();
    private static final RepositoryMapper REPOSITORY_MAPPER = new RepositoryMapper();
    private static final ToDependencyMapper TO_DEPENDENCY_MAPPER = new ToDependencyMapper();
    public Element element;
    private String id;
    private Activation activation;
    private List<String> modules;
    private Build build;
    private List<Repository> repositories;
    private Map<String, String> properties;
    private Dependencies dependencies;
    private DependencyManagement dependencyManagement;

    Profile(Element element) {
        this.element = element;
        this.id = element.getChildText("id");
        Element modules = element.getSingleChild("modules");
        if (element.hasSingleChild("modules") && modules != null) {
            this.modules = modules.getChildren(TEXT_MAPPER);
        }
        if (element.hasSingleChild("activation")) {
            this.activation = new Activation(element.getSingleChild("activation"));
        }
        if (element.hasSingleChild("build")) {
            this.build = new Build(element.getSingleChild("build"));
        }
        Element repositories = element.getSingleChild("repositories");
        if (element.hasSingleChild("repositories") && repositories != null) {
            this.repositories = repositories.getChildren((ElementMapper)REPOSITORY_MAPPER);
        }
        Element elementDependencies = element.getSingleChild("dependencies");
        if (element.hasSingleChild("dependencies") && elementDependencies != null) {
            List dependencies = elementDependencies.getChildren((ElementMapper)TO_DEPENDENCY_MAPPER);
            this.dependencies = new Dependencies(element, dependencies);
        }
        Element properties = element.getSingleChild("properties");
        if (element.hasSingleChild("properties") && properties != null) {
            this.properties = Profile.fetchProperties(properties);
        }
        Element dependencyManagementDependencies = element.getSingleChild("dependencyManagement/dependencies");
        if (element.hasSingleChild("dependencyManagement") && dependencyManagementDependencies != null) {
            Element dm = element.getSingleChild("dependencyManagement");
            List dependencies = dependencyManagementDependencies.getChildren((ElementMapper)TO_DEPENDENCY_MAPPER);
            this.dependencyManagement = new DependencyManagement(dm, dependencies);
        }
    }

    public String getId() {
        return this.id;
    }

    public Profile setId(String id) {
        this.id = id;
        if (!this.isNew()) {
            if (Strings.isNullOrEmpty((String)id)) {
                this.element.removeChild("id");
            } else {
                Element idElement = this.element.getSingleChild("id");
                if (this.element.hasSingleChild("id") && idElement != null) {
                    idElement.setText(id);
                } else {
                    this.element.insertChild(NewElement.createElement((String)"id", (String)id), XMLTreeLocation.inTheBegin());
                }
            }
        }
        return this;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public Profile setActivation(Activation activation) {
        this.activation = activation;
        if (!this.isNew()) {
            if (activation == null) {
                this.element.removeChild("activation");
            } else if (this.element.hasSingleChild("activation")) {
                this.element.removeChild("activation");
                this.element.appendChild(activation.asXMLElement());
            } else {
                this.element.appendChild(activation.asXMLElement());
            }
        }
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(this.properties);
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Repository>(this.repositories);
    }

    public Profile setRepositories(Collection<? extends Repository> repositories) {
        for (Repository repository : this.repositories()) {
            repository.remove();
        }
        if (repositories != null && !repositories.isEmpty()) {
            for (Repository repository : repositories) {
                this.addRepository(repository);
            }
        } else {
            this.element.removeChild("repositories");
            this.repositories = null;
        }
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies == null ? Collections.emptyList() : this.dependencies.get();
    }

    public Profile setDependencies(List<Dependency> dependencies) {
        this.dependencies = new Dependencies(this.element, dependencies);
        return this;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Profile setDependencyManagement(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
        if (dependencyManagement == null) {
            this.element.removeChild("dependencyManagement");
        } else {
            Element dependencyManagementElement = this.element.getSingleChild("dependencyManagement");
            if (this.element.hasSingleChild("dependencyManagement") && dependencyManagementElement != null) {
                dependencyManagement.dmElement = dependencyManagementElement.replaceWith(dependencyManagement.asXMLElement());
            } else {
                this.element.insertChild(this.dependencyManagement.asXMLElement(), XMLTreeLocation.beforeAnyOf((String[])new String[]{"dependencies"}).or(XMLTreeLocation.inTheEnd()));
                dependencyManagement.dmElement = dependencyManagementElement;
            }
        }
        return this;
    }

    public Build getBuild() {
        return this.build;
    }

    public Profile setBuild(Build build) {
        this.build = build;
        if (!this.isNew()) {
            if (build == null) {
                this.element.removeChild("build");
            } else if (this.element.hasSingleChild("build")) {
                this.element.removeChild("build");
                this.element.appendChild(build.asXMLElement());
            } else {
                this.element.appendChild(build.asXMLElement());
            }
        }
        return this;
    }

    public List<String> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.modules);
    }

    public Profile setModules(Collection<String> modules) {
        if (modules == null || modules.isEmpty()) {
            this.removeModules();
        } else {
            this.setModules0(modules);
        }
        return this;
    }

    public void remove() {
        if (this.element != null) {
            this.element.remove();
            this.element = null;
        }
    }

    public NewElement asXMLElement() {
        NewElement profile = NewElement.createElement((String)"profile");
        if (!Strings.isNullOrEmpty((String)this.id)) {
            profile.appendChild(NewElement.createElement((String)"id", (String)this.id));
        }
        if (this.modules != null && !this.modules.isEmpty()) {
            profile.appendChild(this.newModulesXMLElement(this.modules));
        }
        if (this.activation != null) {
            profile.appendChild(this.activation.asXMLElement());
        }
        if (this.build != null) {
            profile.appendChild(this.build.asXMLElement());
        }
        if (this.repositories != null && !this.repositories.isEmpty()) {
            profile.appendChild(this.newRepositoryElement(this.repositories));
        }
        if (this.dependencies != null && !this.dependencies.get().isEmpty()) {
            profile.appendChild(this.newDependencyElement(this.dependencies.get()));
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            profile.appendChild(this.newPropertiesElement(this.properties));
        }
        if (this.dependencyManagement != null && !this.dependencyManagement.getDependencies().isEmpty()) {
            profile.appendChild(this.newDependencyManagementElement(this.dependencies.get()));
        }
        return profile;
    }

    private Profile addRepository(Repository repository) {
        this.repositories().add(repository);
        Element repositoriesElement = this.element.getSingleChild("repositories");
        if (this.element.hasSingleChild("repositories") && repositoriesElement != null) {
            repositoriesElement.appendChild(repository.asXMLElement());
            repository.element = this.element.getLastChild();
        } else {
            this.element.insertChild(NewElement.createElement((String)"repositories", (NewElement[])new NewElement[]{repository.asXMLElement()}), XMLTreeLocation.beforeAnyOf((String[])new String[]{"pluginRepositories", "activation", "build"}).or(XMLTreeLocation.inTheEnd()));
            if (repositoriesElement != null) {
                repository.element = repositoriesElement.getFirstChild();
            }
        }
        return this;
    }

    private static Map<String, String> fetchProperties(Element propertiesElement) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element property : propertiesElement.getChildren()) {
            properties.put(property.getName(), property.getText());
        }
        return properties;
    }

    private Map<String, String> properties() {
        return this.properties == null ? (this.properties = new HashMap<String, String>()) : this.properties;
    }

    private List<Repository> repositories() {
        return this.repositories == null ? (this.repositories = new ArrayList<Repository>()) : this.repositories;
    }

    private void setModules0(Collection<String> modules) {
        this.modules = new ArrayList<String>(modules);
        if (this.isNew()) {
            return;
        }
        if (this.element.hasSingleChild("modules")) {
            Element modulesElement = this.element.getSingleChild("modules");
            if (modulesElement == null) {
                return;
            }
            for (Element element : modulesElement.getChildren()) {
                element.remove();
            }
            for (String string : modules) {
                this.element.appendChild(NewElement.createElement((String)"module", (String)string));
            }
        } else {
            this.element.insertChild(this.newModulesXMLElement(this.modules), XMLTreeLocation.before((String)"build").or(XMLTreeLocation.inTheEnd()));
        }
    }

    private NewElement newRepositoryElement(List<Repository> repositories) {
        NewElement repositoriesElement = NewElement.createElement((String)"repositories");
        for (Repository repository : repositories) {
            repositoriesElement.appendChild(repository.asXMLElement());
        }
        return repositoriesElement;
    }

    private NewElement newDependencyElement(List<Dependency> dependencies) {
        NewElement dependenciesElement = NewElement.createElement((String)"dependencies");
        for (Dependency dependency : dependencies) {
            dependenciesElement.appendChild(dependency.asXMLElement());
        }
        return dependenciesElement;
    }

    private NewElement newPropertiesElement(Map<String, String> properties) {
        NewElement propertiesElement = NewElement.createElement((String)"properties");
        for (String key : properties.keySet()) {
            propertiesElement.appendChild(NewElement.createElement((String)key, (String)properties.get(key)));
        }
        return propertiesElement;
    }

    private NewElement newDependencyManagementElement(List<Dependency> dependencies) {
        NewElement dependenciesElement = NewElement.createElement((String)"dependencies");
        for (Dependency dependency : dependencies) {
            dependenciesElement.appendChild(dependency.asXMLElement());
        }
        NewElement dependencyManagement = NewElement.createElement((String)"dependencyManagement");
        dependencyManagement.appendChild(dependenciesElement);
        return dependencyManagement;
    }

    private NewElement newModulesXMLElement(List<String> text) {
        NewElement element = NewElement.createElement((String)"modules");
        for (String line : text) {
            element.appendChild(NewElement.createElement((String)"module", (String)line));
        }
        return element;
    }

    private void removeModules() {
        if (!this.isNew()) {
            this.element.removeChild("modules");
        }
        this.modules = null;
    }

    private boolean isNew() {
        return this.element == null;
    }

    private static class ToDependencyMapper
    implements ElementMapper<Dependency> {
        private ToDependencyMapper() {
        }

        public Dependency map(Element element) {
            return new Dependency(element);
        }
    }

    private static class RepositoryMapper
    implements ElementMapper<Repository> {
        private RepositoryMapper() {
        }

        public Repository map(Element element) {
            return new Repository(element);
        }
    }

    private static class ElementTextMapper
    implements ElementMapper<String> {
        private ElementTextMapper() {
        }

        public String map(Element element) {
            return element.getText();
        }
    }
}

