/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.maven.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.che.commons.xml.Element;
import org.eclipse.che.commons.xml.ElementMapper;
import org.eclipse.che.commons.xml.NewElement;
import org.eclipse.che.commons.xml.XMLTreeLocation;

public class Resource {
    private static final ElementMapper<String> TEXT_MAPPER = new ElementTextMapper();
    private String targetPath;
    private String directory;
    private boolean filtering;
    private List<String> includes;
    private List<String> excludes;
    Element resourceElement;

    public Resource() {
    }

    Resource(Element resourceElement) {
        this.resourceElement = resourceElement;
        this.targetPath = resourceElement.getChildText("targetPath");
        this.directory = resourceElement.getChildText("directory");
        this.filtering = Boolean.parseBoolean(resourceElement.getChildText("filtering"));
        if (resourceElement.hasSingleChild("includes")) {
            this.includes = resourceElement.getSingleChild("includes").getChildren(TEXT_MAPPER);
        }
        if (resourceElement.hasSingleChild("excludes")) {
            this.excludes = resourceElement.getSingleChild("excludes").getChildren(TEXT_MAPPER);
        }
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public Resource setTargetPath(String targetPath) {
        this.targetPath = targetPath;
        if (!this.isNew()) {
            if (targetPath == null) {
                this.resourceElement.removeChild("targetPath");
            } else if (this.resourceElement.hasChild("targetPath")) {
                this.resourceElement.getSingleChild("targetPath").setText(targetPath);
            } else {
                this.resourceElement.insertChild(NewElement.createElement((String)"targetPath", (String)targetPath), XMLTreeLocation.inTheBegin());
            }
        }
        return this;
    }

    public String getDirectory() {
        return this.directory;
    }

    public Resource setDirectory(String directory) {
        this.directory = directory;
        if (!this.isNew()) {
            if (directory == null) {
                this.resourceElement.removeChild("directory");
            } else if (this.resourceElement.hasSingleChild("directory")) {
                this.resourceElement.getSingleChild("directory").setText(directory);
            } else {
                this.resourceElement.insertChild(NewElement.createElement((String)"directory", (String)directory), XMLTreeLocation.afterAnyOf((String[])new String[]{"targetPath", "filtering"}).or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    public Resource setFiltering(boolean filtering) {
        this.filtering = filtering;
        if (!this.isNew()) {
            if (this.resourceElement.hasSingleChild("filtering")) {
                this.resourceElement.getSingleChild("filtering").setText(Boolean.toString(filtering));
            } else {
                this.resourceElement.insertChild(NewElement.createElement((String)"filtering", (String)Boolean.toString(filtering)), XMLTreeLocation.after((String)"targetPath").or(XMLTreeLocation.inTheBegin()));
            }
        }
        return this;
    }

    public List<String> getIncludes() {
        if (this.includes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.includes);
    }

    public Resource setIncludes(Collection<String> includes) {
        if (includes == null || includes.isEmpty()) {
            this.removeIncludes();
        } else {
            this.setIncludes0(includes);
        }
        return this;
    }

    public List<String> getExcludes() {
        if (this.excludes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.excludes);
    }

    public Resource setExcludes(Collection<String> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            this.removeExcludes();
        } else {
            this.setExcludes0(excludes);
        }
        return this;
    }

    NewElement asXMLElement() {
        NewElement resource = NewElement.createElement((String)"resource");
        if (this.targetPath != null) {
            resource.appendChild(NewElement.createElement((String)"targetPath", (String)this.targetPath));
        }
        if (this.filtering) {
            resource.appendChild(NewElement.createElement((String)"filtering", (String)"true"));
        }
        if (this.directory != null) {
            resource.appendChild(NewElement.createElement((String)"directory", (String)this.directory));
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            resource.appendChild(this.newXMLElement(this.includes, "includes", "include"));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            resource.appendChild(this.newXMLElement(this.excludes, "excludes", "exclude"));
        }
        return resource;
    }

    private void setIncludes0(Collection<String> includes) {
        this.includes = new ArrayList<String>(includes);
        if (this.isNew()) {
            return;
        }
        if (this.resourceElement.hasSingleChild("includes")) {
            Element includesElement = this.resourceElement.getSingleChild("includes");
            for (Element element : includesElement.getChildren()) {
                element.remove();
            }
            for (String string : includes) {
                includesElement.appendChild(NewElement.createElement((String)"include", (String)string));
            }
        } else {
            this.resourceElement.insertChild(this.newXMLElement(this.includes, "includes", "include"), XMLTreeLocation.before((String)"excludes").or(XMLTreeLocation.inTheEnd()));
        }
    }

    private void removeIncludes() {
        if (!this.isNew()) {
            this.resourceElement.removeChild("includes");
        }
        this.includes = null;
    }

    private void removeExcludes() {
        if (!this.isNew()) {
            this.resourceElement.removeChild("excludes");
        }
        this.excludes = null;
    }

    private void setExcludes0(Collection<String> excludes) {
        this.excludes = new ArrayList<String>(excludes);
        if (this.isNew()) {
            return;
        }
        if (this.resourceElement.hasSingleChild("excludes")) {
            Element excludesElement = this.resourceElement.getSingleChild("excludes");
            for (Element element : excludesElement.getChildren()) {
                element.remove();
            }
            for (String string : excludes) {
                excludesElement.appendChild(NewElement.createElement((String)"exclude", (String)string));
            }
        } else {
            this.resourceElement.appendChild(this.newXMLElement(this.excludes, "excludes", "exclude"));
        }
    }

    private boolean isNew() {
        return this.resourceElement == null;
    }

    private NewElement newXMLElement(List<String> text, String parentName, String childName) {
        NewElement element = NewElement.createElement((String)parentName);
        for (String line : text) {
            element.appendChild(NewElement.createElement((String)childName, (String)line));
        }
        return element;
    }

    private static class ElementTextMapper
    implements ElementMapper<String> {
        private ElementTextMapper() {
        }

        public String map(Element element) {
            return element.getText();
        }
    }
}

