/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.plain.server.projecttype;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.jdt.core.launching.JREContainerInitializer;
import org.eclipse.che.plugin.java.plain.server.projecttype.PlainJavaInitHandler;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClasspathBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PlainJavaInitHandler.class);

    public void generateClasspath(IJavaProject project, List<String> sourceFolders, List<String> library) throws ServerException {
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry jreContainer = JavaCore.newContainerEntry((IPath)new Path(JREContainerInitializer.JRE_CONTAINER));
        classpathEntries.add(jreContainer);
        this.addSourceFolders(project, sourceFolders, classpathEntries);
        this.addJars(project, library, classpathEntries);
        try {
            project.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
        }
        catch (JavaModelException e) {
            LOG.warn("Can't set classpath for: " + project.getProject().getFullPath().toOSString(), (Throwable)e);
            throw new ServerException((Throwable)e);
        }
    }

    private void addJars(IJavaProject project, List<String> library, List<IClasspathEntry> classpathEntries) {
        if (library == null || library.isEmpty()) {
            return;
        }
        for (String libFolder : library) {
            if (libFolder.isEmpty()) continue;
            IFolder libraryFolder = project.getProject().getFolder(libFolder);
            if (!libraryFolder.exists()) {
                return;
            }
            try {
                libraryFolder.accept(proxy -> {
                    if (1 != proxy.getType()) {
                        return true;
                    }
                    IPath path = proxy.requestFullPath();
                    if (!path.toString().endsWith(".jar")) {
                        return false;
                    }
                    IClasspathEntry libEntry = JavaCore.newLibraryEntry((IPath)proxy.requestResource().getLocation(), null, null);
                    classpathEntries.add(libEntry);
                    return false;
                }, 1);
            }
            catch (CoreException e) {
                LOG.warn("Can't read folder structure: " + libraryFolder.getFullPath().toString());
            }
        }
    }

    private void addSourceFolders(IJavaProject project, List<String> sourceFolders, List<IClasspathEntry> classpathEntries) {
        for (String source : sourceFolders) {
            IFolder src = project.getProject().getFolder(source);
            if (!src.exists()) continue;
            IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)src.getFullPath());
            classpathEntries.add(sourceEntry);
        }
    }
}

