/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.plain.server.rest;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import org.eclipse.che.api.core.BadRequestException;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.fs.server.PathTransformer;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.impl.NewProjectConfigImpl;
import org.eclipse.che.ide.ext.java.shared.dto.classpath.ClasspathEntryDto;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@javax.ws.rs.Path(value="jdt/classpath/update")
public class ClasspathUpdaterService {
    private static final JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
    private final ProjectManager projectManager;
    private final PathTransformer pathTransformer;

    @Inject
    public ClasspathUpdaterService(ProjectManager projectManager, PathTransformer pathTransformer) {
        this.projectManager = projectManager;
        this.pathTransformer = pathTransformer;
    }

    @POST
    @Consumes(value={"application/json"})
    public void updateClasspath(@QueryParam(value="projectpath") String projectPath, List<ClasspathEntryDto> entries) throws JavaModelException, ServerException, ForbiddenException, ConflictException, NotFoundException, IOException, BadRequestException {
        IJavaProject javaProject = model.getJavaProject(projectPath);
        javaProject.setRawClasspath(this.createModifiedEntry(entries), javaProject.getOutputLocation(), (IProgressMonitor)new NullProgressMonitor());
        this.updateProjectConfig(projectPath);
    }

    private void updateProjectConfig(String projectWsPath) throws IOException, ForbiddenException, ConflictException, NotFoundException, ServerException, BadRequestException {
        String wsPath = WsPathUtils.absolutize((String)projectWsPath);
        ProjectConfig project = (ProjectConfig)this.projectManager.get(wsPath).orElseThrow(() -> new NotFoundException("Can't find project: " + projectWsPath));
        NewProjectConfigImpl projectConfig = new NewProjectConfigImpl(projectWsPath, project.getName(), project.getType(), project.getSource());
        this.projectManager.update((ProjectConfig)projectConfig);
    }

    private IClasspathEntry[] createModifiedEntry(List<ClasspathEntryDto> entries) {
        ArrayList<IClasspathEntry> coreClasspathEntries = new ArrayList<IClasspathEntry>(entries.size());
        for (ClasspathEntryDto entry : entries) {
            IPath path = Path.fromOSString((String)entry.getPath());
            int entryKind = entry.getEntryKind();
            if (1 == entryKind) {
                coreClasspathEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                continue;
            }
            if (3 == entryKind) {
                coreClasspathEntries.add(JavaCore.newSourceEntry((IPath)path));
                continue;
            }
            if (4 == entryKind) {
                coreClasspathEntries.add(JavaCore.newVariableEntry((IPath)path, null, null));
                continue;
            }
            if (5 == entryKind) {
                coreClasspathEntries.add(JavaCore.newContainerEntry((IPath)path));
                continue;
            }
            if (2 != entryKind) continue;
            coreClasspathEntries.add(JavaCore.newProjectEntry((IPath)path));
        }
        return coreClasspathEntries.toArray(new IClasspathEntry[coreClasspathEntries.size()]);
    }
}

