/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.plain.server.projecttype;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.List;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.plugin.java.plain.server.projecttype.ClasspathBuilder;
import org.eclipse.che.plugin.java.plain.shared.PlainJavaProjectConstants;
import org.eclipse.che.plugin.java.server.projecttype.AbstractJavaInitHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainJavaInitHandler
extends AbstractJavaInitHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PlainJavaInitHandler.class);
    private final ClasspathBuilder classpathBuilder;
    private final Provider<ProjectManager> projectRegistryProvider;

    @Inject
    public PlainJavaInitHandler(ClasspathBuilder classpathBuilder, Provider<ProjectManager> projectRegistryProvider) {
        this.classpathBuilder = classpathBuilder;
        this.projectRegistryProvider = projectRegistryProvider;
    }

    protected void initializeClasspath(IJavaProject javaProject) throws ServerException {
        Object[] projectClasspath;
        try {
            projectClasspath = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            LOG.warn("Can't get classpath for: " + javaProject.getProject().getFullPath().toOSString(), (Throwable)e);
            throw new ServerException((Throwable)e);
        }
        Object[] defaultClasspath = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)javaProject.getPath())};
        if (!Arrays.equals(defaultClasspath, projectClasspath)) {
            return;
        }
        String wsPath = WsPathUtils.absolutize((String)javaProject.getPath().toOSString());
        ProjectConfig project = (ProjectConfig)((ProjectManager)this.projectRegistryProvider.get()).get(wsPath).orElseThrow(() -> new ServerException("Can't find a project: " + wsPath));
        List sourceFolders = (List)project.getAttributes().get("java.source.folder");
        List library = (List)project.getAttributes().get(PlainJavaProjectConstants.LIBRARY_FOLDER);
        this.classpathBuilder.generateClasspath(javaProject, sourceFolders, library);
    }

    public String getProjectType() {
        return "javac";
    }
}

