/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.plain.server.projecttype;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.che.api.project.server.type.ReadonlyValueProvider;
import org.eclipse.che.api.project.server.type.ValueProvider;
import org.eclipse.che.api.project.server.type.ValueProviderFactory;
import org.eclipse.che.api.project.server.type.ValueStorageException;
import org.eclipse.che.plugin.java.plain.shared.PlainJavaProjectConstants;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;

@Singleton
public class PlainJavaValueProviderFactory
implements ValueProviderFactory {
    @Inject
    public PlainJavaValueProviderFactory() {
    }

    public ValueProvider newInstance(String wsPath) {
        return new PlainJavaValueProvider(wsPath);
    }

    private class PlainJavaValueProvider
    extends ReadonlyValueProvider {
        private String wsPath;

        PlainJavaValueProvider(String wsPath) {
            this.wsPath = wsPath;
        }

        public List<String> getValues(String attributeName) throws ValueStorageException {
            if ("java.source.folder".equals(attributeName)) {
                return this.getSourceFolders();
            }
            if ("java.output.folder".equals(attributeName)) {
                return this.getOutputFolder();
            }
            return null;
        }

        private List<String> getOutputFolder() throws ValueStorageException {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject project = model.getJavaProject(this.wsPath);
            try {
                String outputDirPath = project.getOutputLocation().toOSString();
                return outputDirPath.startsWith(this.wsPath) ? Collections.singletonList(outputDirPath.substring(this.wsPath.length() + 1)) : Collections.singletonList(outputDirPath);
            }
            catch (JavaModelException e) {
                throw new ValueStorageException("Can't get output location: " + e.getMessage());
            }
        }

        private List<String> getSourceFolders() throws ValueStorageException {
            ArrayList<String> sourceFolders = new ArrayList<String>();
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject project = model.getJavaProject(this.wsPath);
            try {
                IClasspathEntry[] classpath;
                for (IClasspathEntry entry : classpath = project.getRawClasspath()) {
                    String entryPath = entry.getPath().toOSString();
                    if (3 != entry.getEntryKind() || entryPath.equals(this.wsPath)) continue;
                    if (entryPath.startsWith(this.wsPath)) {
                        sourceFolders.add(entryPath.substring(this.wsPath.length() + 1));
                        continue;
                    }
                    sourceFolders.add(entryPath);
                }
            }
            catch (JavaModelException e) {
                throw new ValueStorageException("Classpath does not exist or an exception occurs while accessing its corresponding resource : " + e.getMessage());
            }
            return sourceFolders.isEmpty() ? Collections.singletonList(PlainJavaProjectConstants.DEFAULT_SOURCE_FOLDER_VALUE) : sourceFolders;
        }
    }
}

