/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.plain.server.generator;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.fs.server.FsManager;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.handlers.CreateProjectHandler;
import org.eclipse.che.api.project.server.type.AttributeValue;
import org.eclipse.che.plugin.java.plain.server.projecttype.ClasspathBuilder;
import org.eclipse.che.plugin.java.plain.shared.PlainJavaProjectConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PlainJavaProjectGenerator
implements CreateProjectHandler {
    private static final String FILE_NAME = "Main.java";
    private final ClasspathBuilder classpathBuilder;
    private final FsManager fsManager;

    @Inject
    protected PlainJavaProjectGenerator(ClasspathBuilder classpathBuilder, FsManager fsManager) {
        this.classpathBuilder = classpathBuilder;
        this.fsManager = fsManager;
    }

    public void onCreateProject(String projectWsPath, Map<String, AttributeValue> attributes, Map<String, String> options) throws ForbiddenException, ConflictException, ServerException, NotFoundException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("files/main_class_content");){
            List sourceFolders = attributes.containsKey("java.source.folder") && !attributes.get("java.source.folder").isEmpty() ? attributes.get("java.source.folder").getList() : Collections.singletonList(PlainJavaProjectConstants.DEFAULT_SOURCE_FOLDER_VALUE);
            this.fsManager.createDir(projectWsPath);
            String outputDirWsPath = WsPathUtils.resolve((String)projectWsPath, (String)PlainJavaProjectConstants.DEFAULT_OUTPUT_FOLDER_VALUE);
            this.fsManager.createDir(outputDirWsPath);
            String sourceDirWsPath = WsPathUtils.resolve((String)projectWsPath, (String)((String)sourceFolders.get(0)));
            this.fsManager.createDir(sourceDirWsPath);
            String mainJavaWsPath = WsPathUtils.resolve((String)sourceDirWsPath, (String)FILE_NAME);
            this.fsManager.createFile(mainJavaWsPath, inputStream);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectWsPath);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            this.classpathBuilder.generateClasspath(javaProject, sourceFolders, Collections.singletonList(PlainJavaProjectConstants.DEFAULT_LIBRARY_FOLDER_VALUE));
        }
        catch (IOException e) {
            throw new ServerException((Throwable)e);
        }
    }

    public String getProjectType() {
        return "javac";
    }
}

